/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.excel;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.logisticspurchase.base.entity.DestinationAddressLibrary;
import com.els.modules.logisticspurchase.base.enumerate.AddressTypeEnum;
import com.els.modules.logisticspurchase.base.enumerate.StatusEnum;
import com.els.modules.logisticspurchase.base.service.DestinationAddressLibraryService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="DestinationAddressLibraryExcelHandler")
public class DestinationAddressLibraryExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private DestinationAddressLibraryService destinationAddressLibraryService;
    @Autowired
    private InvokeBaseRpcService baseRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        String elsAccount = TenantContext.getTenant();
        List addressTypeDictDTOS = this.baseRpcService.queryDictItemsByCode("addressType", TenantContext.getTenant());
        ArrayList<DestinationAddressLibrary> DestinationAddressLibraryList = new ArrayList<DestinationAddressLibrary>();
        List dbList = this.destinationAddressLibraryService.list();
        List<Object> highwayList = new ArrayList();
        List<Object> otherTypeList = new ArrayList();
        List<Object> dbHighwayUniqueKeys = new ArrayList();
        List<Object> dbOtherTypeUniqueKeys = new ArrayList();
        if (dbList.size() > 0) {
            highwayList = dbList.stream().filter(item -> AddressTypeEnum.HIGHWAY.getValue().equals(item.getArriveAddressType())).collect(Collectors.toList());
            if (highwayList.size() > 0) {
                dbHighwayUniqueKeys = highwayList.stream().map(item -> item.getArriveProvince() + "_" + item.getArriveCity() + "_" + item.getArriveCounty() + "_" + item.getArriveAddressType()).collect(Collectors.toList());
            }
            if ((otherTypeList = dbList.stream().filter(item -> !AddressTypeEnum.HIGHWAY.getValue().equals(item.getArriveAddressType())).collect(Collectors.toList())).size() > 0) {
                dbOtherTypeUniqueKeys = otherTypeList.stream().map(item -> item.getArriveProvince() + "_" + item.getArriveCityStation() + "_" + item.getArriveAddressType()).collect(Collectors.toList());
            }
        }
        ArrayList<CallSite> uniqueKeys = new ArrayList<CallSite>();
        int index = 2;
        for (Map data : dataList) {
            String msg;
            String addressTypeDictText;
            String arriveProvince = data.get("arriveProvince") == null ? "" : data.get("arriveProvince");
            String arriveCity = data.get("arriveCity") == null ? "" : data.get("arriveCity");
            String arriveCounty = data.get("arriveCounty") == null ? "" : data.get("arriveCounty");
            String arriveCityStation = data.get("arriveCityStation") == null ? "" : data.get("arriveCityStation");
            String arriveAddressType = data.get("arriveAddressType") == null ? "" : data.get("arriveAddressType");
            String uniqueKey = null;
            uniqueKey = AddressTypeEnum.HIGHWAY.getValue().equals(arriveAddressType) ? arriveProvince + "_" + arriveCity + "_" + arriveCounty + "_" + arriveAddressType : arriveProvince + "_" + arriveCityStation + "_" + arriveAddressType;
            ++index;
            if (uniqueKeys.contains(uniqueKey)) {
                addressTypeDictText = addressTypeDictDTOS.parallelStream().filter(o -> o.getValue().equals(arriveAddressType)).map(DictDTO::getText).collect(Collectors.joining());
                msg = "\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684\u6570\u636e\uff0c\u91cd\u590d\u6570\u636e\u4e3a\u5bfc\u5165\u8868\u4e2d\u7b2c" + index + " \u884c";
                data.put("arriveAddressType", addressTypeDictText);
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (AddressTypeEnum.HIGHWAY.getValue().equals(arriveAddressType)) {
                if (CollUtil.isNotEmpty(dbHighwayUniqueKeys) && dbHighwayUniqueKeys.contains(uniqueKey)) {
                    addressTypeDictText = addressTypeDictDTOS.parallelStream().filter(o -> o.getValue().equals(arriveAddressType)).map(DictDTO::getText).collect(Collectors.joining());
                    msg = "\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u5bfc\u5165\u8868\u4e2d\u7b2c" + index + "\u884c\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01";
                    data.put("arriveAddressType", addressTypeDictText);
                    this.errorAdd(excelImportDTO, msg, data);
                    continue;
                }
            } else if (CollUtil.isNotEmpty(dbOtherTypeUniqueKeys) && dbOtherTypeUniqueKeys.contains(uniqueKey)) {
                addressTypeDictText = addressTypeDictDTOS.parallelStream().filter(o -> o.getValue().equals(arriveAddressType)).map(DictDTO::getText).collect(Collectors.joining());
                msg = "\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u5bfc\u5165\u8868\u4e2d\u7b2c" + index + "\u884c\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01";
                data.put("arriveAddressType", addressTypeDictText);
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            uniqueKeys.add((CallSite)((Object)uniqueKey));
            DestinationAddressLibrary entity = (DestinationAddressLibrary)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), DestinationAddressLibrary.class));
            entity.setArriveNumber(this.baseRpcService.getNextCode("srmArriveNumber", DestinationAddressLibrary.class));
            entity.setStatus(StatusEnum.EFFECTIVE.getValue());
            entity.setDeleted(CommonConstant.DEL_FLAG_0);
            entity.setElsAccount(elsAccount);
            DestinationAddressLibraryList.add(entity);
        }
        if (!CollectionUtils.isEmpty(DestinationAddressLibraryList)) {
            this.destinationAddressLibraryService.saveBatch(DestinationAddressLibraryList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

