/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.enumerate;

import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EbiddingQuoteTypeEnum {
    TAX_INCLUDING("0", "\u542b\u7a0e\u4ef7"){

        @Override
        public BigDecimal computeOtherPrice(String taxRateString, BigDecimal price) {
            BigDecimal taxRate = StrUtil.isNotBlank((CharSequence)taxRateString) ? new BigDecimal(taxRateString) : BigDecimal.ZERO;
            return price == null ? null : price.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
        }
    }
    ,
    TAX_EXCLUDING("1", "\u4e0d\u542b\u7a0e\u4ef7"){

        @Override
        public BigDecimal computeOtherPrice(String taxRateString, BigDecimal netPrice) {
            BigDecimal taxRate = StrUtil.isNotBlank((CharSequence)taxRateString) ? new BigDecimal(taxRateString) : BigDecimal.ZERO;
            return netPrice == null ? null : netPrice.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(6, 4);
        }
    };

    private final String value;
    private final String desc;

    public abstract BigDecimal computeOtherPrice(String var1, BigDecimal var2);

    private EbiddingQuoteTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}

