/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceHead;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceItem;
import com.els.modules.logisticspurchase.base.entity.SubjectFileItem;
import com.els.modules.logisticspurchase.base.enumerate.LineSourceTypeEnum;
import com.els.modules.logisticspurchase.base.service.LineDifferenceHeadService;
import com.els.modules.logisticspurchase.base.service.LineDifferenceItemService;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.modules.logisticspurchase.base.vo.LineDifferenceHeadVO;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryItemLpService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/lpbase/lineDifferenceItem"})
@Api(tags={"\u7ebf\u8def\u5dee\u5f02\u62a5\u8868\u5934\u4fe1\u606f"})
public class LineDifferenceItemController
extends BaseController<LineDifferenceItem, LineDifferenceItemService> {
    private static final Logger log = LoggerFactory.getLogger(LineDifferenceItemController.class);
    @Autowired
    private LineDifferenceItemService lineDifferenceItemService;
    @Autowired
    private PurchaseEnquiryHeadLpService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemLpService purchaseEnquiryItemService;
    @Resource(name="srmPoolExecutor")
    private ThreadPoolExecutor executor;
    private static final String DIFFERENCE_ITEM_MANUAL_GENERATE = "sys:differenceItem:manualGenerate";
    private static final String DIFFERENCE_ITEM_UPDATE_CENTER_VARIANCE_RATIO = "sys:differenceItem:updateCenterVarianceRatio";
    @Autowired
    private RedisUtil redis;
    @Autowired
    private SubjectFileItemService subjectFileItemService;
    @Autowired
    private PurchaseEbiddingHeadLpService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEbiddingItemLpService purchaseEbiddingItemService;
    @Autowired
    private LineDifferenceHeadService lineDifferenceHeadService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"lpbase#lineDifferenceHead:list"})
    public Result<?> queryPageList(LineDifferenceItem lineDifferenceItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)lineDifferenceItem), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"is_show", (Object)"1");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.lineDifferenceItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u624b\u52a8\u89e6\u53d1\u751f\u6210\u5dee\u5f02", notes="\u6d4b\u8bd5")
    @PostMapping(value={"/manualGenerateLineDifference"})
    @RequiresPermissions(value={"enquiryLp#purchaseEnquiryHeadLp:pushData"})
    public Result<?> manualGenerateLineDifference(@RequestBody LineDifferenceHeadVO lineDifferenceHeadVO) {
        if (!this.redis.tryGetDistributedLock(DIFFERENCE_ITEM_MANUAL_GENERATE, lineDifferenceHeadVO.getId(), 3600000L)) {
            throw new ELSBootException("\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u624b\u52a8\u751f\u6210\u5dee\u5f02\u62a5\u8868\u4fe1\u606f\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c");
        }
        List<Object> toElsAccountList = new ArrayList();
        List LineDifferenceHeads = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lineDifferenceHeadService.lambdaQuery().eq(LineDifferenceHead::getSourceType, (Object)lineDifferenceHeadVO.getSourceType())).eq(LineDifferenceHead::getSourceNumber, (Object)lineDifferenceHeadVO.getSourceNumber())).orderByAsc(LineDifferenceHead::getTotalNetAmount)).last("LIMIT 3")).list();
        if (!CollectionUtils.isEmpty((Collection)LineDifferenceHeads)) {
            toElsAccountList = LineDifferenceHeads.stream().map(LineDifferenceHead::getToElsAccount).collect(Collectors.toList());
        }
        List<SubjectFileItem> SubjectFileItemDTOList = this.subjectFileItemService.selectBySubjectNumber(lineDifferenceHeadVO.getSubjectNumber(), lineDifferenceHeadVO.getSubjectYear());
        LoginUser loginUser = SysUtil.getLoginUser();
        List<Object> finalToElsAccountList = toElsAccountList;
        this.executor.execute(() -> {
            LoginUserContext.setUser((LoginUser)loginUser);
            TenantContext.setTenant((String)loginUser.getElsAccount());
            try {
                PurchaseEbiddingHeadLp ebiddingHead;
                if ("1".equals(lineDifferenceHeadVO.getSourceType())) {
                    for (SubjectFileItem subjectFileItem : SubjectFileItemDTOList) {
                        PurchaseEnquiryHeadLp enquiryHead = (PurchaseEnquiryHeadLp)((Object)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)lineDifferenceHeadVO.getId()))));
                        if (enquiryHead == null) continue;
                        List purchaseEnquiryItems = this.purchaseEnquiryItemService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"head_id", (Object)lineDifferenceHeadVO.getId())).eq((Object)"section_number", (Object)subjectFileItem.getSectionNumber()));
                        Map<String, List<PurchaseEnquiryItemLp>> itemMap = purchaseEnquiryItems.stream().collect(Collectors.groupingBy(item -> item.getSectionNumber() + "_" + item.getArriveProvince()));
                        for (Map.Entry<String, List<PurchaseEnquiryItemLp>> itemListEntry : itemMap.entrySet()) {
                            List<PurchaseEnquiryItemLp> enquiryItemList = itemListEntry.getValue();
                            ((LineDifferenceItemService)this.service).generateLineDifferenceItems(enquiryHead, enquiryItemList, (List<String>)finalToElsAccountList);
                        }
                        PurchaseEnquiryHeadLp updateHead = new PurchaseEnquiryHeadLp();
                        updateHead.setId(enquiryHead.getId());
                        updateHead.setFbk4("1");
                        this.purchaseEnquiryHeadService.updateById((Object)updateHead);
                    }
                } else if ("2".equals(lineDifferenceHeadVO.getSourceType()) && (ebiddingHead = (PurchaseEbiddingHeadLp)((Object)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)lineDifferenceHeadVO.getId()))))) != null && !"1".equals(ebiddingHead.getFbk4())) {
                    List<PurchaseEbiddingItemLp> ebiddingItems = this.purchaseEbiddingItemService.selectByMainId(ebiddingHead.getId());
                    ((LineDifferenceItemService)this.service).generateLineDifferenceItems(ebiddingHead, ebiddingItems, (List<String>)finalToElsAccountList);
                    if (!CollectionUtils.isEmpty(ebiddingItems)) {
                        PurchaseEbiddingHeadLp updateHead = new PurchaseEbiddingHeadLp();
                        updateHead.setId(ebiddingItems.get(0).getHeadId());
                        updateHead.setFbk4("1");
                        this.purchaseEbiddingHeadService.updateById((Object)updateHead);
                    }
                }
            }
            catch (Exception e) {
                log.error("differenceItem_manualGenerateend_failed:", (Throwable)e);
                if ("1".equals(lineDifferenceHeadVO.getSourceType())) {
                    PurchaseEnquiryHeadLp updateHead = new PurchaseEnquiryHeadLp();
                    updateHead.setId(lineDifferenceHeadVO.getId());
                    updateHead.setFbk3(e.getMessage());
                    updateHead.setFbk4("0");
                    this.purchaseEnquiryHeadService.updateById((Object)updateHead);
                } else if ("2".equals(lineDifferenceHeadVO.getSourceType())) {
                    PurchaseEbiddingHeadLp updateHead = new PurchaseEbiddingHeadLp();
                    updateHead.setId(lineDifferenceHeadVO.getId());
                    updateHead.setFbk4("0");
                    updateHead.setFbk3(e.getMessage());
                    this.purchaseEbiddingHeadService.updateById((Object)updateHead);
                }
            }
            finally {
                this.redis.releaseDistributedLock(DIFFERENCE_ITEM_MANUAL_GENERATE, lineDifferenceHeadVO.getId());
                LoginUserContext.clear();
                TenantContext.clear();
            }
        });
        return Result.ok();
    }

    @ApiOperation(value="\u5dee\u5f02\u884c\u62a5\u8868", notes="\u4f9b\u5e94\u5546\u4fe1\u606f\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/querySupplierList"})
    @RequiresPermissions(value={"lpbase#lineDifferenceHead:export"})
    public Result<?> querySupplierList(@RequestParam(name="sourceType", required=false) String sourceType, @RequestParam(name="subjectNumber", required=false) String subjectNumber, @RequestParam(name="subjectYear", required=false) String subjectYear) {
        Assert.notNull((Object)sourceType, (String)"\u8bf7\u9009\u62e9\u6765\u6e90\u7c7b\u578b");
        Assert.notNull((Object)subjectNumber, (String)"\u8bf7\u586b\u5199\u6807\u7684\u7f16\u7801");
        Assert.notNull((Object)subjectYear, (String)"\u8bf7\u9009\u62e9\u6807\u7684\u5e74\u4efd");
        return Result.ok(((LineDifferenceItemService)this.service).getLineSupplierList(sourceType, subjectNumber, subjectYear));
    }

    @ApiOperation(value="\u5dee\u5f02\u62a5\u8868\u5220\u9664", notes="\u5220\u9664")
    @PostMapping(value={"/deleteLineDifference"})
    @RequiresPermissions(value={"lpbase#lineDifferenceHead:delete"})
    public Result<?> deleteLineDifference(@RequestBody LineDifferenceItem lineDifferenceItem) {
        ((LineDifferenceItemService)this.service).deleteLineDifference(lineDifferenceItem);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u5dee\u5f02\u884c\u62a5\u8868", notes="\u5237\u65b0\u4e2d\u5fc3\u70b9\u5dee\u5f02")
    @PostMapping(value={"/noToken/tempUpdateCenterVarianceRatio"})
    public Result<?> tempUpdateCenterVarianceRatio(@RequestParam(name="id") String id) {
        if (!this.redis.tryGetDistributedLock(DIFFERENCE_ITEM_UPDATE_CENTER_VARIANCE_RATIO, id, 3600000L)) {
            throw new ELSBootException("\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u8be2\u4ef7\u5dee\u5f02\u62a5\u8868\u4e2d\u5fc3\u70b9\u6bd4\u4f8b\u5237\u65b0\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c");
        }
        PurchaseEnquiryHeadLp head = (PurchaseEnquiryHeadLp)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)head), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        List<SubjectFileItem> SubjectFileItemDTOList = this.subjectFileItemService.selectBySubjectNumber(head.getSubjectNumber(), head.getSubjectYear());
        LoginUser loginUser = SysUtil.getLoginUser();
        if (ObjectUtil.isEmpty((Object)loginUser)) {
            loginUser = new LoginUser();
            loginUser.setElsAccount(head.getElsAccount());
            loginUser.setSubAccount("1001");
        }
        LoginUser finalLoginUser = loginUser;
        this.executor.execute(() -> {
            LoginUserContext.setUser((LoginUser)finalLoginUser);
            TenantContext.setTenant((String)finalLoginUser.getElsAccount());
            try {
                for (SubjectFileItem SubjectFileItemDTO : SubjectFileItemDTOList) {
                    List lineDifferenceItemList = this.lineDifferenceItemService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"enquiry_number", (Object)head.getEnquiryNumber())).eq((Object)"section_number", (Object)SubjectFileItemDTO.getSectionNumber())).eq((Object)"source_type", (Object)LineSourceTypeEnum.ENQUIRY_SOURCE.getValue()));
                    ((LineDifferenceItemService)this.service).refreshCenterVarianceRatio(lineDifferenceItemList, head);
                }
            }
            catch (Exception e) {
                log.error("differenceItem_updateCenterVarianceRatio_failed:", (Throwable)e);
            }
            finally {
                this.redis.releaseDistributedLock(DIFFERENCE_ITEM_UPDATE_CENTER_VARIANCE_RATIO, id);
                LoginUserContext.clear();
                TenantContext.clear();
            }
        });
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u901a\u8fc7excel\u6a21\u677f\u5bfc\u5165\u6570\u636e", operateType=5)
    @PostMapping(value={"/importExcelData"})
    public Result<?> importExcelData(HttpServletRequest request, Map<String, Object> otherRequestParam) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<Map<String, Object>> ids = new ArrayList<Map<String, Object>>();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            Map<String, Object> errorMap = ((LineDifferenceItemService)this.service).importExcel(file, otherRequestParam);
            ids.add(errorMap);
        }
        return Result.ok(ids);
    }
}

