/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.ebidding.enumerate.EbiddingConfirmStatusEnum;
import com.els.modules.logisticspurchase.ebidding.entity.EbiddingConfirmItemLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingConfirmLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingConfirmLp;
import com.els.modules.logisticspurchase.ebidding.mapper.SaleEbiddingConfirmLpMapper;
import com.els.modules.logisticspurchase.ebidding.service.EbiddingConfirmItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingConfirmLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingConfirmLpService;
import com.els.modules.logisticspurchase.ebidding.vo.SaleEbiddingConfirmLpVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEbiddingConfirmLpServiceImpl
extends BaseServiceImpl<SaleEbiddingConfirmLpMapper, SaleEbiddingConfirmLp>
implements SaleEbiddingConfirmLpService {
    @Autowired
    private EbiddingConfirmItemLpService ebiddingConfirmItemService;
    @Autowired
    private PurchaseEbiddingConfirmLpService purchaseEbiddingConfirmService;

    @Override
    public List<SaleEbiddingConfirmLpVO> selectByMainId(String mainId) {
        List<SaleEbiddingConfirmLp> confirmList = ((SaleEbiddingConfirmLpMapper)this.baseMapper).selectByMainId(mainId);
        ArrayList result = SysUtil.copyProperties(confirmList, SaleEbiddingConfirmLpVO.class);
        if (CollectionUtil.isNotEmpty(confirmList)) {
            List idList = confirmList.stream().map(SaleEbiddingConfirmLp::getRelationId).collect(Collectors.toList());
            List itemList = this.ebiddingConfirmItemService.list((Wrapper)new LambdaQueryWrapper().in(EbiddingConfirmItemLp::getHeadId, idList));
            Map<String, List<EbiddingConfirmItemLp>> itemMap = itemList.stream().collect(Collectors.groupingBy(EbiddingConfirmItemLp::getHeadId));
            for (SaleEbiddingConfirmLpVO vo : result) {
                List<EbiddingConfirmItemLp> list = itemMap.get(vo.getRelationId());
                vo.setConfirmItemList(list);
            }
        }
        return result;
    }

    @Override
    public void publish(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingConfirmLp> confirmList, Map<String, String> idMap) {
        if (CollectionUtil.isNotEmpty(confirmList)) {
            ArrayList<SaleEbiddingConfirmLp> insertList = new ArrayList<SaleEbiddingConfirmLp>();
            for (PurchaseEbiddingConfirmLp confirm : confirmList) {
                SaleEbiddingConfirmLp insert = new SaleEbiddingConfirmLp();
                BeanUtils.copyProperties((Object)((Object)confirm), (Object)((Object)insert));
                insert.setId(confirm.getRelationId());
                insert.setElsAccount(confirm.getToElsAccount());
                insert.setRelationId(confirm.getId());
                insert.setHeadId(idMap.get(confirm.getToElsAccount()));
                insert.setToElsAccount(confirm.getElsAccount());
                insertList.add(insert);
            }
            this.saveBatch(insertList, 2000);
        }
    }

    @Override
    public void acceptResponse(List<SaleEbiddingConfirmLpVO> confirmList) {
        if (CollectionUtil.isNotEmpty(confirmList)) {
            ArrayList<SaleEbiddingConfirmLp> updateSaleList = new ArrayList<SaleEbiddingConfirmLp>();
            ArrayList<PurchaseEbiddingConfirmLp> updatePurchaseList = new ArrayList<PurchaseEbiddingConfirmLp>();
            for (SaleEbiddingConfirmLpVO confirmVO : confirmList) {
                SaleEbiddingConfirmLp saleConfirm = new SaleEbiddingConfirmLp();
                saleConfirm.setId(confirmVO.getId());
                saleConfirm.setSupplierRemark(confirmVO.getSupplierRemark());
                saleConfirm.setContent(confirmVO.getContent());
                saleConfirm.setStatus(EbiddingConfirmStatusEnum.ALREADY_REPLY.getValue());
                updateSaleList.add(saleConfirm);
                PurchaseEbiddingConfirmLp purchaseConfirm = new PurchaseEbiddingConfirmLp();
                purchaseConfirm.setId(confirmVO.getRelationId());
                purchaseConfirm.setSupplierRemark(confirmVO.getSupplierRemark());
                purchaseConfirm.setContent(confirmVO.getContent());
                purchaseConfirm.setStatus(EbiddingConfirmStatusEnum.ALREADY_REPLY.getValue());
                updatePurchaseList.add(purchaseConfirm);
            }
            this.updateBatchById(updateSaleList);
            this.purchaseEbiddingConfirmService.updateBatchById(updatePurchaseList);
        }
    }
}

