/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceHead;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceItem;
import com.els.modules.logisticspurchase.base.enumerate.LineSourceTypeEnum;
import com.els.modules.logisticspurchase.base.mapper.LineDifferenceHeadMapper;
import com.els.modules.logisticspurchase.base.mapper.LineDifferenceItemMapper;
import com.els.modules.logisticspurchase.base.service.LineDifferenceHeadService;
import com.els.modules.logisticspurchase.base.service.LineDifferenceItemService;
import com.els.modules.logisticspurchase.base.vo.OverallRankVO;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryHeadLpService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class LineDifferenceHeadServiceImpl
extends BaseServiceImpl<LineDifferenceHeadMapper, LineDifferenceHead>
implements LineDifferenceHeadService {
    @Autowired
    private LineDifferenceHeadMapper lineDifferenceHeadMapper;
    @Autowired
    private LineDifferenceItemMapper lineDifferenceItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    private static final String EBIDDING_END_KEY = "sys:ebidding:end";
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor executor;
    @Autowired
    private RedisUtil redis;
    private Integer rankCounts = 8;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(LineDifferenceHead lineDifferenceHead, List<LineDifferenceItem> lineDifferenceItemList) {
        this.lineDifferenceHeadMapper.insert((Object)lineDifferenceHead);
        super.setHeadDefaultValue((BaseEntity)lineDifferenceHead);
        this.insertData(lineDifferenceHead, lineDifferenceItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(LineDifferenceHead lineDifferenceHead, List<LineDifferenceItem> lineDifferenceItemList) {
        this.lineDifferenceHeadMapper.updateById((Object)lineDifferenceHead);
        this.lineDifferenceItemMapper.deleteByMainId(lineDifferenceHead.getId());
        this.insertData(lineDifferenceHead, lineDifferenceItemList);
    }

    private void insertData(LineDifferenceHead lineDifferenceHead, List<LineDifferenceItem> lineDifferenceItemList) {
        if (!CollectionUtils.isEmpty(lineDifferenceItemList)) {
            for (LineDifferenceItem entity : lineDifferenceItemList) {
                entity.setHeadId(lineDifferenceHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)lineDifferenceHead);
            }
            if (!lineDifferenceItemList.isEmpty()) {
                this.lineDifferenceItemMapper.insertBatchSomeColumn(lineDifferenceItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.lineDifferenceItemMapper.deleteByMainId(id);
        this.lineDifferenceHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.lineDifferenceItemMapper.deleteByMainId(serializable.toString());
            this.lineDifferenceHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public List<OverallRankVO> overallRanking(String sourceType, String subjectNumber, String subjectYear) {
        List lineDifferenceHeadList;
        List transportTypeDictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("addressType", TenantContext.getTenant());
        List<OverallRankVO> overallRankVOList = new ArrayList<OverallRankVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_type", (Object)sourceType);
        queryWrapper.eq((Object)"subject_year", (Object)subjectYear);
        if (!ObjectUtils.isEmpty((Object)subjectNumber)) {
            if (subjectNumber.contains(",")) {
                String[] subjectNumbers = subjectNumber.split(",");
                ArrayList<String> subjectNumbersList = new ArrayList<String>();
                for (String name : subjectNumbers) {
                    subjectNumbersList.add(name);
                }
                queryWrapper.in((Object)"subject_number", subjectNumbersList);
            } else {
                queryWrapper.eq((Object)"subject_number", (Object)subjectNumber);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(lineDifferenceHeadList = this.list((Wrapper)queryWrapper)))) {
            return overallRankVOList;
        }
        Map<String, String> sourceNumberToIdMap = null;
        Map<String, PurchaseEnquiryHeadLp> dbEnquiryHeadMap = null;
        Map<String, PurchaseEbiddingHeadLp> dbEbiddingHeadMap = null;
        Map<String, List<PurchaseEbiddingItemLp>> dbEbiddingItemMap = null;
        PurchaseEnquiryHeadLpService purchaseEnquiryHeadService = (PurchaseEnquiryHeadLpService)SpringContextUtils.getBean(PurchaseEnquiryHeadLpService.class);
        PurchaseEbiddingHeadLpService purchaseEbiddingHeadService = (PurchaseEbiddingHeadLpService)SpringContextUtils.getBean(PurchaseEbiddingHeadLpService.class);
        PurchaseEbiddingItemLpService purchaseEbiddingItemService = (PurchaseEbiddingItemLpService)SpringContextUtils.getBean(PurchaseEbiddingItemLpService.class);
        if (LineSourceTypeEnum.ENQUIRY_SOURCE.getValue().equals(sourceType)) {
            enquiryNumbers = lineDifferenceHeadList.stream().map(LineDifferenceHead::getSourceNumber).distinct().collect(Collectors.toList());
            List dbEnquiryHeads = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)purchaseEnquiryHeadService.lambdaQuery().select(new SFunction[]{BaseEntity::getId, PurchaseEnquiryHeadLp::getEnquiryNumber, PurchaseEnquiryHeadLp::getEnquiryStatus}).in(PurchaseEnquiryHeadLp::getEnquiryNumber, enquiryNumbers)).ne(PurchaseEnquiryHeadLp::getEnquiryStatus, (Object)EnquiryLpStatusEnum.CANCEL.getValue())).list();
            dbEnquiryHeadMap = dbEnquiryHeads.stream().collect(Collectors.toMap(PurchaseEnquiryHeadLp::getEnquiryNumber, e -> e, (o, n) -> o));
            sourceNumberToIdMap = dbEnquiryHeads.stream().collect(Collectors.toMap(PurchaseEnquiryHeadLp::getEnquiryNumber, BaseEntity::getId, (o, n) -> o));
        } else if (LineSourceTypeEnum.EBIDDING_SOURCE.getValue().equals(sourceType)) {
            List ebiddingNumbers = lineDifferenceHeadList.stream().map(LineDifferenceHead::getSourceNumber).distinct().collect(Collectors.toList());
            dbEbiddingHeads = ((LambdaQueryChainWrapper)purchaseEbiddingHeadService.lambdaQuery().in(PurchaseEbiddingHeadLp::getEbiddingNumber, ebiddingNumbers)).list();
            dbEbiddingHeadMap = dbEbiddingHeads.stream().collect(Collectors.toMap(PurchaseEbiddingHeadLp::getEbiddingNumber, e -> e, (o, n) -> o));
            sourceNumberToIdMap = dbEbiddingHeads.stream().collect(Collectors.toMap(PurchaseEbiddingHeadLp::getEbiddingNumber, BaseEntity::getId, (o, n) -> o));
        } else if (LineSourceTypeEnum.IMPORT_SOURCE.getValue().equals(sourceType)) {
            enquiryNumbers = lineDifferenceHeadList.stream().map(LineDifferenceHead::getSourceNumber).distinct().collect(Collectors.toList());
            dbEbiddingHeads = ((LambdaQueryChainWrapper)purchaseEbiddingHeadService.lambdaQuery().select(new SFunction[]{BaseEntity::getId, PurchaseEbiddingHeadLp::getEnquiryNumber, PurchaseEbiddingHeadLp::getEbiddingStatus}).in(PurchaseEbiddingHeadLp::getEnquiryNumber, enquiryNumbers)).list();
            List list = dbEbiddingHeads.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List dbEbiddingItems = ((LambdaQueryChainWrapper)purchaseEbiddingItemService.lambdaQuery().in(PurchaseEbiddingItemLp::getHeadId, list)).list();
            dbEbiddingItemMap = dbEbiddingItems.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemLp::getSubjectNumber));
            List dbEnquiryHeads = ((LambdaQueryChainWrapper)purchaseEnquiryHeadService.lambdaQuery().select(new SFunction[]{BaseEntity::getId, PurchaseEnquiryHeadLp::getEnquiryNumber, PurchaseEnquiryHeadLp::getEnquiryStatus}).in(PurchaseEnquiryHeadLp::getEnquiryNumber, enquiryNumbers)).list();
            dbEbiddingHeadMap = dbEbiddingHeads.stream().collect(Collectors.toMap(PurchaseEbiddingHeadLp::getEnquiryNumber, e -> e, (o, n) -> o));
            dbEnquiryHeadMap = dbEnquiryHeads.stream().collect(Collectors.toMap(PurchaseEnquiryHeadLp::getEnquiryNumber, e -> e, (o, n) -> o));
            sourceNumberToIdMap = dbEnquiryHeads.stream().collect(Collectors.toMap(PurchaseEnquiryHeadLp::getEnquiryNumber, BaseEntity::getId, (o, n) -> o));
        }
        Map<String, List<LineDifferenceHead>> lineDifferenceHeadMap = lineDifferenceHeadList.stream().collect(Collectors.groupingBy(LineDifferenceHead::getSubjectNumber));
        for (Map.Entry entry : lineDifferenceHeadMap.entrySet()) {
            OverallRankVO overallRankVO = new OverallRankVO();
            overallRankVO.setSourceType(sourceType);
            List lineDifferenceHeads = (List)entry.getValue();
            overallRankVO.setSubjectFileHeadId(((LineDifferenceHead)((Object)lineDifferenceHeads.get(0))).getSubjectFileHeadId());
            overallRankVO.setSubjectNumber(((LineDifferenceHead)((Object)lineDifferenceHeads.get(0))).getSubjectNumber());
            overallRankVO.setSubjectName(((LineDifferenceHead)((Object)lineDifferenceHeads.get(0))).getSubjectName());
            overallRankVO.setTransportType(((LineDifferenceHead)((Object)lineDifferenceHeads.get(0))).getTransportType());
            String transportTypeDictText = transportTypeDictDTOS.parallelStream().filter(o -> o.getValue().equals(((LineDifferenceHead)((Object)((Object)((Object)lineDifferenceHeads.get(0))))).getTransportType())).map(DictDTO::getText).collect(Collectors.joining());
            overallRankVO.setTransportType_dictText(transportTypeDictText);
            overallRankVO.setCanRebidding(true);
            overallRankVO.setSourceId(CollUtil.isEmpty(sourceNumberToIdMap) ? null : sourceNumberToIdMap.get(((LineDifferenceHead)((Object)lineDifferenceHeads.get(0))).getSourceNumber()));
            if (CollUtil.isNotEmpty(dbEbiddingHeadMap) && dbEbiddingHeadMap.containsKey(((LineDifferenceHead)((Object)lineDifferenceHeads.get(0))).getSourceNumber())) {
                PurchaseEbiddingHeadLp ebiddingHead = dbEbiddingHeadMap.get(((LineDifferenceHead)((Object)lineDifferenceHeads.get(0))).getSourceNumber());
                overallRankVO.setEbiddingStatus(ebiddingHead.getEbiddingStatus());
                if (LineSourceTypeEnum.EBIDDING_SOURCE.getValue().equals(sourceType)) {
                    overallRankVO.setSourceNumber(ebiddingHead.getEbiddingNumber());
                    overallRankVO.setTest(ebiddingHead.getTest());
                }
            }
            if (CollUtil.isNotEmpty(dbEnquiryHeadMap) && dbEnquiryHeadMap.containsKey(((LineDifferenceHead)((Object)lineDifferenceHeads.get(0))).getSourceNumber())) {
                PurchaseEnquiryHeadLp enquiryHead = dbEnquiryHeadMap.get(((LineDifferenceHead)((Object)lineDifferenceHeads.get(0))).getSourceNumber());
                overallRankVO.setEnquiryStatus(enquiryHead.getEnquiryStatus());
                if (LineSourceTypeEnum.ENQUIRY_SOURCE.getValue().equals(sourceType) || LineSourceTypeEnum.IMPORT_SOURCE.getValue().equals(sourceType)) {
                    overallRankVO.setSourceNumber(enquiryHead.getEnquiryNumber());
                }
            }
            if (LineSourceTypeEnum.ENQUIRY_SOURCE.getValue().equals(overallRankVO.getSourceType()) && !EnquiryLpStatusEnum.BARGAIN.getValue().equals(overallRankVO.getEnquiryStatus()) && !EnquiryLpStatusEnum.PRICED.getValue().equals(overallRankVO.getEnquiryStatus()) && !EnquiryLpStatusEnum.TRANSFERRED.getValue().equals(overallRankVO.getEnquiryStatus()) || LineSourceTypeEnum.EBIDDING_SOURCE.getValue().equals(overallRankVO.getSourceType()) && (!EbiddingLpStatusEnum.BIDDING_END.getValue().equals(overallRankVO.getEbiddingStatus()) || "1".equals(overallRankVO.getTest()))) continue;
            List LineDifferenceHeads = lineDifferenceHeads.stream().sorted(Comparator.comparing(LineDifferenceHead::getTotalNetAmount)).collect(Collectors.toList());
            ArrayList<LineDifferenceHead> rankLineDifferenceList = new ArrayList<LineDifferenceHead>();
            int i = 1;
            Map<String, PurchaseEbiddingItemLp> dbEbiddingItemsMap = null;
            if (CollUtil.isNotEmpty(dbEbiddingItemMap) && dbEbiddingItemMap.containsKey(entry.getKey())) {
                List<PurchaseEbiddingItemLp> dbEbiddingItems = dbEbiddingItemMap.get(entry.getKey());
                dbEbiddingItemsMap = dbEbiddingItems.stream().collect(Collectors.toMap(PurchaseEbiddingItemLp::getToElsAccount, p -> p, (o, n) -> o));
            }
            for (LineDifferenceHead lineDifferenceHead : LineDifferenceHeads) {
                lineDifferenceHead.setFbk1(String.valueOf(i));
                if (CollUtil.isNotEmpty(dbEbiddingItemsMap) && dbEbiddingItemsMap.containsKey(lineDifferenceHead.getToElsAccount())) {
                    lineDifferenceHead.setEbiddingItemStatus(dbEbiddingItemsMap.get(lineDifferenceHead.getToElsAccount()).getItemStatus());
                }
                rankLineDifferenceList.add(lineDifferenceHead);
                if (++i <= this.rankCounts) continue;
                break;
            }
            overallRankVO.setLineDifferenceHeadList(rankLineDifferenceList);
            overallRankVOList.add(overallRankVO);
        }
        if (LineSourceTypeEnum.ENQUIRY_SOURCE.getValue().equals(sourceType)) {
            List<String> enquiryStatus = Arrays.asList("7", "9", "16");
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)purchaseEnquiryHeadService.lambdaQuery().eq(PurchaseEnquiryHeadLp::getSubjectYear, (Object)subjectYear)).in(PurchaseEnquiryHeadLp::getEnquiryStatus, enquiryStatus)).list();
            List enquiryNumbers = overallRankVOList.stream().map(OverallRankVO::getSourceNumber).collect(Collectors.toList());
            if (list.size() > 0 && enquiryNumbers.size() > 0) {
                List list2 = list.stream().filter(item -> !enquiryNumbers.contains(item.getEnquiryNumber())).collect(Collectors.toList());
                for (PurchaseEnquiryHeadLp purchaseEnquiryHead : list2) {
                    OverallRankVO overallRankVO = new OverallRankVO();
                    overallRankVO.setSourceType(sourceType);
                    overallRankVO.setSubjectFileHeadId(purchaseEnquiryHead.getSubjectFileHeadId());
                    overallRankVO.setSubjectNumber(purchaseEnquiryHead.getSubjectNumber());
                    overallRankVO.setSubjectName(purchaseEnquiryHead.getSubjectName());
                    overallRankVO.setTransportType(purchaseEnquiryHead.getSubjectType());
                    overallRankVO.setEnquiryStatus(purchaseEnquiryHead.getEnquiryStatus());
                    overallRankVO.setSourceNumber(purchaseEnquiryHead.getEnquiryNumber());
                    String transportTypeDictText = transportTypeDictDTOS.parallelStream().filter(o -> o.getValue().equals(purchaseEnquiryHead.getSubjectType())).map(DictDTO::getText).collect(Collectors.joining());
                    overallRankVO.setTransportType_dictText(transportTypeDictText);
                    overallRankVO.setSourceId(purchaseEnquiryHead.getId());
                    overallRankVO.setCanRebidding(false);
                    overallRankVOList.add(overallRankVO);
                }
            }
        }
        if (!CollectionUtils.isEmpty(overallRankVOList)) {
            overallRankVOList = overallRankVOList.stream().sorted(Comparator.comparing(OverallRankVO::getSourceId).reversed()).collect(Collectors.toList());
        }
        return overallRankVOList;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void generateLineDifferenceItemsByEbiddingId(String id) {
        PurchaseEbiddingHeadLpService purchaseEbiddingHeadService = (PurchaseEbiddingHeadLpService)SpringContextUtils.getBean(PurchaseEbiddingHeadLpService.class);
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
        if (ObjectUtil.isEmpty((Object)((Object)dbHead))) {
            throw new ELSBootException("\u627e\u4e0d\u5230\u7ade\u4ef7\u5355");
        }
        List<PurchaseEbiddingItemLp> dbItems = ((PurchaseEbiddingItemLpService)SpringContextUtils.getBean(PurchaseEbiddingItemLpService.class)).selectByMainId(dbHead.getId());
        if (CollUtil.isEmpty(dbItems)) {
            throw new ELSBootException("\u627e\u4e0d\u5230\u7ade\u4ef7\u884c");
        }
        if (!this.redis.tryGetDistributedLock(EBIDDING_END_KEY, dbHead.getId(), 3600000L)) {
            throw new ELSBootException("\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u7ed3\u675f\u7ade\u4ef7\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c");
        }
        List LineDifferenceHeads = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(LineDifferenceHead::getSourceType, (Object)LineSourceTypeEnum.EBIDDING_SOURCE.getValue())).eq(LineDifferenceHead::getSourceNumber, (Object)dbHead.getEbiddingNumber())).orderByAsc(LineDifferenceHead::getTotalNetAmount)).last("LIMIT 3")).list();
        List toElsAccountList = LineDifferenceHeads.stream().map(LineDifferenceHead::getToElsAccount).collect(Collectors.toList());
        LoginUser loginUser = SysUtil.getLoginUser();
        if (ObjectUtil.isEmpty((Object)loginUser)) {
            loginUser = new LoginUser();
            loginUser.setElsAccount(dbHead.getElsAccount());
            loginUser.setSubAccount("1001");
        }
        List finalToElsAccountList = toElsAccountList;
        LoginUser finalLoginUser = loginUser;
        this.executor.execute(() -> {
            try {
                LoginUserContext.setUser((LoginUser)finalLoginUser);
                TenantContext.setTenant((String)finalLoginUser.getElsAccount());
                ((LineDifferenceItemService)SpringContextUtils.getBean(LineDifferenceItemService.class)).tempGenerateLineDifferenceItems(dbHead, dbItems, finalToElsAccountList);
            }
            catch (Exception e) {
                this.log.error("ebidding_end_failed:", (Throwable)e);
                PurchaseEbiddingHeadLp updateHead = new PurchaseEbiddingHeadLp();
                updateHead.setId(dbHead.getId());
                updateHead.setFbk3(e.getMessage());
                purchaseEbiddingHeadService.updateById((Object)updateHead);
            }
            finally {
                this.redis.releaseDistributedLock(EBIDDING_END_KEY, dbHead.getId());
                LoginUserContext.clear();
                TenantContext.clear();
            }
        });
    }
}

