/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.excel.listener;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryItemLp;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnquiryQuoteDataListener
extends AnalysisEventListener<Map<Integer, String>> {
    private static final Logger log = LoggerFactory.getLogger(EnquiryQuoteDataListener.class);
    private List<SaleEnquiryItemLp> cachedDataList = Lists.newArrayList();
    private Map<Integer, CellData> headMap;
    private String itemNumber;
    private int row = 0;

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        log.error("EnquiryQuoteDataListener_onException:", (Throwable)exception);
        throw new ELSBootException((Throwable)exception);
    }

    public void invokeHead(Map<Integer, CellData> headMap, AnalysisContext context) {
        this.headMap = headMap;
    }

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        if (this.row == 0) {
            ++this.row;
            return;
        }
        this.itemNumber = data.get(0);
        if (StrUtil.isBlank((CharSequence)this.itemNumber)) {
            return;
        }
        JSONObject object = new JSONObject();
        for (Integer index : data.keySet()) {
            if (this.headMap.get(index) == null) continue;
            object.put(this.headMap.get(index).getStringValue(), (Object)data.get(index));
        }
        try {
            SaleEnquiryItemLp item = (SaleEnquiryItemLp)((Object)JSONObject.parseObject((String)object.toJSONString(), SaleEnquiryItemLp.class));
            item.setItemNumber(this.formatItemNumber(item.getItemNumber()));
            this.cachedDataList.add(item);
        }
        catch (Exception e) {
            throw new ELSBootException("\u62a5\u4ef7Excel\u89e3\u6790\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5 Excel \u5185\u5bb9\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
    }

    private String formatItemNumber(String itemNumber) {
        if (itemNumber.contains(".")) {
            return itemNumber.substring(0, itemNumber.indexOf("."));
        }
        return itemNumber;
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.row = 0;
    }

    public boolean hasNext(AnalysisContext context) {
        return !StrUtil.isBlank((CharSequence)this.itemNumber) || this.cachedDataList.size() <= 0;
    }

    public List<SaleEnquiryItemLp> getCachedDataList() {
        return this.cachedDataList;
    }
}

