/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatTypeEnum;
import com.els.modules.tender.clarification.entity.PurchaseClarificationTenderBidLetter;
import com.els.modules.tender.clarification.entity.PurchaseTenderClarificationInfo;
import com.els.modules.tender.clarification.service.PurchaseTenderClarificationInfoService;
import com.els.modules.tender.clarification.vo.PurchaseTenderClarificationInfoVO;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.common.aspect.ValidatedTenderStatus;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u62db\u6807\u9879\u76ee\u6f84\u6e05"})
@RestController
@RequestMapping(value={"/tender/purchaseTenderClarificationInfo"})
public class PurchaseTenderClarificationInfoController
extends BaseController<PurchaseTenderClarificationInfo, PurchaseTenderClarificationInfoService> {
    @Autowired
    private PurchaseTenderClarificationInfoService clarificationInfoService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService tenderProjectSupplierService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryPageList(PurchaseTenderClarificationInfo purchaseTenderClarificationInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderClarificationInfo), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)"0");
        IPage<PurchaseTenderClarificationInfo> pageList = this.clarificationInfoService.queryTenderPage((Page<PurchaseTenderClarificationInfo>)page, (QueryWrapper<PurchaseTenderClarificationInfo>)queryWrapper);
        List records = pageList.getRecords();
        if (CollectionUtil.isNotEmpty((Collection)records)) {
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            qw.eq(TenderProjectSupplier::getSubpackageId, (Object)((PurchaseTenderClarificationInfo)((Object)records.get(0))).getSubpackageId());
            int count = this.tenderProjectSupplierService.count((Wrapper)qw);
            records.forEach(clarificationInfo -> clarificationInfo.setTotal(count));
        }
        return Result.ok(pageList);
    }

    @AutoLog(value="\u62db\u6807\u9879\u76ee\u6f84\u6e05-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"tender#tenderProject:add"})
    @SrmValidated
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> add(@RequestBody PurchaseTenderClarificationInfoVO clarificationInfoVO) {
        PurchaseTenderClarificationInfo clarificationInfo = this.clarificationInfoService.add(clarificationInfoVO);
        return Result.ok((Object)((Object)this.clarificationInfoService.queryById(clarificationInfo.getId(), clarificationInfo.getSubpackageId())));
    }

    @AutoLog(value="\u62db\u6807\u9879\u76ee\u6f84\u6e05-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> edit(@RequestBody PurchaseTenderClarificationInfoVO clarificationInfoVO) {
        PurchaseTenderClarificationInfo clarificationInfo = this.clarificationInfoService.edit(clarificationInfoVO);
        return Result.ok((Object)((Object)this.clarificationInfoService.queryById(clarificationInfo.getId(), clarificationInfo.getSubpackageId())));
    }

    @AutoLog(value="\u62db\u6807\u9879\u76ee\u6f84\u6e05-\u62db\u6807\u6587\u4ef6\u53d8\u66f4")
    @ApiOperation(value="\u62db\u6807\u6587\u4ef6\u53d8\u66f4", notes="\u62db\u6807\u6587\u4ef6\u53d8\u66f4")
    @PostMapping(value={"/change/attachment"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> changeAttachment(@RequestBody PurchaseTenderClarificationInfoVO clarificationInfoVO) {
        PurchaseTenderClarificationInfoVO changeAttachment = this.clarificationInfoService.changeAttachment(clarificationInfoVO);
        return Result.ok((Object)((Object)changeAttachment));
    }

    @AutoLog(value="\u62db\u6807\u9879\u76ee\u6f84\u6e05-\u62db\u6807\u6587\u4ef6\u53d8\u66f4\u6e05\u9664")
    @ApiOperation(value="\u62db\u6807\u6587\u4ef6\u53d8\u66f4\u6e05\u9664", notes="\u62db\u6807\u6587\u4ef6\u53d8\u66f4\u6e05\u9664")
    @GetMapping(value={"/change/attachment/clear"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> changeAttachmentClear(@RequestParam(name="id") String id, @RequestParam(name="subpackageId") String subpackageId) {
        PurchaseTenderClarificationInfoVO changeAttachment = this.clarificationInfoService.changeAttachmentClear(id, subpackageId);
        return Result.ok((Object)((Object)changeAttachment));
    }

    @AutoLog(value="\u62db\u6807\u9879\u76ee\u6f84\u6e05-\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    @SrmValidated
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> submit(@RequestBody PurchaseTenderClarificationInfoVO clarificationInfo) {
        this.clarificationInfoService.submit(clarificationInfo);
        return Result.ok((Object)((Object)this.clarificationInfoService.queryById(clarificationInfo.getId(), clarificationInfo.getSubpackageId())));
    }

    @AutoLog(value="\u62db\u6807\u9879\u76ee\u6f84\u6e05-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> publish(@RequestParam(name="id") String id) {
        this.clarificationInfoService.publish(id);
        return this.commonSuccessResult(CommonConstant.SC_OK_200);
    }

    @AutoLog(value="\u62db\u6807\u6587\u4ef6-\u83b7\u53d6\u6295\u6807\u51fd\u5217\u8868")
    @ApiOperation(value="\u83b7\u53d6\u6295\u6807\u51fd\u5217\u8868", notes="\u83b7\u53d6\u6295\u6807\u51fd\u5217\u8868")
    @GetMapping(value={"/queryTenderBidLetter"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryTenderBidLetterList(@RequestParam(name="clarificationId") String clarificationId) {
        List<PurchaseClarificationTenderBidLetter> customColumnList = this.clarificationInfoService.queryTenderBidLetterList(clarificationId);
        if ("1".equals(TenderFlagInjectionContext.getTenderProcessType()) && CollectionUtil.isNotEmpty(customColumnList)) {
            customColumnList = customColumnList.parallelStream().filter(bidLetter -> !BidLetterFormatTypeEnum.OTHER.getValue().equals(bidLetter.getFormatType())).collect(Collectors.toList());
        }
        return Result.ok(customColumnList);
    }

    @AutoLog(value="\u62db\u6807\u6587\u4ef6-\u83b7\u53d6\u4ef7\u683c\u5217\u4fe1\u606f")
    @ApiOperation(value="\u83b7\u53d6\u4ef7\u683c\u5217\u4fe1\u606f", notes="\u83b7\u53d6\u4ef7\u683c\u5217\u4fe1\u606f")
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @GetMapping(value={"/queryPriceColumn"})
    public Result<?> queryPriceColumn(@RequestParam(name="bidLetterId") String bidLetterId) {
        List<CustomColumnModel> customColumnList = this.clarificationInfoService.queryPriceColumn(bidLetterId);
        return Result.ok(customColumnList);
    }

    @AutoLog(value="\u62db\u6807\u9879\u76ee\u6f84\u6e05-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#tenderProject:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.clarificationInfoService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u62db\u6807\u9879\u76ee\u6f84\u6e05-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"tender#tenderProject:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.clarificationInfoService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryById(@RequestParam(name="id") String id, @RequestParam(name="subpackageId", required=false) String subpackageId) {
        PurchaseTenderClarificationInfoVO purchaseTenderClarificationInfo = this.clarificationInfoService.queryById(id, subpackageId);
        return Result.ok((Object)((Object)purchaseTenderClarificationInfo));
    }
}

