/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.column.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.column.entity.TenderCustomColumn;
import com.els.modules.tender.column.service.TenderCustomColumnService;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DictColumnTranslateUtils {
    public static void dictColumnTranslate(List<SaleTenderPriceOpenings> tenderPriceOpeningsList) {
        TenderCustomColumnService customColumnService = (TenderCustomColumnService)SpringContextUtils.getBean(TenderCustomColumnService.class);
        InvokeBaseRpcService invokeBaseRpcService = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
        HashSet dictFieldNameList = new HashSet();
        tenderPriceOpeningsList.stream().forEach(saleTenderPriceOpenings -> {
            List<CustomColumnModel> customColumnModels = FastJsonUtils.toList(saleTenderPriceOpenings.getCustomizeFieldModel(), CustomColumnModel.class);
            Set dictFieldList = customColumnModels.stream().filter(customColumnModel -> "dict".equals(customColumnModel.getFieldType())).map(CustomColumnModel::getField).collect(Collectors.toSet());
            if (CollectionUtil.isNotEmpty(dictFieldList)) {
                dictFieldNameList.addAll(dictFieldList);
            }
        });
        if (CollectionUtil.isNotEmpty(dictFieldNameList)) {
            LinkedHashMap<String, List> dictDTOListMap = new LinkedHashMap<String, List>();
            LambdaQueryWrapper columnLambdaQueryChainWrapper = new LambdaQueryWrapper();
            columnLambdaQueryChainWrapper.eq(TenderCustomColumn::getFieldType, (Object)"dict");
            columnLambdaQueryChainWrapper.in(TenderCustomColumn::getColumnFieldName, dictFieldNameList);
            columnLambdaQueryChainWrapper.eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            List customColumnList = customColumnService.list((Wrapper)columnLambdaQueryChainWrapper);
            for (SaleTenderPriceOpenings saleTenderPriceOpenings2 : tenderPriceOpeningsList) {
                String customizeFieldData = saleTenderPriceOpenings2.getCustomizeFieldData();
                JSONArray jsonArray = JSONArray.parseArray((String)customizeFieldData);
                for (Object o : jsonArray) {
                    JSONObject row = (JSONObject)o;
                    for (TenderCustomColumn tenderCustomColumn : customColumnList) {
                        String dictKey;
                        Map dictDTOMap;
                        DictDTO dictDTO;
                        if (!row.containsKey((Object)tenderCustomColumn.getColumnFieldName())) continue;
                        List dictDTOList = null;
                        if (dictDTOListMap.containsKey(tenderCustomColumn.getDictCode())) {
                            dictDTOList = (List)dictDTOListMap.get(tenderCustomColumn.getDictCode());
                        } else {
                            dictDTOList = invokeBaseRpcService.queryDictItemsByCode(tenderCustomColumn.getDictCode(), tenderCustomColumn.getElsAccount());
                            dictDTOListMap.put(tenderCustomColumn.getDictCode(), dictDTOList);
                        }
                        if (CollectionUtil.isEmpty((Collection)dictDTOList) || (dictDTO = (DictDTO)(dictDTOMap = dictDTOList.stream().collect(Collectors.toMap(DictDTO::getValue, Function.identity()))).get(dictKey = (String)row.get((Object)tenderCustomColumn.getColumnFieldName()))) == null) continue;
                        row.put(tenderCustomColumn.getColumnFieldName(), (Object)I18nUtil.translate((String)dictDTO.getTextI18nKey(), (String)dictDTO.getText()));
                    }
                }
                saleTenderPriceOpenings2.setCustomizeFieldData(jsonArray.toJSONString());
            }
        }
    }
}

