/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.entity.PurchaseBidEvaJudgesWithdrawRecord;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResultHistory;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaSupplierResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaExpertTask;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.mapper.PurchaseBidEvaJudgesWithdrawRecordMapper;
import com.els.modules.tender.evaluation.service.PurchaseBidEvaJudgesWithdrawRecordService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaGroupSummaryResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultHistoryService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaSupplierResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaExpertTaskService;
import com.els.modules.tender.evaluation.vo.SupplierEvaRankingVO;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBidEvaJudgesWithdrawRecordServiceImpl
extends BaseServiceImpl<PurchaseBidEvaJudgesWithdrawRecordMapper, PurchaseBidEvaJudgesWithdrawRecord>
implements PurchaseBidEvaJudgesWithdrawRecordService {
    @Autowired
    private PurchaseTenderProjectEvaExpertTaskService evaExpertTaskService;
    @Autowired
    private PurchaseTenderProjectBidEvaRegulationResultService evaRegulationResultService;
    @Autowired
    private PurchaseTenderProjectBidEvaGroupSummaryResultService evaSummaryResultService;
    @Autowired
    private PurchaseTenderProjectBidEvaRegulationResultHistoryService evaRegulationResultHistoryService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectBidEvaSupplierResultService supplierResultService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void withdraw(PurchaseBidEvaJudgesWithdrawRecord evaJudgesWithdrawRecord) {
        String judgesTaskItemId = evaJudgesWithdrawRecord.getJudgesTaskItemId();
        String evaGroupId = evaJudgesWithdrawRecord.getEvaGroupId();
        PurchaseTenderProjectEvaExpertTask evaExpertTask = (PurchaseTenderProjectEvaExpertTask)((Object)this.evaExpertTaskService.getById((Serializable)((Object)judgesTaskItemId)));
        evaExpertTask.setEvaGroupStatus("0");
        this.evaExpertTaskService.updateById((Object)evaExpertTask);
        List<SupplierEvaRankingVO> rankingVOList = this.evaSummaryResultService.selectEvaGroupSummaryResultByMainId(Arrays.asList(evaExpertTask.getEvaInfoId()), evaGroupId);
        List supplierAccountList = rankingVOList.stream().filter(supplierEvaRankingVO -> "1".equals(supplierEvaRankingVO.getInvalid())).map(SupplierEvaRankingVO::getSupplierAccount).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(supplierAccountList)) {
            LambdaUpdateWrapper supplierLambdaUpdateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)supplierLambdaUpdateWrapper.eq(TenderProjectSupplier::getSubpackageId, (Object)evaExpertTask.getSubpackageId())).in(TenderProjectSupplier::getSupplierAccount, supplierAccountList)).set(TenderProjectSupplier::getInvalid, (Object)"0");
            this.tenderProjectSupplierService.update((Wrapper)supplierLambdaUpdateWrapper);
            LambdaUpdateWrapper supplierResultLambdaUpdateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)supplierResultLambdaUpdateWrapper.eq(PurchaseTenderProjectBidEvaSupplierResult::getSubpackageId, (Object)evaExpertTask.getSubpackageId())).in(PurchaseTenderProjectBidEvaSupplierResult::getSupplierAccount, supplierAccountList)).set(PurchaseTenderProjectBidEvaSupplierResult::getInvalid, (Object)"0");
            this.supplierResultService.update((Wrapper)supplierResultLambdaUpdateWrapper);
        }
        this.evaSummaryResultService.deleteByMainId(evaExpertTask.getEvaInfoId(), evaGroupId);
        List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = this.evaRegulationResultService.selectByMainId(judgesTaskItemId, evaGroupId);
        ArrayList historyArrayList = SysUtil.copyProperties(regulationResultList, PurchaseTenderProjectBidEvaRegulationResultHistory.class);
        historyArrayList.stream().forEach(history -> history.setId(null));
        if (!regulationResultList.isEmpty()) {
            PurchaseTenderProjectBidEvaRegulationResult regulationResult = regulationResultList.get(0);
            if (TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue().equals(regulationResult.getEvaGroupType()) || TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue().equals(regulationResult.getEvaGroupType())) {
                this.evaRegulationResultService.deleteByMainId(evaGroupId, judgesTaskItemId);
            }
        }
        evaJudgesWithdrawRecord.setId(IdWorker.getIdStr());
        evaJudgesWithdrawRecord.setEvaGroupId(evaExpertTask.getEvaGroupId());
        evaJudgesWithdrawRecord.setJudgesName(evaExpertTask.getJudgesName());
        evaJudgesWithdrawRecord.setJudgesElsAccount(evaExpertTask.getJudgesElsAccount());
        evaJudgesWithdrawRecord.setJudgesElsSubAccount(evaExpertTask.getJudgesElsSubAccount());
        evaJudgesWithdrawRecord.setJudgesTaskHeadId(evaExpertTask.getHeadId());
        evaJudgesWithdrawRecord.setJudgesTaskItemId(evaExpertTask.getId());
        evaJudgesWithdrawRecord.setSubpackageId(evaExpertTask.getSubpackageId());
        evaJudgesWithdrawRecord.setTenderProjectId(evaExpertTask.getTenderProjectId());
        evaJudgesWithdrawRecord.setWithDrawStatus("1");
        evaJudgesWithdrawRecord.setDeleted(CommonConstant.DEL_FLAG_0);
        evaJudgesWithdrawRecord.setElsAccount(TenantContext.getTenant());
        evaJudgesWithdrawRecord.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
        evaJudgesWithdrawRecord.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
        evaJudgesWithdrawRecord.setCurrentStep(TenderFlagInjectionContext.getTenderCurrentStep());
        this.save((Object)evaJudgesWithdrawRecord);
        historyArrayList.stream().forEach(history -> {
            history.setId(null);
            history.setJudgesWithdrawRecordId(evaJudgesWithdrawRecord.getId());
        });
        this.evaRegulationResultHistoryService.saveBatch(historyArrayList);
    }
}

