/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.common.aspect.ValidatedTenderStatus;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenSettingHead;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingHeadService;
import com.els.modules.tender.openbid.vo.PurchaseOpenSettingHeadVO;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/purchaseTenderProjectOpenSettingHead"})
@Api(tags={"\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u5f00\u6807\u8bbe\u7f6e\u5934"})
public class PurchaseTenderProjectOpenSettingHeadController
extends BaseController<PurchaseTenderProjectOpenSettingHead, PurchaseTenderProjectOpenSettingHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectOpenSettingHeadController.class);
    @Autowired
    private PurchaseTenderProjectOpenSettingHeadService purchaseTenderProjectOpenSettingHeadService;

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u5f00\u6807\u8bbe\u7f6e\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED, TenderProjectSubpackageStatusEnum.RESULT_BID_EVA_TERMINATION})
    public Result<?> add(@RequestBody PurchaseOpenSettingHeadVO purchaseTenderProjectOpenSettingHeadPage) {
        PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead = new PurchaseTenderProjectOpenSettingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectOpenSettingHeadPage), (Object)((Object)purchaseTenderProjectOpenSettingHead));
        this.purchaseTenderProjectOpenSettingHeadService.saveMain(purchaseTenderProjectOpenSettingHead, purchaseTenderProjectOpenSettingHeadPage.getAttendeesList());
        return Result.ok((Object)((Object)purchaseTenderProjectOpenSettingHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u5f00\u6807\u8bbe\u7f6e\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED, TenderProjectSubpackageStatusEnum.RESULT_BID_EVA_TERMINATION})
    public Result<?> edit(@RequestBody PurchaseOpenSettingHeadVO purchaseTenderProjectOpenSettingHeadPage) {
        PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead = new PurchaseTenderProjectOpenSettingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectOpenSettingHeadPage), (Object)((Object)purchaseTenderProjectOpenSettingHead));
        this.purchaseTenderProjectOpenSettingHeadService.updateMain(purchaseTenderProjectOpenSettingHead, purchaseTenderProjectOpenSettingHeadPage.getAttendeesList());
        return this.queryBySubpackageId(purchaseTenderProjectOpenSettingHead.getSubpackageId());
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u5f00\u6807\u8bbe\u7f6e\u5934", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED, TenderProjectSubpackageStatusEnum.RESULT_BID_EVA_TERMINATION})
    public Result<?> publish(@RequestBody PurchaseOpenSettingHeadVO purchaseTenderProjectOpenSettingHeadPage) {
        PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead = new PurchaseTenderProjectOpenSettingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectOpenSettingHeadPage), (Object)((Object)purchaseTenderProjectOpenSettingHead));
        this.purchaseTenderProjectOpenSettingHeadService.saveOrUpatePublish(purchaseTenderProjectOpenSettingHead, purchaseTenderProjectOpenSettingHeadPage.getAttendeesList());
        return Result.ok((Object)((Object)purchaseTenderProjectOpenSettingHead));
    }

    @ApiOperation(value="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2", notes="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2")
    @GetMapping(value={"/queryBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER, TenderRoleEnum.BIDING_ORG})
    public Result<?> queryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        PurchaseOpenSettingHeadVO purchaseOpenSettingHeadVO = this.purchaseTenderProjectOpenSettingHeadService.queryBySubpackageId(subpackageId);
        return Result.ok((Object)((Object)purchaseOpenSettingHeadVO));
    }
}

