/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.Enhance;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.encryption.AesEncryptUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.board.dto.CountDTO;
import com.els.modules.board.service.InquiryBoardService;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.utils.RequestItemUtils;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.ebidding.entity.ProbeResult;
import com.els.modules.ebidding.service.ProbeResultService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.PurchaseImminentSourcingOrder;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.excel.PurchaseEnquiryHeadExportServiceImpl;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.utils.CostTranslateDictUtil;
import com.els.modules.enquiry.utils.DefaultValueInitUtil;
import com.els.modules.enquiry.vo.PurchaseAwardOpinionVO;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.modules.enquiry.vo.PurchaseEnquiryItemPageVO;
import com.els.modules.enquiry.vo.PurchaseEnquiryItemVO;
import com.els.modules.enquiry.vo.PurchaseEnquiryPrintVO;
import com.els.modules.inquiry.entity.PurchaseAwardOpinion;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.service.PurchaseAwardOpinionService;
import com.els.modules.searchSourceConfig.service.SearSourMaterValidService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/enquiry/purchaseEnquiryHead"})
@Api(tags={"\u91c7\u8d2d\u8be2\u4ef7\u5934"})
@BusinessModule(module="enquiry")
public class PurchaseEnquiryHeadController
extends BaseController<PurchaseEnquiryHead, PurchaseEnquiryHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEnquiryHeadController.class);
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    private PurchaseAwardOpinionService purchaseAwardOpinionService;
    @Autowired
    private SearSourMaterValidService validService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseEbiddingSupplierService ebiddingSupplierService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private RequestItemUtils requestItemUtils;
    @Autowired
    private ProbeResultService probeResultService;
    @Autowired
    private InquiryBoardService inquiryBoardService;
    @Resource
    private PurchaseEbiddingHeadService ebiddingHeadService;
    @Resource
    private PurchaseBiddingHeadService biddingHeadService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="enquiry")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:list"})
    public Result<?> queryPageList(PurchaseEnquiryHead purchaseEnquiryHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEnquiryHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseEnquiryHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @PermissionDataView(businessType="enquiry")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:list"})
    public Result<?> queryTabsCount(PurchaseEnquiryHead purchaseEnquiryHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEnquiryHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"enquiry_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"enquiry_status");
        List list = ((PurchaseEnquiryHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseEnquiryHead::getEnquiryStatus, PurchaseEnquiryHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "enquiryStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmEnquiryStatus", TenantContext.getTenant());
        String[] statuses = new String[]{"0", "1", "7", "9", "3", "10", "11", "14"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "enquiryStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5408\u540c\u67e5\u8be2\u8be2\u4ef7\u6570\u636e", notes="\u5408\u540c\u67e5\u8be2\u8be2\u4ef7\u6570\u636e")
    @GetMapping(value={"/contractQueryEnquiry"})
    @PermissionDataView(businessType="enquiry")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:list"})
    public Result<?> contractQueryEnquiry(PurchaseEnquiryItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.lambda().in(PurchaseEnquiryItem::getItemStatus, new Object[]{EnquiryStatusEnum.ACCEPT.getValue(), EnquiryStatusEnum.PRICED.getValue()});
        queryWrapper.lambda().in(PurchaseEnquiryItem::getAuditStatus, new Object[]{AuditStatusEnum.AUDIT_FINISH.getValue(), AuditStatusEnum.NO_AUDIT_REQUIRED.getValue()});
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEnquiryItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8ba2\u5355\u67e5\u8be2\u8be2\u4ef7\u6570\u636e", notes="\u8ba2\u5355\u67e5\u8be2\u8be2\u4ef7\u6570\u636e")
    @GetMapping(value={"/orderQueryEnquiryByDesc"})
    @PermissionDataView(businessType="enquiry")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:list"})
    public Result<?> orderQueryEnquiryByDesc(PurchaseEnquiryItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.lambda().in(PurchaseEnquiryItem::getItemStatus, new Object[]{EnquiryStatusEnum.ACCEPT.getValue(), EnquiryStatusEnum.PRICED.getValue()});
        queryWrapper.lambda().eq(PurchaseEnquiryItem::getMaterialDesc, (Object)item.getMaterialDesc());
        queryWrapper.lambda().and(qw -> ((LambdaQueryWrapper)qw.isNull(PurchaseEnquiryItem::getMaterialNumber)).or(qw1 -> qw1.eq(PurchaseEnquiryItem::getMaterialNumber, (Object)"")));
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEnquiryItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf\u67e5\u8be2\u8be2\u4ef7", notes="\u4f9b\u5e94\u5546\u753b\u50cf\u67e5\u8be2\u8be2\u4ef7")
    @GetMapping(value={"/supplierPortraitCount"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById", "supplier_master_data#supplierMasterData:picImage", "supplier_master_data#supplierMasterData:list", "supplier_master_data#supplierMasterData:supplierPicImage"}, logical=Logical.OR)
    public Result<?> supplierPortraitCount(@RequestParam(name="toElsAccount") String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItem::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List allList = this.purchaseEnquiryItemService.list((Wrapper)queryWrapper);
        long participationCount = allList.stream().map(PurchaseEnquiryItem::getHeadId).distinct().count();
        long biddingWinCount = allList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return Result.ok(returnMap);
    }

    @AutoLog(value="\u91c7\u8d2d\u8be2\u4ef7-\u8f6c\u5408\u540c")
    @ApiOperation(value="\u751f\u6210\u5408\u540c", notes="\u751f\u6210\u5408\u540c")
    @PostMapping(value={"/generateContract"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:generateContract"})
    public Result<?> generateContract(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)headVO.getTemplateNumber()), (String)I18nUtil.translate((String)"i18n_alert_ViFvKneIr_c1af30e5", (String)"\u8bf7\u9009\u62e9\u8303\u5f0f\u5408\u540c\u6a21\u677f"));
        List<PurchaseContractHeadDTO> strings = ((PurchaseEnquiryHeadService)this.service).generateContract(headVO);
        if (!strings.isEmpty() && strings.size() == 1) {
            return Result.ok(strings);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (PurchaseContractHeadDTO s : strings) {
            stringBuffer = stringBuffer.append(" " + s.getContractNumber());
        }
        return Result.ok((String)(I18nUtil.translate((String)"i18n_alert_bLneLRLRbLnetW0tyzqL_dd17f85e", (String)"\u751f\u6210\u5408\u540c\u6210\u529f,\u6210\u529f\u751f\u6210\u5408\u540c\u5355\u6570:${0},\u5355\u53f7\u5206\u522b\u4e3a:", (String[])new String[]{String.valueOf(strings.size())}) + stringBuffer));
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf\u67e5\u8be2\u8be2\u4ef7-\u5217\u8868\u8df3\u8f6c", notes="\u4f9b\u5e94\u5546\u753b\u50cf\u67e5\u8be2\u8be2\u4ef7-\u5217\u8868\u8df3\u8f6c")
    @GetMapping(value={"/supplierPortraiTotList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> supplierPortraiTotList(@RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="type") String type) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItem::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.eq("1".equals(type), PurchaseEnquiryItem::getItemStatus, (Object)EnquiryStatusEnum.ACCEPT.getValue());
        List allList = this.purchaseEnquiryItemService.list((Wrapper)queryWrapper);
        List ids = allList.stream().map(PurchaseEnquiryItem::getHeadId).distinct().collect(Collectors.toList());
        String id = ids.isEmpty() ? "-1" : String.join((CharSequence)",", ids);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("id", id);
        returnMap.put("isMenu", true);
        return Result.ok(returnMap);
    }

    @AutoLog(value="\u8be2\u4ef7-\u9700\u6c42\u6c60\u8f6c\u8be2\u4ef7")
    @ApiOperation(value="\u9700\u6c42\u6c60\u8f6c\u8be2\u4ef7", notes="\u9700\u6c42\u6c60\u8f6c\u8be2\u4ef7")
    @PostMapping(value={"/requestToEnquiry"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:requestToEnquiry"})
    @SrmValidated
    public Result<?> requestToEnquiry(@RequestBody PurchaseRequestHeadVO requestHeadVO) {
        List documentParentIdList;
        this.requestItemUtils.validRequestItemStatus(requestHeadVO.getPurchaseRequestItemList());
        LoginUser loginUser = SysUtil.getLoginUser();
        JSONObject companySet = loginUser.getCompanySet() == null ? new JSONObject() : loginUser.getCompanySet();
        boolean allowMultipleSources = "1".equals(companySet.getString("allowMultipleSources"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1");
        arrayList.add("2");
        String templateNumber = requestHeadVO.getTemplateNumber();
        String templateVersion = requestHeadVO.getTemplateVersion();
        Assert.hasText((String)templateNumber, (String)I18nUtil.translate((String)"i18n_alert_empty_template_num_no_null_template", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateVersion, (String)I18nUtil.translate((String)"i18n_alert_empty_template_version_num_template", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
        headVO.setTemplateNumber(templateNumber);
        headVO.setTemplateVersion(Integer.valueOf(templateVersion));
        headVO.setTemplateName(requestHeadVO.getTemplateName());
        headVO.setTemplateAccount(requestHeadVO.getTemplateAccount());
        ArrayList<PurchaseEnquiryItem> itemList = new ArrayList<PurchaseEnquiryItem>();
        List<PurchaseRequestItem> requestItemList = requestHeadVO.getPurchaseRequestItemList();
        List requestItemIdList = requestItemList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        List requestItemListDb = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(BaseEntity::getId, requestItemIdList)).list();
        ArrayList<PurchaseRequestItem> dbRequestItemList = new ArrayList<PurchaseRequestItem>();
        block0: for (PurchaseRequestItem purchaseRequestItem : requestItemList) {
            for (Object item1 : requestItemListDb) {
                if (!Objects.equals(purchaseRequestItem.getId(), item1.getId())) continue;
                dbRequestItemList.add((PurchaseRequestItem)((Object)item1));
                continue block0;
            }
        }
        List orgList = dbRequestItemList.stream().map(item -> item.getPurchaseOrg() == null ? "" : item.getPurchaseOrg()).distinct().collect(Collectors.toList());
        Assert.isTrue((orgList.size() == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_oper_no_the_same_purchase_organization", (String)"\u76f8\u540c\u91c7\u8d2d\u7ec4\u7ec7\u624d\u53ef\u8f6c\u5355"));
        this.validService.requestPoolValid("0", ((PurchaseRequestItem)((Object)dbRequestItemList.get(0))).getPurchaseOrg(), dbRequestItemList);
        for (PurchaseRequestItem requestItem : dbRequestItemList) {
            if (allowMultipleSources) continue;
            Assert.isTrue((boolean)arrayList.contains(requestItem.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_nRUVtyWWWWWWEyWWWWWWxBnHeiTOmhjER_5462a613", (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7:${0},\u884c\u53f7:${1},\u4e0d\u7b26\u5408\u7cfb\u7edf\u5141\u8bb8\u591a\u6b21\u5bfb\u6e90\u914d\u7f6e", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
        }
        List<PurchaseRequestItem> list = this.purchaseRequestItemService.mergeRequest(dbRequestItemList);
        Map<String, String> itemValueMap = DefaultValueInitUtil.getItemDefaultValue(requestHeadVO.getTemplateAccount(), templateNumber, templateVersion);
        for (PurchaseRequestItem requestItem : list) {
            PurchaseEnquiryItem item3 = new PurchaseEnquiryItem();
            BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item3));
            item3.setId(null);
            item3.setSourceType(SourceTypeEnum.REQUEST.getValue());
            item3.setSourceNumber(requestItem.getRequestNumber());
            item3.setSourceItemNumber(requestItem.getItemNumber());
            item3.setSourceId(requestItem.getHeadId());
            item3.setSourceItemId(requestItem.getId());
            item3.setDocumentItemId(requestItem.getDocumentItemId());
            item3.setDocumentId(requestItem.getDocumentId());
            item3.setDocumentParentId(requestItem.getId());
            item3.setPriceUnit(requestItem.getUnitPrice());
            String purchaseUnit = DefaultValueInitUtil.getFieldValue(itemValueMap, "purchaseUnit", requestItem.getPurchaseUnit());
            String purchaseType = DefaultValueInitUtil.getFieldValue(itemValueMap, "purchaseType", requestItem.getPurchaseType());
            item3.setPurchaseUnit(purchaseUnit);
            item3.setPurchaseType(purchaseType);
            item3.setRequireQuantity(requestItem.getQuantity());
            item3.setRequireDate(requestItem.getDeliveryDate());
            item3.setFuturePrice(requestItem.getBudgetPrice());
            item3.setPrice(null);
            item3.setNetPrice(null);
            item3.setCreateBy(null);
            item3.setCreateTime(null);
            item3.setCreateById(null);
            item3.setUpdateBy(null);
            item3.setUpdateById(null);
            item3.setUpdateTime(null);
            itemList.add(item3);
        }
        List documentIdList = list.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getDocumentId())).map(PurchaseRequestItem::getDocumentId).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(documentIdList)) {
            headVO.setDocumentId(String.join((CharSequence)",", documentIdList));
        }
        if (CollectionUtil.isNotEmpty(documentParentIdList = list.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getHeadId())).map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList()))) {
            headVO.setDocumentParentId(String.join((CharSequence)",", documentParentIdList));
        }
        headVO.setPurchaseEnquiryItemList(itemList);
        headVO.setCompany(list.get(0).getCompany());
        Map<String, String> headValueMap = DefaultValueInitUtil.getHeadDefaultValue(requestHeadVO.getTemplateAccount(), templateNumber, templateVersion);
        String purchaseGroup = DefaultValueInitUtil.getFieldValue(headValueMap, "purchaseGroup", list.get(0).getPurchaseGroup());
        headVO.setPurchaseGroup(purchaseGroup);
        headVO.setPurchaseOrg(list.get(0).getPurchaseOrg());
        if ("person".equals(list.get(0).getTacticsEntity())) {
            headVO.setPurchasePrincipal(list.get(0).getTacticsObject());
        } else {
            headVO.setPurchasePrincipal(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        }
        List headIds = requestHeadVO.getPurchaseRequestItemList().stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
        Map headIdList = requestHeadVO.getPurchaseRequestItemList().stream().collect(Collectors.groupingBy(PurchaseRequestItem::getHeadId, Collectors.mapping(PurchaseRequestItem::getItemNumber, Collectors.toList())));
        List<PurchaseAttachmentDTO> requestAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainIds(headIds);
        requestAttachmentDTOS = requestAttachmentDTOS.stream().filter(x -> {
            if (CharSequenceUtil.isEmpty((CharSequence)x.getItemNumber())) {
                return true;
            }
            List itemFileNnmber = (List)headIdList.get(x.getHeadId());
            if (CollectionUtil.isEmpty((Collection)itemFileNnmber)) {
                return false;
            }
            return itemFileNnmber.contains(x.getItemNumber());
        }).collect(Collectors.toList());
        HashMap<CallSite, CallSite> itemIndex = new HashMap<CallSite, CallSite>();
        HashMap<CallSite, String> itemNumber = new HashMap<CallSite, String>();
        for (int i2 = 0; i2 < itemList.size(); ++i2) {
            PurchaseEnquiryItem item4 = (PurchaseEnquiryItem)((Object)itemList.get(i2));
            itemIndex.put((CallSite)((Object)(item4.getHeadId() + "_" + item4.getSourceItemNumber())), (CallSite)((Object)("" + (i2 + 1))));
            itemNumber.put((CallSite)((Object)(item4.getHeadId() + "_" + item4.getSourceItemNumber())), item4.getSourceNumber());
        }
        for (PurchaseAttachmentDTO dto : requestAttachmentDTOS) {
            if (itemIndex.containsKey(dto.getHeadId() + "_" + dto.getItemNumber())) {
                dto.setItemNumber((String)itemIndex.get(dto.getHeadId() + "_" + dto.getItemNumber()));
                dto.setSourceNumber((String)itemNumber.get(dto.getHeadId() + "_" + dto.getItemNumber()));
            }
            dto.setHeadId(null);
            dto.setId(null);
            dto.setRelationId(null);
            dto.setCreateBy(null);
            dto.setCreateById(null);
            dto.setCreateTime(null);
            dto.setUpdateTime(null);
            dto.setUpdateBy(null);
            dto.setUpdateById(null);
        }
        headVO.setPurchaseAttachmentList(requestAttachmentDTOS);
        ((PurchaseEnquiryHeadService)this.service).saveMain(headVO);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_shuLRWhutyLWWWWWWW_5f1875b1", (String)"\u8f6c\u8be2\u4ef7\u6210\u529f,\u8be2\u4ef7\u5355\u53f7\u4e3a:[${0}]", (String[])new String[]{headVO.getEnquiryNumber()}), Arrays.asList(headVO));
    }

    @AutoLog(value="\u8be2\u4ef7-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:add"})
    @PermissionDataOpt(businessType="enquiry", beanClass=PurchaseEnquiryHeadService.class)
    @SrmValidated
    public Result<?> add(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_template_num_no_null_template", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_template_version_num_template", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        headVO.setAuditStatus("1".equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ((PurchaseEnquiryHeadService)this.service).saveMain(headVO);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u8be2\u4ef7-\u8865\u5145\u7269\u6599\u7f16\u7801")
    @ApiOperation(value="\u8865\u5145\u7269\u6599\u7f16\u7801", notes="\u8865\u5145\u7269\u6599\u7f16\u7801")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:replenishMaterialNumber"})
    @PostMapping(value={"/replenishMaterialNumber"})
    @SrmValidated
    public Result<?> replenishMaterialNumber(@RequestBody PurchaseEnquiryItem webItem) {
        Assert.notNull((Object)((Object)webItem), (String)I18nUtil.translate((String)"i18n_alert_xVjcVHxOLV_24626b86", (String)"\u8865\u5145\u7684\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        this.purchaseEnquiryItemService.replenishMaterialNumber(webItem);
        return Result.ok((Object)3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:edit"})
    @PermissionDataOpt(businessType="enquiry", beanClass=PurchaseEnquiryHeadService.class)
    @SrmValidated
    public Result<?> edit(@RequestBody PurchaseEnquiryHeadVO headVO) {
        if (StrUtil.isNotBlank((CharSequence)headVO.getId())) {
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headVO.getId())));
            Assert.isNull((Object)dbHead.getPublishTime(), (String)I18nUtil.translate((String)"i18n_alert_IhxjtFxqKmAt_8f58052a", (String)"\u5df2\u53d1\u5e03\u7684\u5355\u636e\u4e0d\u53ef\u518d\u6b21\u7f16\u8f91"));
        }
        headVO.setAuditStatus("1".equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ((PurchaseEnquiryHeadService)this.service).updateMain(headVO);
        String id = headVO.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u8be2\u4ef7-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/editItemList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:edit"})
    @PermissionDataOpt(businessType="enquiry", beanClass=PurchaseEnquiryHeadService.class)
    @SrmValidated
    public Result<?> editItemList(@RequestBody List<PurchaseEnquiryItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return this.commonSuccessResult(3);
        }
        ArrayList newItemList = new ArrayList();
        itemList.forEach(e -> {
            PurchaseEnquiryItem newItem = new PurchaseEnquiryItem();
            newItem.setQuotaScale(e.getQuotaScale());
            newItem.setId(e.getId());
            newItem.setQuotaQuantity(e.getQuotaQuantity());
            newItemList.add(newItem);
        });
        this.purchaseEnquiryItemService.updateBatchById(newItemList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:copy"})
    @PermissionDataOpt(businessType="enquiry", beanClass=PurchaseEnquiryHeadService.class)
    public Result<?> copy(@RequestParam(name="id") String id) {
        List dbItemList;
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        Assert.isTrue((!EnquiryStatusEnum.PUBLISH_FAILED.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__hxKmjtFxqIBR_b1883f75", (String)"\u53d1\u5e03\u5931\u8d25\u7684\u5355\u636e\u4e0d\u53ef\u4ee5\u590d\u5236"));
        if (EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            dbItemList = this.purchaseEnquiryItemService.selectByMainId(id);
        } else {
            ElsInitialTableDTO itemInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(id);
            dbItemList = JSON.parseArray((String)itemInitInfo.getBusinessInfoJson(), PurchaseEnquiryItem.class);
        }
        List<EnquirySupplierList> dbSupplierList = this.enquirySupplierListService.selectByMainId(id);
        List attachmentDemandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        dbHead.setAuditStatus("1".equals(dbHead.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        dbHead.setResultAuditStatus("1".equals(dbHead.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ((PurchaseEnquiryHeadService)this.service).copy(dbHead, dbItemList, dbSupplierList, attachmentDemandList);
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u8be2\u4ef7-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:publish"})
    @PermissionDataOpt(businessType="enquiry", beanClass=PurchaseEnquiryHeadService.class)
    @SrmValidated
    public Result<?> publish(@RequestBody PurchaseEnquiryHeadVO headVO) {
        this.validService.publishEnquiry(headVO.getPurchaseOrg(), headVO.getPurchaseEnquiryItemList());
        Assert.hasText((String)headVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_template_num_no_null_template", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_template_version_num_template", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        if (StrUtil.isNotBlank((CharSequence)headVO.getId())) {
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headVO.getId())));
            Assert.isNull((Object)dbHead.getPublishTime(), (String)I18nUtil.translate((String)"i18n_alert_IhxjtFxqKmhx_8f529641", (String)"\u5df2\u53d1\u5e03\u7684\u5355\u636e\u4e0d\u53ef\u518d\u6b21\u53d1\u5e03"));
        }
        String elsAccount = this.getTenantId();
        headVO.setElsAccount(elsAccount);
        headVO.setBusAccount(elsAccount);
        headVO.setAuditStatus("1".equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ((PurchaseEnquiryHeadService)this.service).publish(headVO);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u8be2\u4ef7-\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:delete"})
    @PermissionDataOpt(businessType="enquiry", beanClass=PurchaseEnquiryHeadService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        ((PurchaseEnquiryHeadService)this.service).delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8be2\u4ef7-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:deleteBatch"})
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        ((PurchaseEnquiryHeadService)this.service).delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> queryItemPageList(PurchaseEnquiryItem purchaseEnquiryItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String headId = purchaseEnquiryItem.getHeadId();
        if (StrUtil.isBlank((CharSequence)headId)) {
            throw new ELSBootException("\u8be2\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEnquiryItem), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEnquiryItemService.page((IPage)page, (Wrapper)queryWrapper);
        List itemList = pageList.getRecords();
        if (!CollectionUtils.isEmpty((Collection)itemList)) {
            CostTranslateDictUtil.build().translatePurchase(itemList);
        }
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            this.purchaseEnquiryItemService.hideQuotePrice(dbHead, itemList);
        }
        ArrayList pageVOS = SysUtil.copyProperties((List)itemList, PurchaseEnquiryItemPageVO.class);
        for (PurchaseEnquiryItemPageVO pageVO : pageVOS) {
            pageVO.setTemplateAccount(dbHead.getTemplateAccount());
            pageVO.setTemplateNumber(dbHead.getTemplateNumber());
            pageVO.setTemplateVersion(dbHead.getTemplateVersion());
            pageVO.setBusAccount(dbHead.getBusAccount());
        }
        Page result = new Page(pageList.getCurrent(), pageList.getSize(), pageList.getTotal());
        result.setRecords((List)pageVOS);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u8be6\u60c5", notes="\u901a\u8fc7id\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    @Enhance(enhancePoint="enquiryDetail")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    @BusinessModule(module="enquiry")
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(id);
        if (!CollectionUtils.isEmpty(itemList)) {
            CostTranslateDictUtil.build().translatePurchase(itemList);
        }
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            this.purchaseEnquiryItemService.hideQuotePrice(dbHead, itemList);
        }
        headVO.setPurchaseEnquiryItemList(itemList);
        List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(id);
        headVO.setEnquirySupplierListList(supplierList);
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        headVO.setPurchaseAttachmentList(attachmentList);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        headVO.setPurchaseAttachmentDemandList(demandList);
        List<PurchaseAwardOpinion> awardOpinionList = this.purchaseAwardOpinionService.selectByMainId(id);
        headVO.setPurchaseAwardOpinionList(awardOpinionList);
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(id);
        if (initInfo != null) {
            List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEnquiryItem.class);
            headVO.setInitItemList(initItemList);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"relation_id", (Object)id);
        queryWrapper.eq((Object)"relation_module", (Object)"enquiry");
        List resultList = this.probeResultService.list((Wrapper)queryWrapper);
        headVO.setProbeResultList(resultList);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(busModule="\u8be2\u4ef7\u7ba1\u7406-\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b", value="\u8be2\u4ef7\u7ba1\u7406-\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b")
    @ApiOperation(value="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b", notes="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b")
    @GetMapping(value={"/queryRisk"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> queryRisk(@RequestParam(name="id") String id) {
        List<PurchaseEnquiryItem> purchaseBiddingItemList = this.purchaseEnquiryItemService.selectByMainId(id);
        if (purchaseBiddingItemList == null || purchaseBiddingItemList.size() == 0) {
            return Result.ok(new ArrayList());
        }
        List<String> toElsAccounts = Optional.ofNullable(purchaseBiddingItemList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        List<SupplierRelationFindResultVO> resultList = this.ebiddingSupplierService.probeSupplier(toElsAccounts);
        if (purchaseBiddingItemList.size() > 1) {
            resultList.addAll(this.purchaseEnquiryItemService.probeIP(purchaseBiddingItemList));
        }
        List supplierNameList = Optional.ofNullable(purchaseBiddingItemList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(PurchaseEnquiryItem::getSupplierName).distinct().collect(Collectors.toList());
        ProbeResult probeResult = new ProbeResult();
        probeResult.setId(IdWorker.getIdStr());
        probeResult.setElsAccount(TenantContext.getTenant());
        probeResult.setSupplierName(StringUtils.join(supplierNameList, (String)","));
        probeResult.setRelationId(id);
        probeResult.setRelationModule("enquiry");
        probeResult.setProbeResult(this.probeResultService.processProbeResult(resultList));
        probeResult.setDeleted(CommonConstant.DEL_FLAG_0);
        probeResult.setCreateBy(SysUtil.getLoginUser().getSubAccount());
        probeResult.setCreateTime(new Date());
        this.probeResultService.save((Object)probeResult);
        return Result.ok(resultList);
    }

    @ApiOperation(value="\u8be2\u4ef7\u5927\u5385\u5934\uff0c\u7269\u6599\u67e5\u8be2", notes="\u8be2\u4ef7\u5927\u5385\u5934\uff0c\u7269\u6599\u67e5\u8be2")
    @GetMapping(value={"/queryMaterialList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> queryMaterialList(@RequestParam(name="headId") String headId) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
        List distinctList = itemList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber())))), ArrayList::new));
        headVO.setPurchaseEnquiryItemList(distinctList);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u8be2\u4ef7\u5927\u5385\u5e38\u89c4\u6bd4\u4ef7\u67e5\u8be2", notes="\u8be2\u4ef7\u5927\u5385\u5e38\u89c4\u6bd4\u4ef7\u67e5\u8be2")
    @GetMapping(value={"/queryDetailsCompare"})
    @Enhance(enhancePoint="enquiryDetailCompare")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> queryDetailsCompare(@RequestParam(name="headId") String headId, @RequestParam(name="itemNumber") String itemNumber) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.notNull((Object)((Object)dbHead), (String)I18nUtil.translate((String)"i18n_alert_WFxMKSIqQG_3b3ce094", (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(headId).stream().filter(item -> itemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            this.purchaseEnquiryItemService.hideQuotePrice(dbHead, itemList);
        }
        this.purchaseEnquiryItemService.initCompareMsg(dbHead, itemList);
        ArrayList detailsList = SysUtil.copyProperties(itemList, PurchaseEnquiryItemVO.class);
        List<PurchaseEnquiryItemVO> sortList = detailsList.stream().filter(item -> item.getPrice() != null && item.getQuoteTime() != null).sorted(Comparator.comparing(PurchaseEnquiryItem::getPrice).thenComparing(PurchaseEnquiryItem::getQuoteTime)).collect(Collectors.toList());
        this.setQuoteRank(detailsList, sortList);
        return Result.ok((Object)detailsList);
    }

    private void setQuoteRank(List<PurchaseEnquiryItemVO> itemList, List<PurchaseEnquiryItemVO> sortList) {
        block0: for (int i = 0; i < sortList.size(); ++i) {
            for (PurchaseEnquiryItemVO item : itemList) {
                if (!item.getId().equals(sortList.get(i).getId())) continue;
                int rank = i + 1;
                item.setQuoteRank(rank);
                continue block0;
            }
        }
        itemList.sort(Comparator.comparing(PurchaseEnquiryItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
    }

    @ApiOperation(value="\u8be2\u4ef7\u5927\u5385\u9636\u68af\u6bd4\u4ef7\u67e5\u8be2", notes="\u8be2\u4ef7\u5927\u5385\u9636\u68af\u6bd4\u4ef7\u67e5\u8be2")
    @GetMapping(value={"/queryLadderCompare"})
    @Enhance(enhancePoint="enquiryDetailCompare")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> queryLadderCompare(@RequestParam(name="headId") String headId, @RequestParam(name="itemNumber") String itemNumber) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.notNull((Object)((Object)dbHead), (String)I18nUtil.translate((String)"i18n_alert_WFxMKSIqQG_3b3ce094", (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(headId).stream().filter(item -> itemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            this.purchaseEnquiryItemService.hideQuotePrice(dbHead, itemList);
        }
        this.purchaseEnquiryItemService.initCompareMsg(dbHead, itemList);
        String price = QuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType()) ? "price" : "netPrice";
        List ladderJsonList = itemList.stream().filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())).filter(item -> StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())).map(PurchaseEnquiryItem::getLadderPriceJson).collect(Collectors.toList());
        ArrayList<Map<String, String>> ladderColumn = new ArrayList<Map<String, String>>();
        if (CollectionUtil.isNotEmpty(ladderJsonList)) {
            JSONArray ladderJsonArray = JSONObject.parseArray((String)((String)ladderJsonList.get(0)));
            for (Object object : ladderJsonArray) {
                JSONObject ladderData = (JSONObject)object;
                HashMap<String, Object> column = new HashMap<String, Object>();
                column.put("field", price + "-" + ladderData.getString("ladderQuantity"));
                column.put("title", ladderData.getString("ladder"));
                column.put("width", "150");
                ladderColumn.add(column);
            }
        }
        ArrayList<PurchaseEnquiryItemVO> ladderList = new ArrayList<PurchaseEnquiryItemVO>();
        for (PurchaseEnquiryItem item2 : itemList) {
            PurchaseEnquiryItemVO vo = new PurchaseEnquiryItemVO();
            BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)vo));
            vo.setLadderColumn(ladderColumn);
            if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item2.getQuotePriceWay()) && StrUtil.isNotBlank((CharSequence)item2.getLadderPriceJson())) {
                JSONArray ladderJsonArray = JSONObject.parseArray((String)item2.getLadderPriceJson());
                HashMap<String, String> ladderDataMap = new HashMap<String, String>();
                for (Object object : ladderJsonArray) {
                    JSONObject ladderData = (JSONObject)object;
                    ladderDataMap.put(price + "-" + ladderData.getString("ladderQuantity"), ladderData.getString(price));
                }
                vo.setLadderDataMap(ladderDataMap);
            }
            ladderList.add(vo);
        }
        return Result.ok(ladderList);
    }

    @ApiOperation(value="\u8be2\u4ef7\u5927\u5385\u6210\u672c\u6bd4\u4ef7\u67e5\u8be2", notes="\u8be2\u4ef7\u5927\u5385\u6210\u672c\u6bd4\u4ef7\u67e5\u8be2")
    @GetMapping(value={"/queryCostCompare"})
    @Enhance(enhancePoint="enquiryDetailCompare")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> queryCostCompare(@RequestParam(name="headId") String headId, @RequestParam(name="itemNumber") String itemNumber) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.notNull((Object)((Object)dbHead), (String)I18nUtil.translate((String)"i18n_alert_WFxMKSIqQG_3b3ce094", (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(headId).stream().filter(item -> itemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
        CostTranslateDictUtil.build().translatePurchase(itemList);
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            this.purchaseEnquiryItemService.hideQuotePrice(dbHead, itemList);
        }
        this.purchaseEnquiryItemService.initCompareMsg(dbHead, itemList);
        List costFormJsonList = itemList.stream().filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())).filter(item -> StrUtil.isNotBlank((CharSequence)item.getCostFormJson())).map(PurchaseEnquiryItem::getCostFormJson).collect(Collectors.toList());
        List column = null;
        if (CollectionUtil.isNotEmpty(costFormJsonList)) {
            JSONObject costJson = JSONObject.parseObject((String)((String)costFormJsonList.get(0)));
            column = this.invokeBaseRpcService.getColumnByNumber(costJson.getString("templateNumber"), costJson.getInteger("templateVersion").intValue());
        }
        ArrayList<PurchaseEnquiryItemVO> costList = new ArrayList<PurchaseEnquiryItemVO>();
        for (PurchaseEnquiryItem item2 : itemList) {
            PurchaseEnquiryItemVO vo = new PurchaseEnquiryItemVO();
            BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)vo));
            vo.setCostColumn(column);
            if (EnquiryQuoteWayEnum.COST.getValue().equals(item2.getQuotePriceWay()) && StrUtil.isNotBlank((CharSequence)item2.getCostFormJson())) {
                JSONObject costJson = JSONObject.parseObject((String)item2.getCostFormJson());
                JSONArray groups = costJson.getJSONArray("groups") == null ? new JSONArray() : costJson.getJSONArray("groups");
                HashMap<String, String> costDataMap = new HashMap<String, String>();
                for (Object obj : groups) {
                    JSONObject data = (JSONObject)obj;
                    costDataMap.put(data.getString("groupCode"), data.getString("totalValue"));
                }
                vo.setCostDataMap(costDataMap);
            }
            costList.add(vo);
        }
        return Result.ok(costList);
    }

    @ApiOperation(value="\u6253\u5305\u6bd4\u4ef7\u67e5\u8be2", notes="\u6253\u5305\u6bd4\u4ef7\u67e5\u8be2")
    @GetMapping(value={"/queryPackageCompare"})
    @Enhance(enhancePoint="enquiryDetailCompare")
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> queryPackageCompare(@RequestParam(name="headId") String headId) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.notNull((Object)((Object)dbHead), (String)I18nUtil.translate((String)"i18n_alert_WFxMKSIqQG_3b3ce094", (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
        this.purchaseEnquiryItemService.hideQuotePrice(dbHead, itemList);
        this.purchaseEnquiryItemService.initPackageCompareMsg(dbHead, itemList);
        Map packageMap = itemList.stream().collect(Collectors.toMap(PurchaseEnquiryItem::getToElsAccount, Function.identity(), (oldVal, newVal) -> {
            BigDecimal newTaxAmount = newVal.getTaxAmount();
            BigDecimal oldTaxAmount = oldVal.getTaxAmount();
            if (newTaxAmount == null || oldTaxAmount == null) {
                oldVal.setTaxAmount(null);
                oldVal.setNetAmount(null);
            } else {
                oldVal.setTaxAmount(oldTaxAmount.add(newTaxAmount));
            }
            BigDecimal newNetAmount = newVal.getNetAmount();
            BigDecimal oldNetAmount = oldVal.getNetAmount();
            if (newNetAmount == null || oldNetAmount == null) {
                oldVal.setTaxAmount(null);
                oldVal.setNetAmount(null);
            } else {
                oldVal.setNetAmount(oldNetAmount.add(newNetAmount));
            }
            if (newVal.getUpdateTime().compareTo(oldVal.getUpdateTime()) > 0) {
                oldVal.setItemStatus(newVal.getItemStatus());
            }
            return oldVal;
        }));
        ArrayList<PurchaseEnquiryItemVO> packageList = new ArrayList<PurchaseEnquiryItemVO>();
        for (PurchaseEnquiryItem item2 : packageMap.values()) {
            PurchaseEnquiryItemVO vo = new PurchaseEnquiryItemVO();
            BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)vo));
            packageList.add(vo);
        }
        List<PurchaseEnquiryItemVO> sortList = packageList.stream().filter(item -> item.getTaxAmount() != null && item.getQuoteTime() != null).sorted(Comparator.comparing(PurchaseEnquiryItem::getTaxAmount).thenComparing(PurchaseEnquiryItem::getQuoteTime)).collect(Collectors.toList());
        this.setQuoteRank(packageList, sortList);
        return Result.ok(packageList);
    }

    @ApiOperation(value="\u7ed3\u679c\u5ba1\u6279\u6570\u636e\u67e5\u8be2", notes="\u7ed3\u679c\u5ba1\u6279\u6570\u636e\u67e5\u8be2")
    @GetMapping(value={"/resultAuditQuery"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> auditQuery(@RequestParam(name="id") String id) {
        List<PurchaseAwardOpinion> purchaseAwardOpinions;
        List attachmentList;
        List<PurchaseEnquiryItem> itemList;
        String headId = id.contains("_") ? id.split("_")[0] : id;
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        if (id.contains("_")) {
            List<PurchaseAwardOpinion> queryPurchaseAwardOpinionList = this.purchaseAwardOpinionService.selectByMainId(headId);
            List<String> itemNumbers = Arrays.asList(id.split("_")[1].split(","));
            itemList = this.purchaseEnquiryItemService.selectByMainId(headId).stream().filter(item -> itemNumbers.contains(item.getItemNumber())).collect(Collectors.toList());
            attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(headId).stream().filter(attachment -> StrUtil.isEmpty((CharSequence)attachment.getItemNumber()) || itemNumbers.contains(attachment.getItemNumber())).collect(Collectors.toList());
            List itemNumberList = itemNumbers.stream().distinct().sorted().collect(Collectors.toList());
            String join = String.join((CharSequence)",", itemNumberList);
            purchaseAwardOpinions = queryPurchaseAwardOpinionList.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getItemNumber()) && item.getItemNumber().equals(join)).collect(Collectors.toList());
        } else {
            purchaseAwardOpinions = this.purchaseAwardOpinionService.selectByMainId(headId);
            itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
            attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(headId);
        }
        headVO.setPurchaseEnquiryItemList(itemList);
        headVO.setPurchaseAttachmentList(attachmentList);
        headVO.setPurchaseAttachmentDemandList(this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId));
        headVO.setPurchaseAwardOpinionList(purchaseAwardOpinions);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u8be2\u4ef7-\u66f4\u65b0\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4")
    @ApiOperation(value="\u66f4\u65b0\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4", notes="\u66f4\u65b0\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4")
    @PostMapping(value={"/updateQuoteEntTime"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:updateQuoteEntTime"})
    @SrmValidated
    public Result<?> updateQuoteEntTime(@RequestBody PurchaseEnquiryHeadVO headVO) {
        String headId = headVO.getId();
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)"1".equals(dbHead.getAllowDelay()), (String)I18nUtil.translate((String)"i18n_alert_APtFxqcryRKI_9d4cd956", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u53ef\u4fee\u6539\u622a\u6b62\u65f6\u95f4"));
        String status = dbHead.getEnquiryStatus();
        boolean canDo = EnquiryStatusEnum.QUOTING.getValue().equals(status) || EnquiryStatusEnum.NO_QUOTE.getValue().equals(status);
        Assert.isTrue((boolean)canDo, (String)I18nUtil.translate((String)"i18n_alert_susSLsujtFnqtk_d3bccbcd", (String)"\u62a5\u4ef7\u4e2d\u6216\u672a\u62a5\u4ef7\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
        Date quoteEndTime = headVO.getQuoteEndTime();
        Assert.notNull((Object)quoteEndTime, (String)I18nUtil.translate((String)"i18n_alert_suyRKIxOLV_95472738", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((boolean)quoteEndTime.after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_yRKIlTfUAPKI_f7e8be6b", (String)"\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
        Assert.isTrue((boolean)quoteEndTime.after(dbHead.getQuoteEndTime()), (String)I18nUtil.translate((String)"i18n_alert_yRKIlTfUjyRKI_678924e2", (String)"\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u539f\u622a\u6b62\u65f6\u95f4"));
        ((PurchaseEnquiryHeadService)this.service).updateQuoteEntTime(dbHead, quoteEndTime);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u5f00\u6807")
    @ApiOperation(value="\u5f00\u6807", notes="\u5f00\u6807")
    @PostMapping(value={"/openBid"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:openBid"})
    @SrmValidated
    public Result<?> openBid(@RequestBody PurchaseEnquiryHeadVO headVO) {
        String headId = headVO.getId();
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)"1".equals(dbHead.getOpenBidBefore()), (String)I18nUtil.translate((String)"i18n_alert_APtFxqDPvB_39ac0c19", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u53ef\u63d0\u524d\u5f00\u6807"));
        Assert.isTrue((boolean)EnquiryStatusEnum.QUOTING.getValue().equals(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_susntFnqvB_972759ab", (String)"\u62a5\u4ef7\u4e2d\u7684\u5355\u636e\u624d\u53ef\u5f00\u6807"));
        String openBidWord = headVO.getOpenBidWord();
        Assert.hasText((String)openBidWord, (String)I18nUtil.translate((String)"i18n_alert_vBwoxOLV_e5606b52", (String)"\u5f00\u6807\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((boolean)dbHead.getOpenBidWord().equals(AesEncryptUtil.encrypt((String)openBidWord)), (String)I18nUtil.translate((String)"i18n_alert_vBwoNS_1dee9b8", (String)"\u5f00\u6807\u5bc6\u7801\u9519\u8bef"));
        ((PurchaseEnquiryHeadService)this.service).openBid(dbHead, false);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u67e5\u770b\u5f00\u6807\u5bc6\u7801", notes="\u67e5\u770b\u5f00\u6807\u5bc6\u7801")
    @GetMapping(value={"/viewPassword"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:viewPassword"})
    public Result<?> viewPassword(@RequestParam(value="headId") String headId) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        String opd = dbHead.getOpenBidWord();
        opd = StrUtil.isNotBlank((CharSequence)opd) ? AesEncryptUtil.desEncrypt((String)opd) : I18nUtil.translate((String)"i18n_alert_SvBwo_c85bce22", (String)"\u65e0\u5f00\u6807\u5bc6\u7801");
        return Result.ok((String)opd.trim());
    }

    @AutoLog(value="\u8be2\u4ef7-\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546")
    @ApiOperation(value="\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546", notes="\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546")
    @PostMapping(value={"/publishNewSupplier"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:publishNewSupplier"})
    @SrmValidated
    public Result<?> publishNewSupplier(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((boolean)new Date().before(headVO.getQuoteEndTime()), (String)I18nUtil.translate((String)"i18n__APKIfUsuyRKIxqhxVjRdX_69b67cca", (String)"\u5f53\u524d\u65f6\u95f4\u5927\u4e8e\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4, \u4e0d\u53ef\u53d1\u5e03\u65b0\u7684\u4f9b\u5e94\u5546"));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headVO.getId())));
        Assert.isTrue((!"0".equals(dbHead.getPublishNewSupplier()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APtFxqhxVRdX_dac5ea44", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        Assert.isTrue((!"1".equals(dbHead.getOpenBidStatus()) && !EnquiryStatusEnum.BARGAIN.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_IDPvBxqhxVjRdX_a1099bfb", (String)"\u5df2\u63d0\u524d\u5f00\u6807, \u4e0d\u53ef\u53d1\u5e03\u65b0\u7684\u4f9b\u5e94\u5546"));
        List<String> status = Arrays.asList(EnquiryStatusEnum.QUOTING.getValue(), EnquiryStatusEnum.BARGAIN.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjsusSIusntFnqhxVRdX_88c41b44", (String)"\u53ea\u6709\u62a5\u4ef7\u4e2d\u6216\u8bae\u4ef7\u4e2d\u7684\u5355\u636e\u624d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        List<EnquirySupplierList> chooseSupplierList = headVO.getEnquirySupplierListList();
        Assert.notEmpty(chooseSupplierList, (String)I18nUtil.translate((String)"i18n_alert_SvBwo_c85bce22", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d1\u5e03\u7684\u4f9b\u5e94\u5546"));
        ((PurchaseEnquiryHeadService)this.service).publishNewSupplier(dbHead, chooseSupplierList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u4e00\u952e\u6388\u6807")
    @ApiOperation(value="\u4e00\u952e\u6388\u6807", notes="\u4e00\u952e\u6388\u6807")
    @GetMapping(value={"/oneAward"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:accept"})
    public Result<?> oneAward(@RequestParam(value="headId") String headId, @RequestParam(value="optType") String optType) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.isTrue((!EnquiryStatusEnum.QUOTING.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_suLyRWxqtk_598b4d4d", (String)"\u62a5\u4ef7\u672a\u622a\u6b62\uff0c\u4e0d\u53ef\u64cd\u4f5c"));
        ((PurchaseEnquiryHeadService)this.service).oneAward(dbHead, optType);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u63a5\u53d7")
    @ApiOperation(value="\u63a5\u53d7", notes="\u63a5\u53d7")
    @PostMapping(value={"/accept"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:accept"})
    @SrmValidated
    public Result<?> accept(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notEmpty(headVO.getPurchaseEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_tkjWFcxOLV_5c4c7b49", (String)"\u64cd\u4f5c\u7684\u6570\u636e\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEnquiryHeadService)this.service).accept(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u5168\u90e8\u7269\u6599\u63a5\u53d7")
    @ApiOperation(value="\u5168\u90e8\u7269\u6599\u63a5\u53d7", notes="\u5168\u90e8\u7269\u6599\u63a5\u53d7")
    @PostMapping(value={"/allAccept"})
    @SrmValidated
    public Result<?> allAccept(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notEmpty(headVO.getPurchaseEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_tkjWFcxOLV_5c4c7b49", (String)"\u64cd\u4f5c\u7684\u6570\u636e\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEnquiryHeadService)this.service).allAccept(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u5168\u90e8\u7269\u6599\u62d2\u7edd")
    @ApiOperation(value="\u5168\u90e8\u7269\u6599\u62d2\u7edd", notes="\u5168\u90e8\u7269\u6599\u62d2\u7edd")
    @PostMapping(value={"/allReject"})
    @SrmValidated
    public Result<?> allReject(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notEmpty(headVO.getPurchaseEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_tkjWFcxOLV_5c4c7b49", (String)"\u64cd\u4f5c\u7684\u6570\u636e\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEnquiryHeadService)this.service).allReject(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u4f59\u884c\u5168\u90e8\u62d2\u7edd")
    @ApiOperation(value="\u4f59\u884c\u5168\u90e8\u62d2\u7edd", notes="\u4f59\u884c\u5168\u90e8\u62d2\u7edd")
    @PostMapping(value={"/partReject"})
    @SrmValidated
    public Result<?> partReject(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notEmpty(headVO.getPurchaseEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_tkjWFcxOLV_5c4c7b49", (String)"\u64cd\u4f5c\u7684\u6570\u636e\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEnquiryHeadService)this.service).partReject(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u62d2\u7edd")
    @ApiOperation(value="\u62d2\u7edd", notes="\u62d2\u7edd")
    @PostMapping(value={"/reject"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:reject"})
    @SrmValidated
    public Result<?> reject(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notEmpty(headVO.getPurchaseEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_tkjWFcxOLV_5c4c7b49", (String)"\u64cd\u4f5c\u7684\u6570\u636e\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEnquiryHeadService)this.service).reject(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u64a4\u9500")
    @ApiOperation(value="\u64a4\u9500", notes="\u64a4\u9500")
    @PostMapping(value={"/revoke"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:revoke"})
    @SrmValidated
    public Result<?> revoke(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        List<PurchaseEnquiryItem> itemList = headVO.getPurchaseEnquiryItemList();
        Assert.notEmpty(itemList, (String)I18nUtil.translate((String)"i18n_alert_tkjWFcxOLV_5c4c7b49", (String)"\u64cd\u4f5c\u7684\u6570\u636e\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        itemList.forEach(item -> Assert.isTrue((!AuditStatusEnum.AUDIT_DOING.getValue().equals(item.getAuditStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UzsnxqIqM_1f6940e", (String)"\u5ba1\u6279\u4e2d\u7684\u4e0d\u53ef\u4ee5\u64a4\u56de")));
        ((PurchaseEnquiryHeadService)this.service).revoke(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u91cd\u62a5\u4ef7")
    @ApiOperation(value="\u91cd\u62a5\u4ef7", notes="\u91cd\u62a5\u4ef7")
    @PostMapping(value={"/reQuote"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:reQuote"})
    @SrmValidated
    public Result<?> reQuote(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getQuoteEndTime(), (String)I18nUtil.translate((String)"i18n_alert_VsuyRKIxOLV_2d0830e8", (String)"\u65b0\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEnquiryHeadService)this.service).reQuote(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u63d0\u4ea4\u5b9a\u4ef7")
    @ApiOperation(value="\u63d0\u4ea4\u5b9a\u4ef7", notes="\u63d0\u4ea4\u5b9a\u4ef7")
    @PostMapping(value={"/submitPriced"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:submitPriced"})
    @SrmValidated
    public Result<?> submitPriced(@RequestBody PurchaseAwardOpinionVO awardOpinionVO) {
        Assert.hasText((String)awardOpinionVO.getHeadId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEnquiryHeadService)this.service).submitPriced(awardOpinionVO);
        return this.commonSuccessResult(2);
    }

    @ApiOperation(value="\u91cd\u62a5\u4ef7\u4f9b\u5e94\u5546\u67e5\u8be2", notes="\u91cd\u62a5\u4ef7\u4f9b\u5e94\u5546\u67e5\u8be2")
    @GetMapping(value={"/reQuoteSupplierList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:list"})
    public Result<?> reQuoteSupplierList(EnquirySupplierList supplier, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplier), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.enquirySupplierListService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u91cd\u62a5\u4ef7\u7269\u6599\u884c\u67e5\u8be2", notes="\u91cd\u62a5\u4ef7\u7269\u6599\u884c\u67e5\u8be2")
    @GetMapping(value={"/reQuoteMaterialList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:list"})
    public Result<?> reQuoteMaterialList(PurchaseEnquiryItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"DISTINCT item_number,material_number,material_name,material_desc,material_spec,purchase_cycle"});
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEnquiryItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u8be2\u4ef7-\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:cancel"})
    @PermissionDataOpt(businessType="enquiry", beanClass=PurchaseEnquiryHeadService.class)
    public Result<?> cancel(@RequestParam(name="headId") String headId) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        List<String> status = Arrays.asList(EnquiryStatusEnum.QUOTING.getValue(), EnquiryStatusEnum.BARGAIN.getValue(), EnquiryStatusEnum.NO_QUOTE.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_zELsusWIusWLsujtFnqtk_4ac70cc4", (String)"\u72b6\u6001\u4e3a\u62a5\u4ef7\u4e2d\u3001\u8bae\u4ef7\u4e2d\u3001\u672a\u62a5\u4ef7\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
        Assert.isTrue((!dbHead.getResultAuditStatus().equals(AuditStatusEnum.AUDIT_DOING.getValue()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_yRUzzELUzsxqIuA_24b84420", (String)"\u7ed3\u679c\u5ba1\u6279\u72b6\u6001\u4e3a\u5ba1\u6279\u4e2d\u4e0d\u53ef\u4ee5\u5e9f\u5f03"));
        ((PurchaseEnquiryHeadService)this.service).cancel(dbHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u6094\u6807")
    @ApiOperation(value="\u6094\u6807", notes="\u6094\u6807")
    @PostMapping(value={"/regret"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:regret"})
    @SrmValidated
    public Result<?> regret(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getRegretFlag(), (String)I18nUtil.translate((String)"i18n_alert_MBBKxOLV_d46458e2", (String)"\u6094\u6807\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getRegretWay(), (String)I18nUtil.translate((String)"i18n_alert_MBCKxOLV_6f7c2139", (String)"\u6094\u6807\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        String message = ((PurchaseEnquiryHeadService)this.service).regret(headVO);
        return Result.ok((String)message);
    }

    @AutoLog(value="\u8be2\u4ef7-\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @ApiOperation(value="\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55", notes="\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @PostMapping(value={"/generatePriceRecord"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:generatePriceRecord"})
    @SrmValidated
    public Result<?> generatePriceRecord(@RequestBody PurchaseEnquiryHeadVO headVO) {
        String headId = headVO.getId();
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notEmpty(headVO.getPurchaseEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_tkjcVHxOLV_d797fb35", (String)"\u64cd\u4f5c\u7684\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.notNull((Object)((Object)dbHead), (String)I18nUtil.translate((String)"i18n_alert_WFxMKSIqQG_3b3ce094", (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        ArrayList status = Lists.newArrayList((Object[])new String[]{EnquiryStatusEnum.PRICED.getValue(), EnquiryStatusEnum.REGRET.getValue()});
        Assert.isTrue((boolean)status.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_IIuSIMBntFnqtk_976a60d0", (String)"\u5df2\u5b9a\u4ef7\u6216\u5df2\u6094\u6807\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
        Assert.isTrue((!PriceCreateWayEnum.NOT.getValue().equals(dbHead.getPriceCreateWay()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umbLCKLxbLWxTbLumtH_ae13c26a", (String)"\u4ef7\u683c\u751f\u6210\u65b9\u5f0f\u4e3a\u4e0d\u751f\u6210\uff0c\u4e0d\u9700\u751f\u6210\u4ef7\u683c\u8bb0\u5f55"));
        Assert.isTrue((boolean)PriceCreateWayEnum.MANUAL.getValue().equals(dbHead.getPriceCreateWay()), (String)I18nUtil.translate((String)"i18n_alert_umbLCKLJObLWxTlObL_6649b670", (String)"\u4ef7\u683c\u751f\u6210\u65b9\u5f0f\u4e3a\u81ea\u52a8\u751f\u6210\uff0c\u4e0d\u9700\u624b\u52a8\u751f\u6210"));
        List itemNumberList = headVO.getPurchaseEnquiryItemList().stream().map(PurchaseEnquiryItem::getItemNumber).distinct().collect(Collectors.toList());
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
        List<PurchaseEnquiryItem> webAcceptList = itemList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).filter(item -> itemNumberList.contains(item.getItemNumber())).collect(Collectors.toList());
        Assert.notEmpty(webAcceptList, (String)I18nUtil.translate((String)"i18n_alert_yljhucnObLumtH_4dccee90", (String)"\u63a5\u53d7\u7684\u8be2\u4ef7\u884c\u624d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55"));
        webAcceptList.forEach(item -> {
            Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_SLyxObLumtHWVxVSLAy_c134b965", (String)"\u65e0\u6599\u53f7\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff0c\u8bf7\u8865\u5145\u7269\u6599\u7f16\u53f7"));
            if (!"0".equals(dbHead.getResultAudit())) {
                Assert.isTrue((boolean)AuditStatusEnum.AUDIT_FINISH.getValue().equals(item.getAuditStatus()), (String)I18nUtil.translate((String)"i18n_alert_UzeRSnqbLumVHtH_419f1354", (String)"\u5ba1\u6279\u901a\u8fc7\u540e\u624d\u53ef\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55"));
            }
            Assert.isTrue((!"1".equals(item.getSendStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_SLWWWWWWWWIbLRVHtHWxqVBbL_d8148f82", (String)("\u7269\u6599\uff1a" + item.getMaterialName() + "\uff0c\u5df2\u751f\u6210\u8fc7\u4fe1\u606f\u8bb0\u5f55\uff0c\u4e0d\u53ef\u91cd\u590d\u751f\u6210"), (String[])new String[]{item.getMaterialName()}));
        });
        ((PurchaseEnquiryHeadService)this.service).generatePriceRecord(dbHead, webAcceptList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8be2\u4ef7-\u5bfc\u51fa\u6bd4\u4ef7\u62a5\u8868")
    @ApiOperation(value="\u5bfc\u51fa\u6bd4\u4ef7\u62a5\u8868", notes="\u5bfc\u51fa\u6bd4\u4ef7\u62a5\u8868")
    @GetMapping(value={"/exportBargain"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public void exportBargain(HttpServletRequest request, HttpServletResponse response) {
        String headId = request.getParameter("headId");
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)this.service).getById((Serializable)((Object)headId)));
        this.purchaseEnquiryItemService.exportCompare(dbHead, response);
    }

    @AutoLog(value="\u8be2\u4ef7-\u5b9a\u4ef7\u901a\u77e5")
    @ApiOperation(value="\u5b9a\u4ef7\u901a\u77e5", notes="\u5b9a\u4ef7\u901a\u77e5")
    @GetMapping(value={"/pricingNotice"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> pricingNotice(@RequestParam(value="headId") String headId, @RequestParam(value="pricingNotice") String pricingNotice) {
        ((PurchaseEnquiryHeadService)this.service).pricingNotice(headId, pricingNotice);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u8be2\u4ef7\u4f9b\u5e94\u5546\u67e5\u8be2", notes="\u8be2\u4ef7\u4f9b\u5e94\u5546\u67e5\u8be2")
    @GetMapping(value={"/querySupplier"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:queryById"})
    public Result<?> querySupplier(@RequestParam(value="headId") String headId) {
        List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(headId);
        return Result.ok(supplierList);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:export"})
    @PermissionDataView(businessType="enquiry")
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseEnquiryHeadExportServiceImpl.class);
    }

    @AutoLog(value="\u8be2\u4ef7-\u63d0\u4ea4\u6838\u4ef7")
    @ApiOperation(value="\u63d0\u4ea4\u6838\u4ef7", notes="\u63d0\u4ea4\u6838\u4ef7")
    @PostMapping(value={"/submitEvaluationPrice"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:submitEvaluationPrice"})
    @SrmValidated
    public Result<?> submitEvaluationPrice(@RequestBody PurchaseEnquiryHeadVO headVO) {
        ((PurchaseEnquiryHeadService)this.service).submitEvaluationPrice(headVO);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u8be2\u4ef7-\u6253\u5370")
    @ApiOperation(value="\u6253\u5370", notes="\u6253\u5370")
    @GetMapping(value={"/print"})
    public Result<?> print(@RequestParam(value="id") String id) {
        PurchaseEnquiryPrintVO printVO = ((PurchaseEnquiryHeadService)this.service).print(id);
        return Result.ok((Object)((Object)printVO));
    }

    @AutoLog(value="\u8be2\u4ef7-\u6821\u9a8c\u76f8\u540c\u7269\u6599\u76f8\u540c\u5de5\u5382")
    @ApiOperation(value="\u8be2\u4ef7-\u6821\u9a8c\u76f8\u540c\u7269\u6599\u76f8\u540c\u5de5\u5382", notes="\u8be2\u4ef7-\u6821\u9a8c\u76f8\u540c\u7269\u6599\u76f8\u540c\u5de5\u5382")
    @PostMapping(value={"/checkEnquirySameMaterial"})
    public Result<?> print(@RequestBody List<PurchaseEnquiryItem> itemList) {
        ((PurchaseEnquiryHeadService)this.service).checkEnquirySameMaterial(itemList);
        return Result.ok();
    }

    @GetMapping(value={"/inquiryStatistics"})
    public Result<?> inquiryStatistics(HttpServletRequest req) {
        Calendar calendar = Calendar.getInstance();
        String thisMonth = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM");
        calendar.add(2, -1);
        String lastMonth = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM");
        List lastEnquiryHeadList = ((LambdaQueryChainWrapper)((PurchaseEnquiryHeadService)this.service).lambdaQuery().apply("date_format(create_time, '%Y-%m') = {0}", new Object[]{lastMonth})).list();
        List enquiryHeadList = ((LambdaQueryChainWrapper)((PurchaseEnquiryHeadService)this.service).lambdaQuery().apply("date_format(create_time, '%Y-%m') = {0}", new Object[]{thisMonth})).list();
        List lastEbiddingHeadList = ((LambdaQueryChainWrapper)this.ebiddingHeadService.lambdaQuery().apply("date_format(create_time, '%Y-%m') = {0}", new Object[]{lastMonth})).list();
        List ebiddingHeadList = ((LambdaQueryChainWrapper)this.ebiddingHeadService.lambdaQuery().apply("date_format(create_time, '%Y-%m') = {0}", new Object[]{thisMonth})).list();
        List lastBiddingHeadList = ((LambdaQueryChainWrapper)this.biddingHeadService.lambdaQuery().apply("date_format(create_time, '%Y-%m') = {0}", new Object[]{lastMonth})).list();
        List biddingHeadList = ((LambdaQueryChainWrapper)this.biddingHeadService.lambdaQuery().apply("date_format(create_time, '%Y-%m') = {0}", new Object[]{thisMonth})).list();
        int lastMonthCount = lastEnquiryHeadList.size() + lastEbiddingHeadList.size() + lastBiddingHeadList.size();
        int thisMonthCount = enquiryHeadList.size() + ebiddingHeadList.size() + biddingHeadList.size();
        long lastEnquiryTime = enquiryHeadList.stream().map(item -> DateUtil.betweenDay((Date)item.getCreateTime(), (Date)item.getUpdateTime(), (boolean)false)).collect(Collectors.summarizingLong(Long::longValue)).getSum();
        long lastEbiddingTime = ebiddingHeadList.stream().map(item -> DateUtil.betweenDay((Date)item.getCreateTime(), (Date)item.getUpdateTime(), (boolean)false)).collect(Collectors.summarizingLong(Long::longValue)).getSum();
        long lastBiddingTime = biddingHeadList.stream().map(item -> DateUtil.betweenDay((Date)item.getCreateTime(), (Date)item.getUpdateTime(), (boolean)false)).collect(Collectors.summarizingLong(Long::longValue)).getSum();
        long lastMonthTime = lastEnquiryTime + lastEbiddingTime + lastBiddingTime;
        long enquiryTime = enquiryHeadList.stream().map(item -> DateUtil.betweenDay((Date)item.getCreateTime(), (Date)item.getUpdateTime(), (boolean)false)).collect(Collectors.summarizingLong(Long::longValue)).getSum();
        long ebiddingTime = ebiddingHeadList.stream().map(item -> DateUtil.betweenDay((Date)item.getCreateTime(), (Date)item.getUpdateTime(), (boolean)false)).collect(Collectors.summarizingLong(Long::longValue)).getSum();
        long biddingTime = biddingHeadList.stream().map(item -> DateUtil.betweenDay((Date)item.getCreateTime(), (Date)item.getUpdateTime(), (boolean)false)).collect(Collectors.summarizingLong(Long::longValue)).getSum();
        long thisMonthTime = enquiryTime + ebiddingTime + biddingTime;
        ArrayList<CountDTO> result = new ArrayList<CountDTO>();
        result.add(new CountDTO(I18nUtil.translate((String)"i18n_alert_XZhjtW_26ff0ae", (String)"\u4e0a\u6708\u5bfb\u6e90\u5355\u6570"), "quantity", null, Integer.valueOf(lastMonthCount), "", ""));
        result.add(new CountDTO(I18nUtil.translate((String)"i18n_alert_XZhjyK_2755cb2", (String)"\u4e0a\u6708\u5bfb\u6e90\u8017\u65f6"), "time", null, Integer.valueOf((int)lastMonthTime), "", ""));
        result.add(new CountDTO(I18nUtil.translate((String)"i18n_alert_vZhjtW_e59c3ccc", (String)"\u672c\u6708\u5bfb\u6e90\u5355\u6570"), "quantity", null, Integer.valueOf(thisMonthCount), "", ""));
        result.add(new CountDTO(I18nUtil.translate((String)"i18n_alert_vZhjyK_e5a1a8d0", (String)"\u672c\u6708\u5bfb\u6e90\u8017\u65f6"), "time", null, Integer.valueOf((int)thisMonthTime), "", ""));
        return Result.ok(result);
    }

    @ApiOperation(value="\u62a5\u4ef7\u4e34\u671f", notes="\u62a5\u4ef7\u4e34\u671f")
    @GetMapping(value={"/offerComingOfAge"})
    public Result<?> offerComingOfAge(PurchaseEnquiryHead purchaseEnquiryHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 2);
        Date date = calendar.getTime();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        this.inquiryBoardService.offerComingOfAge((Page<PurchaseImminentSourcingOrder>)page, "", date);
        return Result.ok((Object)page);
    }

    @ApiOperation(value="\u4e34\u671f", notes="\u4e34\u671f")
    @GetMapping(value={"/comingOfAge"})
    public Result<?> comingOfAge(PurchaseEnquiryHead purchaseEnquiryHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 2);
        Date date = calendar.getTime();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        this.inquiryBoardService.comingOfAge((Page<PurchaseImminentSourcingOrder>)page, "", date);
        return Result.ok((Object)page);
    }
}

