/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.exception.ELSExcelBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceHead;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceItem;
import com.els.modules.logisticspurchase.base.entity.SubjectFileItem;
import com.els.modules.logisticspurchase.base.enumerate.LineSourceTypeEnum;
import com.els.modules.logisticspurchase.base.mapper.LineDifferenceItemMapper;
import com.els.modules.logisticspurchase.base.service.LineDifferenceHeadService;
import com.els.modules.logisticspurchase.base.service.LineDifferenceItemService;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.modules.logisticspurchase.base.vo.LineSupplierListVO;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingItemLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.mapper.SaleEbiddingItemLpMapper;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.excel.listener.LineDifferenceDataListener;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryItemLpService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.ListUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LineDifferenceItemServiceImpl
extends BaseServiceImpl<LineDifferenceItemMapper, LineDifferenceItem>
implements LineDifferenceItemService {
    private static final Logger log = LoggerFactory.getLogger(LineDifferenceItemServiceImpl.class);
    @Autowired
    private LineDifferenceItemMapper lineDifferenceItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private LineDifferenceHeadService lineDifferenceHeadService;
    @Autowired
    private SaleEbiddingItemLpMapper saleEbiddingItemMapper;
    @Autowired
    private PurchaseEbiddingItemLpService purchaseEbiddingItemService;
    @Autowired
    private SubjectFileItemService subjectFileItemService;
    @Resource(name="srmPoolExecutor")
    private ThreadPoolExecutor executor;
    @Resource
    private RedisUtil redisUtil;
    private static final String APPLY_KEY = "sys:nbeLineDifference:import";
    private static final BigDecimal ONE_HUNDRED = new BigDecimal("100");

    @Override
    public List<LineDifferenceItem> selectByMainId(String mainId) {
        return this.lineDifferenceItemMapper.selectByMainId(mainId);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void generateLineDifferenceItems(PurchaseEnquiryHeadLp purchaseEnquiryHead, List<PurchaseEnquiryItemLp> purchaseEnquiryItemList, List<String> toElsAccountList) {
        List initialTableList = this.invokeBaseRpcService.getInitTableListByRelationId(purchaseEnquiryHead.getId());
        ArrayList<PurchaseEnquiryItemLp> initItemList = new ArrayList<PurchaseEnquiryItemLp>();
        for (ElsInitialTableDTO table : initialTableList) {
            PurchaseEnquiryItemLp enquiryItem = (PurchaseEnquiryItemLp)((Object)JSONObject.parseObject((String)table.getBusinessInfoJson(), PurchaseEnquiryItemLp.class));
            initItemList.add(enquiryItem);
        }
        Map itemMap = initItemList.stream().collect(Collectors.toMap(item -> item.getItemNumber() + item.getSectionNumber(), Function.identity()));
        ArrayList<LineDifferenceItem> lineDifferenceItemList = new ArrayList<LineDifferenceItem>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
        String subjectYear = dateFormat.format(new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_number", (Object)purchaseEnquiryHead.getEnquiryNumber());
        queryWrapper.eq((Object)"subject_number", (Object)purchaseEnquiryHead.getSubjectNumber());
        queryWrapper.eq((Object)"source_type", (Object)LineSourceTypeEnum.ENQUIRY_SOURCE.getValue());
        List LineDifferenceHeads = this.lineDifferenceHeadService.list((Wrapper)queryWrapper);
        List transportTypeDictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("srmOilPrice", TenantContext.getTenant());
        BigDecimal oilPrice = BigDecimal.ZERO;
        if (transportTypeDictDTOS.size() <= 0) {
            throw new ELSBootException("\u8bf7\u7ef4\u62a4\u597d\u6cb9\u4ef7\u5b57\u5178\u503c");
        }
        oilPrice = new BigDecimal(((DictDTO)transportTypeDictDTOS.get(0)).getValue());
        log.error("\u4ef7\u683c\u5dee\u5f02\u5f00\u59cb\u8ba1\u7b97\uff1a" + new Date());
        Map<String, List<PurchaseEnquiryItemLp>> purchaseItemMap = purchaseEnquiryItemList.stream().collect(Collectors.groupingBy(item -> item.getSectionNumber() + "_" + item.getArriveProvince() + "_" + item.getToElsAccount()));
        for (Map.Entry<String, List<PurchaseEnquiryItemLp>> itemListEntry : purchaseItemMap.entrySet()) {
            List<PurchaseEnquiryItemLp> enquiryItems = itemListEntry.getValue();
            if ("2".equals(purchaseEnquiryHead.getSubjectType())) {
                for (PurchaseEnquiryItemLp purchaseEnquiryItem : enquiryItems) {
                    PurchaseEnquiryItemLp initItem = (PurchaseEnquiryItemLp)((Object)itemMap.get(purchaseEnquiryItem.getItemNumber() + purchaseEnquiryItem.getSectionNumber()));
                    if (initItem != null) {
                        purchaseEnquiryItem.setKilometre(initItem.getKilometre());
                    } else {
                        log.error("initItem_isnull_");
                    }
                    LineDifferenceItem lineDifferenceItem = new LineDifferenceItem();
                    BeanUtils.copyProperties((Object)((Object)purchaseEnquiryItem), (Object)((Object)lineDifferenceItem));
                    lineDifferenceItem.setId(null);
                    lineDifferenceItem.setSourceType(LineSourceTypeEnum.ENQUIRY_SOURCE.getValue());
                    lineDifferenceItem.setSourceId(purchaseEnquiryItem.getHeadId());
                    lineDifferenceItem.setSourceNumber(purchaseEnquiryItem.getEnquiryNumber());
                    lineDifferenceItem.setSourceItemId(purchaseEnquiryItem.getId());
                    lineDifferenceItem.setSourceItemNumber(purchaseEnquiryItem.getItemNumber());
                    lineDifferenceItem.setTransportType(purchaseEnquiryHead.getSubjectType());
                    lineDifferenceItem.setSubjectNumber(purchaseEnquiryHead.getSubjectNumber());
                    lineDifferenceItem.setSubjectName(purchaseEnquiryHead.getSubjectName());
                    lineDifferenceItem.setSubjectFileHeadId(purchaseEnquiryHead.getSubjectFileHeadId());
                    lineDifferenceItem.setEnquiryItemNumber(purchaseEnquiryItem.getItemNumber());
                    lineDifferenceItem.setEnquiryNumber(purchaseEnquiryItem.getEnquiryNumber());
                    lineDifferenceItem.setLineNumber(purchaseEnquiryItem.getLineNumber());
                    lineDifferenceItem.setTrafficVolumeProportion(purchaseEnquiryItem.getTrafficVolumeProportion());
                    lineDifferenceItem.setNetAmount(purchaseEnquiryItem.getNetPrice());
                    lineDifferenceItem.setSubjectYear(subjectYear);
                    lineDifferenceItem.setIsShow("1");
                    lineDifferenceItem.setExpiryDate(purchaseEnquiryHead.getExpiryDate());
                    lineDifferenceItem.setEffectiveDate(purchaseEnquiryHead.getEffectiveDate());
                    if (toElsAccountList.size() > 0) {
                        BigDecimal trafficVolumeAmount = lineDifferenceItem.getNetAmount().multiply(lineDifferenceItem.getTrafficVolumeProportion().divide(ONE_HUNDRED, 6, 4));
                        lineDifferenceItem.setTrafficVolumeAmount(trafficVolumeAmount);
                    }
                    lineDifferenceItem.setDeleted(CommonConstant.DEL_FLAG_0);
                    lineDifferenceItemList.add(lineDifferenceItem);
                }
                continue;
            }
            for (PurchaseEnquiryItemLp purchaseEnquiryItem : enquiryItems) {
                LineDifferenceItem lineDifferenceItem = new LineDifferenceItem();
                BeanUtils.copyProperties((Object)((Object)purchaseEnquiryItem), (Object)((Object)lineDifferenceItem));
                lineDifferenceItem.setId(null);
                lineDifferenceItem.setSourceType(LineSourceTypeEnum.ENQUIRY_SOURCE.getValue());
                lineDifferenceItem.setSourceId(purchaseEnquiryItem.getHeadId());
                lineDifferenceItem.setSourceNumber(purchaseEnquiryItem.getEnquiryNumber());
                lineDifferenceItem.setSourceItemId(purchaseEnquiryItem.getId());
                lineDifferenceItem.setSourceItemNumber(purchaseEnquiryItem.getItemNumber());
                lineDifferenceItem.setTransportType(purchaseEnquiryHead.getSubjectType());
                lineDifferenceItem.setSubjectNumber(purchaseEnquiryHead.getSubjectNumber());
                lineDifferenceItem.setSubjectName(purchaseEnquiryHead.getSubjectName());
                lineDifferenceItem.setSubjectFileHeadId(purchaseEnquiryHead.getSubjectFileHeadId());
                lineDifferenceItem.setDeleted(CommonConstant.DEL_FLAG_0);
                lineDifferenceItem.setLineNumber(purchaseEnquiryItem.getLineNumber());
                lineDifferenceItem.setEnquiryItemNumber(purchaseEnquiryItem.getItemNumber());
                lineDifferenceItem.setEnquiryNumber(purchaseEnquiryItem.getEnquiryNumber());
                lineDifferenceItem.setSubjectYear(subjectYear);
                lineDifferenceItem.setIsShow("1");
                lineDifferenceItem.setToStationDate(purchaseEnquiryItem.getToSta());
                lineDifferenceItem.setExpiryDate(purchaseEnquiryHead.getExpiryDate());
                lineDifferenceItem.setEffectiveDate(purchaseEnquiryHead.getEffectiveDate());
                if ("1".equals(purchaseEnquiryHead.getSubjectType())) {
                    lineDifferenceItem.setArriveCityStation(purchaseEnquiryItem.getArriveCity());
                    lineDifferenceItem.setArriveCity(null);
                    lineDifferenceItem.setNetAmount(lineDifferenceItem.getToDoorNetPrice().setScale(2, 4));
                } else if ("3".equals(purchaseEnquiryHead.getSubjectType())) {
                    lineDifferenceItem.setNetAmount(lineDifferenceItem.getToDoorTonsNetPrice().setScale(2, 4));
                } else if ("4".equals(purchaseEnquiryHead.getSubjectType())) {
                    lineDifferenceItem.setNetAmount(lineDifferenceItem.getToStationNetPrice().setScale(2, 4));
                }
                if (toElsAccountList.size() > 0) {
                    BigDecimal trafficVolumeAmount = lineDifferenceItem.getNetAmount().multiply(purchaseEnquiryItem.getTrafficVolumeProportion().divide(ONE_HUNDRED, 6, 4));
                    lineDifferenceItem.setTrafficVolumeAmount(trafficVolumeAmount);
                }
                lineDifferenceItemList.add(lineDifferenceItem);
            }
        }
        log.error("\u4ef7\u683c\u5dee\u5f02\u8ba1\u7b97\u7ed3\u675f\uff1a" + new Date());
        if (lineDifferenceItemList.size() > 0) {
            log.error("\u4ef7\u683c\u5dee\u5f02\u5f00\u59cb\u5199\u5165\uff1a" + new Date());
            this.saveBatch(lineDifferenceItemList, 2000);
            log.error("\u4ef7\u683c\u5dee\u5f02\u5199\u5165\u7ed3\u675f\uff1a" + new Date());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void generateLineDifferenceItems(PurchaseEbiddingHeadLp purchaseEbiddingHead, List<PurchaseEbiddingItemLp> purchaseEbiddingItems, List<String> toElsAccountList) {
        PurchaseEbiddingItemLp purchaseEbiddingItem = purchaseEbiddingItems.get(0);
        List initialTableList = this.invokeBaseRpcService.getInitTableListByRelationId(purchaseEbiddingHead.getEnquiryId());
        ArrayList<PurchaseEnquiryItemLp> initItemList = new ArrayList<PurchaseEnquiryItemLp>();
        for (ElsInitialTableDTO table : initialTableList) {
            PurchaseEnquiryItemLp enquiryItem = (PurchaseEnquiryItemLp)((Object)JSONObject.parseObject((String)table.getBusinessInfoJson(), PurchaseEnquiryItemLp.class));
            initItemList.add(enquiryItem);
        }
        Map itemMap = initItemList.stream().collect(Collectors.toMap(item -> item.getItemNumber() + item.getSectionNumber(), Function.identity()));
        ArrayList lineDifferenceItemList = new ArrayList();
        String subjectYear = String.valueOf(LocalDate.now().getYear());
        List LineDifferenceHeads = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lineDifferenceHeadService.lambdaQuery().eq(LineDifferenceHead::getSourceNumber, (Object)purchaseEbiddingHead.getEbiddingNumber())).eq(LineDifferenceHead::getSourceType, (Object)LineSourceTypeEnum.EBIDDING_SOURCE.getValue())).orderByAsc(LineDifferenceHead::getTotalNetAmount)).list();
        List supplierAccounts = LineDifferenceHeads.stream().map(LineDifferenceHead::getToElsAccount).collect(Collectors.toList());
        if (CollUtil.isEmpty(supplierAccounts)) {
            throw new ELSBootException("\u627e\u4e0d\u5230\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546");
        }
        List transportTypeDictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("srmOilPrice", TenantContext.getTenant());
        if (CollUtil.isEmpty((Collection)transportTypeDictDTOS)) {
            throw new ELSBootException("\u8bf7\u7ef4\u62a4\u597d\u6cb9\u4ef7\u5b57\u5178\u503c");
        }
        BigDecimal oilPrice = (BigDecimal)ObjectUtil.defaultIfNull((Object)new BigDecimal(((DictDTO)transportTypeDictDTOS.get(0)).getValue()), (Object)BigDecimal.ZERO);
        BigDecimal supplierCounts = supplierAccounts.size() >= 3 ? new BigDecimal("3") : new BigDecimal(supplierAccounts.size());
        List purchaseEnquiryItems = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((PurchaseEnquiryItemLpService)SpringContextUtils.getBean(PurchaseEnquiryItemLpService.class)).lambdaQuery().eq(PurchaseEnquiryItemLp::getHeadId, (Object)purchaseEbiddingHead.getEnquiryId())).in(PurchaseEnquiryItemLp::getToElsAccount, supplierAccounts)).list();
        List saleEbiddingItems = this.saleEbiddingItemMapper.selectWithoutElsAccountByEbiddingNumber(purchaseEbiddingHead.getEbiddingNumber()).stream().filter(s -> supplierAccounts.contains(s.getElsAccount())).collect(Collectors.toList());
        Map<String, BigDecimal> ebiddingRangeMap = saleEbiddingItems.stream().filter(s -> ((BigDecimal)ObjectUtil.defaultIfNull((Object)s.getEbiddingRange(), (Object)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toMap(BaseEntity::getElsAccount, SaleEbiddingItemLp::getEbiddingRange));
        purchaseEnquiryItems.forEach(purchaseEnquiryItem -> {
            BigDecimal ebiddingRange = (BigDecimal)ebiddingRangeMap.get(purchaseEnquiryItem.getToElsAccount());
            if (ObjectUtil.isNotNull((Object)ebiddingRange) && ebiddingRange.compareTo(BigDecimal.ZERO) > 0) {
                this.calculateEbiddingPrice(purchaseEbiddingHead, (PurchaseEnquiryItemLp)((Object)purchaseEnquiryItem), ebiddingRange);
            }
        });
        List purchaseEnquiryItemList = purchaseEnquiryItems.stream().filter(item -> toElsAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
        Map<String, List<PurchaseEnquiryItemLp>> enquiryItemGroupByArriveProvince = purchaseEnquiryItems.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemLp::getArriveProvince));
        ArrayList futures = new ArrayList(enquiryItemGroupByArriveProvince.size());
        enquiryItemGroupByArriveProvince.forEach((arriveProvince, itemsGroupByArriveProvince) -> {
            Future<List> future = this.executor.submit(() -> {
                Map<String, List<PurchaseEnquiryItemLp>> purchaseItemMap = itemsGroupByArriveProvince.stream().collect(Collectors.groupingBy(item -> item.getSectionNumber() + "_" + item.getToElsAccount()));
                ArrayList currentThreadResult = new ArrayList();
                purchaseItemMap.forEach((key, enquiryItems) -> {
                    for (PurchaseEnquiryItemLp purchaseEnquiryItem : enquiryItems) {
                        try {
                            List enquiryItemList = purchaseEnquiryItemList.stream().filter(item -> item.getSectionNumber().equals(purchaseEnquiryItem.getSectionNumber()) && item.getItemNumber().equals(purchaseEnquiryItem.getItemNumber())).collect(Collectors.toList());
                            BigDecimal acceptTotalNetAmount = enquiryItemList.stream().map(PurchaseEnquiryItemLp::getNetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal averageTrafficVolumeAmount = acceptTotalNetAmount.divide(supplierCounts, 6, RoundingMode.HALF_UP);
                            LineDifferenceItem lineDifferenceItem = new LineDifferenceItem();
                            BeanUtils.copyProperties((Object)((Object)purchaseEnquiryItem), (Object)((Object)lineDifferenceItem));
                            lineDifferenceItem.setId(null);
                            lineDifferenceItem.setSourceType(LineSourceTypeEnum.EBIDDING_SOURCE.getValue());
                            lineDifferenceItem.setSourceId(purchaseEbiddingHead.getId());
                            lineDifferenceItem.setSourceNumber(purchaseEbiddingHead.getEbiddingNumber());
                            lineDifferenceItem.setSourceItemId(purchaseEbiddingItem.getId());
                            lineDifferenceItem.setSourceItemNumber(purchaseEbiddingItem.getItemNumber());
                            lineDifferenceItem.setTransportType(purchaseEbiddingHead.getSubjectType());
                            lineDifferenceItem.setSubjectNumber(purchaseEbiddingHead.getSubjectNumber());
                            lineDifferenceItem.setSubjectName(purchaseEbiddingHead.getSubjectName());
                            lineDifferenceItem.setSubjectFileHeadId(purchaseEbiddingHead.getSubjectFileHeadId());
                            lineDifferenceItem.setEnquiryNumber(purchaseEnquiryItem.getEnquiryNumber());
                            lineDifferenceItem.setEnquiryItemNumber(purchaseEnquiryItem.getItemNumber());
                            lineDifferenceItem.setLineNumber(purchaseEnquiryItem.getLineNumber());
                            lineDifferenceItem.setToStationDate(purchaseEnquiryItem.getToSta());
                            lineDifferenceItem.setSubjectYear(subjectYear);
                            lineDifferenceItem.setIsShow("1");
                            lineDifferenceItem.setExpiryDate(purchaseEbiddingHead.getExpiryDate());
                            lineDifferenceItem.setEffectiveDate(purchaseEbiddingHead.getEffectiveDate());
                            lineDifferenceItem.setDeleted(CommonConstant.DEL_FLAG_0);
                            lineDifferenceItem.setAverageTrafficVolumeAmount(averageTrafficVolumeAmount);
                            if ("1".equals(purchaseEbiddingHead.getSubjectType())) {
                                lineDifferenceItem.setNetAmount(lineDifferenceItem.getToDoorNetPrice().setScale(2, RoundingMode.HALF_UP));
                                lineDifferenceItem.setArriveCityStation(purchaseEnquiryItem.getArriveCity());
                                lineDifferenceItem.setArriveCity(null);
                            } else if ("2".equals(purchaseEbiddingHead.getSubjectType())) {
                                lineDifferenceItem.setNetAmount(purchaseEnquiryItem.getNetPrice());
                                lineDifferenceItem.setTrafficVolumeProportion(purchaseEnquiryItem.getTrafficVolumeProportion());
                            } else if ("3".equals(purchaseEbiddingHead.getSubjectType())) {
                                lineDifferenceItem.setNetAmount(lineDifferenceItem.getToDoorTonsNetPrice().setScale(2, RoundingMode.HALF_UP));
                            } else if ("4".equals(purchaseEbiddingHead.getSubjectType())) {
                                lineDifferenceItem.setNetAmount(lineDifferenceItem.getToStationNetPrice().setScale(2, RoundingMode.HALF_UP));
                            }
                            BigDecimal diffItemNetAmount = (BigDecimal)ObjectUtil.defaultIfNull((Object)lineDifferenceItem.getNetAmount(), (Object)BigDecimal.ZERO);
                            BigDecimal diffItemTrafficVolumeProportion = (BigDecimal)ObjectUtil.defaultIfNull((Object)lineDifferenceItem.getTrafficVolumeProportion(), (Object)BigDecimal.ZERO);
                            BigDecimal enquiryItemTrafficVolumeProportion = (BigDecimal)ObjectUtil.defaultIfNull((Object)purchaseEnquiryItem.getTrafficVolumeProportion(), (Object)BigDecimal.ZERO);
                            BigDecimal trafficVolumeAmount = "2".equals(purchaseEbiddingHead.getSubjectType()) ? diffItemNetAmount.multiply(diffItemTrafficVolumeProportion.divide(ONE_HUNDRED, 6, RoundingMode.HALF_UP)) : diffItemNetAmount.multiply(enquiryItemTrafficVolumeProportion.divide(ONE_HUNDRED, 6, RoundingMode.HALF_UP));
                            lineDifferenceItem.setTrafficVolumeAmount(trafficVolumeAmount);
                            BigDecimal differenceAmount = BigDecimal.ZERO;
                            if (averageTrafficVolumeAmount.compareTo(BigDecimal.ZERO) > 0) {
                                differenceAmount = trafficVolumeAmount.subtract(averageTrafficVolumeAmount).divide(averageTrafficVolumeAmount, 4, RoundingMode.HALF_UP).multiply(ONE_HUNDRED);
                            }
                            if (differenceAmount.compareTo(new BigDecimal("20")) > 0) {
                                lineDifferenceItem.setPriceVarianceRatio(differenceAmount.setScale(2, RoundingMode.HALF_UP));
                            }
                            if ("2".equals(purchaseEbiddingHead.getSubjectType())) {
                                PurchaseEnquiryItemLp initItem = (PurchaseEnquiryItemLp)((Object)((Object)((Object)((Object)itemMap.get(purchaseEnquiryItem.getItemNumber() + purchaseEnquiryItem.getSectionNumber())))));
                                if (initItem != null) {
                                    purchaseEnquiryItem.setKilometre(initItem.getKilometre());
                                    lineDifferenceItem.setKilometre(purchaseEnquiryItem.getKilometre());
                                } else {
                                    log.error("initItem_isnull_");
                                }
                            }
                            currentThreadResult.add(lineDifferenceItem);
                        }
                        catch (Exception e) {
                            throw new ELSBootException(e.getCause().getMessage());
                        }
                    }
                });
                return currentThreadResult;
            });
            futures.add(future);
        });
        for (Future future : futures) {
            try {
                List currentFutureResult = (List)future.get();
                if (!CollUtil.isNotEmpty((Collection)currentFutureResult)) continue;
                lineDifferenceItemList.addAll(currentFutureResult);
            }
            catch (Exception e) {
                throw new ELSBootException(e.getMessage());
            }
        }
        if (lineDifferenceItemList.size() > 0) {
            this.saveBatch(lineDifferenceItemList, 2000);
        }
    }

    @Override
    public List<LineSupplierListVO> getLineSupplierList(String sourceType, String subjectNumber, String subjectYear) {
        List<LineDifferenceItem> lineSupplierList = ((LineDifferenceItemMapper)this.baseMapper).getLineSupplierList(sourceType, subjectNumber, subjectYear);
        ArrayList<LineSupplierListVO> supplierListVOS = new ArrayList<LineSupplierListVO>();
        for (LineDifferenceItem lineDifferenceItem : lineSupplierList) {
            LineSupplierListVO LineSupplierListVO2 = new LineSupplierListVO();
            BeanUtils.copyProperties((Object)((Object)lineDifferenceItem), (Object)LineSupplierListVO2);
            supplierListVOS.add(LineSupplierListVO2);
        }
        return supplierListVOS;
    }

    @Override
    public void deleteBatchBySourceId(String sourceId, String sourceType) {
        ((LineDifferenceItemMapper)this.getBaseMapper()).deleteBySourceId(sourceId, sourceType);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void deleteLineDifference(LineDifferenceItem lineDifferenceItem) {
        Assert.notNull((Object)lineDifferenceItem.getSourceType(), (String)"\u8bf7\u9009\u62e9\u6765\u6e90\u7c7b\u578b");
        Assert.notNull((Object)lineDifferenceItem.getSubjectNumber(), (String)"\u8bf7\u586b\u5199\u6807\u7684\u7f16\u7801");
        Assert.notNull((Object)lineDifferenceItem.getSubjectYear(), (String)"\u8bf7\u9009\u62e9\u6807\u7684\u5e74\u4efd");
        Assert.notNull((Object)lineDifferenceItem.getToElsAccount(), (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4f9b\u5e94\u5546");
        if (!LineSourceTypeEnum.IMPORT_SOURCE.getValue().equals(lineDifferenceItem.getSourceType())) {
            throw new ELSBootException("\u53ea\u80fd\u5220\u9664\u6765\u6e90\u7c7b\u578b\u4e3a\u5bfc\u5165\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_type", (Object)lineDifferenceItem.getSourceType());
        queryWrapper.eq((Object)"subject_number", (Object)lineDifferenceItem.getSubjectNumber());
        queryWrapper.eq((Object)"subject_year", (Object)lineDifferenceItem.getSubjectYear());
        queryWrapper.eq((Object)"to_els_account", (Object)lineDifferenceItem.getToElsAccount());
        List lineDifferenceItemList = this.lineDifferenceItemMapper.selectList((Wrapper)queryWrapper);
        if (lineDifferenceItemList.size() > 0) {
            QueryWrapper headQueryWrapper = new QueryWrapper();
            headQueryWrapper.eq((Object)"source_type", (Object)((LineDifferenceItem)((Object)lineDifferenceItemList.get(0))).getSourceType());
            headQueryWrapper.eq((Object)"subject_number", (Object)((LineDifferenceItem)((Object)lineDifferenceItemList.get(0))).getSubjectNumber());
            headQueryWrapper.eq((Object)"subject_year", (Object)((LineDifferenceItem)((Object)lineDifferenceItemList.get(0))).getSubjectYear());
            headQueryWrapper.eq((Object)"to_els_account", (Object)((LineDifferenceItem)((Object)lineDifferenceItemList.get(0))).getToElsAccount());
            LineDifferenceHead lineDifferenceHead = (LineDifferenceHead)((Object)this.lineDifferenceHeadService.getOne((Wrapper)headQueryWrapper));
            if (lineDifferenceHead != null) {
                QueryWrapper ebiddingItemQueryWrapper = new QueryWrapper();
                ebiddingItemQueryWrapper.eq((Object)"subject_number", (Object)((LineDifferenceItem)((Object)lineDifferenceItemList.get(0))).getSubjectNumber());
                ebiddingItemQueryWrapper.eq((Object)"subject_year", (Object)((LineDifferenceItem)((Object)lineDifferenceItemList.get(0))).getSubjectYear());
                ebiddingItemQueryWrapper.eq((Object)"to_els_account", (Object)((LineDifferenceItem)((Object)lineDifferenceItemList.get(0))).getToElsAccount());
                PurchaseEbiddingItemLp ebiddingItem = (PurchaseEbiddingItemLp)((Object)this.purchaseEbiddingItemService.getOne((Wrapper)ebiddingItemQueryWrapper));
                if (ebiddingItem != null && EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(ebiddingItem.getItemStatus())) {
                    throw new ELSBootException("\u4f9b\u5e94\u5546" + ebiddingItem.getSupplierName() + "\u6807\u7684\u7f16\u7801\u4e3a" + ebiddingItem.getSubjectNumber() + "\u5df2\u5b9a\u6807\uff0c\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u68c0\u67e5");
                }
                this.lineDifferenceHeadService.removeById((Serializable)((Object)lineDifferenceHead));
            }
        } else {
            throw new ELSBootException("\u672a\u67e5\u5230\u6709\u6548\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        List<String> ids = lineDifferenceItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.lineDifferenceItemMapper.deleteBatchByIdList(ids);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void refreshCenterVarianceRatio(List<LineDifferenceItem> lineDifferenceItemList, PurchaseEnquiryHeadLp head) {
        List transportTypeDictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("srmOilPrice", TenantContext.getTenant());
        BigDecimal oilPrice = BigDecimal.ZERO;
        if (transportTypeDictDTOS.size() <= 0) {
            throw new ELSBootException("\u8bf7\u7ef4\u62a4\u597d\u6cb9\u4ef7\u5b57\u5178\u503c");
        }
        oilPrice = new BigDecimal(((DictDTO)transportTypeDictDTOS.get(0)).getValue());
        Map<String, List<LineDifferenceItem>> lineDifferenceItemMap = lineDifferenceItemList.stream().collect(Collectors.groupingBy(item -> item.getSectionNumber() + "_" + item.getArriveProvince() + "_" + item.getToElsAccount()));
        for (Map.Entry<String, List<LineDifferenceItem>> itemListEntry : lineDifferenceItemMap.entrySet()) {
            List<LineDifferenceItem> lineDifferenceItems = itemListEntry.getValue();
            if (!"2".equals(head.getSubjectType())) continue;
            for (LineDifferenceItem lineDifferenceItem : lineDifferenceItems) {
            }
        }
        if (lineDifferenceItemList.size() > 0) {
            ArrayList<List<LineDifferenceItem>> updateList = new ArrayList<List<LineDifferenceItem>>();
            int updateCount = lineDifferenceItemList.size() / 2000;
            if (updateCount > 0) {
                for (int i = 0; i < updateCount; ++i) {
                    updateList.add(lineDifferenceItemList.subList(2000 * i, 2000 * (i + 1)));
                }
                if (lineDifferenceItemList.size() % 2000 != 0) {
                    updateList.add(lineDifferenceItemList.subList(2000 * updateCount, lineDifferenceItemList.size()));
                }
            } else {
                updateList.add(lineDifferenceItemList);
            }
            int hasBendUpdate = 1;
            for (List list : updateList) {
                log.error("\u7b2c" + hasBendUpdate + "\u6b21\u8be2\u4ef7\u5dee\u5f02\u62a5\u8868\u66f4\u65b0\u4e2d\u5fc3\u70b9\u5dee\u5f02\u5f00\u59cb\uff1a" + new Date());
                this.lineDifferenceItemMapper.refreshCenterVarianceRatio(list);
                log.error("\u7b2c" + hasBendUpdate + "\u6b21\u8be2\u4ef7\u5dee\u5f02\u62a5\u8868\u66f4\u65b0\u4e2d\u5fc3\u70b9\u5dee\u5f02\u7ed3\u675f\uff1a" + new Date());
                ++hasBendUpdate;
            }
        }
    }

    private void calculateEbiddingPrice(PurchaseEbiddingHeadLp purchaseEbiddingHead, PurchaseEnquiryItemLp purchaseEnquiryItem, BigDecimal ebiddingRange) {
        purchaseEnquiryItem.setNetPrice(this.reversePirce(purchaseEnquiryItem.getNetPrice(), ebiddingRange));
        purchaseEnquiryItem.setPrice(this.reversePirce(purchaseEnquiryItem.getPrice(), ebiddingRange));
        purchaseEnquiryItem.setTaxAmount(this.reversePirce(purchaseEnquiryItem.getTaxAmount(), ebiddingRange));
        purchaseEnquiryItem.setNetAmount(this.reversePirce(purchaseEnquiryItem.getNetAmount(), ebiddingRange));
        if ("2".equals(purchaseEbiddingHead.getSubjectType())) {
            purchaseEnquiryItem.setIntervalRatioPrice1(this.reversePirce(purchaseEnquiryItem.getIntervalRatioPrice1(), ebiddingRange));
            purchaseEnquiryItem.setIntervalRatioPrice2(this.reversePirce(purchaseEnquiryItem.getIntervalRatioPrice2(), ebiddingRange));
            purchaseEnquiryItem.setIntervalRatioPrice3(this.reversePirce(purchaseEnquiryItem.getIntervalRatioPrice3(), ebiddingRange));
            purchaseEnquiryItem.setIntervalRatioPrice4(this.reversePirce(purchaseEnquiryItem.getIntervalRatioPrice4(), ebiddingRange));
            purchaseEnquiryItem.setIntervalRatioNetPrice1(this.reversePirce(purchaseEnquiryItem.getIntervalRatioNetPrice1(), ebiddingRange));
            purchaseEnquiryItem.setIntervalRatioNetPrice2(this.reversePirce(purchaseEnquiryItem.getIntervalRatioNetPrice2(), ebiddingRange));
            purchaseEnquiryItem.setIntervalRatioNetPrice3(this.reversePirce(purchaseEnquiryItem.getIntervalRatioNetPrice3(), ebiddingRange));
            purchaseEnquiryItem.setIntervalRatioNetPrice4(this.reversePirce(purchaseEnquiryItem.getIntervalRatioNetPrice4(), ebiddingRange));
        } else if ("1".equals(purchaseEbiddingHead.getSubjectType())) {
            purchaseEnquiryItem.setToDoorPrice(this.reversePirce(purchaseEnquiryItem.getToDoorPrice(), ebiddingRange));
            purchaseEnquiryItem.setToDoorNetPrice(this.reversePirce(purchaseEnquiryItem.getToDoorNetPrice(), ebiddingRange));
        } else if ("3".equals(purchaseEbiddingHead.getSubjectType())) {
            purchaseEnquiryItem.setToDoorTonsPrice(this.reversePirce(purchaseEnquiryItem.getToDoorTonsPrice(), ebiddingRange));
            purchaseEnquiryItem.setToDoorTonsNetPrice(this.reversePirce(purchaseEnquiryItem.getToDoorTonsNetPrice(), ebiddingRange));
        } else if ("4".equals(purchaseEbiddingHead.getSubjectType())) {
            purchaseEnquiryItem.setToStationPrice(this.reversePirce(purchaseEnquiryItem.getToStationPrice(), ebiddingRange));
            purchaseEnquiryItem.setToStationNetPrice(this.reversePirce(purchaseEnquiryItem.getToStationNetPrice(), ebiddingRange));
        }
    }

    private BigDecimal reversePirce(BigDecimal price, BigDecimal ebiddingRange) {
        if (((BigDecimal)ObjectUtil.defaultIfNull((Object)price, (Object)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return price.subtract(price.multiply(ebiddingRange.multiply(new BigDecimal("0.01")))).setScale(6, 4);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void tempGenerateLineDifferenceItems(PurchaseEbiddingHeadLp purchaseEbiddingHead, List<PurchaseEbiddingItemLp> purchaseEbiddingItems, List<String> toElsAccountList) {
        PurchaseEbiddingItemLp purchaseEbiddingItem = purchaseEbiddingItems.get(0);
        List initialTableList = this.invokeBaseRpcService.getInitTableListByRelationId(purchaseEbiddingHead.getEnquiryId());
        ArrayList<PurchaseEnquiryItemLp> initItemList = new ArrayList<PurchaseEnquiryItemLp>();
        for (ElsInitialTableDTO table : initialTableList) {
            PurchaseEnquiryItemLp enquiryItem = (PurchaseEnquiryItemLp)((Object)JSONObject.parseObject((String)table.getBusinessInfoJson(), PurchaseEnquiryItemLp.class));
            initItemList.add(enquiryItem);
        }
        Map itemMap = initItemList.stream().collect(Collectors.toMap(item -> item.getItemNumber() + item.getSectionNumber(), Function.identity()));
        ArrayList lineDifferenceItemList = new ArrayList();
        String subjectYear = String.valueOf(LocalDate.now().getYear());
        List LineDifferenceHeads = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lineDifferenceHeadService.lambdaQuery().eq(LineDifferenceHead::getSourceNumber, (Object)purchaseEbiddingHead.getEbiddingNumber())).eq(LineDifferenceHead::getSourceType, (Object)LineSourceTypeEnum.EBIDDING_SOURCE.getValue())).orderByAsc(LineDifferenceHead::getTotalNetAmount)).list();
        List supplierAccounts = LineDifferenceHeads.stream().map(LineDifferenceHead::getToElsAccount).collect(Collectors.toList());
        if (CollUtil.isEmpty(supplierAccounts)) {
            throw new ELSBootException("\u627e\u4e0d\u5230\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546");
        }
        List transportTypeDictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("srmOilPrice", TenantContext.getTenant());
        if (CollUtil.isEmpty((Collection)transportTypeDictDTOS)) {
            throw new ELSBootException("\u8bf7\u7ef4\u62a4\u597d\u6cb9\u4ef7\u5b57\u5178\u503c");
        }
        BigDecimal oilPrice = (BigDecimal)ObjectUtil.defaultIfNull((Object)new BigDecimal(((DictDTO)transportTypeDictDTOS.get(0)).getValue()), (Object)BigDecimal.ZERO);
        BigDecimal supplierCounts = supplierAccounts.size() >= 3 ? new BigDecimal("3") : new BigDecimal(supplierAccounts.size());
        List purchaseEnquiryItems = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((PurchaseEnquiryItemLpService)SpringContextUtils.getBean(PurchaseEnquiryItemLpService.class)).lambdaQuery().eq(PurchaseEnquiryItemLp::getHeadId, (Object)purchaseEbiddingHead.getEnquiryId())).in(PurchaseEnquiryItemLp::getToElsAccount, supplierAccounts)).list();
        List saleEbiddingItems = this.saleEbiddingItemMapper.selectWithoutElsAccountByEbiddingNumber(purchaseEbiddingHead.getEbiddingNumber()).stream().filter(s -> supplierAccounts.contains(s.getElsAccount())).collect(Collectors.toList());
        Map<String, BigDecimal> ebiddingRangeMap = saleEbiddingItems.stream().filter(s -> ((BigDecimal)ObjectUtil.defaultIfNull((Object)s.getEbiddingRange(), (Object)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toMap(BaseEntity::getElsAccount, SaleEbiddingItemLp::getEbiddingRange));
        purchaseEnquiryItems.forEach(purchaseEnquiryItem -> {
            BigDecimal ebiddingRange = (BigDecimal)ebiddingRangeMap.get(purchaseEnquiryItem.getToElsAccount());
            if (ObjectUtil.isNotNull((Object)ebiddingRange) && ebiddingRange.compareTo(BigDecimal.ZERO) > 0) {
                this.calculateEbiddingPrice(purchaseEbiddingHead, (PurchaseEnquiryItemLp)((Object)purchaseEnquiryItem), ebiddingRange);
            }
        });
        List purchaseEnquiryItemList = purchaseEnquiryItems.stream().filter(item -> toElsAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"DISTINCT to_els_account"});
        queryWrapper.eq((Object)"subject_number", (Object)purchaseEbiddingHead.getSubjectNumber());
        queryWrapper.eq((Object)"source_type", (Object)LineSourceTypeEnum.EBIDDING_SOURCE.getValue());
        queryWrapper.eq((Object)"enquiry_number", (Object)purchaseEbiddingHead.getEnquiryNumber());
        List generatedToElsAccounts = this.list((Wrapper)queryWrapper).stream().map(LineDifferenceItem::getToElsAccount).collect(Collectors.toList());
        List<LineDifferenceItem> generatedItems = new ArrayList();
        boolean isFbk7AlreadyRefreshed = true;
        if (CollUtil.isNotEmpty(generatedToElsAccounts)) {
            generatedItems = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{BaseEntity::getId, LineDifferenceItem::getToElsAccount, LineDifferenceItem::getArriveProvince, LineDifferenceItem::getSectionNumber, LineDifferenceItem::getEnquiryItemNumber}).eq(LineDifferenceItem::getSubjectNumber, (Object)purchaseEbiddingHead.getSubjectNumber())).eq(LineDifferenceItem::getSourceType, (Object)LineSourceTypeEnum.EBIDDING_SOURCE.getValue())).eq(LineDifferenceItem::getEnquiryNumber, (Object)purchaseEbiddingHead.getEnquiryNumber())).in(LineDifferenceItem::getToElsAccount, generatedToElsAccounts)).list();
            isFbk7AlreadyRefreshed = generatedItems.stream().anyMatch(i -> StrUtil.isNotBlank((CharSequence)i.getFbk7()));
        }
        Map<String, LineDifferenceItem> generatedItemMap = generatedItems.stream().collect(Collectors.toMap(item -> item.getArriveProvince() + "_" + item.getSectionNumber() + "_" + item.getToElsAccount() + "_" + item.getEnquiryItemNumber(), i -> i, (o, n) -> n));
        Map<String, List<PurchaseEnquiryItemLp>> enquiryItemGroupByArriveProvince = purchaseEnquiryItems.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemLp::getArriveProvince));
        ArrayList futures = new ArrayList(enquiryItemGroupByArriveProvince.size());
        enquiryItemGroupByArriveProvince.forEach((arriveProvince, itemsGroupByArriveProvince) -> {
            Future<List> future = this.executor.submit(() -> {
                Map<String, List<PurchaseEnquiryItemLp>> purchaseItemMap = itemsGroupByArriveProvince.stream().collect(Collectors.groupingBy(item -> item.getSectionNumber() + "_" + item.getToElsAccount()));
                ArrayList currentThreadResult = new ArrayList();
                purchaseItemMap.forEach((key, enquiryItems) -> {
                    for (PurchaseEnquiryItemLp purchaseEnquiryItem : enquiryItems) {
                        try {
                            List enquiryItemList = purchaseEnquiryItemList.stream().filter(item -> item.getSectionNumber().equals(purchaseEnquiryItem.getSectionNumber()) && item.getItemNumber().equals(purchaseEnquiryItem.getItemNumber())).collect(Collectors.toList());
                            BigDecimal acceptTotalNetAmount = enquiryItemList.stream().map(PurchaseEnquiryItemLp::getNetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal averageTrafficVolumeAmount = acceptTotalNetAmount.divide(supplierCounts, 6, RoundingMode.HALF_UP);
                            LineDifferenceItem lineDifferenceItem = new LineDifferenceItem();
                            BeanUtils.copyProperties((Object)((Object)purchaseEnquiryItem), (Object)((Object)lineDifferenceItem));
                            lineDifferenceItem.setId(null);
                            lineDifferenceItem.setSourceType(LineSourceTypeEnum.EBIDDING_SOURCE.getValue());
                            lineDifferenceItem.setSourceId(purchaseEbiddingHead.getId());
                            lineDifferenceItem.setSourceNumber(purchaseEbiddingHead.getEbiddingNumber());
                            lineDifferenceItem.setSourceItemId(purchaseEbiddingItem.getId());
                            lineDifferenceItem.setSourceItemNumber(purchaseEbiddingItem.getItemNumber());
                            lineDifferenceItem.setTransportType(purchaseEbiddingHead.getSubjectType());
                            lineDifferenceItem.setSubjectNumber(purchaseEbiddingHead.getSubjectNumber());
                            lineDifferenceItem.setSubjectName(purchaseEbiddingHead.getSubjectName());
                            lineDifferenceItem.setSubjectFileHeadId(purchaseEbiddingHead.getSubjectFileHeadId());
                            lineDifferenceItem.setEnquiryNumber(purchaseEnquiryItem.getEnquiryNumber());
                            lineDifferenceItem.setEnquiryItemNumber(purchaseEnquiryItem.getItemNumber());
                            lineDifferenceItem.setLineNumber(purchaseEnquiryItem.getLineNumber());
                            lineDifferenceItem.setToStationDate(purchaseEnquiryItem.getToSta());
                            lineDifferenceItem.setSubjectYear(subjectYear);
                            lineDifferenceItem.setIsShow("1");
                            lineDifferenceItem.setExpiryDate(purchaseEbiddingHead.getExpiryDate());
                            lineDifferenceItem.setEffectiveDate(purchaseEbiddingHead.getEffectiveDate());
                            lineDifferenceItem.setDeleted(CommonConstant.DEL_FLAG_0);
                            lineDifferenceItem.setAverageTrafficVolumeAmount(averageTrafficVolumeAmount);
                            if ("1".equals(purchaseEbiddingHead.getSubjectType())) {
                                lineDifferenceItem.setNetAmount(lineDifferenceItem.getToDoorNetPrice().setScale(2, RoundingMode.HALF_UP));
                                lineDifferenceItem.setArriveCityStation(purchaseEnquiryItem.getArriveCity());
                                lineDifferenceItem.setArriveCity(null);
                            } else if ("2".equals(purchaseEbiddingHead.getSubjectType())) {
                                lineDifferenceItem.setNetAmount(purchaseEnquiryItem.getNetPrice());
                                lineDifferenceItem.setTrafficVolumeProportion(purchaseEnquiryItem.getTrafficVolumeProportion());
                            } else if ("3".equals(purchaseEbiddingHead.getSubjectType())) {
                                lineDifferenceItem.setNetAmount(lineDifferenceItem.getToDoorTonsNetPrice().setScale(2, RoundingMode.HALF_UP));
                            } else if ("4".equals(purchaseEbiddingHead.getSubjectType())) {
                                lineDifferenceItem.setNetAmount(lineDifferenceItem.getToStationNetPrice().setScale(2, RoundingMode.HALF_UP));
                            }
                            BigDecimal diffItemNetAmount = (BigDecimal)ObjectUtil.defaultIfNull((Object)lineDifferenceItem.getNetAmount(), (Object)BigDecimal.ZERO);
                            BigDecimal diffItemTrafficVolumeProportion = (BigDecimal)ObjectUtil.defaultIfNull((Object)lineDifferenceItem.getTrafficVolumeProportion(), (Object)BigDecimal.ZERO);
                            BigDecimal enquiryItemTrafficVolumeProportion = (BigDecimal)ObjectUtil.defaultIfNull((Object)purchaseEnquiryItem.getTrafficVolumeProportion(), (Object)BigDecimal.ZERO);
                            BigDecimal trafficVolumeAmount = "2".equals(purchaseEbiddingHead.getSubjectType()) ? diffItemNetAmount.multiply(diffItemTrafficVolumeProportion.divide(ONE_HUNDRED, 6, RoundingMode.HALF_UP)) : diffItemNetAmount.multiply(enquiryItemTrafficVolumeProportion.divide(ONE_HUNDRED, 6, RoundingMode.HALF_UP));
                            lineDifferenceItem.setTrafficVolumeAmount(trafficVolumeAmount);
                            BigDecimal differenceAmount = BigDecimal.ZERO;
                            if (averageTrafficVolumeAmount.compareTo(BigDecimal.ZERO) > 0) {
                                differenceAmount = trafficVolumeAmount.subtract(averageTrafficVolumeAmount).divide(averageTrafficVolumeAmount, 4, RoundingMode.HALF_UP).multiply(ONE_HUNDRED);
                            }
                            if (differenceAmount.compareTo(new BigDecimal("20")) > 0) {
                                lineDifferenceItem.setPriceVarianceRatio(differenceAmount.setScale(2, RoundingMode.HALF_UP));
                            }
                            if ("2".equals(purchaseEbiddingHead.getSubjectType())) {
                                PurchaseEnquiryItemLp initItem = (PurchaseEnquiryItemLp)((Object)((Object)((Object)((Object)itemMap.get(purchaseEnquiryItem.getItemNumber() + purchaseEnquiryItem.getSectionNumber())))));
                                if (initItem != null) {
                                    purchaseEnquiryItem.setKilometre(initItem.getKilometre());
                                    lineDifferenceItem.setKilometre(purchaseEnquiryItem.getKilometre());
                                } else {
                                    log.error("initItem_isnull_");
                                }
                            }
                            lineDifferenceItem.setFbk7(ObjectUtil.isNull((Object)lineDifferenceItem.getPriceVarianceRatio()) ? null : lineDifferenceItem.getPriceVarianceRatio().stripTrailingZeros().toPlainString());
                            if (CollUtil.isNotEmpty((Map)generatedItemMap) && generatedItemMap.containsKey(arriveProvince + "_" + key + "_" + lineDifferenceItem.getEnquiryItemNumber())) {
                                LineDifferenceItem generatedItem = (LineDifferenceItem)((Object)((Object)((Object)((Object)generatedItemMap.get(arriveProvince + "_" + key + "_" + lineDifferenceItem.getEnquiryItemNumber())))));
                                generatedItem.setFbk7(ObjectUtil.isNull((Object)lineDifferenceItem.getPriceVarianceRatio()) ? null : lineDifferenceItem.getPriceVarianceRatio().stripTrailingZeros().toPlainString());
                                continue;
                            }
                            currentThreadResult.add(lineDifferenceItem);
                        }
                        catch (Exception e) {
                            throw new ELSBootException(e.getCause().getMessage());
                        }
                    }
                });
                return currentThreadResult;
            });
            futures.add(future);
        });
        for (Future future : futures) {
            try {
                List currentFutureResult = (List)future.get();
                if (!CollUtil.isNotEmpty((Collection)currentFutureResult)) continue;
                lineDifferenceItemList.addAll(currentFutureResult);
            }
            catch (Exception e) {
                throw new ELSBootException(e.getMessage());
            }
        }
        if (lineDifferenceItemList.size() > 0 && isFbk7AlreadyRefreshed) {
            this.saveBatch(lineDifferenceItemList, 2000);
        }
        if (generatedItems.size() > 0) {
            ((LineDifferenceItemMapper)this.getBaseMapper()).tempBatchUpdateFbk7(generatedItems);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Map<String, Object> importExcel(MultipartFile file, Map<String, Object> otherRequestParam) {
        InputStream inputStream = null;
        Object requestId = "nbeLineDifferenceRequestId";
        try {
            LineDifferenceDataListener dataListener = new LineDifferenceDataListener();
            inputStream = file.getInputStream();
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            EasyExcel.read((InputStream)inputStream, (ReadListener)dataListener).headRowNumber(Integer.valueOf(1)).doReadAll();
            final List<LineDifferenceItem> cachedDataList = dataListener.getCachedDataList();
            if (!CollectionUtils.isEmpty(cachedDataList)) {
                requestId = cachedDataList.get(0).getSourceType() + "_" + cachedDataList.get(0).getToElsAccount() + "_" + cachedDataList.get(0).getSubjectNumber();
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"source_type", (Object)LineSourceTypeEnum.IMPORT_SOURCE.getValue());
                queryWrapper.eq((Object)"to_els_account", (Object)cachedDataList.get(0).getToElsAccount());
                queryWrapper.eq((Object)"subject_number", (Object)cachedDataList.get(0).getSubjectNumber());
                queryWrapper.eq((Object)"subject_year", (Object)cachedDataList.get(0).getSubjectYear());
                List lineDifferenceItems = this.list((Wrapper)queryWrapper);
                int currentYear = DateUtil.year((Date)new Date());
                lineDifferenceItems = lineDifferenceItems.stream().filter(item -> currentYear == DateUtil.year((Date)item.getCreateTime())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(lineDifferenceItems)) {
                    throw new ELSBootException("\u6807\u7684\u300a" + cachedDataList.get(0).getSubjectName() + "\u300b\u5df2\u5b58\u5728\u6570\u636e\u6765\u6e90\u4e3a\u5bfc\u5165\u3001\u4f9b\u5e94\u5546\u4e3a" + cachedDataList.get(0).getSupplierName() + " \u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5bfc\u5165");
                }
            }
            if (!this.redisUtil.tryGetDistributedLock(APPLY_KEY, (String)requestId, 3600000L)) {
                throw new ELSBootException("\u5bfc\u5165\u4e2d\uff0c\u8bf7\u7b49\u5f85\u6570\u636e\u5199\u5165\u5b8c\u6bd5\uff0c\u52ff\u91cd\u590d\u5bfc\u5165!");
            }
            final String finalRequestId = requestId;
            final LoginUser loginUser = SysUtil.getLoginUser();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    LoginUserContext.setUser((LoginUser)loginUser);
                    TenantContext.setTenant((String)loginUser.getElsAccount());
                    try {
                        ((LineDifferenceItemService)SpringContextUtils.getBean(LineDifferenceItemService.class)).asynImportExcel(cachedDataList);
                    }
                    catch (Exception e) {
                        log.error("asynImportExcel_faild:", (Throwable)e);
                    }
                    finally {
                        LineDifferenceItemServiceImpl.this.redisUtil.releaseDistributedLock(LineDifferenceItemServiceImpl.APPLY_KEY, finalRequestId);
                        LoginUserContext.clear();
                        TenantContext.clear();
                    }
                }
            });
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            return errorMap;
        }
        catch (Exception e) {
            if (e instanceof ELSExcelBootException) {
                throw (ELSExcelBootException)e;
            }
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void asynImportExcel(List<LineDifferenceItem> cachedDataList) {
        List transportTypeDictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("addressType", TenantContext.getTenant());
        List ynDictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("yn", TenantContext.getTenant());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
        String subjectYear = dateFormat.format(new Date());
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal oilPrice = BigDecimal.ZERO;
        List oilPriceDictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("srmOilPrice", TenantContext.getTenant());
        if (oilPriceDictDTOS.size() <= 0) {
            throw new ELSBootException("\u8bf7\u7ef4\u62a4\u597d\u6cb9\u4ef7\u5b57\u5178\u503c");
        }
        oilPrice = new BigDecimal(((DictDTO)oilPriceDictDTOS.get(0)).getValue());
        String headId = IdWorker.getIdStr();
        Set sectionNumberSet = cachedDataList.stream().map(LineDifferenceItem::getSectionNumber).collect(Collectors.toSet());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"subject_number", (Object)cachedDataList.get(0).getSubjectNumber());
        queryWrapper.in((Object)"section_number", sectionNumberSet);
        List nbeSubjectFileItemList = this.subjectFileItemService.list((Wrapper)queryWrapper);
        int currentYear = DateUtil.year((Date)new Date());
        nbeSubjectFileItemList = nbeSubjectFileItemList.stream().filter(item -> currentYear == DateUtil.year((Date)item.getCreateTime())).collect(Collectors.toList());
        Map subjectMap = nbeSubjectFileItemList.stream().collect(Collectors.toMap(SubjectFileItem::getSectionNumber, Function.identity()));
        Map<String, List<LineDifferenceItem>> itemListMap = cachedDataList.stream().collect(Collectors.groupingBy(LineDifferenceItem::getSectionNumber));
        for (String string : itemListMap.keySet()) {
            List<LineDifferenceItem> lineDifferenceItemList = itemListMap.get(string);
            SubjectFileItem subjectItem = (SubjectFileItem)((Object)subjectMap.get(string));
            if (null != lineDifferenceItemList && lineDifferenceItemList.size() > 0) {
                if (null == subjectItem) {
                    throw new ELSBootException("\u8bf7\u5148\u7ef4\u62a4\u3010" + lineDifferenceItemList.get(0).getSubjectNumber() + "_" + string + "\u3011\u7684\u6807\u7684\u6863\u6848\u4fe1\u606f\uff01");
                }
            } else {
                throw new ELSBootException("\u7ebf\u8def\u5dee\u5f02\u62a5\u8868\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            BigDecimal subjectAmount = BigDecimal.ZERO;
            for (LineDifferenceItem lineDifferenceItem : lineDifferenceItemList) {
                lineDifferenceItem.setHeadId(headId);
                lineDifferenceItem.setId(null);
                lineDifferenceItem.setSourceType(LineSourceTypeEnum.IMPORT_SOURCE.getValue());
                String transportTypeDictValue = transportTypeDictDTOS.parallelStream().filter(o -> o.getText().equals(lineDifferenceItem.getTransportType())).map(DictDTO::getValue).collect(Collectors.joining());
                String ynDictValue = ynDictDTOS.parallelStream().filter(o -> o.getText().equals(lineDifferenceItem.getCenterPoint())).map(DictDTO::getValue).collect(Collectors.joining());
                lineDifferenceItem.setTransportType(transportTypeDictValue);
                lineDifferenceItem.setCenterPoint(ynDictValue);
                lineDifferenceItem.setSourceNumber(lineDifferenceItem.getEnquiryNumber());
                lineDifferenceItem.setSourceItemNumber(lineDifferenceItem.getEnquiryItemNumber());
                lineDifferenceItem.setSubjectYear(subjectYear);
                lineDifferenceItem.setIsShow("1");
                BigDecimal taxRate = new BigDecimal(lineDifferenceItem.getTaxRate());
                if (null != lineDifferenceItem.getIntervalRatioPrice1()) {
                    lineDifferenceItem.setIntervalRatioPrice1(lineDifferenceItem.getIntervalRatioPrice1().setScale(0, 4));
                    lineDifferenceItem.setIntervalRatioNetPrice1(lineDifferenceItem.getIntervalRatioPrice1().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
                }
                if (null != lineDifferenceItem.getIntervalRatioPrice2()) {
                    lineDifferenceItem.setIntervalRatioPrice2(lineDifferenceItem.getIntervalRatioPrice2().setScale(0, 4));
                    lineDifferenceItem.setIntervalRatioNetPrice2(lineDifferenceItem.getIntervalRatioPrice2().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
                }
                if (null != lineDifferenceItem.getIntervalRatioPrice3()) {
                    lineDifferenceItem.setIntervalRatioPrice3(lineDifferenceItem.getIntervalRatioPrice3().setScale(0, 4));
                    lineDifferenceItem.setIntervalRatioNetPrice3(lineDifferenceItem.getIntervalRatioPrice3().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
                }
                if (null != lineDifferenceItem.getIntervalRatioPrice4()) {
                    lineDifferenceItem.setIntervalRatioPrice4(lineDifferenceItem.getIntervalRatioPrice4().setScale(0, 4));
                    lineDifferenceItem.setIntervalRatioNetPrice4(lineDifferenceItem.getIntervalRatioPrice4().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
                }
                if (null != lineDifferenceItem.getToDoorPrice()) {
                    lineDifferenceItem.setToDoorPrice(lineDifferenceItem.getToDoorPrice().setScale(0, 4));
                    lineDifferenceItem.setToDoorNetPrice(lineDifferenceItem.getToDoorPrice().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
                }
                if (null != lineDifferenceItem.getToStationPrice()) {
                    lineDifferenceItem.setToStationPrice(lineDifferenceItem.getToStationPrice().setScale(0, 4));
                    lineDifferenceItem.setToStationNetPrice(lineDifferenceItem.getToStationPrice().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
                }
                if (null != lineDifferenceItem.getToDoorTonsPrice()) {
                    lineDifferenceItem.setToDoorTonsPrice(lineDifferenceItem.getToDoorTonsPrice().setScale(0, 4));
                    lineDifferenceItem.setToDoorTonsNetPrice(lineDifferenceItem.getToDoorTonsPrice().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
                }
                if ("2".equals(lineDifferenceItem.getTransportType())) {
                    BigDecimal netPrice1 = lineDifferenceItem.getIntervalRatioNetPrice1().multiply(subjectItem.getIntervalRatio1().divide(new BigDecimal(100), 6, 4));
                    BigDecimal netPrice2 = lineDifferenceItem.getIntervalRatioNetPrice2().multiply(subjectItem.getIntervalRatio2().divide(new BigDecimal(100), 6, 4));
                    BigDecimal netPrice3 = lineDifferenceItem.getIntervalRatioNetPrice3().multiply(subjectItem.getIntervalRatio3().divide(new BigDecimal(100), 6, 4));
                    BigDecimal netPrice4 = lineDifferenceItem.getIntervalRatioNetPrice4().multiply(subjectItem.getIntervalRatio4().divide(new BigDecimal(100), 6, 4));
                    BigDecimal netAmount = netPrice1.add(netPrice2).add(netPrice3).add(netPrice4);
                    lineDifferenceItem.setNetAmount(netAmount.setScale(6, 4));
                    BigDecimal trafficVolumeAmount = lineDifferenceItem.getNetAmount().multiply(lineDifferenceItem.getTrafficVolumeProportion().divide(new BigDecimal(100), 6, 4));
                    lineDifferenceItem.setTrafficVolumeAmount(trafficVolumeAmount);
                } else if ("1".equals(lineDifferenceItem.getTransportType())) {
                    lineDifferenceItem.setNetAmount(lineDifferenceItem.getToDoorNetPrice().setScale(6, 4));
                    trafficVolumeAmount = lineDifferenceItem.getNetAmount().multiply(lineDifferenceItem.getTrafficVolumeProportion().divide(new BigDecimal(100), 6, 4));
                    lineDifferenceItem.setTrafficVolumeAmount(trafficVolumeAmount);
                } else if ("3".equals(lineDifferenceItem.getTransportType())) {
                    lineDifferenceItem.setNetAmount(lineDifferenceItem.getToDoorTonsNetPrice().setScale(2, 4));
                    trafficVolumeAmount = lineDifferenceItem.getNetAmount().multiply(lineDifferenceItem.getTrafficVolumeProportion().divide(new BigDecimal(100), 6, 4));
                    lineDifferenceItem.setTrafficVolumeAmount(trafficVolumeAmount);
                } else if ("4".equals(lineDifferenceItem.getTransportType())) {
                    lineDifferenceItem.setNetAmount(lineDifferenceItem.getToStationNetPrice().setScale(2, 4));
                    trafficVolumeAmount = lineDifferenceItem.getNetAmount().multiply(lineDifferenceItem.getTrafficVolumeProportion().divide(new BigDecimal(100), 6, 4));
                    lineDifferenceItem.setTrafficVolumeAmount(trafficVolumeAmount);
                }
                subjectAmount = subjectAmount.add(lineDifferenceItem.getTrafficVolumeAmount());
            }
            BigDecimal trafficVolumeProportion = subjectItem.getTrafficVolumeProportion();
            totalAmount = totalAmount.add(subjectAmount.multiply(trafficVolumeProportion.divide(new BigDecimal(100), 4, 4)));
        }
        if (!CollectionUtils.isEmpty(cachedDataList)) {
            cachedDataList.forEach(item -> item.setElsAccount(TenantContext.getTenant()));
            List subList = ListUtils.partition(cachedDataList, (int)2000);
            for (List itemList : subList) {
                this.lineDifferenceItemMapper.insertBatchSomeColumn(itemList);
            }
            LineDifferenceHead lineDifferenceHead = new LineDifferenceHead();
            lineDifferenceHead.setId(headId);
            lineDifferenceHead.setElsAccount(cachedDataList.get(0).getElsAccount());
            lineDifferenceHead.setSupplierName(cachedDataList.get(0).getSupplierName());
            lineDifferenceHead.setSourceId(cachedDataList.get(0).getId());
            lineDifferenceHead.setSourceNumber(cachedDataList.get(0).getEnquiryNumber());
            lineDifferenceHead.setSourceType(LineSourceTypeEnum.IMPORT_SOURCE.getValue());
            lineDifferenceHead.setToElsAccount(cachedDataList.get(0).getToElsAccount());
            lineDifferenceHead.setSubjectNumber(cachedDataList.get(0).getSubjectNumber());
            lineDifferenceHead.setSubjectName(cachedDataList.get(0).getSubjectName());
            lineDifferenceHead.setSubjectFileHeadId(cachedDataList.get(0).getSubjectFileHeadId());
            lineDifferenceHead.setTransportType(cachedDataList.get(0).getTransportType());
            lineDifferenceHead.setTotalNetAmount(totalAmount.setScale(2, 4));
            lineDifferenceHead.setSubjectYear(subjectYear);
            this.lineDifferenceHeadService.save((Object)lineDifferenceHead);
        }
    }
}

