/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.entity.PurchaseClarificationInfo;
import com.els.modules.bidding.entity.SaleClarificationInfo;
import com.els.modules.bidding.mapper.PurchaseClarificationInfoMapper;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.PurchaseMentoringHeadService;
import com.els.modules.bidding.service.SaleClarificationInfoService;
import com.els.modules.bidding.service.SendToSupplierService;
import com.els.modules.bidding.service.impl.SendToSupplierServiceFactory;
import com.els.modules.bidding.vo.PurchaseClarificationInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseClarificationInfoServiceImpl
extends BaseServiceImpl<PurchaseClarificationInfoMapper, PurchaseClarificationInfo>
implements PurchaseClarificationInfoService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseClarificationInfoServiceImpl.class);
    @Autowired
    private SaleClarificationInfoService saleClarificationInfoService;
    @Autowired
    private PurchaseClarificationInfoMapper purchaseClarificationInfoMapper;
    @Autowired
    private PurchaseMentoringHeadService purchaseMentoringHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void savePurchaseClarificationInfo(PurchaseClarificationInfo purchaseClarificationInfo, List<PurchaseAttachmentDTO> attachments) {
        purchaseClarificationInfo.setRelationId(IdWorker.getIdStr());
        purchaseClarificationInfo.setPurchaseName(SysUtil.getLoginUser().getEnterpriseName());
        if (StringUtils.isBlank((CharSequence)purchaseClarificationInfo.getSendStatus())) {
            purchaseClarificationInfo.setSendStatus("0");
        }
        purchaseClarificationInfo.setClarificationNumber(this.invokeBaseRpcService.getNextCode("clarificationNumber", (Object)purchaseClarificationInfo));
        ((PurchaseClarificationInfoMapper)this.baseMapper).insert((Object)purchaseClarificationInfo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updatePurchaseClarificationInfo(PurchaseClarificationInfo purchaseClarificationInfo, List<PurchaseAttachmentDTO> attachments) {
        int count = ((PurchaseClarificationInfoMapper)this.baseMapper).updateById((Object)purchaseClarificationInfo);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delPurchaseClarificationInfo(String id) {
        ((PurchaseClarificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchPurchaseClarificationInfo(List<String> idList) {
        ((PurchaseClarificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void publish(PurchaseClarificationInfo purchaseClarificationInfo, List<PurchaseAttachmentDTO> attachments) {
        purchaseClarificationInfo.setSendStatus("1");
        this.savePurchaseCharificaton(purchaseClarificationInfo, attachments);
        SendToSupplierService send = SendToSupplierServiceFactory.getbusinessTypeService(purchaseClarificationInfo.getBusinessType());
        Map<String, String> suppliers = send.handleSupplier(purchaseClarificationInfo);
        if (CollectionUtils.isEmpty(suppliers)) {
            return;
        }
        this.sendToSupplier(purchaseClarificationInfo, attachments, suppliers);
    }

    private void savePurchaseCharificaton(PurchaseClarificationInfo purchaseClarificationInfo, List<PurchaseAttachmentDTO> attachments) {
        if (StringUtils.isBlank((CharSequence)purchaseClarificationInfo.getId())) {
            this.savePurchaseClarificationInfo(purchaseClarificationInfo, attachments);
            return;
        }
        this.updatePurchaseClarificationInfo(purchaseClarificationInfo, attachments);
    }

    public void sendToSupplier(PurchaseClarificationInfo purchaseClarificationInfo, List<PurchaseAttachmentDTO> attachments, Map<String, String> suppliers) {
        if (suppliers != null && suppliers.size() > 0) {
            Set<String> toElsAccounts = suppliers.keySet();
            ArrayList<String> recevieAccount = new ArrayList<String>();
            HashMap<String, String> idMap = new HashMap<String, String>();
            for (String string : toElsAccounts) {
                Map<String, String> saleClarificationMap = this.saveSaleClarification(purchaseClarificationInfo, string, attachments);
                log.info("saleClarificationMap:{}", (Object)JSONObject.toJSONString(saleClarificationMap));
                idMap.putAll(saleClarificationMap);
                recevieAccount.add(string);
            }
            super.sendMessage(TenantContext.getTenant(), "clarification", "publish", purchaseClarificationInfo.getId(), "clarificationBusDataServiceImpl", recevieAccount);
        }
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, String> idMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(idMap)) {
            idMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", value);
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addClarificationInfoForSupplier(String businessType, String businessNumber, String toElsAccount, String supplierName) {
        this.purchaseMentoringHeadService.addMentoringInfoForSupplier(businessType, businessNumber, toElsAccount, supplierName);
        List<PurchaseClarificationInfo> clarificationInfos = this.purchaseClarificationInfoMapper.getByKey(TenantContext.getTenant(), businessType, businessNumber);
        if (CollectionUtils.isEmpty(clarificationInfos)) {
            return;
        }
        for (PurchaseClarificationInfo purchaseClarificationInfo : clarificationInfos) {
            List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseClarificationInfo.getId());
            this.saveSaleClarification(purchaseClarificationInfo, toElsAccount, attachments);
        }
    }

    public Map<String, String> saveSaleClarification(PurchaseClarificationInfo purchaseClarificationInfo, String toElsAccount, List<PurchaseAttachmentDTO> attachments) {
        SaleClarificationInfo saleClarificationInfo = new SaleClarificationInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseClarificationInfo), (Object)((Object)saleClarificationInfo));
        saleClarificationInfo.setId(IdWorker.getIdStr());
        saleClarificationInfo.setRelationId(purchaseClarificationInfo.getId());
        saleClarificationInfo.setElsAccount(toElsAccount);
        saleClarificationInfo.setToElsAccount(purchaseClarificationInfo.getElsAccount());
        saleClarificationInfo.setViewStatus("0");
        saleClarificationInfo.setReceiveTime(new Date());
        this.saleClarificationInfoService.saveSaleClarificationInfo(saleClarificationInfo);
        if (!CollectionUtils.isEmpty(attachments)) {
            attachments.forEach(e -> e.setSendStatus("1"));
            this.invokeBaseRpcService.updatePurchaseAttachmentBatchById(attachments);
            ArrayList<SaleAttachmentDTO> saleAttachmentArrayList = new ArrayList<SaleAttachmentDTO>();
            ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
            for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
                if (StringUtils.isBlank((CharSequence)purchaseAttachment.getHeadId()) || StringUtils.isNotBlank((CharSequence)purchaseAttachment.getHeadId()) && "undefined".equals(purchaseAttachment.getHeadId())) {
                    purchaseAttachment.setHeadId(purchaseClarificationInfo.getId());
                    purchaseAttachments.add(purchaseAttachment);
                }
                SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
                saleAttachment.setId(null);
                saleAttachment.setRelationId(purchaseAttachment.getId());
                saleAttachment.setElsAccount(toElsAccount);
                saleAttachment.setHeadId(saleClarificationInfo.getId());
                saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
                saleAttachmentArrayList.add(saleAttachment);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentArrayList);
        }
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put(saleClarificationInfo.getElsAccount(), saleClarificationInfo.getId());
        return idMap;
    }

    @Override
    public JSONObject getDataById(String id) {
        PurchaseClarificationInfoVO messageById = this.getMessageById(id);
        if (messageById == null) {
            return null;
        }
        Result result = Result.ok((Object)((Object)messageById));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    private PurchaseClarificationInfoVO getMessageById(String id) {
        PurchaseClarificationInfo head = (PurchaseClarificationInfo)((Object)this.getById((Serializable)((Object)id)));
        if (head == null) {
            return null;
        }
        PurchaseClarificationInfoVO headVO = new PurchaseClarificationInfoVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        return headVO;
    }
}

