/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResultEnquiryAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        Object operataion = "resultSubmitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_resultSubmitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, (String)operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "resultAuditPass");
        } else {
            Object operataion = "resultSubmitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_resultSubmitAudit";
            }
            this.sendMsg(inputParamVO, outputParamVO, (String)operataion);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "resultAuditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PurchaseEnquiryHead head = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(id);
            headVO.setPurchaseEnquiryItemList(itemList);
            Result result = Result.ok((Object)((Object)headVO));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        List<PurchaseEnquiryItem> itemList;
        List<String> itemNumbers;
        String headId;
        String businessId = inputParamVO.getBusinessId();
        String flowId = outputParamVO.getProcessRootId();
        String auditStatus = outputParamVO.getAuditStatus();
        String bpmnType = outputParamVO.getBpmnType();
        PurchaseEnquiryHeadVO headVO = (PurchaseEnquiryHeadVO)((Object)JSON.parseObject((String)inputParamVO.getParams(), PurchaseEnquiryHeadVO.class));
        boolean isByRowAudit = businessId.contains("_");
        String string = headId = isByRowAudit ? businessId.split("_")[0] : businessId;
        if (isByRowAudit) {
            itemNumbers = Arrays.asList(businessId.split("_")[1].split(","));
            this.updateAudit(true, headId, itemNumbers, auditStatus, bpmnType, flowId);
            itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
        } else {
            this.updateAudit(false, headId, null, auditStatus, bpmnType, flowId);
            itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
            itemNumbers = itemList.stream().map(PurchaseEnquiryItem::getItemNumber).distinct().collect(Collectors.toList());
        }
        PurchaseEnquiryHead head = new PurchaseEnquiryHead();
        head.setId(headId);
        head.setResultAuditStatus(auditStatus);
        head.setWorkFlowType(outputParamVO.getBpmnType());
        head.setResultFlowId(flowId);
        this.purchaseEnquiryHeadService.updateById((Object)head);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
            List<PurchaseEnquiryItem> accept = headVO.getPurchaseEnquiryItemList().stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            List<PurchaseEnquiryItem> reject = headVO.getPurchaseEnquiryItemList().stream().filter(item -> EnquiryStatusEnum.REJECT.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            this.saleEnquiryItemService.accept(accept);
            if (!reject.isEmpty()) {
                this.saleEnquiryItemService.reject(reject);
            }
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEnquiryItem> acceptList = itemList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).filter(item -> itemNumbers.contains(item.getItemNumber())).collect(Collectors.toList());
                this.purchaseEnquiryHeadService.generatePriceRecord(dbHead, acceptList);
            }
            List<PurchaseEnquiryItem> pricedList = itemList.stream().filter(item -> itemNumbers.contains(item.getItemNumber())).collect(Collectors.toList());
            this.purchaseEnquiryHeadService.priced(dbHead, pricedList);
            List<PurchaseEnquiryItem> acceptList = pricedList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).toList();
            this.purchaseEnquiryHeadService.goBackDemand(acceptList, PurchaseRequestStatusItemEnum.INQUIRY_COMPLETED.getValue());
        }
    }

    private void updateAudit(boolean isByRowAudit, String headId, List<String> itemNumbers, String auditStatus, String bpmnType, String flowId) {
        this.purchaseEnquiryItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEnquiryItem::getHeadId, (Object)headId)).in(isByRowAudit, PurchaseEnquiryItem::getItemNumber, itemNumbers)).set(PurchaseEnquiryItem::getAuditStatus, (Object)auditStatus)).set(PurchaseEnquiryItem::getWorkFlowType, (Object)bpmnType)).set(PurchaseEnquiryItem::getFlowId, (Object)flowId));
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"enquiry", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"enquiry", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId().split("_")[0];
        String businessType = inputParamVO.getBusinessType();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseEnquiryHead head = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
        if (inputParamVO.getBusinessId().contains("_")) {
            List<String> itemNumbers = Arrays.asList(inputParamVO.getBusinessId().split("_")[1].split(","));
            itemList = itemList.stream().filter(item -> itemNumbers.contains(item.getItemNumber())).collect(Collectors.toList());
        }
        headVO.setPurchaseEnquiryItemList(itemList);
        Result result = Result.ok((Object)((Object)headVO));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("Id", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

