/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceHead;
import com.els.modules.logisticspurchase.base.enumerate.LineSourceTypeEnum;
import com.els.modules.logisticspurchase.base.service.LineDifferenceHeadService;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.mapper.SaleEbiddingItemLpMapper;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.vo.SaleEbiddingHeadLpVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SaleEbiddingItemLpServiceImpl
extends ServiceImpl<SaleEbiddingItemLpMapper, SaleEbiddingItemLp>
implements SaleEbiddingItemLpService {
    @Autowired
    private PurchaseEbiddingItemLpService purchaseEbiddingItemService;

    @Override
    public List<SaleEbiddingItemLp> selectByMainId(String mainId) {
        return ((SaleEbiddingItemLpMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void publish(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, Map<String, String> idMap) {
        ArrayList<SaleEbiddingItemLp> insertList = new ArrayList<SaleEbiddingItemLp>();
        LoginUser user = SysUtil.getLoginUser();
        for (PurchaseEbiddingItemLp item : itemList) {
            SaleEbiddingItemLp insertItem = new SaleEbiddingItemLp();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)insertItem));
            insertItem.setId(item.getRelationId());
            insertItem.setElsAccount(item.getToElsAccount());
            insertItem.setRelationId(item.getId());
            insertItem.setHeadId(idMap.get(item.getToElsAccount()));
            insertItem.setToElsAccount(item.getElsAccount());
            insertItem.setPurchaseName(user.getEnterpriseName());
            insertItem.setTargetPrice("1".equals(head.getSendTargetPrice()) ? item.getTargetPrice() : null);
            insertList.add(insertItem);
        }
        this.saveBatch(insertList, 2000);
        this.generateNbeLineDifferenceHead(insertList);
    }

    private void generateNbeLineDifferenceHead(List<SaleEbiddingItemLp> saleItems) {
        ArrayList differenceHeads = new ArrayList(saleItems.size());
        saleItems.forEach(saleItem -> {
            SupplierMasterDataDTO supplierMasterDataDTO = ((InquiryInvokeSupplierRpcService)SpringContextUtils.getBean(InquiryInvokeSupplierRpcService.class)).getByAccount(saleItem.getToElsAccount(), saleItem.getElsAccount());
            LineDifferenceHead differenceHead = new LineDifferenceHead();
            if (supplierMasterDataDTO != null && !ObjectUtils.isEmpty((Object)supplierMasterDataDTO.getSupplierName())) {
                differenceHead.setSupplierName(supplierMasterDataDTO.getSupplierName());
            } else {
                differenceHead.setSupplierName(saleItem.getSupplierName());
            }
            differenceHead.setElsAccount(saleItem.getToElsAccount());
            differenceHead.setSourceId(saleItem.getHeadId());
            differenceHead.setSourceNumber(saleItem.getEbiddingNumber());
            differenceHead.setSourceType(LineSourceTypeEnum.EBIDDING_SOURCE.getValue());
            differenceHead.setToElsAccount(saleItem.getElsAccount());
            differenceHead.setSubjectNumber(saleItem.getSubjectNumber());
            differenceHead.setSubjectName(saleItem.getSubjectName());
            differenceHead.setSubjectFileHeadId(saleItem.getSubjectFileHeadId());
            differenceHead.setTransportType(saleItem.getSubjectType());
            differenceHead.setSubjectYear(saleItem.getSubjectYear());
            differenceHead.setTotalNetAmount(saleItem.getNetTotalAmount().setScale(2, RoundingMode.HALF_UP));
            differenceHeads.add(differenceHead);
        });
        ((LineDifferenceHeadService)SpringContextUtils.getBean(LineDifferenceHeadService.class)).saveBatch(differenceHeads);
    }

    @Override
    public void acceptResponse(SaleEbiddingHeadLpVO saleHeadVO) {
        List<SaleEbiddingItemLp> itemList = saleHeadVO.getSaleEbiddingItemList();
        ArrayList<PurchaseEbiddingItemLp> updatePurchaseList = new ArrayList<PurchaseEbiddingItemLp>();
        for (SaleEbiddingItemLp item : itemList) {
            PurchaseEbiddingItemLp purchaseItem = new PurchaseEbiddingItemLp();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)purchaseItem));
            purchaseItem.setId(item.getRelationId());
            purchaseItem.setElsAccount(item.getToElsAccount());
            purchaseItem.setRelationId(item.getId());
            purchaseItem.setHeadId(saleHeadVO.getRelationId());
            purchaseItem.setToElsAccount(item.getElsAccount());
            updatePurchaseList.add(purchaseItem);
        }
        this.updateBatchById(itemList);
        this.purchaseEbiddingItemService.updateBatchById(updatePurchaseList);
    }

    @Override
    public void replenishMaterialNumber(List<PurchaseEbiddingItemLp> itemList) {
        ArrayList<SaleEbiddingItemLp> updateList = new ArrayList<SaleEbiddingItemLp>();
        for (PurchaseEbiddingItemLp item : itemList) {
            SaleEbiddingItemLp update = new SaleEbiddingItemLp();
            update.setId(item.getRelationId());
            update.setMaterialNumber(item.getMaterialNumber());
            update.setMaterialDesc(item.getMaterialDesc());
            update.setMaterialGroup(item.getMaterialGroup());
            update.setMaterialSpec(item.getMaterialSpec());
            update.setMaterialGroupName(item.getMaterialGroupName());
            updateList.add(update);
        }
        this.updateBatchById(updateList);
    }

    @Override
    public SaleEbiddingItemLp selectOneByMainIdAndItemNumber(String headId, String nextItemNumber) {
        return ((SaleEbiddingItemLpMapper)this.baseMapper).selectOneByMainIdAndItemNumber(headId, nextItemNumber);
    }

    @Override
    public List<SaleEbiddingItemLp> selectWithoutElsAccountByHeadId(List<String> saleHeadIdList) {
        return ((SaleEbiddingItemLpMapper)this.baseMapper).selectWithoutElsAccountByHeadId(saleHeadIdList);
    }

    @Override
    public List<SaleEbiddingItemLp> selectWithoutElsAccountByItemStatus(String itemStatus, String subjectType) {
        return ((SaleEbiddingItemLpMapper)this.baseMapper).selectWithoutElsAccountByItemStatus(itemStatus, subjectType);
    }
}

