/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySubstituteItemLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.mapper.SaleEnquiryItemLpMapper;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySubstituteHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySubstituteItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.impl.SaleEnquiryHeadLpServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEnquiryItemLpServiceImpl
extends ServiceImpl<SaleEnquiryItemLpMapper, SaleEnquiryItemLp>
implements SaleEnquiryItemLpService {
    @Autowired
    private EnquirySubstituteItemLpService enquirySubstituteItemService;

    @Override
    public List<SaleEnquiryItemLp> selectByMainId(String mainId) {
        return ((SaleEnquiryItemLpMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void revoke(List<PurchaseEnquiryItemLp> revokeList) {
        List<SaleEnquiryItemLp> optionList = this.getOptionList(revokeList);
        this.updateBatchById(optionList);
        this.enquirySubstituteItemService.updateBatchById(SysUtil.copyProperties(optionList, EnquirySubstituteItemLp.class));
    }

    @Override
    public void reject(List<PurchaseEnquiryItemLp> rejectList) {
        List<SaleEnquiryItemLp> optionList = this.getOptionList(rejectList);
        this.updateBatchById(optionList);
        this.enquirySubstituteItemService.updateBatchById(SysUtil.copyProperties(optionList, EnquirySubstituteItemLp.class));
    }

    @Override
    public void accept(List<PurchaseEnquiryItemLp> acceptList) {
        List<SaleEnquiryItemLp> optionList = this.getOptionList(acceptList);
        this.updateBatchById(optionList);
        this.enquirySubstituteItemService.updateBatchById(SysUtil.copyProperties(optionList, EnquirySubstituteItemLp.class));
    }

    @Override
    public void oneAward(List<PurchaseEnquiryItemLp> awardList) {
        List<SaleEnquiryItemLp> optionList = this.getOptionList(awardList);
        this.updateBatchById(optionList);
        this.enquirySubstituteItemService.updateBatchById(SysUtil.copyProperties(optionList, EnquirySubstituteItemLp.class));
    }

    private List<SaleEnquiryItemLp> getOptionList(List<PurchaseEnquiryItemLp> optionList) {
        ArrayList<SaleEnquiryItemLp> resultList = new ArrayList<SaleEnquiryItemLp>();
        for (PurchaseEnquiryItemLp item : optionList) {
            SaleEnquiryItemLp option = new SaleEnquiryItemLp();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)option));
            option.setId(item.getRelationId());
            option.setHeadId(null);
            option.setRelationId(item.getId());
            option.setElsAccount(item.getToElsAccount());
            option.setToElsAccount(item.getElsAccount());
            resultList.add(option);
        }
        return resultList;
    }

    @Override
    @SrmTransaction
    public void quoteConfirm(SaleEnquiryHeadLp dbHead) {
        dbHead.setQuoteConfirmFlag("1");
        SaleEnquiryHeadLp newdbHead = new SaleEnquiryHeadLp();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)newdbHead));
        ((SaleEnquiryHeadLpServiceImpl)SpringContextUtils.getBean(SaleEnquiryHeadLpServiceImpl.class)).updateById((Object)dbHead);
        List<SaleEnquiryItemLp> dbItemList = ((SaleEnquiryItemLpMapper)this.baseMapper).selectByMainId(dbHead.getId());
        dbItemList.forEach(item -> item.setQuoteFlag("1"));
        this.updateBatchById(dbItemList);
        ArrayList<PurchaseEnquiryItemLp> updateList = new ArrayList<PurchaseEnquiryItemLp>();
        for (SaleEnquiryItemLp item2 : dbItemList) {
            PurchaseEnquiryItemLp purchase = new PurchaseEnquiryItemLp();
            purchase.setId(item2.getRelationId());
            purchase.setQuoteFlag("1");
            updateList.add(purchase);
        }
        PurchaseEnquiryItemLpService purchaseEnquiryItemService = (PurchaseEnquiryItemLpService)SpringContextUtils.getBean(PurchaseEnquiryItemLpService.class);
        purchaseEnquiryItemService.updateBatchById(updateList);
        EnquirySubstituteHeadLpService enquirySubstituteHeadService = (EnquirySubstituteHeadLpService)SpringContextUtils.getBean(EnquirySubstituteHeadLpService.class);
        enquirySubstituteHeadService.quoteConfirm(newdbHead, dbItemList);
    }

    @Override
    public void replenishMaterialNumber(List<PurchaseEnquiryItemLp> itemList) {
        ArrayList<SaleEnquiryItemLp> updateList = new ArrayList<SaleEnquiryItemLp>();
        for (PurchaseEnquiryItemLp item : itemList) {
            SaleEnquiryItemLp updateItem = new SaleEnquiryItemLp();
            updateItem.setId(item.getRelationId());
            updateItem.setMaterialNumber(item.getMaterialNumber());
            updateItem.setMaterialDesc(item.getMaterialDesc());
            updateItem.setMaterialGroup(item.getMaterialGroup());
            updateItem.setMaterialSpec(item.getMaterialSpec());
            updateItem.setMaterialGroupName(item.getMaterialGroupName());
            updateList.add(updateItem);
        }
        this.updateBatchById(updateList);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((SaleEnquiryItemLpMapper)this.baseMapper).deleteByMainId(mainId);
    }
}

