/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.socket.config;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.SocketConfig;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.annotation.SpringAnnotationScanner;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration
public class SocketIOServerConfig {
    @Value(value="${socketio.host}")
    private String host;
    @Value(value="${socketio.port}")
    private Integer port;
    @Value(value="${socketio.bossCount}")
    private int bossCount;
    @Value(value="${socketio.workCount}")
    private int workCount;
    @Value(value="${socketio.allowCustomRequests}")
    private boolean allowCustomRequests;
    @Value(value="${socketio.upgradeTimeout}")
    private int upgradeTimeout;
    @Value(value="${socketio.pingTimeout}")
    private int pingTimeout;
    @Value(value="${socketio.pingInterval}")
    private int pingInterval;
    private String[] namespaces;

    @Bean
    public SocketIOServer socketIOServer() {
        SocketConfig socketConfig = new SocketConfig();
        socketConfig.setTcpNoDelay(true);
        socketConfig.setSoLinger(0);
        Configuration config = new Configuration();
        config.setSocketConfig(socketConfig);
        config.setContext("/els/getSocketIO");
        config.setHostname(this.host);
        config.setOrigin("*");
        config.setPort(this.port.intValue());
        config.setBossThreads(this.bossCount);
        config.setWorkerThreads(this.workCount);
        config.setAllowCustomRequests(this.allowCustomRequests);
        config.setUpgradeTimeout(this.upgradeTimeout);
        config.setPingTimeout(this.pingTimeout);
        config.setPingInterval(this.pingInterval);
        SocketIOServer server = new SocketIOServer(config);
        Optional.ofNullable(this.namespaces).ifPresent(nss -> Arrays.stream(nss).forEach(arg_0 -> ((SocketIOServer)server).addNamespace(arg_0)));
        return server;
    }

    @Bean
    public SpringAnnotationScanner springAnnotationScanner() {
        return new SpringAnnotationScanner(this.socketIOServer());
    }
}

