/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.inquiry.qualification.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.mapper.SaleBiddingHeadMapper;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.mapper.SaleEbiddingHeadMapper;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.mapper.SaleEnquiryHeadMapper;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.enumerate.ReviewStatusEnum;
import com.els.modules.inquiry.qualification.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.qualification.mapper.PurchaseQualificationReviewMapper;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.qualification.service.PurchaseQualificationReviewService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseQualificationReviewServiceImpl
extends BaseServiceImpl<PurchaseQualificationReviewMapper, PurchaseQualificationReview>
implements PurchaseQualificationReviewService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseQualificationReviewServiceImpl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleEnquiryHeadMapper saleEnquiryHeadMapper;
    @Resource
    private SaleEbiddingHeadMapper saleEbiddingHeadMapper;
    @Resource
    private SaleBiddingHeadMapper saleBiddingHeadMapper;

    @Override
    public void add(PurchaseQualificationReview review) {
        String reviewNumber = this.invokeBaseRpcService.getNextCode("qualificationReview", (Object)review, review.getElsAccount());
        review.setQuaReviewNumber(reviewNumber);
        review.setReviewStatus(ReviewStatusEnum.NEW.getValue());
        ((PurchaseQualificationReviewMapper)this.baseMapper).insert((Object)review);
    }

    @Override
    public void update(PurchaseQualificationReview review) {
        ((PurchaseQualificationReviewMapper)this.baseMapper).updateById((Object)review);
    }

    @Override
    @SrmTransaction
    public void review(PurchaseQualificationReview review) {
        PurchaseQualificationReview dbReview = (PurchaseQualificationReview)((Object)((PurchaseQualificationReviewMapper)this.baseMapper).selectById((Serializable)((Object)review.getId())));
        Assert.isTrue((boolean)ReviewStatusEnum.NEW.getValue().equals(dbReview.getReviewStatus()), (String)I18nUtil.translate((String)"i18n_alert_fail_documents_no_review_repeat", (String)"\u5df2\u7ecf\u5ba1\u67e5\u8fc7\u7684\u5355\u636e\uff0c\u4e0d\u53ef\u91cd\u590d\u5ba1\u67e5"));
        Assert.isTrue((boolean)dbReview.getReviewTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_fail_documents_reviewtime_timeout", (String)"\u8d44\u683c\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        dbReview.setReviewStatus(review.getReviewStatus());
        dbReview.setRemark(review.getRemark());
        ((PurchaseQualificationReviewMapper)this.baseMapper).updateById((Object)dbReview);
        if (ReviewStatusEnum.PASS.getValue().equals(review.getReviewStatus())) {
            PurchaseExecuteReviewService executeReviewService = SourceTypeEnum.getExecuteService(dbReview.getSourceType());
            executeReviewService.executeReview(dbReview);
        }
        this.sendMsg(dbReview);
    }

    private void sendMsg(PurchaseQualificationReview dbReview) {
        String businessType = null;
        String id = null;
        String bean = null;
        if (SourceTypeEnum.BIDDING.getValue().equals(dbReview.getSourceType())) {
            list = this.saleBiddingHeadMapper.selectByMainId(dbReview.getRelationId());
            List collect = list.stream().filter(x -> x.getElsAccount().equals(dbReview.getToElsAccount())).collect(Collectors.toList());
            id = !CollectionUtils.isEmpty(collect) ? ((SaleBiddingHead)((Object)collect.get(0))).getId() : dbReview.getRelationId();
            bean = "biddingBusDataServiceImpl";
            businessType = "bidding";
        } else if (SourceTypeEnum.EBIDDING.getValue().equals(dbReview.getSourceType())) {
            list = this.saleEbiddingHeadMapper.selectByMainId(dbReview.getRelationId());
            List collect = list.stream().filter(x -> x.getElsAccount().equals(dbReview.getToElsAccount())).collect(Collectors.toList());
            id = !CollectionUtils.isEmpty(collect) ? ((SaleEbiddingHead)((Object)collect.get(0))).getId() : dbReview.getRelationId();
            bean = "ebiddingBusDataServiceImpl";
            businessType = "ebidding";
        } else if (SourceTypeEnum.ENQUIRY.getValue().equals(dbReview.getSourceType())) {
            list = this.saleEnquiryHeadMapper.selectByMainId(dbReview.getRelationId());
            List collect = list.stream().filter(x -> x.getElsAccount().equals(dbReview.getToElsAccount())).collect(Collectors.toList());
            log.info("PurchaseQualificationReview->sendMsg:{}", (Object)JSONObject.toJSONString(collect));
            id = !CollectionUtils.isEmpty(collect) ? ((SaleEnquiryHead)((Object)collect.get(0))).getId() : dbReview.getRelationId();
            bean = "enquiryBusinessDataRpcService";
            businessType = "enquiry";
        }
        if (StringUtils.isNotBlank(businessType)) {
            String operateType = ReviewStatusEnum.PASS.getValue().equals(dbReview.getReviewStatus()) ? "pass" : "refund";
            super.sendMessage(TenantContext.getTenant(), businessType, operateType, id, bean, Collections.singletonList(dbReview.getToElsAccount()));
        }
    }

    @Override
    public List<PurchaseQualificationReview> selectByMainId(String id) {
        return ((PurchaseQualificationReviewMapper)this.baseMapper).selectByMainId(id);
    }
}

