/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.utils;

import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TenderBaseCommonUtils {
    private static final Logger log = LoggerFactory.getLogger(TenderBaseCommonUtils.class);
    private static String ADVANCE = "pre";
    private static String RESULT = "result";

    private TenderBaseCommonUtils() {
    }

    private static String getMethodName(String prefix, String fileName) {
        Object methodPrefix = "";
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        methodPrefix = SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType) ? ADVANCE + TenderBaseCommonUtils.captureName(fileName) : (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep) ? TenderBaseCommonUtils.captureName(fileName) : RESULT + TenderBaseCommonUtils.captureName(fileName));
        return prefix + TenderBaseCommonUtils.captureName((String)methodPrefix);
    }

    private static String getfieldName(String fileName) {
        Object methodPrefix = "";
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        methodPrefix = SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType) ? ADVANCE + TenderBaseCommonUtils.captureName(fileName) : (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep) ? fileName : RESULT + TenderBaseCommonUtils.captureName(fileName));
        return methodPrefix;
    }

    private static Object executeMethod(Object obj, Object value, String methodName, String fileName) {
        log.info("executeMethod,methodName:{},fileName:{},value:{}", new Object[]{methodName, fileName, value});
        Class<?> aClass = obj.getClass();
        try {
            aClass = TenderBaseCommonUtils.getDeclaredField(aClass, fileName);
            Field declaredField = aClass.getDeclaredField(fileName);
            Class<?> paramsType = declaredField.getType();
            if (value == null) {
                Method declaredMethod = aClass.getDeclaredMethod(methodName, new Class[0]);
                return declaredMethod.invoke(obj, new Object[0]);
            }
            Method declaredMethod = aClass.getDeclaredMethod(methodName, paramsType);
            return declaredMethod.invoke(obj, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private static Class<?> getDeclaredField(Class<?> aClass, String fileName) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = aClass.getDeclaredFields()) {
            String name = declaredField.getName();
            if (!name.equals(fileName)) continue;
            return aClass;
        }
        return TenderBaseCommonUtils.getDeclaredField(aClass.getSuperclass(), fileName);
    }

    private static String captureName(String name) {
        name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        return name;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value, boolean appendPrefixName) {
        Object methodName = "set" + TenderBaseCommonUtils.captureName(fieldName);
        String name = fieldName;
        if (appendPrefixName) {
            methodName = TenderBaseCommonUtils.getMethodName("set", fieldName);
            name = TenderBaseCommonUtils.getfieldName(fieldName);
        }
        TenderBaseCommonUtils.executeMethod(obj, value, (String)methodName, name);
    }

    public static Object getFieldValue(Object obj, String fieldName, boolean appendPrefixName) {
        Object methodName = "get" + TenderBaseCommonUtils.captureName(fieldName);
        String name = fieldName;
        if (appendPrefixName) {
            methodName = TenderBaseCommonUtils.getMethodName("get", fieldName);
            name = TenderBaseCommonUtils.getfieldName(fieldName);
        }
        return TenderBaseCommonUtils.executeMethod(obj, null, (String)methodName, name);
    }
}

