/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetterFormatGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPriceRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatQuoteTypeEnum;
import com.els.modules.tender.attachment.enumerate.PriceRegulationInfoRankingRulesEnum;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterFormatGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationPrinciplesService;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.mapper.PurchaseTenderProjectBidEvaRegulationResultMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultService;
import com.els.modules.tender.evaluation.strategy.review.SummaryStrategy;
import com.els.modules.tender.evaluation.vo.SupplierEvaRankingVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectBidEvaRegulationResultServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectBidEvaRegulationResultMapper, PurchaseTenderProjectBidEvaRegulationResult>
implements PurchaseTenderProjectBidEvaRegulationResultService {
    @Autowired
    private PurchaseTenderEvaluationGroupService evaluationGroupService;
    @Autowired
    private PurchaseTenderEvaluationPrinciplesService principlesService;
    @Autowired
    @Lazy
    private PurchaseTenderBidLetterFormatGroupService bidLetterFormatGroupService;

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResult> selectBySubpackageId(String subpackageId, String evaGroupId) {
        return ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).selectBySubpackageId(subpackageId, evaGroupId);
    }

    @Override
    public void deleteByGroupIdAndJudgesAccount(String evaGroupId, String judgesElsAccount, String judgesElsSubAccount) {
        ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).deleteByGroupIdAndJudgesAccount(evaGroupId, judgesElsAccount, judgesElsSubAccount);
    }

    @Override
    public void deleteByMainId(String evaGroupId, String judgesTaskItemId) {
        ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).deleteByMainId(evaGroupId, judgesTaskItemId);
    }

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResult> selectByMainId(String judgesTaskItemId, String evaGroupId) {
        return ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).selectByMainId(judgesTaskItemId, evaGroupId);
    }

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResult> querySupplierByEvaGroupId(String supplierAccount, String evaGroupId, String evaInfoId) {
        return ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).querySupplierByEvaGroupId(supplierAccount, evaGroupId, evaInfoId);
    }

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResult> summaryEvaRegulationResult(String evaInfoId, String evaGroupId) {
        ArrayList<PurchaseTenderProjectBidEvaRegulationResult> result = new ArrayList<PurchaseTenderProjectBidEvaRegulationResult>();
        List<SupplierEvaRankingVO> summaryEvaResultList = this.summaryEvaResult(evaInfoId, evaGroupId);
        for (SupplierEvaRankingVO supplierEvaRankingVO : summaryEvaResultList) {
            SupplierEvaRankingVO.EvaGroupSummaryResult evaGroupSummaryResult = supplierEvaRankingVO.getResult().get(evaGroupId);
            List<PurchaseTenderProjectBidEvaRegulationResult> summaryRegulationResultList = evaGroupSummaryResult.getSummaryRegulationResultList();
            result.addAll(summaryRegulationResultList);
        }
        return result;
    }

    @Override
    public List<SupplierEvaRankingVO> summaryEvaResult(String evaInfoId, String evaGroupId) {
        List<SupplierEvaRankingVO> result = new ArrayList<SupplierEvaRankingVO>();
        PurchaseTenderEvaluationGroupVO evaluationGroup = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(evaGroupId);
        List<PurchaseTenderBidLetterFormatGroup> purchaseTenderBidLetterFormatGroupList = this.bidLetterFormatGroupService.selectByMainId(evaluationGroup.getHeadId());
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = purchaseTenderBidLetterFormatGroupList.get(0);
        Assert.isTrue((evaluationGroup != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_TvVVHLVWVImW_4c384209", (String)"\u6761\u4f8b\u7ec4\u4fe1\u606f\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!"));
        PurchaseTenderEvaluationPrinciples purchaseTenderEvaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroup.getHeadId());
        List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = this.selectByEvaInfoId(evaInfoId, evaGroupId);
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> supplierAccountMap = regulationResultList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
        for (String supplierAccount : supplierAccountMap.keySet()) {
            List<PurchaseTenderProjectBidEvaRegulationResult> supplierAllRegulationResultList = supplierAccountMap.get(supplierAccount);
            SupplierEvaRankingVO supplierEvaRankingVO = new SupplierEvaRankingVO();
            BeanUtils.copyProperties((Object)((Object)supplierAllRegulationResultList.get(0)), (Object)supplierEvaRankingVO);
            SummaryStrategy summaryStrategy = (SummaryStrategy)SpringContextUtils.getBean((String)TenderEvaGroupTypeEnum.getTenderEvaGroupTypeEnum(evaluationGroup.getGroupType()).getBeanName(), SummaryStrategy.class);
            SupplierEvaRankingVO.EvaGroupSummaryResult summaryResult = summaryStrategy.summaryResult(bidLetterFormatGroup, evaluationGroup, purchaseTenderEvaluationPrinciples, supplierAllRegulationResultList);
            supplierEvaRankingVO.setGroupOrder(evaluationGroup.getOrderBy());
            supplierEvaRankingVO.setResultMap(evaGroupId, summaryResult);
            Map<String, SupplierEvaRankingVO.EvaGroupSummaryResult> groupResultMap = supplierEvaRankingVO.getResult();
            BigDecimal totalScore = BigDecimal.ZERO;
            BigDecimal totalQuote = BigDecimal.ZERO;
            BigDecimal weightScore = BigDecimal.ZERO;
            for (String key : groupResultMap.keySet()) {
                SupplierEvaRankingVO.EvaGroupSummaryResult summaryResultTemp = groupResultMap.get(key);
                supplierEvaRankingVO.setInvalid(summaryResultTemp.getInvalid());
                if ("1".equals(summaryResultTemp.getInvalid())) break;
                totalQuote = totalQuote.add(summaryResultTemp.getTotalQuote() == null ? BigDecimal.ZERO : summaryResultTemp.getTotalQuote());
                totalScore = totalScore.add(summaryResultTemp.getTotalScore() == null ? BigDecimal.ZERO : summaryResultTemp.getTotalScore());
                weightScore = weightScore.add(summaryResultTemp.getWeightScore() == null ? BigDecimal.ZERO : summaryResultTemp.getWeightScore());
            }
            supplierEvaRankingVO.setTotalScore(totalScore);
            supplierEvaRankingVO.setTotalQuote(totalQuote);
            supplierEvaRankingVO.setWeightScore(weightScore);
            result.add(supplierEvaRankingVO);
        }
        if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(bidLetterFormatGroup.getQuoteType()) && TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue().equals(evaluationGroup.getGroupType())) {
            PurchaseTenderEvaluationPriceRegulationInfo regulationInfo = evaluationGroup.getTenderEvaluationTemplatePriceRegulationInfo();
            String rankingRules = regulationInfo.getRankingRules();
            result = PriceRegulationInfoRankingRulesEnum.QUOTES_SORT_FROM_LOW_TO_HIGH.getValue().equals(rankingRules) ? result.stream().sorted(Comparator.comparing(SupplierEvaRankingVO::getTotalQuote)).collect(Collectors.toList()) : result.stream().sorted(Comparator.comparing(SupplierEvaRankingVO::getTotalQuote).reversed()).collect(Collectors.toList());
            int order = 1;
            if (!result.isEmpty()) {
                LinkedHashMap<Double, Integer> orderByMap = new LinkedHashMap<Double, Integer>();
                for (SupplierEvaRankingVO supplierEvaRankingVO : result) {
                    BigDecimal totalQuote = supplierEvaRankingVO.getTotalQuote();
                    Integer index = (Integer)orderByMap.get(totalQuote.doubleValue());
                    if (index == null) {
                        index = order;
                    }
                    SupplierEvaRankingVO.EvaGroupSummaryResult evaGroupSummaryResult = supplierEvaRankingVO.getResult().get(evaGroupId);
                    evaGroupSummaryResult.setOrderBy(index);
                    orderByMap.put(totalQuote.doubleValue(), index);
                    index = index + 1;
                    order = index;
                }
            }
        }
        return result;
    }

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResult> selectByEvaInfoId(String evaInfoId, String evaGroupId) {
        return ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).selectByEvaInfoId(evaInfoId, evaGroupId);
    }

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResult> selectByEvaInfoIdList(List<String> evaInfoIdList, String evaGroupId) {
        return ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).selectByEvaInfoIdList(evaInfoIdList, evaGroupId);
    }
}

