/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.poi.excel.ExcelWriter;
import cn.hutool.poi.excel.style.StyleUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.PurchaseEnquirySumExcelService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeAccountRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.supplier.api.dto.SupplierContactsInfoDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEnquirySumExcelServiceImpl
implements PurchaseEnquirySumExcelService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEnquirySumExcelServiceImpl.class);
    @Resource
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Resource
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Resource
    private InquiryInvokeAccountRpcService inquiryInvokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void exportExcel(String id, HttpServletResponse response) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)id)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())));
        List<PurchaseEnquiryItem> dbItemList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        Map<String, List<PurchaseEnquiryItem>> enquiryItemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItem::getToElsAccount));
        ArrayList toElsAccountList = Lists.newArrayList(enquiryItemMap.keySet());
        List<SupplierMasterDataDTO> supplierMasterDataList = this.inquiryInvokeSupplierRpcService.selectSupplerList(TenantContext.getTenant(), toElsAccountList);
        Map supplierMap = supplierMasterDataList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (oldVal, newVal) -> newVal));
        List<ElsEnterpriseInfoDTO> enterpriseList = this.inquiryInvokeAccountRpcService.selectWithoutElsAccountByElsAccountList(toElsAccountList);
        Map enterpriseMap = enterpriseList.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, Function.identity(), (oldVal, newVal) -> newVal));
        List dictList = this.invokeBaseRpcService.queryDictItemsByCode("paymentMethod", dbHead.getElsAccount());
        Map<String, String> dictMap = dictList.stream().collect(Collectors.toMap(DictDTO::getValue, DictDTO::getText, (oldVal, newVal) -> newVal));
        int supplierCount = toElsAccountList.size();
        ExcelWriter writer = new ExcelWriter(true, dbHead.getEnquiryNumber());
        writer.merge(0, 0, 0, supplierCount + 1, (Object)"                          (\u4f01\u4f01\u901a\u25a1\u975e\u4f01\u4f01\u901a\u25a1)\u62db\u6807\u6c47\u603b\u5355(\u8868\u4e8c)", false);
        String today = DateUtil.format((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5");
        CellStyle cellStyle = StyleUtil.createDefaultCellStyle((Workbook)writer.getWorkbook());
        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        writer.merge(1, 1, 0, supplierCount + 1, (Object)("\u5236\u8868\u65e5\u671f\uff1a" + today), cellStyle);
        writer.merge(2, 2, 0, 1, (Object)"\u4f9b\u8d27\u5355\u4f4d", false);
        writer.merge(3, 3, 0, 1, (Object)"\u5b9e\u7f34\u8d44\u672c", false);
        writer.merge(4, 4, 0, 1, (Object)"\u4f01\u4e1a\u5730\u5740", false);
        writer.merge(5, 5, 0, 1, (Object)"\u8054\u7cfb\u4eba", false);
        writer.merge(6, 6, 0, 1, (Object)"\u8054\u7cfb\u7535\u8bdd", false);
        writer.merge(7, 7, 0, 1, (Object)"\u751f\u4ea7\u5236\u9020\u8d44\u8d28", false);
        writer.merge(8, 8, 0, 1, (Object)"\u4ea4\u8d27\u5730\u70b9", false);
        writer.merge(9, 9, 0, 1, (Object)"\u4ea4\u8d27\u671f", false);
        writer.merge(10, 10, 0, 1, (Object)"\u4ed8\u6b3e\u65b9\u5f0f", false);
        writer.merge(11, 11, 0, 1, (Object)"\u62db\u6807\u9879\u76ee", false);
        writer.merge(12, 12, 0, 1, (Object)"\u62db\u6807\u6570\u91cf", false);
        writer.merge(13, 13, 0, 1, (Object)"\u62a5\u4ef7(\u5143)", false);
        writer.merge(14, 14, 0, 1, (Object)"\u6700\u7ec8\u4ef7(\u5143)", false);
        writer.merge(15, 15, 0, 1, (Object)"\u6295\u6807\u5c65\u7ea6\u4fdd\u8bc1\u91d1", false);
        writer.merge(16, 16, 0, 1, (Object)"\u5408\u683c\u4f9b\u5e94\u5546\uff08\u8bc4\u7ea7\uff09", false);
        writer.merge(17, 17, 0, 1, (Object)"\u4e1a\u7ee9\u60c5\u51b5", false);
        writer.merge(18, 18, 0, 1, (Object)"\u8d28\u91cf\u60c5\u51b5\u7b49\u7ea7", false);
        writer.merge(19, 19, 0, 1, (Object)"\u8d22\u52a1\u90e8\u786e\u8ba4", false);
        writer.merge(20, 20, 0, 1, (Object)"\u8003\u5bdf\u4eba", false);
        writer.merge(21, 21, 0, 1, (Object)"\u4ea7\u5730", false);
        writer.merge(22, 22, 0, 1, (Object)"\u4f01\u67e5\u67e5", false);
        writer.merge(23, 24, 0, 0, (Object)"\u4ee5\u524d\u4e2d\u6807\u60c5\u51b5", false);
        writer.writeCellValue(1, 23, (Object)"\u4e2d\u6807\u6b21\u6570(\u6b21)");
        writer.writeCellValue(1, 24, (Object)"\u4e2d\u6807\u91d1\u989d(\u4e07\u5143)");
        writer.merge(25, 25, 0, 1, (Object)"\u5907\u6ce8(\u4e0e\u6211\u53f8\u89c4\u8303\u7684\u533a\u522b)\uff1a", false);
        writer.merge(26, 26, 0, 1, (Object)"\u4e0a\u6b21\u91c7\u8d2d\u5355\u4f4d\u53ca\u4ef7\u683c", false);
        writer.merge(27, 27, 0, 1, (Object)"\u63a5\u6536\u8ba1\u5212\u65f6\u95f4\u4e0e\u91c7\u8d2d\u7406\u7531", false);
        writer.merge(28, 28, 0, 1, (Object)"\u8bc4\u6807\u4eba\u5458\u5ba1\u6838\uff1a", false);
        writer.merge(29, 29, 0, 1, (Object)"\u5efa\u8bae\u4e2d\u6807\u5355\u4f4d", false);
        writer.merge(30, 30, 0, 1, (Object)"\u4e2d\u6807\u4ef7\u683c", false);
        writer.merge(31, 31, 0, 1, (Object)"\u7ecf\u8425\u526f\u603b\u5ba1\u6838\uff1a", false);
        writer.merge(32, 32, 0, 1, (Object)"\u603b\u7ecf\u7406\u5ba1\u6279\uff1a", false);
        if (supplierCount > 1) {
            writer.merge(26, 26, 2, supplierCount + 1, (Object)"", false);
            writer.merge(27, 27, 2, supplierCount + 1, (Object)"", false);
            writer.merge(28, 28, 2, supplierCount + 1, (Object)"", false);
            writer.merge(29, 29, 2, supplierCount + 1, (Object)"", false);
            writer.merge(30, 30, 2, supplierCount + 1, (Object)"", false);
            writer.merge(31, 31, 2, supplierCount + 1, (Object)"", false);
            writer.merge(32, 32, 2, supplierCount + 1, (Object)"", false);
        } else {
            writer.writeCellValue(2, 26, (Object)"");
            writer.writeCellValue(2, 27, (Object)"");
            writer.writeCellValue(2, 28, (Object)"");
            writer.writeCellValue(2, 29, (Object)"");
            writer.writeCellValue(2, 30, (Object)"");
            writer.writeCellValue(2, 31, (Object)"");
            writer.writeCellValue(2, 32, (Object)"");
        }
        int x = 2;
        boolean flag = true;
        CellStyle enterCellStyle = StyleUtil.createDefaultCellStyle((Workbook)writer.getWorkbook());
        enterCellStyle.setWrapText(true);
        for (String toElsAccount : toElsAccountList) {
            List<PurchaseEnquiryItem> itemList = enquiryItemMap.get(toElsAccount);
            SupplierMasterDataDTO masterData = (SupplierMasterDataDTO)supplierMap.get(toElsAccount);
            ElsEnterpriseInfoDTO enterpriseInfo = (ElsEnterpriseInfoDTO)enterpriseMap.get(toElsAccount);
            writer.writeCellValue(x, 2, (Object)masterData.getSupplierName());
            writer.writeCellValue(x, 3, (Object)enterpriseInfo.getActualCapital());
            writer.writeCellValue(x, 4, (Object)enterpriseInfo.getRegLocation());
            List<SupplierContactsInfoDTO> contactsInfoList = this.inquiryInvokeSupplierRpcService.selectByMainId(masterData.getId());
            writer.writeCellValue(x, 5, (Object)(contactsInfoList.isEmpty() ? "" : contactsInfoList.get(0).getName()));
            writer.writeCellValue(x, 6, (Object)(contactsInfoList.isEmpty() ? "" : contactsInfoList.get(0).getTelphone()));
            writer.writeCellValue(x, 7, (Object)"");
            writer.writeCellValue(x, 8, (Object)"");
            Date deliveryDate = itemList.get(0).getDeliveryDate();
            writer.writeCellValue(x, 9, (Object)DateUtil.formatDate((Date)deliveryDate));
            writer.writeCellValue(x, 10, (Object)dictMap.get(dbHead.getFbk18()));
            if (flag) {
                BigDecimal quantity = itemList.stream().filter(item -> item.getRequireQuantity() != null).map(PurchaseEnquiryItem::getRequireQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                String content = dbHead.getEnquiryDesc() + "\r\n" + quantity.toPlainString();
                writer.merge(11, 12, 2, supplierCount + 1, (Object)content, enterCellStyle);
                flag = false;
            }
            BigDecimal amount = itemList.stream().filter(item -> item.getTaxAmount() != null).map(PurchaseEnquiryItem::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            writer.writeCellValue(x, 13, (Object)amount);
            writer.writeCellValue(x, 14, (Object)"");
            writer.writeCellValue(x, 15, (Object)"");
            writer.writeCellValue(x, 16, (Object)"");
            writer.writeCellValue(x, 17, (Object)"");
            writer.writeCellValue(x, 18, (Object)"");
            writer.writeCellValue(x, 19, (Object)"");
            writer.writeCellValue(x, 20, (Object)"");
            writer.writeCellValue(x, 21, (Object)"");
            writer.writeCellValue(x, 22, (Object)"");
            writer.writeCellValue(x, 23, (Object)"");
            writer.writeCellValue(x, 24, (Object)"");
            writer.writeCellValue(x, 25, (Object)"");
            ++x;
        }
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u8be2\u4ef7\u6c47\u603b\u62a5\u8868.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }
}

