/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.forecast.entity.PurchaseForecastWeekItem;
import com.els.modules.forecast.mapper.PurchaseForecastWeekItemMapper;
import com.els.modules.forecast.service.PurchaseForecastWeekItemService;
import com.els.modules.forecast.vo.ReportVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseForecastWeekItemServiceImpl
extends BaseServiceImpl<PurchaseForecastWeekItemMapper, PurchaseForecastWeekItem>
implements PurchaseForecastWeekItemService {
    private BigDecimal onehundred = BigDecimal.valueOf(100L);

    @Override
    public List<PurchaseForecastWeekItem> selectByMainId(String mainId) {
        return ((PurchaseForecastWeekItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseForecastWeekItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public JSONArray getReportData(List<String> headIdList, Map<String, String> headMap, ReportVO vo) {
        JSONArray result = new JSONArray();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(PurchaseForecastWeekItem::getMaterialNumber, (Object)vo.getMaterialNumber())).in(PurchaseForecastWeekItem::getHeadId, headIdList);
        if (StrUtil.isNotBlank((CharSequence)vo.getFactory())) {
            queryWrapper.eq(PurchaseForecastWeekItem::getFactory, (Object)vo.getFactory());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getToElsAccount())) {
            queryWrapper.eq(PurchaseForecastWeekItem::getToElsAccount, (Object)vo.getToElsAccount());
        }
        List dbList = ((PurchaseForecastWeekItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        Assert.notEmpty((Collection)dbList, (String)I18nUtil.translate((String)"i18n_field_APTIIWPSTVUicVH_413e42c3", (String)"\u5f53\u524d\u6761\u4ef6\u4e0b\uff0c\u6682\u65e0\u9700\u6c42\u9884\u6d4b\u884c\u4fe1\u606f"));
        Map<String, List<PurchaseForecastWeekItem>> groupMap = dbList.stream().collect(Collectors.groupingBy(PurchaseForecastWeekItem::getHeadId));
        for (Map.Entry<String, List<PurchaseForecastWeekItem>> entry : groupMap.entrySet()) {
            String headId = entry.getKey();
            JSONObject object = new JSONObject();
            object.put("id", (Object)headId);
            object.put("key", (Object)headMap.get(headId));
            BigDecimal requireQuantity = this.getRequireQuantity(vo, entry.getValue());
            object.put("value", (Object)requireQuantity);
            result.add((Object)object);
        }
        return result;
    }

    private BigDecimal getRequireQuantity(ReportVO vo, List<PurchaseForecastWeekItem> sameDateList) {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal beginWeek = BigDecimal.valueOf(vo.getBeginYear().intValue()).add(BigDecimal.valueOf(vo.getBeginWeek().intValue()).divide(this.onehundred, 2, 4));
        BigDecimal endWeek = BigDecimal.valueOf(vo.getEndYear().intValue()).add(BigDecimal.valueOf(vo.getEndWeek().intValue()).divide(this.onehundred, 2, 4));
        for (PurchaseForecastWeekItem item : sameDateList) {
            JSONObject weekJson = StrUtil.isBlank((CharSequence)item.getRequireWeekJson()) ? new JSONObject() : JSONObject.parseObject((String)item.getRequireWeekJson());
            for (String key : weekJson.keySet()) {
                String[] keys = key.split("_");
                BigDecimal week = new BigDecimal(keys[0]).add(new BigDecimal(keys[1]).divide(this.onehundred, 2, 4));
                if (week.compareTo(beginWeek) < 0 || week.compareTo(endWeek) > 0) continue;
                result = result.add(weekJson.getBigDecimal(key));
            }
        }
        return result;
    }
}

