/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.lp.utils;

import java.text.DecimalFormat;
import lpsolve.LpSolve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LpOptimator {
    private static final Logger log = LoggerFactory.getLogger(LpOptimator.class);
    private static LpSolve problem;

    public static void optimate(int[] goal, int[][] stIeMatrix, int[][] stGeMatrix, int[][] stEqMatrix, int[] stIeRest, int[] stGeRest, int[] stEqRest, int[] ups) throws Exception {
        int j;
        Object constraint;
        int i;
        int j2;
        int k;
        int i2;
        System.out.println("----------------------LE CONSTRACTION-----------------------------------");
        for (i2 = 0; i2 < stIeMatrix.length; ++i2) {
            System.out.println("---------------------------------------------------------");
            k = 1;
            for (j2 = 0; j2 < stIeMatrix[i2].length; ++j2) {
                System.out.print(stIeMatrix[i2][j2] + " ");
                if (k % 25 == 0) {
                    System.out.println("");
                }
                ++k;
            }
            System.out.println("------RESULT:-------" + stIeRest[i2] + "--------------------------------------------");
        }
        System.out.println("------------------------END CONSTRACTION---------------------------------");
        System.out.println("------------------------EQ CONSTRACTION---------------------------------");
        for (i2 = 0; i2 < stEqMatrix.length; ++i2) {
            System.out.println("---------------------------------------------------------");
            k = 1;
            for (j2 = 0; j2 < stEqMatrix[i2].length; ++j2) {
                System.out.print(stEqMatrix[i2][j2] + " ");
                if (k % 25 == 0) {
                    System.out.println("");
                }
                ++k;
            }
            System.out.println("------RESULT:-------" + stEqRest[i2] + "--------------------------------------------");
        }
        System.out.println("------------------------END CONSTRACTION---------------------------------");
        System.out.println("------------------------PRINT GOAL---------------------------------");
        for (i2 = 0; i2 < goal.length; ++i2) {
            System.out.print(goal[i2] + " ");
            if ((i2 + 1) % 25 != 0) continue;
            System.out.println("");
        }
        String path = System.getProperty("java.library.path");
        log.error("java libery path:" + path);
        int constraintCount = 0;
        if (stIeMatrix != null) {
            constraintCount += stIeMatrix.length;
        }
        if (stGeMatrix != null) {
            constraintCount += stGeMatrix.length;
        }
        if (stEqMatrix != null) {
            constraintCount += stEqMatrix.length;
        }
        problem = LpSolve.makeLp((int)constraintCount, (int)goal.length);
        Object objFn = "";
        for (i = 0; i < goal.length; ++i) {
            objFn = (String)objFn + goal[i];
            if (i == goal.length - 1) continue;
            objFn = (String)objFn + " ";
        }
        problem.strSetObjFn((String)objFn);
        if (stIeMatrix != null) {
            for (i = 0; i < stIeMatrix.length; ++i) {
                constraint = "";
                for (j = 0; j < stIeMatrix[i].length; ++j) {
                    constraint = (String)constraint + stIeMatrix[i][j];
                    if (j == stIeMatrix[i].length - 1) continue;
                    constraint = (String)constraint + " ";
                }
                problem.strAddConstraint((String)constraint, 1, (double)stIeRest[i]);
            }
        }
        if (stGeMatrix != null) {
            for (i = 0; i < stGeMatrix.length; ++i) {
                constraint = "";
                for (j = 0; j < stGeMatrix[i].length; ++j) {
                    constraint = (String)constraint + stGeMatrix[i][j];
                    if (j == stGeMatrix[i].length - 1) continue;
                    constraint = (String)constraint + " ";
                }
                problem.strAddConstraint((String)constraint, 2, (double)stGeRest[i]);
            }
        }
        if (stEqMatrix != null) {
            for (i = 0; i < stEqMatrix.length; ++i) {
                constraint = "";
                for (j = 0; j < stEqMatrix[i].length; ++j) {
                    constraint = (String)constraint + stEqMatrix[i][j];
                    if (j == stEqMatrix[i].length - 1) continue;
                    constraint = (String)constraint + " ";
                }
                problem.strAddConstraint((String)constraint, 3, (double)stEqRest[i]);
            }
        }
        for (i = 1; i <= goal.length; ++i) {
            problem.setInt(i, true);
        }
        for (i = 1; i <= ups.length; ++i) {
            problem.setUpbo(i, (double)ups[i - 1]);
        }
        problem.solve();
    }

    public static String getObjective() throws Exception {
        if (problem != null) {
            DecimalFormat df = new DecimalFormat("###############0.00#");
            String result = df.format(problem.getObjective());
            return result;
        }
        try {
            throw new Exception("\u8fd8\u6ca1\u6709\u8fdb\u884c\u6c42\u89e3\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "0";
        }
    }

    public static double getInfinite() throws Exception {
        if (problem != null) {
            return problem.getInfinite();
        }
        try {
            throw new Exception("\u8fd8\u6ca1\u6709\u8fdb\u884c\u6c42\u89e3\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0.0;
        }
    }

    public static int getSolutioncount() throws Exception {
        if (problem != null) {
            return problem.getSolutioncount();
        }
        try {
            throw new Exception("\u8fd8\u6ca1\u6709\u8fdb\u884c\u6c42\u89e3\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public static int getScaling() throws Exception {
        if (problem != null) {
            return problem.getScaling();
        }
        try {
            throw new Exception("\u8fd8\u6ca1\u6709\u8fdb\u884c\u6c42\u89e3\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public static long getTimeout() throws Exception {
        if (problem != null) {
            return problem.getTimeout();
        }
        try {
            throw new Exception("\u8fd8\u6ca1\u6709\u8fdb\u884c\u6c42\u89e3\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static double[] getVariables() throws Exception {
        if (problem != null) {
            return problem.getPtrVariables();
        }
        try {
            throw new Exception("\u8fd8\u6ca1\u6709\u8fdb\u884c\u6c42\u89e3\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(24);
    }
}

