/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.modules.logisticspurchase.base.entity.LineFile;
import com.els.modules.logisticspurchase.base.enumerate.StatusEnum;
import com.els.modules.logisticspurchase.base.mapper.LineFileMapper;
import com.els.modules.logisticspurchase.base.service.LineFileService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LineFileServiceImpl
extends BaseServiceImpl<LineFileMapper, LineFile>
implements LineFileService {
    @Autowired
    private InvokeBaseRpcService baseRpcService;

    @Override
    public void saveLineFile(LineFile lineFile) {
        if (StringUtils.isBlank((CharSequence)lineFile.getLineNumber())) {
            lineFile.setLineNumber(this.baseRpcService.getNextCode("srmLineNumber", (Object)lineFile));
        }
        lineFile.setDeleted(CommonConstant.DEL_FLAG_0);
        ((LineFileMapper)this.baseMapper).insert((Object)lineFile);
    }

    private void check(LineFile lineFile) {
        if (StrUtil.isBlank((CharSequence)lineFile.getCenterPoint())) {
            lineFile.setCenterPoint("0");
        }
        Assert.isNotBlank((String)lineFile.getLineType(), (String)I18nUtil.translate((String)"i18n_field_WHAcxOLV_e8881190", (String)"\u7ebf\u8def\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isNotBlank((String)lineFile.getStartNumber(), (String)I18nUtil.translate((String)"i18n_field_AKnAoxOLV_be687b7", (String)"\u8d77\u59cb\u5730\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isNotBlank((String)lineFile.getArriveNumber(), (String)I18nUtil.translate((String)"i18n_field_InnAoxOLV_845edb55", (String)"\u76ee\u7684\u5730\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isNotNull((Object)lineFile.getKilometre(), (String)I18nUtil.translate((String)"i18n_field_RvWxOLV_af886fa0", (String)"\u516c\u91cc\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
    }

    @Override
    public void updateLineFile(LineFile lineFile) {
        ((LineFileMapper)this.baseMapper).updateById((Object)lineFile);
    }

    @Override
    public void delLineFile(String id) {
        ((LineFileMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchLineFile(List<String> idList) {
        ((LineFileMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void frozenLineFile(String id) {
        LineFile lineFile = new LineFile();
        lineFile.setId(id);
        lineFile.setStatus(StatusEnum.FROZEN.getValue());
        int count = ((LineFileMapper)this.baseMapper).updateById((Object)lineFile);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void thawLineFile(String id) {
        LineFile lineFile = new LineFile();
        lineFile.setId(id);
        lineFile.setStatus(StatusEnum.EFFECTIVE.getValue());
        int count = ((LineFileMapper)this.baseMapper).updateById((Object)lineFile);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }
}

