/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.job.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.inquiry.rpc.service.InquriyInvokeJobRpcService;
import com.els.modules.job.api.dto.QuartzJobDTO;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingHeadLp;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LpEbiddingJobUtil {
    private static final Logger log = LoggerFactory.getLogger(LpEbiddingJobUtil.class);
    private static InquriyInvokeJobRpcService inquriyInvokeJobRpcService = (InquriyInvokeJobRpcService)SpringContextUtils.getBean(InquriyInvokeJobRpcService.class);
    private static final String BIDDING_START_JOB = "logisticsPurchaseEbiddingBeginJobBeanServiceImpl";
    private static final String BIDDING_FAILED_JOB = "logisticsPurchaseEbiddingFailedJobServiceImpl";
    private static final String BIDDING_END_JOB = "logisticsPurchaseEbiddingEndJobServiceImpl";
    private static final String BIDDING_DUTCH_QUOTE_JOB = "logisticsPurchaseEbiddingDutchQuoteJobServiceImpl";

    private static void createJob(PurchaseEbiddingHeadLp purchaseHead, Date time, String jobName) {
        String elsAccount = TenantContext.getTenant();
        String cron = DateUtils.formatDate((Date)time, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        if (BIDDING_DUTCH_QUOTE_JOB.equals(jobName)) {
            job.setJobNameKey(jobName + "_" + purchaseHead.getEbiddingNumber() + "_" + purchaseHead.getElsAccount());
        } else {
            job.setJobNameKey(jobName + "_" + purchaseHead.getEbiddingNumber() + "_" + elsAccount);
        }
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)purchaseHead.getId());
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)elsAccount);
        paramObj.put("jobImplName", (Object)jobName);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        try {
            inquriyInvokeJobRpcService.createJob(job);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static void createStartJob(PurchaseEbiddingHeadLp purchaseHead, Date time) {
        LpEbiddingJobUtil.createJob(purchaseHead, time, BIDDING_START_JOB);
    }

    public static void createFailedJob(PurchaseEbiddingHeadLp purchaseHead, Date time) {
        LpEbiddingJobUtil.createJob(purchaseHead, time, BIDDING_FAILED_JOB);
    }

    public static void createEndJob(PurchaseEbiddingHeadLp purchaseHead, Date time) {
        Date addTime = LpEbiddingJobUtil.getAddTime(time);
        LpEbiddingJobUtil.createJob(purchaseHead, addTime, BIDDING_END_JOB);
    }

    public static void createDutchQuoteJob(PurchaseEbiddingHeadLp purchaseHead, Date endTime) {
        DateTime addTime = DateUtil.offsetSecond((Date)endTime, (int)10);
        LpEbiddingJobUtil.createJob(purchaseHead, (Date)addTime, BIDDING_DUTCH_QUOTE_JOB);
    }

    public static void updateEndJob(SaleEbiddingHeadLp dbSaleHead, Date endTime) {
        Date addTime = LpEbiddingJobUtil.getAddTime(endTime);
        String elsAccount = dbSaleHead.getToElsAccount();
        String cron = DateUtils.formatDate((Date)addTime, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey("logisticsPurchaseEbiddingEndJobServiceImpl_" + dbSaleHead.getEbiddingNumber() + "_" + elsAccount);
        try {
            List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(job.getJobNameKey());
            if (!jobList.isEmpty()) {
                job.setId(jobList.get(0).getId());
                job.setParameter(jobList.get(0).getParameter());
            }
            inquriyInvokeJobRpcService.updateJob(job);
        }
        catch (Exception e) {
            throw new ELSBootException((Throwable)e);
        }
    }

    public static void deleteDutchQuoteJob(PurchaseEbiddingHeadLp purchaseHead) {
        String jobKey = "logisticsPurchaseEbiddingDutchQuoteJobServiceImpl_" + purchaseHead.getEbiddingNumber() + "_" + purchaseHead.getElsAccount();
        LpEbiddingJobUtil.deleteJob(jobKey);
    }

    public static void deleteJob(String jobKey) {
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobKey);
        if (!jobList.isEmpty()) {
            inquriyInvokeJobRpcService.deleteJob(jobList.get(0));
        }
        LpEbiddingJobUtil.physicallyDeleteJob(jobKey);
    }

    private static void physicallyDeleteJob(String jobKey) {
        inquriyInvokeJobRpcService.deleteByJobNameKey(jobKey);
    }

    public static void deleteAllJob(PurchaseEbiddingHeadLp purchaseHead) {
        String key = purchaseHead.getEbiddingNumber() + "_" + purchaseHead.getElsAccount();
        LpEbiddingJobUtil.deleteJob("logisticsPurchaseEbiddingBeginJobBeanServiceImpl_" + key);
        LpEbiddingJobUtil.deleteJob("logisticsPurchaseEbiddingFailedJobServiceImpl_" + key);
        LpEbiddingJobUtil.deleteJob("logisticsPurchaseEbiddingEndJobServiceImpl_" + key);
    }

    private static Date getAddTime(Date time) {
        return DateUtil.offsetSecond((Date)time, (int)3);
    }
}

