/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.calibration.service.BidWinningAffirmInformService;
import com.els.modules.tender.calibration.service.BidWinningAffirmNoInformService;
import com.els.modules.tender.calibration.vo.BidWinningAffirmItemVo;
import com.els.modules.tender.calibration.vo.BidWinningAffirmNoInformItemVO;
import com.els.modules.tender.common.enumerate.TenderDownloadBusinessTypeEnum;
import com.els.modules.tender.common.service.TenderDownloadService;
import com.els.modules.tender.common.vo.TenderAttachmentVO;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaBidAttachmentInfo;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaBidAttachmentInfoService;
import com.els.modules.tender.evaluation.utils.HtmlToPdfUtil;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TenderDownloadServiceImpl
implements TenderDownloadService {
    private static final Logger log = LoggerFactory.getLogger(TenderDownloadServiceImpl.class);
    @Autowired
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private PurchaseTenderProjectEvaBidAttachmentInfoService evaBidAttachmentInfoService;
    @Autowired
    private BidWinningAffirmNoInformService bidWinningAffirmNoInformService;
    @Autowired
    private BidWinningAffirmInformService bidWinningAffirmInformService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void downloadPDF(String id, String businessType, HttpServletRequest request, HttpServletResponse response) {
        TenderDownloadBusinessTypeEnum tenderDownloadBusinessTypeEnum = TenderDownloadBusinessTypeEnum.getTenderDownloadBusinessTypeEnum(businessType);
        Assert.notNull((Object)((Object)tenderDownloadBusinessTypeEnum), (String)I18nUtil.translate((String)"i18n_alert_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c!"));
        TenderAttachmentVO tenderAttachmentVO = this.buildTenderAttachment(tenderDownloadBusinessTypeEnum, id);
        String html = tenderAttachmentVO.getContent();
        if (StringUtils.isBlank((CharSequence)html)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CcxOLVW_60c5e69d", (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        log.info("\u62db\u6807html" + html);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)tenderAttachmentVO.getSubpackageId())));
        Object fileName = subpackageInfo.getSubpackageName();
        if (StringUtils.isNotBlank((CharSequence)tenderAttachmentVO.getFileTypeDictText())) {
            fileName = (String)fileName + "_" + tenderAttachmentVO.getFileTypeDictText();
        }
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String nowday = dtf.format(time);
        fileName = (String)fileName + nowday;
        fileName = (String)fileName + ".pdf";
        Object filePathParent = File.separator + "files" + File.separator + TenantContext.getTenant() + File.separator + nowday;
        Object filePath = (String)filePathParent + File.separator + (String)fileName;
        if (((String)filePathParent).contains("\\")) {
            filePathParent = ((String)filePathParent).replace("\\", "/");
            filePath = ((String)filePath).replace("\\", "/");
        }
        byte[] outByteArray = new byte[]{};
        outByteArray = HtmlToPdfUtil.htmlToPdf(html, (String)fileName, true, "", null);
        String uploadFilePath = this.invokeBaseRpcService.uploadFiles(outByteArray, (String)filePath, (String)fileName, "oss");
        if (StringUtils.isNotBlank((CharSequence)tenderAttachmentVO.getAttachmentId())) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByBatchId(Arrays.asList(tenderAttachmentVO.getAttachmentId()));
        }
        PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
        purchaseAttachmentDTO.setId(IdWorker.getIdStr());
        purchaseAttachmentDTO.setBusinessType("tender");
        purchaseAttachmentDTO.setHeadId(tenderAttachmentVO.getHeadId());
        purchaseAttachmentDTO.setFileType(tenderAttachmentVO.getFileType());
        purchaseAttachmentDTO.setSourceNumber(subpackageInfo.getSubpackageNumber());
        purchaseAttachmentDTO.setActionRoutePath(tenderDownloadBusinessTypeEnum.getActionRoutePath());
        purchaseAttachmentDTO.setFileName((String)fileName);
        purchaseAttachmentDTO.setFilePath((String)filePath);
        purchaseAttachmentDTO.setSaveType("oss");
        purchaseAttachmentDTO.setUploadElsAccount(SysUtil.getLoginUser().getElsAccount());
        purchaseAttachmentDTO.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
        purchaseAttachmentDTO.setFileSize(String.valueOf(outByteArray.length));
        this.invokeBaseRpcService.insertPurchaseAttachment(purchaseAttachmentDTO);
        if (TenderDownloadBusinessTypeEnum.EVA_BIDDING_ATTACHMENT.getValue().equals(tenderDownloadBusinessTypeEnum.getValue())) {
            PurchaseTenderProjectEvaBidAttachmentInfo evaAttachmentInfo = new PurchaseTenderProjectEvaBidAttachmentInfo();
            evaAttachmentInfo.setId(tenderAttachmentVO.getId());
            evaAttachmentInfo.setFileName((String)fileName);
            evaAttachmentInfo.setAttachmentId(purchaseAttachmentDTO.getId());
            this.evaBidAttachmentInfoService.updateById((Object)evaAttachmentInfo);
        }
    }

    private TenderAttachmentVO buildTenderAttachment(TenderDownloadBusinessTypeEnum tenderDownloadBusinessTypeEnum, String businessId) {
        switch (tenderDownloadBusinessTypeEnum) {
            case EVA_BIDDING_ATTACHMENT: {
                return this.buildTenderAttachmentByEvaBidding(businessId);
            }
            case BID_WINNING_AFFIRM_INFORM_ATTACHMENT: {
                return this.buildTenderAttachmentByBidWinningAffirmInform(businessId);
            }
            case BID_WINNING_AFFIRM_NOINFORM_ATTACHMENT: {
                return this.buildTenderAttachmentByBidWinningAffirmNoInform(businessId);
            }
        }
        return null;
    }

    private TenderAttachmentVO buildTenderAttachmentByEvaBidding(String businessId) {
        PurchaseTenderProjectEvaBidAttachmentInfo evaAttachmentInfo = (PurchaseTenderProjectEvaBidAttachmentInfo)((Object)this.evaBidAttachmentInfoService.getById((Serializable)((Object)businessId)));
        TenderAttachmentVO tenderAttachmentVO = TenderAttachmentVO.builder().attachmentId(evaAttachmentInfo.getAttachmentId()).content(evaAttachmentInfo.getContent()).headId(evaAttachmentInfo.getEvaInfoId()).subpackageId(evaAttachmentInfo.getSubpackageId()).fileType(evaAttachmentInfo.getFileType()).id(evaAttachmentInfo.getId()).build();
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("tenderEvaFileType", TenantContext.getTenant());
        Map dictMaps = dictDTOList.stream().collect(Collectors.toMap(DictDTO::getValue, Function.identity()));
        DictDTO dictDTO = (DictDTO)dictMaps.get(evaAttachmentInfo.getFileType());
        tenderAttachmentVO.setFileTypeDictText(dictDTO.getText());
        return tenderAttachmentVO;
    }

    private TenderAttachmentVO buildTenderAttachmentByBidWinningAffirmNoInform(String businessId) {
        BidWinningAffirmNoInformItemVO bidWinningAffirmNoInformItemVO = this.bidWinningAffirmNoInformService.queryItemByItemId(businessId);
        List<PurchaseAttachmentDTO> purchaseAttachmentDemandDTOList = bidWinningAffirmNoInformItemVO.getPurchaseAttachmentDemandDTOList();
        PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
        if (CollectionUtil.isNotEmpty(purchaseAttachmentDemandDTOList)) {
            purchaseAttachmentDTO = purchaseAttachmentDemandDTOList.get(0);
        }
        TenderAttachmentVO tenderAttachmentVO = TenderAttachmentVO.builder().attachmentId(purchaseAttachmentDTO.getId()).content(bidWinningAffirmNoInformItemVO.getNoticeContent()).headId(bidWinningAffirmNoInformItemVO.getId()).subpackageId(bidWinningAffirmNoInformItemVO.getSubpackageId()).fileType(purchaseAttachmentDTO.getFileType()).id(purchaseAttachmentDTO.getId()).build();
        return tenderAttachmentVO;
    }

    private TenderAttachmentVO buildTenderAttachmentByBidWinningAffirmInform(String businessId) {
        BidWinningAffirmItemVo bidWinningAffirmItemVo = this.bidWinningAffirmInformService.queryByBidWinningAffirmItemId(businessId);
        List<PurchaseAttachmentDTO> purchaseAttachmentDemandDTOList = bidWinningAffirmItemVo.getPurchaseAttachmentDemandDTOList();
        PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
        if (CollectionUtil.isNotEmpty(purchaseAttachmentDemandDTOList)) {
            purchaseAttachmentDTO = purchaseAttachmentDemandDTOList.get(0);
        }
        TenderAttachmentVO tenderAttachmentVO = TenderAttachmentVO.builder().attachmentId(purchaseAttachmentDTO.getId()).content(bidWinningAffirmItemVo.getNoticeContent()).headId(bidWinningAffirmItemVo.getId()).subpackageId(bidWinningAffirmItemVo.getSubpackageId()).fileType(purchaseAttachmentDTO.getFileType()).id(purchaseAttachmentDTO.getId()).build();
        return tenderAttachmentVO;
    }
}

