/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeItem;
import com.els.modules.tender.notice.entity.PurchaseTenderSupplierInvitation;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeStatusEnum;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeHeadService;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageBidOpenTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.modules.tender.sale.enumerate.TenderInvitationSupplierReceiptSourceTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderInvitationSupplierReceiptStatusEnum;
import com.els.modules.tender.sale.vo.TenderInvitationSupplierReceiptVO;
import com.els.modules.tender.supplier.entity.TenderInvitationSupplierReceipt;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.mapper.TenderInvitationSupplierReceiptMapper;
import com.els.modules.tender.supplier.service.TenderInvitationSupplierReceiptService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TenderInvitationSupplierReceiptServiceImpl
extends BaseServiceImpl<TenderInvitationSupplierReceiptMapper, TenderInvitationSupplierReceipt>
implements TenderInvitationSupplierReceiptService {
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Autowired
    @Lazy
    private PurchaseTenderNoticeHeadService purchaseTenderNoticeHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addBatch(List<TenderInvitationSupplierReceipt> tenderInvitationSupplierReceiptList) {
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(tenderInvitationSupplierReceiptList), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        String subpackageId = tenderInvitationSupplierReceiptList.get(0).getSubpackageId();
        TenderInvitationSupplierReceipt queryInvitationSupplierReceipt = new TenderInvitationSupplierReceipt();
        queryInvitationSupplierReceipt.setSubpackageId(subpackageId);
        List<TenderInvitationSupplierReceipt> tenderInvitationSupplierReceipts = ((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectBySubpackageId(queryInvitationSupplierReceipt);
        List<Object> supplierAccounts = new ArrayList();
        if (CollectionUtil.isNotEmpty(tenderInvitationSupplierReceipts)) {
            supplierAccounts = tenderInvitationSupplierReceipts.stream().map(TenderInvitationSupplierReceipt::getSupplierAccount).distinct().collect(Collectors.toList());
        }
        Set<String> projectIds = tenderInvitationSupplierReceiptList.stream().map(TenderInvitationSupplierReceipt::getTenderProjectId).collect(Collectors.toSet());
        List<PurchaseTenderProjectHead> purchaseTenderProjectHeads = this.purchaseTenderProjectHeadService.selectBatchIds(projectIds);
        Map<String, PurchaseTenderProjectHead> projectHeadMap = purchaseTenderProjectHeads.stream().collect(Collectors.toMap(BaseEntity::getId, projectHead -> projectHead, (o1, o2) -> o1));
        for (TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt : tenderInvitationSupplierReceiptList) {
            Assert.isTrue((!supplierAccounts.contains(tenderInvitationSupplierReceipt.getSupplierAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_RdXWWWWIMKWxqVBPVW_46124e9e", (String)"\u4f9b\u5e94\u5546\u3010${0}\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u9080\u8bf7\uff01", (String[])new String[]{tenderInvitationSupplierReceipt.getSupplierName()}));
            tenderInvitationSupplierReceipt.setElsAccount(tenderInvitationSupplierReceipt.getSupplierAccount());
            PurchaseTenderProjectHead projectHead2 = projectHeadMap.get(tenderInvitationSupplierReceipt.getTenderProjectId());
            tenderInvitationSupplierReceipt.setTenderProjectName(projectHead2.getTenderProjectName());
            tenderInvitationSupplierReceipt.setTenderProjectNumber(projectHead2.getTenderProjectNumber());
            tenderInvitationSupplierReceipt.setPurchaseEnterpriseName(projectHead2.getPurchaseEnterpriseName());
            tenderInvitationSupplierReceipt.setPurchaseEnterpriseAccount(projectHead2.getElsAccount());
        }
        this.saveBatch(tenderInvitationSupplierReceiptList, 2000);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addBatchByNotice(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitationList, boolean hasOffLine) {
        ArrayList<TenderInvitationSupplierReceipt> tenderInvitationSupplierReceiptList = new ArrayList<TenderInvitationSupplierReceipt>();
        String receiptStatus = hasOffLine || "0".equals(purchaseTenderNoticeHead.getReceipt()) ? TenderInvitationSupplierReceiptStatusEnum.CONFIRM.getValue() : TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue();
        for (PurchaseTenderNoticeItem purchaseTenderNoticeItem : purchaseTenderNoticeItemList) {
            for (PurchaseTenderSupplierInvitation purchaseTenderSupplierInvitation : purchaseTenderSupplierInvitationList) {
                TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = new TenderInvitationSupplierReceipt();
                tenderInvitationSupplierReceipt.setReceiptStatus(receiptStatus);
                tenderInvitationSupplierReceipt.setSupplierAccount(purchaseTenderSupplierInvitation.getSupplierAccount());
                tenderInvitationSupplierReceipt.setSupplierName(purchaseTenderSupplierInvitation.getSupplierName());
                tenderInvitationSupplierReceipt.setSubpackageId(purchaseTenderNoticeItem.getSubpackageId());
                tenderInvitationSupplierReceipt.setTenderProjectId(purchaseTenderNoticeItem.getTenderProjectId());
                tenderInvitationSupplierReceipt.setContacts(purchaseTenderSupplierInvitation.getContacts());
                tenderInvitationSupplierReceipt.setContactsPhone(purchaseTenderSupplierInvitation.getContactsPhone());
                tenderInvitationSupplierReceipt.setSourceType(TenderInvitationSupplierReceiptSourceTypeEnum.ON_LINE.getValue());
                tenderInvitationSupplierReceipt.setSubpackageName(purchaseTenderNoticeItem.getSubpackageName());
                tenderInvitationSupplierReceiptList.add(tenderInvitationSupplierReceipt);
            }
        }
        this.addBatch(tenderInvitationSupplierReceiptList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)tenderInvitationSupplierReceipt), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        Assert.isTrue((boolean)TenderInvitationSupplierReceiptStatusEnum.NEW.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus()), (String)I18nUtil.translate((String)"i18n_field_APzExiTQGW_8e1aa79e", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664"));
        ((TenderInvitationSupplierReceiptMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public TenderInvitationSupplierReceiptVO queryById(String id) {
        TenderInvitationSupplierReceipt invitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (invitationSupplierReceipt == null) {
            return null;
        }
        TenderInvitationSupplierReceiptVO invitationSupplierReceiptVO = (TenderInvitationSupplierReceiptVO)((Object)SysUtil.copyProperties((Object)((Object)invitationSupplierReceipt), TenderInvitationSupplierReceiptVO.class));
        List<PurchaseTenderNoticeHead> noticeHeadList = this.purchaseTenderNoticeHeadService.queryNoticeHeadBySubpackageId(invitationSupplierReceiptVO.getSubpackageId(), null, null);
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = noticeHeadList.stream().filter(noticeHead -> !PurchaseTenderNoticeStatusEnum.NEW.getValue().equals(noticeHead.getNoticeStatus())).max(Comparator.comparing(PurchaseTenderNoticeHead::getPublishTime)).get();
        invitationSupplierReceiptVO.setNoticeContent(purchaseTenderNoticeHead.getNoticeContent());
        List attachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        invitationSupplierReceiptVO.setAttachmentDTOList(attachmentDTOS);
        return invitationSupplierReceiptVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)tenderInvitationSupplierReceipt), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        Assert.isTrue((boolean)TenderInvitationSupplierReceiptStatusEnum.NEW.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus()), (String)I18nUtil.translate((String)"i18n_field_APzExiThxW_8e1a2d50", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u53d1\u5e03"));
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)tenderInvitationSupplierReceipt.getSubpackageId())));
        boolean hasOffLine = SubpackageBidOpenTypeEnum.OFF_LINE.getValue().equals(subpackageInfo.getBidOpenType());
        String receiptStatus = "0".equals(subpackageInfo.getReceipt()) ? TenderInvitationSupplierReceiptStatusEnum.CONFIRM.getValue() : TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue();
        tenderInvitationSupplierReceipt.setReceiptStatus(hasOffLine ? TenderInvitationSupplierReceiptStatusEnum.CONFIRM.getValue() : receiptStatus);
        ((TenderInvitationSupplierReceiptMapper)this.baseMapper).updateById((Object)tenderInvitationSupplierReceipt);
        TenderProjectSupplier querySupplier = new TenderProjectSupplier();
        querySupplier.setSupplierAccount(tenderInvitationSupplierReceipt.getSupplierAccount()).setSubpackageId(tenderInvitationSupplierReceipt.getSubpackageId());
        List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier, false);
        if (CollectionUtil.isEmpty(tenderProjectSuppliers)) {
            TenderProjectSupplier supplier = new TenderProjectSupplier();
            supplier.setElsAccount(tenderInvitationSupplierReceipt.getSupplierAccount());
            supplier.setPurchaseEnterpriseAccount(tenderInvitationSupplierReceipt.getPurchaseEnterpriseAccount());
            supplier.setPurchaseEnterpriseName(tenderInvitationSupplierReceipt.getPurchaseEnterpriseName());
            supplier.setSupplierAccount(tenderInvitationSupplierReceipt.getSupplierAccount());
            supplier.setSupplierSubAccount("1001");
            supplier.setSupplierName(tenderInvitationSupplierReceipt.getSupplierName());
            supplier.setSubpackageId(tenderInvitationSupplierReceipt.getSubpackageId());
            supplier.setSubpackageName(tenderInvitationSupplierReceipt.getSubpackageName());
            supplier.setTenderProjectId(tenderInvitationSupplierReceipt.getTenderProjectId());
            supplier.setTenderProjectNumber(tenderInvitationSupplierReceipt.getTenderProjectNumber());
            supplier.setTenderProjectName(tenderInvitationSupplierReceipt.getTenderProjectName());
            supplier.setSourceType(tenderInvitationSupplierReceipt.getSourceType());
            supplier.setEffective(hasOffLine ? "1" : "0");
            supplier.setInviteQuotedPriceStatus("0");
            supplier.setContactsPhone(tenderInvitationSupplierReceipt.getContactsPhone());
            supplier.setContacts(tenderInvitationSupplierReceipt.getContacts());
            this.tenderProjectSupplierService.add(supplier);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public TenderInvitationSupplierReceipt edit(TenderInvitationSupplierReceiptVO tenderInvitationSupplierReceiptVO) {
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)tenderInvitationSupplierReceiptVO.getId())));
        Assert.notNull((Object)((Object)tenderInvitationSupplierReceipt), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        Assert.isTrue((boolean)TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus()), (String)I18nUtil.translate((String)"i18n_field_APzExiTsMW_8e0b03a7", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u4fdd\u5b58"));
        this.updateInvitationSupplierReceipt(tenderInvitationSupplierReceiptVO, tenderInvitationSupplierReceipt);
        return tenderInvitationSupplierReceipt;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public TenderInvitationSupplierReceipt comfirm(TenderInvitationSupplierReceiptVO tenderInvitationSupplierReceiptVO) {
        Assert.hasText((String)tenderInvitationSupplierReceiptVO.getReceiptPhone(), (String)I18nUtil.translate((String)"i18n_field_MRCExOLVW_ee9dd140", (String)"\u56de\u6267\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.hasText((String)tenderInvitationSupplierReceiptVO.getReceiptPerson(), (String)I18nUtil.translate((String)"i18n_field_MRLxOLVW_4c6df00", (String)"\u56de\u6267\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)tenderInvitationSupplierReceiptVO.getId())));
        Assert.notNull((Object)((Object)tenderInvitationSupplierReceipt), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        Assert.isTrue((boolean)TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus()), (String)I18nUtil.translate((String)"i18n_field_APzExiTRLW_8ea9252c", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u786e\u8ba4"));
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)tenderInvitationSupplierReceipt.getSubpackageId())));
        Assert.isTrue((subpackageInfo.getStatus() < TenderProjectSubpackageStatusEnum.FIRST_STEP_OPEN_BIDING.getValue() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vBSxqtk_b92db398", (String)"\u5f00\u6807\u540e\u4e0d\u53ef\u64cd\u4f5c"));
        tenderInvitationSupplierReceipt.setReceiptStatus(TenderInvitationSupplierReceiptStatusEnum.CONFIRM.getValue());
        tenderInvitationSupplierReceipt.setReceiptTime(new Date());
        this.updateInvitationSupplierReceipt(tenderInvitationSupplierReceiptVO, tenderInvitationSupplierReceipt);
        this.tenderProjectSupplierService.updateByReceiptComfirm(tenderInvitationSupplierReceipt);
        List attachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderInvitationSupplierReceiptVO.getId());
        ArchiveUtil.saveArchiveBySaleAttachmentDTO(attachmentDTOS, tenderInvitationSupplierReceiptVO.getId(), tenderInvitationSupplierReceiptVO.getSubpackageId(), subpackageInfo.getHeadId(), TenderProjectArchiveAttachmentEnum.INVITATION_SUPPLIER_RECEIPT.getValue());
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(tenderInvitationSupplierReceipt.getTenderProjectId()).append("&subpackageId=").append(tenderInvitationSupplierReceipt.getSubpackageId()).append("&businessId=").append(tenderInvitationSupplierReceipt.getId());
        List<ElsSubAccountDTO> accountDTOList = TenderProjectMemberUtils.getTenderProjectMember(tenderInvitationSupplierReceipt.getTenderProjectId());
        Map params = FastJsonUtils.toMap((Object)tenderInvitationSupplierReceipt);
        params.put("result", I18nUtil.translate((String)"i18n_field_RL_f20f6", (String)"\u786e\u8ba4"));
        this.sendMsgToSubAccount(TenantContext.getTenant(), accountDTOList, params, urlParams.toString(), "tender", "tenderSupplierReceiveInvitation");
        return tenderInvitationSupplierReceipt;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public TenderInvitationSupplierReceipt reject(String id) {
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)tenderInvitationSupplierReceipt), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        Assert.isTrue((boolean)TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus()), (String)I18nUtil.translate((String)"i18n_field_APzExiFKsuW_84b1fbf", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u62d2\u7edd\u53c2\u52a0"));
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)tenderInvitationSupplierReceipt.getSubpackageId())));
        Assert.isTrue((subpackageInfo.getStatus() < TenderProjectSubpackageStatusEnum.FIRST_STEP_OPEN_BIDING.getValue() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vBSxqtk_b92db398", (String)"\u5f00\u6807\u540e\u4e0d\u53ef\u64cd\u4f5c"));
        tenderInvitationSupplierReceipt.setReceiptStatus(TenderInvitationSupplierReceiptStatusEnum.REJECT.getValue());
        ((TenderInvitationSupplierReceiptMapper)this.baseMapper).updateById((Object)tenderInvitationSupplierReceipt);
        TenderProjectSupplier querySupplier = new TenderProjectSupplier();
        querySupplier.setSupplierAccount(tenderInvitationSupplierReceipt.getSupplierAccount()).setSubpackageId(tenderInvitationSupplierReceipt.getSubpackageId());
        List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
        if (CollectionUtil.isNotEmpty(tenderProjectSuppliers)) {
            this.tenderProjectSupplierService.updateEffectiveById(tenderProjectSuppliers.get(0).getId(), "0");
        }
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(tenderInvitationSupplierReceipt.getTenderProjectId()).append("&subpackageId=").append(tenderInvitationSupplierReceipt.getSubpackageId()).append("&businessId=").append(tenderInvitationSupplierReceipt.getId());
        List<ElsSubAccountDTO> accountDTOList = TenderProjectMemberUtils.getTenderProjectMember(tenderInvitationSupplierReceipt.getTenderProjectId());
        Map params = FastJsonUtils.toMap((Object)tenderInvitationSupplierReceipt);
        params.put("result", I18nUtil.translate((String)"i18n_title_refuse", (String)"\u786e\u8ba4"));
        this.sendMsgToSubAccount(TenantContext.getTenant(), accountDTOList, params, urlParams.toString(), "tender", "tenderSupplierRejectInvitation");
        return tenderInvitationSupplierReceipt;
    }

    @Override
    public List<TenderInvitationSupplierReceipt> selectBySubpackageId(TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt) {
        return ((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectBySubpackageId(tenderInvitationSupplierReceipt);
    }

    private void updateInvitationSupplierReceipt(TenderInvitationSupplierReceiptVO tenderInvitationSupplierReceiptVO, TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt) {
        tenderInvitationSupplierReceipt.setReceiptPerson(tenderInvitationSupplierReceiptVO.getReceiptPerson());
        tenderInvitationSupplierReceipt.setReceiptPhone(tenderInvitationSupplierReceiptVO.getReceiptPhone());
        tenderInvitationSupplierReceipt.setRemark(tenderInvitationSupplierReceiptVO.getRemark());
        ((TenderInvitationSupplierReceiptMapper)this.baseMapper).updateById((Object)tenderInvitationSupplierReceipt);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(tenderInvitationSupplierReceiptVO.getId());
        List<SaleAttachmentDTO> attachmentDTOList = tenderInvitationSupplierReceiptVO.getAttachmentDTOList();
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            attachmentDTOList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderInvitationSupplierReceiptVO.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentDTOList);
        }
    }

    @Override
    public List<CountVO> queryTabsCount(String elsAccount) {
        return ((TenderInvitationSupplierReceiptMapper)this.baseMapper).queryTabsCount(elsAccount);
    }

    @Override
    public List<TenderInvitationSupplierReceipt> selectByMainIds(List<String> oldIds) {
        return ((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectByMainIds(oldIds);
    }

    @Override
    public boolean hasReject(String supplierAccount, String subpackageId) {
        TenderInvitationSupplierReceipt querySupplierReceipt = new TenderInvitationSupplierReceipt().setSupplierAccount(supplierAccount).setSubpackageId(subpackageId);
        List<TenderInvitationSupplierReceipt> tenderInvitationSupplierReceipts = ((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectBySubpackageId(querySupplierReceipt);
        if (CollectionUtil.isEmpty(tenderInvitationSupplierReceipts)) {
            return false;
        }
        return TenderInvitationSupplierReceiptStatusEnum.REJECT.getValue().equals(tenderInvitationSupplierReceipts.get(0).getReceiptStatus());
    }

    @Override
    public void updComfirmBatchByNotice(List<String> subpackageIds) {
        List<TenderInvitationSupplierReceipt> tenderInvitationSupplierReceipts = ((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectByMainIds(subpackageIds);
        if (CollectionUtil.isEmpty(tenderInvitationSupplierReceipts)) {
            return;
        }
        if (CollectionUtil.isEmpty(tenderInvitationSupplierReceipts = tenderInvitationSupplierReceipts.stream().filter(tenderInvitationSupplierReceipt -> TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus())).collect(Collectors.toList()))) {
            return;
        }
        tenderInvitationSupplierReceipts.forEach(tenderInvitationSupplierReceipt -> tenderInvitationSupplierReceipt.setReceiptStatus(TenderInvitationSupplierReceiptStatusEnum.CONFIRM.getValue()));
        this.updateBatchById(tenderInvitationSupplierReceipts);
    }
}

