/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.BigDecimalUtils;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDemandDTO;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.logisticspurchase.base.entity.SubjectFileItem;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.vo.SaleEnquiryHeadLpVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/lpEnquiry/saleEnquiryHead"})
@Api(tags={"\u4f9b\u65b9\u8be2\u4ef7\u5934"})
public class SaleEnquiryHeadLpController
extends BaseController<SaleEnquiryHeadLp, SaleEnquiryHeadLpService> {
    @Autowired
    private SaleEnquiryItemLpService saleEnquiryItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SubjectFileItemService subjectFileItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"lpEnquiry#SaleEnquiryHeadLp:list"})
    public Result<?> queryPageList(SaleEnquiryHeadLp saleEnquiryHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleEnquiryHead), (Map)req.getParameterMap());
        queryWrapper.lambda().ne(SaleEnquiryHeadLp::getEnquiryStatus, (Object)EnquiryLpStatusEnum.CANCEL.getValue());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((SaleEnquiryHeadLpService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u72b6\u6001\u6570\u91cf\u67e5\u8be2", notes="\u79fb\u52a8\u7aef\u72b6\u6001\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"lpEnquiry#SaleEnquiryHeadLp:list"})
    public Result<?> queryStatusCount(SaleEnquiryHeadLp saleEnquiryHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleEnquiryHead), (Map)req.getParameterMap());
        queryWrapper.lambda().in(SaleEnquiryHeadLp::getEnquiryStatus, new Object[]{EnquiryLpStatusEnum.QUOTING.getValue(), EnquiryLpStatusEnum.QUOTED.getValue(), EnquiryLpStatusEnum.NO_QUOTE.getValue(), EnquiryLpStatusEnum.BARGAIN.getValue()});
        List list = ((SaleEnquiryHeadLpService)this.service).list((Wrapper)queryWrapper);
        long quoting = list.stream().filter(head -> EnquiryLpStatusEnum.QUOTING.getValue().equals(head.getEnquiryStatus())).count();
        long quoted = list.stream().filter(head -> EnquiryLpStatusEnum.QUOTED.getValue().equals(head.getEnquiryStatus())).count();
        long noQuote = list.stream().filter(head -> EnquiryLpStatusEnum.NO_QUOTE.getValue().equals(head.getEnquiryStatus())).count();
        long bargain = list.stream().filter(head -> EnquiryLpStatusEnum.BARGAIN.getValue().equals(head.getEnquiryStatus())).count();
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("quoting", quoting);
        result.put("quoted", quoted);
        result.put("noQuote", noQuote);
        result.put("bargain", bargain);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"lpEnquiry#SaleEnquiryHeadLp:list"})
    public Result<?> queryItemPageList(SaleEnquiryItemLp saleEnquiryItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String headId = saleEnquiryItem.getHeadId();
        if (StrUtil.isBlank((CharSequence)headId)) {
            throw new ELSBootException("\u8be2\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleEnquiryItem), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleEnquiryItemService.page((IPage)page, (Wrapper)queryWrapper);
        pageList.getRecords().forEach(record -> record.setCenterPoint("1".equals(record.getCenterPoint()) ? "\u662f" : "\u5426"));
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u8be6\u60c5", notes="\u901a\u8fc7id\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"lpEnquiry#SaleEnquiryHeadLp:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleEnquiryHeadLp dbHead = (SaleEnquiryHeadLp)((Object)((SaleEnquiryHeadLpService)this.service).getById((Serializable)((Object)id)));
        SaleEnquiryHeadLpVO headVO = new SaleEnquiryHeadLpVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        headVO.setSaleAttachmentList(saleAttachmentList);
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(id);
        headVO.setSaleAttachmentDemandList(demandList);
        List<SubjectFileItem> subjectFileItemList = this.subjectFileItemService.selectByMainId(dbHead.getSubjectFileHeadId());
        headVO.setSubjectFileItemList(subjectFileItemList);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u4f9b\u65b9\u8be2\u4ef7\u5934-\u62a5\u4ef7")
    @ApiOperation(value="\u62a5\u4ef7", notes="\u62a5\u4ef7")
    @PostMapping(value={"/quote"})
    @RequiresPermissions(value={"lpEnquiry#SaleEnquiryHeadLp:quote"})
    @SrmValidated
    @FormCommit
    public Result<?> quote(@RequestBody SaleEnquiryHeadLpVO saleHeadVO) {
        Assert.notEmpty(saleHeadVO.getSaleEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_cdIxOLV_e4453e71", (String)"\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)saleHeadVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        this.checkPrice(saleHeadVO);
        SaleEnquiryHeadLp dbHead = (SaleEnquiryHeadLp)((Object)((SaleEnquiryHeadLpService)this.service).getById((Serializable)((Object)saleHeadVO.getId())));
        if (dbHead.getQuoteConfirmTime() != null) {
            Assert.isTrue((boolean)"1".equals(dbHead.getQuoteConfirmFlag()), (String)I18nUtil.translate((String)"i18n_alert_suRLyRKIPLHcsuRLWxiTDJsu_e9a10fb2", (String)"\u62a5\u4ef7\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u524d\u672a\u8fdb\u884c\u62a5\u4ef7\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u62a5\u4ef7"));
        }
        List<String> statusList = Arrays.asList(EnquiryLpStatusEnum.QUOTING.getValue(), EnquiryLpStatusEnum.BARGAIN.getValue(), EnquiryLpStatusEnum.REGRET.getValue());
        Assert.isTrue((boolean)statusList.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_APzExiTsu_3e65ad91", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u62a5\u4ef7"));
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(dbHead.getId()).stream().filter(demand -> "1".equals(demand.getRequired()) && StageTypeEnum.QUOTE.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(dbHead.getId());
        Map<String, List<SaleAttachmentDTO>> checkMap = saleAttachmentList.stream().filter(attachment -> StrUtil.isNotBlank((CharSequence)attachment.getFileType())).collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType));
        for (SaleAttachmentDemandDTO demand2 : demandList) {
            Assert.isTrue((boolean)checkMap.containsKey(demand2.getFileType()), (String)I18nUtil.translate((String)"i18n_alert_VpYPVXVIdAcjQIW_61f8e1a5", (String)"\u8bf7\u6309\u7167\u8981\u6c42\u4e0a\u4f20\u5bf9\u5e94\u7c7b\u578b\u7684\u6587\u4ef6\uff01"));
        }
        ((SaleEnquiryHeadLpService)this.service).quote(dbHead, saleHeadVO.getSaleEnquiryItemList());
        return this.commonSuccessResult(3);
    }

    private void checkPrice(SaleEnquiryHeadLpVO vo) {
        List<SaleEnquiryItemLp> saleEnquiryItemList = vo.getSaleEnquiryItemList();
        if (CollectionUtils.isEmpty(saleEnquiryItemList)) {
            return;
        }
        saleEnquiryItemList.forEach(e -> {
            this.comparePrice(e.getBudgetPrice());
            this.comparePrice(e.getPrice());
            this.comparePrice(e.getNetPrice());
            this.comparePrice(e.getTaxAmount());
            this.comparePrice(e.getNetAmount());
        });
    }

    private void comparePrice(BigDecimal budgetPrice) {
        if (ObjectUtils.isEmpty((Object)budgetPrice)) {
            return;
        }
        boolean less = BigDecimalUtils.lessThan((BigDecimal)budgetPrice, (BigDecimal)BigDecimal.ZERO);
        Assert.isTrue((!less ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umxOKBW_96a86b0b", (String)"\u4ef7\u683c\u4e0d\u80fd\u662f\u8d1f\u6570"));
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/queryTabsCount"})
    @RequiresPermissions(value={"lpEnquiry#SaleEnquiryHeadLp:list"})
    public Result<?> queryTabsCount(SaleEnquiryHeadLp saleEnquiryHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleEnquiryHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"enquiry_status", "count(0) as template_version"});
        queryWrapper.groupBy((Object)"enquiry_status");
        List list = ((SaleEnquiryHeadLpService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleEnquiryHeadLp::getEnquiryStatus, SaleEnquiryHeadLp::getTemplateVersion));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "enquiryStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmEnquiryStatusLp", TenantContext.getTenant());
        String[] statuses = new String[]{"1", "2", "3", "7"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "enquiryStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

