/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentHistory;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatQuoteTypeEnum;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatTypeEnum;
import com.els.modules.tender.attachment.enumerate.PricePointsCalFormualEnum;
import com.els.modules.tender.attachment.enumerate.ShortlistedRulesEnum;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHistoryService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderProjectAttachmentHeadVO;
import com.els.modules.tender.clarification.entity.PurchaseClarificationEvaluationPriceRegulationInfo;
import com.els.modules.tender.clarification.entity.PurchaseClarificationEvaluationPrinciples;
import com.els.modules.tender.clarification.entity.PurchaseClarificationEvaluationRegulationInfo;
import com.els.modules.tender.clarification.entity.PurchaseClarificationPriceOpeningsTemplate;
import com.els.modules.tender.clarification.entity.PurchaseClarificationTenderBidLetter;
import com.els.modules.tender.clarification.entity.PurchaseTenderClarificationInfo;
import com.els.modules.tender.clarification.enumerate.TenderClarificationStatusEnum;
import com.els.modules.tender.clarification.mapper.PurchaseTenderClarificationInfoMapper;
import com.els.modules.tender.clarification.service.PurchaseClarificationBidLetterFormatGroupService;
import com.els.modules.tender.clarification.service.PurchaseClarificationEvaluationGroupService;
import com.els.modules.tender.clarification.service.PurchaseClarificationEvaluationPrinciplesService;
import com.els.modules.tender.clarification.service.PurchaseTenderClarificationInfoService;
import com.els.modules.tender.clarification.vo.PurchaseClarificationBidLetterFormatGroupVO;
import com.els.modules.tender.clarification.vo.PurchaseClarificationEvaluationGroupVO;
import com.els.modules.tender.clarification.vo.PurchaseTenderClarificationBidLetterVO;
import com.els.modules.tender.clarification.vo.PurchaseTenderClarificationInfoVO;
import com.els.modules.tender.column.enumerate.CustomerFieldCategoryEnum;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingHeadService;
import com.els.modules.tender.openbid.vo.PurchaseOpenSettingHeadVO;
import com.els.modules.tender.price.service.PurchaseTenderControlPriceHeadService;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageBidOpenTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageEvaBidTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderClarificationInfoServiceImpl
extends BaseServiceImpl<PurchaseTenderClarificationInfoMapper, PurchaseTenderClarificationInfo>
implements PurchaseTenderClarificationInfoService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private PurchaseTenderProjectOpenSettingHeadService openSettingHeadService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;
    @Autowired
    private PurchaseClarificationBidLetterFormatGroupService clarificationBidLetterFormatGroupService;
    @Autowired
    private PurchaseClarificationEvaluationGroupService clarificationEvaluationGroupService;
    @Autowired
    private PurchaseClarificationEvaluationPrinciplesService clarificationEvaluationPrinciplesService;
    @Autowired
    @Lazy
    private SaleTenderPriceOpeningsService saleTenderPriceOpeningsService;
    @Autowired
    private PurchaseTenderProjectAttachmentHistoryService attachmentHistoryService;
    @Autowired
    @Lazy
    private PurchaseTenderControlPriceHeadService controlPriceHeadService;
    @Resource
    private RedisUtil redisUtil;

    @Override
    public IPage<PurchaseTenderClarificationInfo> queryTenderPage(Page<PurchaseTenderClarificationInfo> page, QueryWrapper<PurchaseTenderClarificationInfo> queryWrapper) {
        return ((PurchaseTenderClarificationInfoMapper)this.baseMapper).queryTenderPage(page, queryWrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderClarificationInfo add(PurchaseTenderClarificationInfoVO clarificationInfoVO) {
        String openBidStatus;
        PurchaseTenderProjectSubpackageInfo subpackageInfo = TenderFlagInjectionContext.getSubpackageInfo();
        if (subpackageInfo == null) {
            subpackageInfo = this.subpackageInfoService.selectById(clarificationInfoVO.getSubpackageId());
            TenderFlagInjectionContext.setTenderProcessType(subpackageInfo.getProcessType());
        }
        if (SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(subpackageInfo.getProcessType())) {
            TenderFlagInjectionContext.setTenderCurrentStep(SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue());
        }
        openBidStatus = StringUtils.isNotBlank((CharSequence)(openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo))) ? openBidStatus : PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue();
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(openBidStatus), (String)I18nUtil.translate((String)"i18n_alert_APtFIvBxiTtkW_98c23454", (String)"\u5f53\u524d\u5355\u636e\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        PurchaseTenderClarificationInfo tenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)SysUtil.copyProperties((Object)((Object)clarificationInfoVO), PurchaseTenderClarificationInfo.class));
        tenderClarificationInfo.setId(IdWorker.getIdStr());
        tenderClarificationInfo.setClarificationNumber(this.invokeBaseRpcService.getNextCode("clarificationNumber", (Object)tenderClarificationInfo));
        tenderClarificationInfo.setConfirmNumber(0);
        tenderClarificationInfo.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
        ((PurchaseTenderClarificationInfoMapper)this.baseMapper).insert((Object)tenderClarificationInfo);
        this.insertData(tenderClarificationInfo, clarificationInfoVO.getPurchaseAttachmentList());
        return tenderClarificationInfo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderClarificationInfoVO changeAttachment(PurchaseTenderClarificationInfoVO clarificationInfoVO) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = TenderFlagInjectionContext.getSubpackageInfo();
        if (subpackageInfo == null) {
            subpackageInfo = this.subpackageInfoService.selectById(clarificationInfoVO.getSubpackageId());
            TenderFlagInjectionContext.setTenderProcessType(subpackageInfo.getProcessType());
        }
        PurchaseClarificationBidLetterFormatGroupVO letterFormatGroupVo = clarificationInfoVO.getTenderBidLetterFormatGroupVo();
        PurchaseClarificationEvaluationPrinciples evaluationPrinciples = clarificationInfoVO.getPurchaseTenderEvaluationPrinciples();
        List<PurchaseClarificationEvaluationGroupVO> evaluationInfoVoList = clarificationInfoVO.getTenderEvaluationInfoVoList();
        clarificationInfoVO.setBiddingDocuments("1");
        PurchaseTenderClarificationInfo clarificationInfo = null;
        clarificationInfo = StringUtils.isBlank((CharSequence)clarificationInfoVO.getId()) ? this.add(clarificationInfoVO) : this.edit(clarificationInfoVO);
        this.setCustomizeFieldParam(letterFormatGroupVo);
        this.insertAttachment(clarificationInfo, letterFormatGroupVo, evaluationPrinciples, evaluationInfoVoList);
        return this.queryById(clarificationInfo.getId(), clarificationInfo.getSubpackageId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderClarificationInfoVO changeAttachmentClear(String clarificationInfoId, String subpackageId) {
        this.clarificationBidLetterFormatGroupService.deleteByMainId(clarificationInfoId);
        this.clarificationEvaluationPrinciplesService.deleteByMainId(clarificationInfoId);
        this.clarificationEvaluationGroupService.deleteByMainId(clarificationInfoId);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        this.update((Wrapper)((LambdaUpdateWrapper)updateWrapper.set(PurchaseTenderClarificationInfo::getBiddingDocuments, (Object)"0")).eq(BaseEntity::getId, (Object)clarificationInfoId));
        return this.queryById(clarificationInfoId, subpackageId);
    }

    public void setCustomizeFieldParam(PurchaseClarificationBidLetterFormatGroupVO letterFormatGroupVo) {
        if (letterFormatGroupVo == null) {
            return;
        }
        List<PurchaseTenderClarificationBidLetterVO> tenderBidTetterVoList = letterFormatGroupVo.getTenderBidTetterVoList();
        if (CollectionUtil.isEmpty(tenderBidTetterVoList)) {
            return;
        }
        for (PurchaseTenderClarificationBidLetterVO purchaseTenderBidLetterVO : tenderBidTetterVoList) {
            String customizeFieldModel = purchaseTenderBidLetterVO.getCustomizeFieldModel();
            String customizeFieldData = purchaseTenderBidLetterVO.getCustomizeFieldData();
            PurchaseClarificationPriceOpeningsTemplate priceOpenings = new PurchaseClarificationPriceOpeningsTemplate();
            priceOpenings.setCustomizeFieldData(customizeFieldData);
            priceOpenings.setCustomizeFieldModel(customizeFieldModel);
            purchaseTenderBidLetterVO.setPriceOpenings(priceOpenings);
        }
    }

    @Override
    public List<PurchaseClarificationTenderBidLetter> queryTenderBidLetterList(String clarificationId) {
        return this.clarificationBidLetterFormatGroupService.queryTenderBidLetterList(clarificationId);
    }

    @Override
    public List<CustomColumnModel> queryPriceColumn(String bidLetterId) {
        List<String> bidLetterIdList = Arrays.asList(bidLetterId);
        List<PurchaseClarificationPriceOpeningsTemplate> priceOpeningsTemplates = this.clarificationBidLetterFormatGroupService.selectByBidLetterIdList(bidLetterIdList);
        ArrayList<CustomColumnModel> tenderCustomColumnList = new ArrayList<CustomColumnModel>();
        for (PurchaseClarificationPriceOpeningsTemplate priceOpening : priceOpeningsTemplates) {
            List categoryFieldList;
            String customizeFieldModel = priceOpening.getCustomizeFieldModel();
            List customColumnModel = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
            if (customColumnModel.isEmpty() || !CollectionUtils.isNotEmpty(categoryFieldList = customColumnModel.stream().filter(column -> CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(column.getFieldCategory())).collect(Collectors.toList()))) continue;
            tenderCustomColumnList.addAll(categoryFieldList);
        }
        return tenderCustomColumnList;
    }

    private void resetAttachementId(PurchaseClarificationBidLetterFormatGroupVO bidLetterFormatGroupVo, PurchaseClarificationEvaluationPrinciples evaluationPrinciples, List<PurchaseClarificationEvaluationGroupVO> evaluationInfoVoList) {
        if (null != bidLetterFormatGroupVo) {
            bidLetterFormatGroupVo.setId(null);
            for (PurchaseTenderClarificationBidLetterVO bidLetterVO : bidLetterFormatGroupVo.getTenderBidTetterVoList()) {
                bidLetterVO.setId(null);
                bidLetterVO.getPriceOpenings().setId(null);
                bidLetterVO.getPriceOpenings().setBidLetterId(null);
            }
        }
        if (null != evaluationPrinciples) {
            evaluationPrinciples.setId(null);
        }
        if (CollectionUtil.isNotEmpty(evaluationInfoVoList)) {
            for (PurchaseClarificationEvaluationGroupVO clarificationEvaluationGroupVO : evaluationInfoVoList) {
                clarificationEvaluationGroupVO.setId(null);
                PurchaseClarificationEvaluationPriceRegulationInfo priceRegulationInfo = clarificationEvaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
                if (priceRegulationInfo == null) continue;
                priceRegulationInfo.setBidLetterFieldName("");
                priceRegulationInfo.setBidLetterName("");
                priceRegulationInfo.setQuoteColumnName("");
                priceRegulationInfo.setTenderBidLetterId("");
            }
        }
    }

    private void insertData(PurchaseTenderClarificationInfo tenderClarificationInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(tenderClarificationInfo.getId());
        purchaseAttachmentList.parallelStream().forEach(item -> item.setHeadId(tenderClarificationInfo.getId()));
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
    }

    private void insertAttachment(PurchaseTenderClarificationInfo tenderClarificationInfo, PurchaseClarificationBidLetterFormatGroupVO bidLetterFormatGroupVo, PurchaseClarificationEvaluationPrinciples evaluationPrinciples, List<PurchaseClarificationEvaluationGroupVO> evaluationInfoVoList) {
        this.clarificationBidLetterFormatGroupService.deleteByMainId(tenderClarificationInfo.getId());
        this.clarificationEvaluationPrinciplesService.deleteByMainId(tenderClarificationInfo.getId());
        this.clarificationEvaluationGroupService.deleteByMainId(tenderClarificationInfo.getId());
        if (null != bidLetterFormatGroupVo) {
            bidLetterFormatGroupVo.setSubpackageId(tenderClarificationInfo.getSubpackageId());
            bidLetterFormatGroupVo.setTenderProjectId(tenderClarificationInfo.getTenderProjectId());
            bidLetterFormatGroupVo.setHeadId(tenderClarificationInfo.getAttachmentHeadId());
            bidLetterFormatGroupVo.setClarificationId(tenderClarificationInfo.getId());
            this.clarificationBidLetterFormatGroupService.addTenderBidLetter(bidLetterFormatGroupVo);
        }
        if (null != evaluationPrinciples) {
            evaluationPrinciples.setSubpackageId(tenderClarificationInfo.getSubpackageId());
            evaluationPrinciples.setTenderProjectId(tenderClarificationInfo.getTenderProjectId());
            evaluationPrinciples.setHeadId(tenderClarificationInfo.getAttachmentHeadId());
            evaluationPrinciples.setClarificationId(tenderClarificationInfo.getId());
            this.clarificationEvaluationPrinciplesService.addTenderEvaluationPrinciples(evaluationPrinciples);
        }
        if (CollectionUtil.isNotEmpty(evaluationInfoVoList)) {
            for (PurchaseClarificationEvaluationGroupVO clarificationEvaluationGroupVO : evaluationInfoVoList) {
                clarificationEvaluationGroupVO.setSubpackageId(tenderClarificationInfo.getSubpackageId());
                clarificationEvaluationGroupVO.setTenderProjectId(tenderClarificationInfo.getTenderProjectId());
                clarificationEvaluationGroupVO.setHeadId(tenderClarificationInfo.getAttachmentHeadId());
                clarificationEvaluationGroupVO.setClarificationId(tenderClarificationInfo.getId());
                clarificationEvaluationGroupVO.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
            }
            this.clarificationEvaluationGroupService.addTenderEvaluationInfo(evaluationInfoVoList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderClarificationInfo edit(PurchaseTenderClarificationInfoVO clarificationInfoVO) {
        int count;
        PurchaseTenderClarificationInfo dbClarificationInfo = (PurchaseTenderClarificationInfo)((Object)this.getById((Serializable)((Object)clarificationInfoVO.getId())));
        clarificationInfoVO.setDataVersion(dbClarificationInfo.getDataVersion());
        PurchaseTenderClarificationInfo tenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)SysUtil.copyProperties((Object)((Object)clarificationInfoVO), PurchaseTenderClarificationInfo.class));
        tenderClarificationInfo.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
        if (StringUtils.isBlank((CharSequence)tenderClarificationInfo.getClarificationNumber())) {
            tenderClarificationInfo.setClarificationNumber(this.invokeBaseRpcService.getNextCode("clarificationNumber", (Object)tenderClarificationInfo));
        }
        Assert.isTrue(((count = ((PurchaseTenderClarificationInfoMapper)this.baseMapper).updateById((Object)tenderClarificationInfo)) != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.insertData(tenderClarificationInfo, clarificationInfoVO.getPurchaseAttachmentList());
        return tenderClarificationInfo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        ((PurchaseTenderClarificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.clarificationBidLetterFormatGroupService.deleteByMainId(id);
        this.clarificationEvaluationPrinciplesService.deleteByMainId(id);
        this.clarificationEvaluationGroupService.deleteByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatch(List<String> idList) {
        ((PurchaseTenderClarificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
        for (String id : idList) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
            this.clarificationBidLetterFormatGroupService.deleteByMainId(id);
            this.clarificationEvaluationPrinciplesService.deleteByMainId(id);
            this.clarificationEvaluationGroupService.deleteByMainId(id);
        }
    }

    @Override
    public PurchaseTenderClarificationInfoVO queryById(String id, String subpackageId) {
        PurchaseTenderClarificationInfo tenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)this.getById((Serializable)((Object)id)));
        PurchaseTenderProjectAttachmentHeadVO attachmentHeadVO = this.attachmentHeadService.queryAll(subpackageId);
        PurchaseTenderClarificationInfoVO clarificationInfoVO = (PurchaseTenderClarificationInfoVO)((Object)SysUtil.copyProperties((Object)((Object)tenderClarificationInfo), PurchaseTenderClarificationInfoVO.class));
        if (tenderClarificationInfo == null) {
            clarificationInfoVO = new PurchaseTenderClarificationInfoVO();
            PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(subpackageId);
            if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType())) {
                clarificationInfoVO.setOpenBiddingTime(subpackageInfo.getPreOpenBiddingTime());
                clarificationInfoVO.setFileClarificationEndTime(subpackageInfo.getPreFileClarificationEndTime());
                clarificationInfoVO.setFileSubmitEndTime(subpackageInfo.getPreFileSubmitEndTime());
            } else {
                if (SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(subpackageInfo.getProcessType())) {
                    clarificationInfoVO.setOpenBiddingTime(subpackageInfo.getResultOpenBiddingTime());
                } else {
                    clarificationInfoVO.setOpenBiddingTime(subpackageInfo.getOpenBiddingTime());
                }
                clarificationInfoVO.setFileClarificationEndTime(subpackageInfo.getFileClarificationEndTime());
                clarificationInfoVO.setFileSubmitEndTime(subpackageInfo.getFileSubmitEndTime());
            }
            clarificationInfoVO.setSubpackageId(subpackageId);
            clarificationInfoVO.setTenderProjectId(subpackageInfo.getHeadId());
            clarificationInfoVO.setBiddingDocuments("0");
            clarificationInfoVO.setAttachmentHeadId(attachmentHeadVO.getId());
        }
        this.queryAllAttachment(clarificationInfoVO, attachmentHeadVO);
        List attachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(clarificationInfoVO.getId());
        clarificationInfoVO.setPurchaseAttachmentList(attachmentDTOList);
        return clarificationInfoVO;
    }

    private void queryAllAttachment(PurchaseTenderClarificationInfoVO clarificationInfoVO, PurchaseTenderProjectAttachmentHeadVO attachmentHeadVO) {
        List<PurchaseTenderEvaluationGroupVO> evaluationInfoVoList;
        ArrayList clarificationEvaluationGroupList;
        PurchaseTenderEvaluationPrinciples evaluationPrinciples;
        PurchaseClarificationEvaluationPrinciples clarificationEvaluationPrinciples;
        PurchaseTenderBidLetterFormatGroupVO bidLetterFormatGroupVO;
        PurchaseClarificationBidLetterFormatGroupVO letterFormatGroupVO = this.clarificationBidLetterFormatGroupService.queryBidLetterFormatGroup(clarificationInfoVO.getId());
        if (letterFormatGroupVO == null && (bidLetterFormatGroupVO = attachmentHeadVO.getTenderBidLetterFormatGroupVo()) != null) {
            letterFormatGroupVO = (PurchaseClarificationBidLetterFormatGroupVO)((Object)SysUtil.copyProperties((Object)((Object)bidLetterFormatGroupVO), PurchaseClarificationBidLetterFormatGroupVO.class));
        }
        if ((clarificationEvaluationPrinciples = this.clarificationEvaluationPrinciplesService.queryEvaluationPrinciples(clarificationInfoVO.getId())) == null && (evaluationPrinciples = attachmentHeadVO.getPurchaseTenderEvaluationPrinciples()) != null) {
            clarificationEvaluationPrinciples = (PurchaseClarificationEvaluationPrinciples)((Object)SysUtil.copyProperties((Object)((Object)evaluationPrinciples), PurchaseClarificationEvaluationPrinciples.class));
        }
        if (CollectionUtil.isEmpty(clarificationEvaluationGroupList = this.clarificationEvaluationGroupService.queryEvaluationInfoVo(clarificationInfoVO.getId())) && CollectionUtil.isNotEmpty(evaluationInfoVoList = attachmentHeadVO.getTenderEvaluationInfoVoList())) {
            clarificationEvaluationGroupList = SysUtil.copyProperties(evaluationInfoVoList, PurchaseClarificationEvaluationGroupVO.class);
        }
        if ("0".equals(clarificationInfoVO.getBiddingDocuments())) {
            this.resetAttachementId(letterFormatGroupVO, clarificationEvaluationPrinciples, clarificationEvaluationGroupList);
        }
        clarificationInfoVO.setTenderBidLetterFormatGroupVo(letterFormatGroupVO);
        clarificationInfoVO.setPurchaseTenderEvaluationPrinciples(clarificationEvaluationPrinciples);
        clarificationInfoVO.setTenderEvaluationInfoVoList(clarificationEvaluationGroupList);
        if (letterFormatGroupVO != null && CollectionUtil.isNotEmpty(letterFormatGroupVO.getTenderBidTetterVoList())) {
            Map bidLetterVOMap = letterFormatGroupVO.getTenderBidTetterVoList().stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (o1, o2) -> o1));
            for (PurchaseClarificationEvaluationGroupVO evaluationGroupVO : clarificationEvaluationGroupList) {
                PurchaseClarificationEvaluationPriceRegulationInfo priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
                if (priceRegulationInfo == null) continue;
                String tenderBidLetterId = priceRegulationInfo.getTenderBidLetterId();
                String tenderBidLetterFieldName = priceRegulationInfo.getQuoteColumnName();
                PurchaseTenderClarificationBidLetterVO bidLetterVO = (PurchaseTenderClarificationBidLetterVO)((Object)bidLetterVOMap.get(tenderBidLetterId));
                if (bidLetterVO == null || StringUtils.isBlank((CharSequence)bidLetterVO.getCustomizeFieldModel())) continue;
                priceRegulationInfo.setBidLetterName(bidLetterVO.getName());
                String model = bidLetterVO.getCustomizeFieldModel();
                JSONArray jsonArray = JSONArray.parseArray((String)model);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    if (!jsonObject.containsValue((Object)tenderBidLetterFieldName)) continue;
                    String title = jsonObject.get((Object)"title").toString();
                    priceRegulationInfo.setBidLetterFieldName(title);
                }
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(PurchaseTenderClarificationInfoVO clarificationInfoVO) {
        this.checkParams(clarificationInfoVO);
        clarificationInfoVO.setStatus(TenderClarificationStatusEnum.TO_BE_SENT.getValue());
        if (StringUtils.isBlank((CharSequence)clarificationInfoVO.getId())) {
            this.add(clarificationInfoVO);
        } else {
            this.edit(clarificationInfoVO);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        PurchaseOpenSettingHeadVO purchaseOpenSettingHeadVO;
        PurchaseTenderClarificationInfo tenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)this.getById((Serializable)((Object)id)));
        tenderClarificationInfo.setStatus(TenderClarificationStatusEnum.HAS_BEEN_SENT.getValue());
        tenderClarificationInfo.setPublishTime(new Date());
        this.updateById((Object)tenderClarificationInfo);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = TenderFlagInjectionContext.getSubpackageInfo();
        if (subpackageInfo == null) {
            subpackageInfo = this.subpackageInfoService.selectById(tenderClarificationInfo.getSubpackageId());
            TenderFlagInjectionContext.setTenderProcessType(subpackageInfo.getProcessType());
        }
        if (SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(subpackageInfo.getProcessType())) {
            TenderFlagInjectionContext.setTenderCurrentStep(SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue());
        }
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(openBidStatus), (String)I18nUtil.translate((String)"i18n_alert_APtFIvBxiTtkW_98c23454", (String)"\u5f53\u524d\u5355\u636e\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        PushEventUtils.updateSubpackageInfo(TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)tenderClarificationInfo).subpackageId(tenderClarificationInfo.getSubpackageId()).build());
        this.updateAttachmentInfo(tenderClarificationInfo);
        List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        if ("0".equals(tenderClarificationInfo.getSupplierHadResponseHandlerType())) {
            this.saleTenderPriceOpeningsService.batchRevokeSave(tenderClarificationInfo.getSubpackageId());
        }
        if ("1".equals((purchaseOpenSettingHeadVO = this.openSettingHeadService.queryBySubpackageId(subpackageInfo.getId())).getAutoOpenBid()) && SubpackageBidOpenTypeEnum.ON_LINE.getValue().equals(subpackageInfo.getBidOpenType())) {
            TenderJobUtil.createOrUpdateOpenBidAlertJob(subpackageInfo, tenderClarificationInfo.getOpenBiddingTime());
            TenderJobUtil.createOrUpdateOpenBidForewarningAlertJob(subpackageInfo, tenderClarificationInfo.getOpenBiddingTime());
        }
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOS, tenderClarificationInfo.getId(), tenderClarificationInfo.getSubpackageId(), tenderClarificationInfo.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.CLARIFY_PREFIX.getValue());
        TenderProjectSupplier supplierInfo = new TenderProjectSupplier();
        supplierInfo.setSubpackageId(tenderClarificationInfo.getSubpackageId());
        String operation = "preProposeClarification";
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderClarificationInfo.getCheckType())) {
            operation = "proposeClarification";
            supplierInfo.setPreShortlisted("1");
        }
        List<TenderProjectSupplier> supplierList = this.tenderProjectSupplierService.selectBySubpackageId(supplierInfo, true);
        List toElsAccountList = supplierList.stream().map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(tenderClarificationInfo.getTenderProjectId()).append("&subpackageId=").append(tenderClarificationInfo.getSubpackageId());
        Map params = FastJsonUtils.toMap((Object)tenderClarificationInfo);
        params.put("subpackageName", subpackageInfo.getSubpackageName());
        params.put("tenderProjectName", subpackageInfo.getTenderProjectName());
        String idStr = IdWorker.getIdStr();
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)params));
        jsonObject.put("urlParams", (Object)urlParams);
        this.redisUtil.set("sys:message:" + idStr, (Object)jsonObject, 172800L);
        super.sendMessage(TenantContext.getTenant(), "tender", operation, idStr, "tenderBusDataServiceImpl", toElsAccountList);
    }

    private void updateAttachmentInfo(PurchaseTenderClarificationInfo tenderClarificationInfo) {
        List<PurchaseClarificationEvaluationGroupVO> clarificationEvaluationGroupList;
        PurchaseClarificationEvaluationPrinciples clarificationEvaluationPrinciples;
        if ("0".equals(tenderClarificationInfo.getBiddingDocuments())) {
            return;
        }
        PurchaseTenderClarificationInfoVO clarificationInfoVO = (PurchaseTenderClarificationInfoVO)((Object)SysUtil.copyProperties((Object)((Object)tenderClarificationInfo), PurchaseTenderClarificationInfoVO.class));
        PurchaseTenderProjectAttachmentHeadVO attachmentHeadVO = this.attachmentHeadService.queryAll(clarificationInfoVO.getSubpackageId());
        PurchaseTenderProjectAttachmentHistory attachmentHistory = new PurchaseTenderProjectAttachmentHistory();
        attachmentHistory.setCheckType(attachmentHeadVO.getCheckType());
        attachmentHistory.setSubpackageId(attachmentHeadVO.getSubpackageId());
        attachmentHistory.setTenderProjectId(attachmentHeadVO.getTenderProjectId());
        attachmentHistory.setProcessType(attachmentHeadVO.getProcessType());
        if (attachmentHeadVO.getTenderBidLetterFormatGroupVo() != null) {
            attachmentHistory.setBidLetterFormatGroupHistory(FastJsonUtils.toString((Object)attachmentHeadVO.getTenderBidLetterFormatGroupVo()));
        }
        if (attachmentHeadVO.getPurchaseTenderEvaluationPrinciples() != null) {
            attachmentHistory.setEvaluationPrinciplesHistory(FastJsonUtils.toString((Object)attachmentHeadVO.getPurchaseTenderEvaluationPrinciples()));
        }
        if (CollectionUtil.isNotEmpty(attachmentHeadVO.getTenderEvaluationInfoVoList())) {
            attachmentHistory.setEvaluationInfoHistory(FastJsonUtils.toString(attachmentHeadVO.getTenderEvaluationInfoVoList()));
        }
        this.attachmentHistoryService.save((Object)attachmentHistory);
        this.queryAllAttachment(clarificationInfoVO, attachmentHeadVO);
        PurchaseClarificationBidLetterFormatGroupVO tenderBidLetterFormatGroupVo = clarificationInfoVO.getTenderBidLetterFormatGroupVo();
        if (tenderBidLetterFormatGroupVo != null) {
            PurchaseTenderBidLetterFormatGroupVO bidLetterFormatGroupVO = (PurchaseTenderBidLetterFormatGroupVO)((Object)SysUtil.copyProperties((Object)((Object)tenderBidLetterFormatGroupVo), PurchaseTenderBidLetterFormatGroupVO.class));
            attachmentHeadVO.setTenderBidLetterFormatGroupVo(bidLetterFormatGroupVO);
        }
        if ((clarificationEvaluationPrinciples = clarificationInfoVO.getPurchaseTenderEvaluationPrinciples()) != null) {
            PurchaseTenderEvaluationPrinciples evaluationPrinciples = (PurchaseTenderEvaluationPrinciples)((Object)SysUtil.copyProperties((Object)((Object)clarificationEvaluationPrinciples), PurchaseTenderEvaluationPrinciples.class));
            attachmentHeadVO.setPurchaseTenderEvaluationPrinciples(evaluationPrinciples);
        }
        if (CollectionUtil.isNotEmpty(clarificationEvaluationGroupList = clarificationInfoVO.getTenderEvaluationInfoVoList())) {
            ArrayList evaluationInfoVoList = SysUtil.copyProperties(clarificationEvaluationGroupList, PurchaseTenderEvaluationGroupVO.class);
            attachmentHeadVO.setTenderEvaluationInfoVoList(evaluationInfoVoList);
        }
        this.attachmentHeadService.clarificationUpdateMain(attachmentHeadVO);
        this.controlPriceHeadService.deleteBySubpackageId(tenderClarificationInfo.getSubpackageId());
    }

    @Override
    public void addConfirmNumber(String id) {
        PurchaseTenderClarificationInfo purchaseTenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)((PurchaseTenderClarificationInfoMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        int count = ((PurchaseTenderClarificationInfoMapper)this.baseMapper).addConfirmNumber(id);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    private void checkParams(PurchaseTenderClarificationInfoVO clarificationInfoVO) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(clarificationInfoVO.getSubpackageId());
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(subpackageInfo.getOpenBidStatus()), (String)I18nUtil.translate((String)"i18n_alert_APtFIvBxiTtkW_98c23454", (String)"\u5f53\u524d\u5355\u636e\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(clarificationInfoVO.getCheckType());
        Date fileClarificationEndTime = hasPreTrial ? subpackageInfo.getPreFileClarificationEndTime() : subpackageInfo.getFileClarificationEndTime();
        Assert.isTrue((fileClarificationEndTime != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RxLhxxqhxLVW_24ef02ae", (String)"\u516c\u544a\u672a\u53d1\u5e03\u4e0d\u53ef\u53d1\u5e03\u6f84\u6e05\uff01"));
        Date currentTime = new Date();
        Assert.isTrue((boolean)currentTime.before(fileClarificationEndTime), (String)I18nUtil.translate((String)"i18n_alert_LVyRKIIRWxiThdLVW_2c4c516c", (String)"\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u6f84\u6e05\uff01"));
        Assert.isTrue((clarificationInfoVO.getSubpackageId() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_zsWWxOLVW_7f840617", (String)"\u5206\u5305ID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((clarificationInfoVO.getTenderProjectId() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_dIWWxOLVW_25b07d81", (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((clarificationInfoVO.getFileClarificationEndTime() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_QILVyRKIxOLVW_bdaf9feb", (String)"\u6587\u4ef6\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((clarificationInfoVO.getFileSubmitEndTime() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_QInJyRKIxOLVW_765c493a", (String)"\u6587\u4ef6\u9012\u4ea4\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)clarificationInfoVO.getTitle()), (String)I18nUtil.translate((String)"i18n_field_LVBDxOLVW_ce2de7ff", (String)"\u6f84\u6e05\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)clarificationInfoVO.getContent()), (String)I18nUtil.translate((String)"i18n_alert_LVCcxOLVW_48de447c", (String)"\u6f84\u6e05\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        if ("0".equals(clarificationInfoVO.getBiddingDocuments())) {
            return;
        }
        boolean bidOpenType = SubpackageBidOpenTypeEnum.ON_LINE.getValue().equals(subpackageInfo.getBidOpenType());
        boolean evaluationType = SubpackageEvaBidTypeEnum.ON_LINE.getValue().equals(subpackageInfo.getEvaluationType());
        HashMap<String, String> bidLetterMap = new HashMap<String, String>();
        HashMap<String, String> bidLetterMaterialsMap = new HashMap<String, String>();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        TenderFlagInjectionContext.setTenderProcessType(subpackageInfo.getProcessType());
        if (bidOpenType) {
            this.checkAndSetParamTenderBidLetter(clarificationInfoVO.getTenderBidLetterFormatGroupVo(), bidLetterMap, bidLetterMaterialsMap);
        }
        if (evaluationType) {
            this.checkAndSetParamEvaPrinciples(clarificationInfoVO.getPurchaseTenderEvaluationPrinciples());
            this.checkAndSetParamEvaluationInfo(clarificationInfoVO.getTenderEvaluationInfoVoList(), subpackageInfo, bidLetterMap, bidLetterMaterialsMap);
        }
        TenderFlagInjectionContext.setTenderProcessType(tenderProcessType);
    }

    private void checkAndSetParamEvaluationInfo(@Valid List<PurchaseClarificationEvaluationGroupVO> tenderEvaluationInfoVoList, PurchaseTenderProjectSubpackageInfo subpackageInfo, Map<String, String> bidTeeterMap, Map<String, String> bidTeeterMaterialsMap) {
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(tenderEvaluationInfoVoList), (String)I18nUtil.translate((String)"i18n_field_UBrhsSyVVHxOLVW_9a786845", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d\u73af\u8282\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        String processType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(checkType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(subpackageInfo.getProcessType())) {
            Set currentStepList = tenderEvaluationInfoVoList.stream().map(PurchaseTenderEvaluationGroup::getCurrentStep).collect(Collectors.toSet());
            Assert.isTrue((boolean)currentStepList.contains(SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue()), (String)I18nUtil.translate((String)"i18n_field_UBrhsSyVnIxUBVHxOLVW_7263c8ad", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d\u73af\u8282\u7ec4\u7b2c\u4e00\u6b65\u8bc4\u6807\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)currentStepList.contains(SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue()), (String)I18nUtil.translate((String)"i18n_field_UBrhsSyVnxxUBVHxOLVW_df758a39", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d\u73af\u8282\u7ec4\u7b2c\u4e8c\u6b65\u8bc4\u6807\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        HashMap priceRegulationMap = new HashMap();
        tenderEvaluationInfoVoList.stream().forEach(evaluationGroupVo -> {
            if ("1".equals(checkType) && "1".equals(processType)) {
                Assert.hasText((String)evaluationGroupVo.getCurrentStep(), (String)I18nUtil.translate((String)"i18n_field_UBrhsWWWWWWSyIUUyOxOLVW_11480d2e", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u8bc4\u5ba1\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
            }
            List<PurchaseClarificationEvaluationRegulationInfo> evaluationRegulationInfoList = evaluationGroupVo.getTenderEvaluationTemplateRegulationInfoList();
            PurchaseClarificationEvaluationPriceRegulationInfo evaluationPriceRegulationInfo = evaluationGroupVo.getTenderEvaluationTemplatePriceRegulationInfo();
            if (CollectionUtils.isEmpty(evaluationRegulationInfoList) && null == evaluationPriceRegulationInfo) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_field_UBrhsWWWWWWSyIlTjITTvWSWzRtdVHW_a9f1b4d4", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u5fc5\u987b\u6709\u4e00\u6761\u6761\u4f8b \u6216 \u5206\u503c\u8ba1\u7b97\u4fe1\u606f!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
            }
            if ("0".equals(checkType) && evaluationPriceRegulationInfo != null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_field_APYBQILUUWUBrhsWWWWWWSyIxOLHcumztdW_cc088680", (String)"\u5f53\u524d\u62db\u6807\u6587\u4ef6\u4e3a\u9884\u5ba1 \u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u4e0d\u80fd\u4e3a\u8fdb\u884c\u4ef7\u683c\u5206\u8ba1\u7b97!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
            }
            if (evaluationPriceRegulationInfo != null) {
                String[] params;
                String bidLetterType;
                String quoteColumnName;
                String tenderBidLetterId = evaluationPriceRegulationInfo.getTenderBidLetterId();
                Object checkExist = bidTeeterMap.get(tenderBidLetterId + "_" + (quoteColumnName = evaluationPriceRegulationInfo.getQuoteColumnName()));
                if (null == checkExist) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_field_UBrhsWWWWWWSyIdRKjsuAxMKVImW_d865a267", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u6240\u5173\u8054\u7684\u62a5\u4ef7\u5217\u4e0d\u5b58\u5728\u8bf7\u68c0\u67e5!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
                }
                priceRegulationMap.put(tenderBidLetterId + "_" + quoteColumnName, null);
                if ("1".equals(checkType) && "1".equals(processType) && "0".equals(currentStep) && !(bidLetterType = (params = ((String)bidTeeterMap.get(tenderBidLetterId + "_" + quoteColumnName)).split("_"))[2]).equals(evaluationGroupVo.getCurrentStep())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_field_UBrhsWWWWWWSyIjUUyOniFjeBxAcxIRW_d77783aa", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u7684\u8bc4\u5ba1\u9636\u6bb5\u548c\u9009\u62e9\u7684\u6295\u6807\u51fd\u7c7b\u578b\u4e0d\u4e00\u81f4!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
                }
                String pricePointsCalFormula = evaluationPriceRegulationInfo.getPricePointsCalFormula();
                if ((PricePointsCalFormualEnum.OPERATION_MIN_PRICE_STRATEGY.equals(pricePointsCalFormula) || PricePointsCalFormualEnum.OPERATION_MIN_PRICE_POSITIVE_DEVIATION_STRATEGY.equals(pricePointsCalFormula)) && !"0".equals(evaluationPriceRegulationInfo.getBaseCalRules())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_field_UBrhsWWWWWWSyItdRKLenuEltdWenuiOvjWtruROiFenuW_12f80d5a", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u8ba1\u7b97\u516c\u5f0f\u4e3a\u6700\u4f4e\u4ef7\u7b49\u6bd4\u8ba1\u7b97,\u6700\u4f4e\u4ef7\u8bc1\u504f\u79bb\u7684 \u57fa\u51c6\u4ef7\u53ea\u80fd\u9009\u62e9\u6700\u4f4e\u4ef7!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
                }
            }
        });
        for (String bidTeeterKey : bidTeeterMap.keySet()) {
            boolean flag = false;
            for (String key : priceRegulationMap.keySet()) {
                if (!bidTeeterKey.equals(key)) continue;
                flag = true;
                break;
            }
            String bidLeeterInfo = bidTeeterMap.get(bidTeeterKey);
            String[] infoList = bidLeeterInfo.split("_");
            if (flag) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxWWWWWWIjWWWWWWLsuAWTPKUBrhsumUUdIHcyIW_7ac50de7", (String)"\u6295\u6807\u51fd[${0}]\u4e0b\u7684[${1}]\u4e3a\u62a5\u4ef7\u5217,\u9700\u8981\u5728\u8bc4\u6807\u529e\u6cd5\u4e2d\u4ef7\u683c\u8bc4\u5ba1\u9879\u4e0b\u8fdb\u884c\u7ed1\u5b9a!", (String[])new String[]{infoList[0], infoList[1]}));
        }
    }

    private void checkAndSetParamEvaPrinciples(PurchaseClarificationEvaluationPrinciples tenderEvaluationPrinciples) {
        Assert.hasText((String)tenderEvaluationPrinciples.getReviewSummaryRules(), (String)I18nUtil.translate((String)"i18n_alert_UUMkLFxiTLVW_b674dec3", (String)"\u8bc4\u5ba1\u6c47\u603b\u89c4\u5219\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        Assert.hasText((String)tenderEvaluationPrinciples.getSummaryCalType(), (String)I18nUtil.translate((String)"i18n_alert_MktdCKxiTLVW_5be8629d", (String)"\u6c47\u603b\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        Assert.hasText((String)tenderEvaluationPrinciples.getSummaryScorePrecision(), (String)I18nUtil.translate((String)"i18n_alert_MkzROzxiTLVW_7647f92f", (String)"\u6c47\u603b\u5206\u503c\u7cbe\u5ea6\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        if ("0".equals(checkType) || "1".equals(checkType) && "1".equals(currentStep)) {
            String shortlistedRules = tenderEvaluationPrinciples.getShortlistedRules();
            Assert.hasText((String)shortlistedRules, (String)I18nUtil.translate((String)"i18n_alert_UBjFsVRiNLLF_e0a4e3d6", (String)"\u8bc4\u6807\u539f\u5219\u4e2d\u8bf7\u52fe\u9009\u5165\u56f4\u89c4\u5219!"));
            if ((ShortlistedRulesEnum.SCORE_RANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules) || ShortlistedRulesEnum.SCOREANDAGGREGATE_RANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules) || ShortlistedRulesEnum.SCOREORAGGREGATE_RANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules)) && null == tenderEvaluationPrinciples.getScoreRanking()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UBjFsjzARxOLVWVImW_ed7bdbe7", (String)"\u8bc4\u6807\u539f\u5219\u4e2d\u5f97\u5206\u6392\u540d\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!"));
            }
            if ((ShortlistedRulesEnum.AGGREGATE_SCORERANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules) || ShortlistedRulesEnum.SCOREANDAGGREGATE_RANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules) || ShortlistedRulesEnum.SCOREORAGGREGATE_RANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules)) && null == tenderEvaluationPrinciples.getSummaryScore()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UBjFsMkszxOLVWVImW_6f78f32e", (String)"\u8bc4\u6807\u539f\u5219\u4e2d\u6c47\u603b\u5f97\u5206\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!"));
            }
        }
    }

    private void checkAndSetParamTenderBidLetter(PurchaseClarificationBidLetterFormatGroupVO tenderBidLetterFormatGroupVo, Map<String, String> bidTeeterMap, Map<String, String> bidLetterMaterialsMap) {
        if ("1".equals(TenderFlagInjectionContext.getTenderCheckType())) {
            Assert.hasText((String)tenderBidLetterFormatGroupVo.getQuoteType(), (String)I18nUtil.translate((String)"i18n_alert_suAcxiTLV_5d905242", (String)"\u62a5\u4ef7\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
            Assert.hasText((String)tenderBidLetterFormatGroupVo.getQuotations(), (String)I18nUtil.translate((String)"i18n_alert_suCKxiTLVW_d4501fa5", (String)"\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        }
        List<PurchaseTenderClarificationBidLetterVO> tenderBidLetterVoList = tenderBidLetterFormatGroupVo.getTenderBidTetterVoList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(tenderBidLetterVoList), (String)I18nUtil.translate((String)"i18n_alert_eBxABxiTLVW_14c9a259", (String)"\u6295\u6807\u51fd\u5217\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(tenderBidLetterFormatGroupVo.getQuoteType())) {
            List quoteBidLetterList = tenderBidLetterVoList.stream().filter(bidLetterVO -> "1".equals(bidLetterVO.getQuoteBidLetter())).collect(Collectors.toList());
            if (CollectionUtil.size(quoteBidLetterList) > 1) {
                List bidLetterNameList = quoteBidLetterList.stream().map(PurchaseTenderBidLetter::getName).collect(Collectors.toList());
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxABWWWWWeKMKsuAW_cdc5fb13", (String)"\u6295\u6807\u51fd\u5217\u8868\u3010{0}\u3011\u540c\u65f6\u5b58\u5728\u62a5\u4ef7\u5217!", (String[])new String[]{StringUtils.join(bidLetterNameList, (String)",")}));
            }
            if (CollectionUtil.size(quoteBidLetterList) == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxABLGRsuAW_282c525a", (String)"\u6295\u6807\u51fd\u5217\u8868\u672a\u8bbe\u7f6e\u62a5\u4ef7\u5217!"));
            }
        }
        HashMap<String, Integer> bidTetterTypeMap = new HashMap<String, Integer>();
        for (PurchaseTenderClarificationBidLetterVO bidTetterVo : tenderBidLetterVoList) {
            if (bidTetterTypeMap.containsKey(bidTetterVo.getFormatType())) {
                bidTetterTypeMap.put(bidTetterVo.getFormatType(), (Integer)bidTetterTypeMap.get(bidTetterVo.getFormatType()) + 1);
            } else {
                bidTetterTypeMap.put(bidTetterVo.getFormatType(), 1);
            }
            bidTetterVo.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
            PurchaseClarificationPriceOpeningsTemplate priceOpeningsList = bidTetterVo.getPriceOpenings();
            if (null == priceOpeningsList) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWWWumIBBxiTLVW_1c5045e1", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}] ,\u4ef7\u683c\u4e00\u89c8\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName()}));
            }
            String customizeFieldModel = priceOpeningsList.getCustomizeFieldModel();
            if (null == customizeFieldModel || "[]".equals(customizeFieldModel)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWWWumIBBeVHxiTLVW_8065107b", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}] ,\u4ef7\u683c\u4e00\u89c8\u8868\u5934\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName()}));
            }
            String customizeFieldData = priceOpeningsList.getCustomizeFieldData();
            if (null == customizeFieldData || "[]".equals(customizeFieldData)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWWWumIBBABVHxiTLVW_31011e40", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}] ,\u4ef7\u683c\u4e00\u89c8\u8868\u5217\u8868\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName()}));
            }
            List customColumnModelList = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
            JSONArray dataJsonArray = JSONArray.parseArray((String)customizeFieldData);
            int materialCount = 0;
            int bidTeeterCount = 0;
            for (CustomColumnModel customColumnModel : customColumnModelList) {
                if ("1".equals(customColumnModel.getMust()) && "1".equals(customColumnModel.getInputOrg())) {
                    for (int i = 0; i < dataJsonArray.size(); ++i) {
                        JSONObject jsonObject = dataJsonArray.getJSONObject(i);
                        if (null != jsonObject.get((Object)customColumnModel.getField()) && !"".equals(jsonObject.get((Object)customColumnModel.getField()))) continue;
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWsWWWWWWAKYBtLlSdxiTLVW_5c4d8733", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}]\u4e2d[${1}]\u5217\u662f\u62db\u6807\u5355\u4f4d\u5fc5\u586b\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName(), customColumnModel.getTitle()}));
                    }
                }
                if (!CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(customColumnModel.getFieldCategory())) continue;
                bidTeeterMap.put(bidTetterVo.getId() + "_" + customColumnModel.getField(), bidTetterVo.getName() + "_" + customColumnModel.getTitle() + "_" + bidTetterVo.getFormatType());
                ++bidTeeterCount;
            }
            if (materialCount <= 0 || bidTeeterCount <= true) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxWWWWWWsMKSLAKeOROGRImsuAW_82714aa6", (String)"\u6295\u6807\u51fd[${0}]\u4e2d\u5b58\u5728\u7269\u6599\u5217\u65f6\u6700\u591a\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u62a5\u4ef7\u5217!", (String[])new String[]{bidTetterVo.getName()}));
        }
        Integer oneCount = (Integer)bidTetterTypeMap.get(BidLetterFormatTypeEnum.BID_OPENING_PREVIEW_FORM.getValue());
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType())) {
            if (SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(TenderFlagInjectionContext.getTenderProcessType())) {
                Integer twoCount = (Integer)bidTetterTypeMap.get(BidLetterFormatTypeEnum.RESULT_FORMAT_TYPE.getValue());
                Assert.isTrue((oneCount != null && twoCount != null && oneCount > 0 && twoCount > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RxhjYBQIWTPjIxhvBIBBnRxhvBIBBW_be1ae10c", (String)"\u4e24\u6b65\u6cd5\u7684\u62db\u6807\u6587\u4ef6 \u9700\u8981\u6709\u4e00\u6b65\u6cd5\u5f00\u6807\u4e00\u89c8\u8868\u548c\u4e24\u6b65\u6cd5\u5f00\u6807\u4e00\u89c8\u8868!"));
            } else {
                Assert.isTrue((oneCount != null && oneCount > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vBIBBxMKVImW_5233ec09", (String)"\u5f00\u6807\u4e00\u89c8\u8868\u4e0d\u5b58\u5728\u8bf7\u68c0\u67e5!"));
            }
        } else {
            Assert.isTrue((oneCount != null && oneCount > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UUvBIBBxMKVImW_bfd3c26", (String)"\u9884\u5ba1\u5f00\u6807\u4e00\u89c8\u8868\u4e0d\u5b58\u5728\u8bf7\u68c0\u67e5!"));
        }
    }
}

