/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.aspect;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.tender.common.aspect.ValidatedTenderStatus;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order
public class ValidatedTenderStatusAspect {
    private static final Logger log = LoggerFactory.getLogger(ValidatedTenderStatusAspect.class);

    @Pointcut(value="@annotation(com.els.modules.tender.common.aspect.ValidatedTenderStatus)")
    public void validatedPointCut() {
    }

    @Around(value="validatedPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = TenderFlagInjectionContext.getSubpackageInfo();
        if (subpackageInfo != null) {
            TenderProjectSubpackageStatusEnum[] subpackageStatusEnums;
            MethodSignature signature = (MethodSignature)point.getSignature();
            Method method = signature.getMethod();
            ValidatedTenderStatus validatedTenderStatus = method.getAnnotation(ValidatedTenderStatus.class);
            for (TenderProjectSubpackageStatusEnum subpackageStatusEnum : subpackageStatusEnums = validatedTenderStatus.value()) {
                if (subpackageStatusEnum.getValue() != subpackageInfo.getStatus().intValue()) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzszELWWWWWWWxiTHEAPtkW_5491347a", (String)"\u5f53\u524d\u5206\u5305\u72b6\u6001\u4e3a\u3010{0}\u3011, \u4e0d\u5141\u8bb8\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01", (String[])new String[]{subpackageStatusEnum.getDesc()}));
            }
        }
        return point.proceed();
    }
}

