/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.process.entity.TenderProcessNode;
import com.els.modules.tender.process.service.TenderProcessNodeService;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenderFlagInjectionInterceptor
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TenderFlagInjectionInterceptor.class);
    private static final String X_NODE_ID = "xNodeId";
    private static final String CHECK_TYPE = "checkType";
    private static final String PROCESS_TYPE = "processType";
    private static final String CURRENT_STEP = "currentStep";
    private static final String SUBPACKAGE_ID = "subpackageId";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private void doHandler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String currentStep;
        String processType;
        boolean flag = false;
        String checkType = request.getParameter(CHECK_TYPE);
        if (StringUtils.isNotBlank((CharSequence)checkType)) {
            TenderFlagInjectionContext.setTenderCheckType(checkType);
            flag = true;
        }
        if (StringUtils.isNotBlank((CharSequence)(processType = request.getParameter(PROCESS_TYPE)))) {
            TenderFlagInjectionContext.setTenderProcessType(processType);
            flag = true;
        }
        if (StringUtils.isNotBlank((CharSequence)(currentStep = request.getParameter(CURRENT_STEP)))) {
            TenderFlagInjectionContext.setTenderCurrentStep(currentStep);
            flag = true;
        }
        String nodeId = request.getHeader(X_NODE_ID);
        log.info("\u62db\u6807\u9879\u76ee\uff1a\u81ea\u52a8\u6ce8\u5165\u9884\u5ba1\u548c\u4e00\u6b65\u6cd5\u3001\u4e24\u6b65\u6cd5\u62e6\u622a\u5668\u8fdb\u5165\uff01\u53c2\u6570nodeId:{}", (Object)nodeId);
        if (StringUtils.isNotBlank((CharSequence)nodeId) && !flag) {
            try {
                if (nodeId.indexOf("_") == -1) {
                    TenderProcessNodeService nodeService = (TenderProcessNodeService)SpringContextUtils.getBean(TenderProcessNodeService.class);
                    TenderProcessNode processNode = (TenderProcessNode)((Object)nodeService.getById((Serializable)((Object)nodeId)));
                    if (processNode != null && StringUtils.isNotBlank((CharSequence)processNode.getExtend())) {
                        JSONObject jsonObject = JSON.parseObject((String)processNode.getExtend());
                        log.info("\u83b7\u53d6\u8282\u70b9\u6269\u5c55\u53c2\u6570:{}", (Object)processNode.getExtend());
                        checkType = jsonObject.getString(CHECK_TYPE);
                        processType = jsonObject.getString(PROCESS_TYPE);
                        if (jsonObject.containsKey((Object)CURRENT_STEP) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(processType)) {
                            currentStep = jsonObject.getString(CURRENT_STEP);
                        }
                    }
                } else {
                    String[] splits = nodeId.split("_");
                    checkType = splits[0];
                    if (splits.length > 1) {
                        processType = splits[1];
                    }
                    if (splits.length > 2 && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(splits[1])) {
                        currentStep = splits[2];
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)checkType)) {
                    TenderFlagInjectionContext.setTenderCheckType(checkType);
                }
                if (StringUtils.isNotBlank((CharSequence)processType)) {
                    TenderFlagInjectionContext.setTenderProcessType(processType);
                }
                if (StringUtils.isNotBlank((CharSequence)currentStep)) {
                    TenderFlagInjectionContext.setTenderCurrentStep(currentStep);
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u8282\u70b9\u6269\u5c55\u53c2\u6570\u5f02\u5e38{}", (Object)e.getMessage());
            }
        }
        if (request instanceof TenderRequestWrapper) {
            TenderRequestWrapper requestWrapper;
            String body;
            String subpackageId = request.getParameter(SUBPACKAGE_ID);
            if (StringUtils.isBlank((CharSequence)subpackageId) && StringUtils.isNotBlank((CharSequence)(body = (requestWrapper = (TenderRequestWrapper)request).getBody()))) {
                try {
                    JsonNode jsonNode = MAPPER.readTree(body);
                    subpackageId = jsonNode.findValue(SUBPACKAGE_ID).asText();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)subpackageId)) {
                PurchaseTenderProjectSubpackageInfoService subpackageInfoService = (PurchaseTenderProjectSubpackageInfoService)SpringContextUtils.getBean(PurchaseTenderProjectSubpackageInfoService.class);
                PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)subpackageInfoService.getById((Serializable)((Object)subpackageId)));
                TenderFlagInjectionContext.setTenderProcessType(subpackageInfo.getProcessType());
                TenderFlagInjectionContext.setSubpackageInfo(subpackageInfo);
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        TenderRequestWrapper requestWrapper = null;
        if (servletRequest instanceof HttpServletRequest) {
            requestWrapper = new TenderRequestWrapper((HttpServletRequest)servletRequest);
        }
        try {
            this.doHandler((HttpServletRequest)requestWrapper, (HttpServletResponse)servletResponse);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (null == requestWrapper) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
        }
        log.info("\u62db\u6807\u9879\u76ee\uff1a\u81ea\u52a8\u6ce8\u5165\u9884\u5ba1\u548c\u4e00\u6b65\u6cd5\u3001\u4e24\u6b65\u6cd5\u62e6\u622a\u5668\u9000\u51fa\uff01");
        TenderFlagInjectionContext.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBodyString(ServletRequest request) {
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = request.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public class TenderRequestWrapper
    extends HttpServletRequestWrapper {
        private String mBody;

        public TenderRequestWrapper(HttpServletRequest request) {
            super(request);
            this.mBody = this.getBody(request);
        }

        private String getBody(HttpServletRequest request) {
            return TenderFlagInjectionInterceptor.this.getBodyString((ServletRequest)request);
        }

        public String getBody() {
            return this.mBody;
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream bais = new ByteArrayInputStream(this.mBody.getBytes(StandardCharsets.UTF_8));
            return new ServletInputStream(){

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() throws IOException {
                    return bais.read();
                }
            };
        }
    }
}

