/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.common.aspect.ValidatedTenderStatus;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectJuryHead;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectJuryMemberRecord;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectJuryHeadService;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectJuryHeadVO;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/jury/purchaseTenderProjectJuryHead"})
@Api(tags={"\u6295\u6807\u5927\u5385-\u8bc4\u59d4\u4f1a-\u57fa\u672c\u4fe1\u606f"})
public class PurchaseTenderProjectJuryHeadController
extends BaseController<PurchaseTenderProjectJuryHead, PurchaseTenderProjectJuryHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectJuryHeadController.class);
    @Autowired
    private PurchaseTenderProjectJuryHeadService juryHeadService;

    @AutoLog(busModule="\u6295\u6807\u5927\u5385-\u8bc4\u59d4\u4f1a-\u57fa\u672c\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:add"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> add(@RequestBody PurchaseTenderProjectJuryHeadVO purchaseTenderProjectJuryHeadPage) {
        PurchaseTenderProjectJuryHead purchaseTenderProjectJuryHead = new PurchaseTenderProjectJuryHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectJuryHeadPage), (Object)((Object)purchaseTenderProjectJuryHead));
        this.juryHeadService.saveMain(purchaseTenderProjectJuryHead, purchaseTenderProjectJuryHeadPage.getPurchaseTenderProjectJuryMemberList(), purchaseTenderProjectJuryHeadPage.getJuryMemberRecordList(), purchaseTenderProjectJuryHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseTenderProjectJuryHead));
    }

    @AutoLog(busModule="\u6295\u6807\u5927\u5385-\u8bc4\u59d4\u4f1a-\u57fa\u672c\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> edit(@RequestBody PurchaseTenderProjectJuryHeadVO purchaseTenderProjectJuryHeadPage) {
        PurchaseTenderProjectJuryHead purchaseTenderProjectJuryHead = new PurchaseTenderProjectJuryHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectJuryHeadPage), (Object)((Object)purchaseTenderProjectJuryHead));
        this.juryHeadService.updateMain(purchaseTenderProjectJuryHead, purchaseTenderProjectJuryHeadPage.getPurchaseTenderProjectJuryMemberList(), purchaseTenderProjectJuryHeadPage.getJuryMemberRecordList(), purchaseTenderProjectJuryHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u7ec4\u59d4\u4f1a\u4fe1\u606f", notes="\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u7ec4\u59d4\u4f1a\u4fe1\u606f")
    @GetMapping(value={"/queryByCondition"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryByCondition(PurchaseTenderProjectJuryHead juryHead) {
        PurchaseTenderProjectJuryHeadVO vo = this.juryHeadService.queryByCondition(juryHead);
        return Result.ok((Object)((Object)vo));
    }

    @AutoLog(busModule="\u6295\u6807\u5927\u5385-\u8bc4\u59d4\u4f1a-\u57fa\u672c\u4fe1\u606f", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> publish(@RequestBody PurchaseTenderProjectJuryHeadVO purchaseTenderProjectJuryHeadPage) {
        PurchaseTenderProjectJuryHead purchaseTenderProjectJuryHead = new PurchaseTenderProjectJuryHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectJuryHeadPage), (Object)((Object)purchaseTenderProjectJuryHead));
        this.juryHeadService.saveOrUpdatePublish(purchaseTenderProjectJuryHead, purchaseTenderProjectJuryHeadPage.getPurchaseTenderProjectJuryMemberList(), purchaseTenderProjectJuryHeadPage.getJuryMemberRecordList(), purchaseTenderProjectJuryHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6295\u6807\u5927\u5385-\u8bc4\u59d4\u4f1a-\u53d8\u66f4", value="\u6295\u6807\u5927\u5385-\u8bc4\u59d4\u4f1a-\u53d8\u66f4")
    @ApiOperation(value="\u53d8\u66f4", notes="\u53d8\u66f4")
    @PostMapping(value={"/change"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> change(@RequestBody PurchaseTenderProjectJuryHeadVO purchaseTenderProjectJuryHeadPage) {
        PurchaseTenderProjectJuryHead purchaseTenderProjectJuryHead = new PurchaseTenderProjectJuryHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectJuryHeadPage), (Object)((Object)purchaseTenderProjectJuryHead));
        this.juryHeadService.change(purchaseTenderProjectJuryHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6", value="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6")
    @ApiOperation(value="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6", notes="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6")
    @PostMapping(value={"/extract/specialist"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> extractSpecialist(@RequestBody PurchaseTenderProjectJuryHeadVO juryHeadVO) {
        PurchaseTenderProjectJuryHead purchaseTenderProjectJuryHead = new PurchaseTenderProjectJuryHead();
        BeanUtils.copyProperties((Object)((Object)juryHeadVO), (Object)((Object)purchaseTenderProjectJuryHead));
        List<PurchaseTenderProjectJuryMemberRecord> memberRecordList = this.juryHeadService.extractSpecialist(purchaseTenderProjectJuryHead, juryHeadVO.getPurchaseTenderProjectJuryMemberList(), juryHeadVO.getJuryConditionList(), juryHeadVO.getPurchaseAttachmentList());
        return Result.ok(memberRecordList);
    }

    @AutoLog(busModule="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6(\u786e\u8ba4\u53c2\u52a0)", value="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6(\u786e\u8ba4\u53c2\u52a0)")
    @ApiOperation(value="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6(\u786e\u8ba4\u53c2\u52a0)", notes="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6(\u786e\u8ba4\u53c2\u52a0)")
    @PostMapping(value={"/extract/specialist/confirmed"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> extractSpecialistConfirmed(@RequestBody PurchaseTenderProjectJuryMemberRecord juryMemberRecord) {
        this.juryHeadService.extractSpecialistConfirmed(juryMemberRecord);
        return Result.ok();
    }

    @AutoLog(busModule="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6(\u62d2\u7edd\u53c2\u52a0)", value="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6(\u62d2\u7edd\u53c2\u52a0)")
    @ApiOperation(value="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6(\u62d2\u7edd\u53c2\u52a0)", notes="\u7ec4\u59d4\u4f1a-\u4e13\u5bb6\u62bd\u53d6(\u62d2\u7edd\u53c2\u52a0)")
    @PostMapping(value={"/extract/specialist/reject"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> extractSpecialistReject(@RequestBody PurchaseTenderProjectJuryMemberRecord juryMemberRecord) {
        this.juryHeadService.extractSpecialistReject(juryMemberRecord);
        return Result.ok();
    }
}

