/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.bidding.entity.SaleMentoringHead;
import com.els.modules.bidding.entity.SaleMentoringItem;
import com.els.modules.bidding.service.SaleMentoringHeadService;
import com.els.modules.bidding.service.SaleMentoringItemService;
import com.els.modules.bidding.vo.SaleMentoringHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/saleMentoringHead"})
@Api(tags={"\u9500\u552e\u65b9\u7b54\u7591\u4fe1\u606f\u5934"})
public class SaleMentoringHeadController
extends BaseController<SaleMentoringHead, SaleMentoringHeadService> {
    @Autowired
    private SaleMentoringHeadService saleMentoringHeadService;
    @Autowired
    private SaleMentoringItemService saleMentoringItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"bidding#saleMentoringHead:list"})
    public Result<?> queryPageList(SaleMentoringHead saleMentoringHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleMentoringHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleMentoringHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u9500\u552e\u65b9\u7b54\u7591\u4fe1\u606f\u5934-\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#saleMentoringHead:add"})
    public Result<?> add(@RequestBody SaleMentoringHeadVO saleMentoringHeadPage) {
        SaleMentoringHead saleMentoringHead = new SaleMentoringHead();
        BeanUtils.copyProperties((Object)((Object)saleMentoringHeadPage), (Object)((Object)saleMentoringHead));
        this.saleMentoringHeadService.saveMain(saleMentoringHead, saleMentoringHeadPage.getPurchaseMentoringItemList(), saleMentoringHeadPage.getAttachments());
        return Result.ok((Object)((Object)saleMentoringHead));
    }

    @AutoLog(value="\u9500\u552e\u65b9\u7b54\u7591\u4fe1\u606f\u5934-\u7f16\u8f91", operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"bidding#saleMentoringHead:edit"})
    @SrmValidated
    public Result<?> edit(@RequestBody SaleMentoringHeadVO saleMentoringHeadPage) {
        SaleMentoringHead saleMentoringHead = new SaleMentoringHead();
        BeanUtils.copyProperties((Object)((Object)saleMentoringHeadPage), (Object)((Object)saleMentoringHead));
        this.saleMentoringHeadService.updateMain(saleMentoringHead, saleMentoringHeadPage.getPurchaseMentoringItemList(), saleMentoringHeadPage.getAttachments());
        String id = saleMentoringHead.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u9500\u552e\u65b9\u7b54\u7591\u4fe1\u606f\u5934-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"bidding#saleMentoringHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleMentoringHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u65b9\u7b54\u7591\u4fe1\u606f\u5934-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"bidding#saleMentoringHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.saleMentoringHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"bidding#saleMentoringHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleMentoringHead saleMentoringHead = (SaleMentoringHead)((Object)this.saleMentoringHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleMentoringHeadVO saleMentoringHeadVO = new SaleMentoringHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleMentoringHead), (Object)((Object)saleMentoringHeadVO));
        List<SaleMentoringItem> saleMentoringItemList = this.saleMentoringItemService.selectByMainId(id);
        saleMentoringHeadVO.setPurchaseMentoringItemList(saleMentoringItemList);
        List attachments = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleMentoringHeadVO.setAttachments(attachments);
        return Result.ok((Object)((Object)saleMentoringHeadVO));
    }

    private String replaceFileNameDashed(String val) {
        String[] strArr = val.split("-");
        if (strArr.length < 3) {
            return val;
        }
        String id = strArr[0];
        return id + "-" + val.replaceAll(id + "-", "").replaceAll("-", "_");
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u65b9\u7b54\u7591\u4fe1\u606f\u5934id\u67e5\u8be2\u9500\u552e\u65b9\u7b54\u7591\u4fe1\u606f\u884c", notes="\u901a\u8fc7\u9500\u552e\u65b9\u7b54\u7591\u4fe1\u606f\u5934id\u67e5\u8be2\u9500\u552e\u65b9\u7b54\u7591\u4fe1\u606f\u884c")
    @GetMapping(value={"/querySaleMentoringItemByMainId"})
    @RequiresPermissions(value={"bidding#saleMentoringHead:queryById"})
    public Result<?> querySaleMentoringItemListByMainId(@RequestParam(name="id") String id) {
        List<SaleMentoringItem> saleMentoringItemList = this.saleMentoringItemService.selectByMainId(id);
        return Result.ok(saleMentoringItemList);
    }

    @AutoLog(value="\u5c06\u672a\u8bfb\u6570\u636e\u6570\u636e\u8bbe\u7f6e\u4e3a\u5df2\u8bfb", operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/handleUnreadData"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#saleMentoringHead:edit"})
    public Result<?> handleUnreadData(@RequestBody SaleMentoringItem saleMentoringItem) {
        saleMentoringItem.setViewStatus("1");
        this.saleMentoringItemService.updateById((Object)saleMentoringItem);
        SaleMentoringHead mentoringHead = (SaleMentoringHead)((Object)this.saleMentoringHeadService.getById((Serializable)((Object)saleMentoringItem.getHeadId())));
        mentoringHead.setUnreadTimes(mentoringHead.getUnreadTimes() - 1);
        this.saleMentoringHeadService.updateById((Object)mentoringHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u65b9\u7b54\u7591\u4fe1\u606f\u5934-\u63d0\u4ea4", operateType=3)
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#saleMentoringHead:submit"})
    public Result<?> submit(@RequestBody SaleMentoringHeadVO saleMentoringHeadPage) {
        SaleMentoringHead saleMentoringHead = new SaleMentoringHead();
        BeanUtils.copyProperties((Object)((Object)saleMentoringHeadPage), (Object)((Object)saleMentoringHead));
        this.saleMentoringHeadService.submit(saleMentoringHead, saleMentoringHeadPage.getAttachments());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(SaleMentoringHead saleMentoringHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleMentoringHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"submit_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"submit_status");
        List list = ((SaleMentoringHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleMentoringHead::getSubmitStatus, SaleMentoringHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "submitStatus", null, all));
        List srmRequestStatus = this.invokeBaseRpcService.queryDictItemsByCode("submitStatus", TenantContext.getTenant());
        for (DictDTO status : srmRequestStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "submitStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

