/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.utils;

import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.enumerate.RiskTypeEnum;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.inquiry.utils.IpV4Util;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingSupplierLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareIPUtils {
    private static final Logger log = LoggerFactory.getLogger(CompareIPUtils.class);

    public static void compareBiddingIp(String sourceAccountIp, String targetAccountIp, Map<String, PurchaseBiddingItem> supplierMap, List<SupplierRelationFindResultVO> result) {
        String sourceAccount = sourceAccountIp.split("_")[0];
        String targetAccount = targetAccountIp.split("_")[0];
        String sourceIp = sourceAccountIp.split("_")[1];
        String targetIp = targetAccountIp.split("_")[1];
        Map<String, List<SupplierRelationFindResultVO>> resultMap = null;
        if (result != null && result.size() > 0) {
            resultMap = result.stream().collect(Collectors.groupingBy(o -> o.getSourceName() + ":" + o.getToName() + ":" + o.getType() + ":" + o.getResult()));
        }
        if (IpV4Util.isSameAddress(sourceIp, targetIp)) {
            PurchaseBiddingItem sourceSupplier = supplierMap.get(sourceAccount);
            PurchaseBiddingItem targetSupplier = supplierMap.get(targetAccount);
            SupplierRelationFindResultVO vo = new SupplierRelationFindResultVO();
            vo.setSourceName(sourceSupplier.getSupplierName());
            vo.setToName(targetSupplier.getSupplierName());
            vo.setType(RiskTypeEnum.QUOTE_IP.getValue());
            vo.setResult(sourceIp);
            String key1 = vo.getSourceName() + ":" + vo.getToName() + ":" + vo.getType() + ":" + vo.getResult();
            String key2 = vo.getToName() + ":" + vo.getSourceName() + ":" + vo.getType() + ":" + vo.getResult();
            if (resultMap == null || resultMap != null && resultMap.get(key1) == null && resultMap.get(key2) == null) {
                result.add(vo);
            }
        }
    }

    public static void compareEbiddingIp(String sourceAccountIp, String targetAccountIp, Map<String, PurchaseEbiddingSupplier> supplierMap, List<SupplierRelationFindResultVO> result) {
        String sourceAccount = sourceAccountIp.split("_")[0];
        String targetAccount = targetAccountIp.split("_")[0];
        String sourceIp = sourceAccountIp.split("_")[1];
        String targetIp = targetAccountIp.split("_")[1];
        Map<String, List<SupplierRelationFindResultVO>> resultMap = null;
        if (result != null && result.size() > 0) {
            resultMap = result.stream().collect(Collectors.groupingBy(o -> o.getSourceName() + ":" + o.getToName() + ":" + o.getType() + ":" + o.getResult()));
        }
        if (IpV4Util.isSameAddress(sourceIp, targetIp)) {
            PurchaseEbiddingSupplier sourceSupplier = supplierMap.get(sourceAccount);
            PurchaseEbiddingSupplier targetSupplier = supplierMap.get(targetAccount);
            SupplierRelationFindResultVO vo = new SupplierRelationFindResultVO();
            vo.setSourceName(sourceSupplier.getSupplierName());
            vo.setToName(targetSupplier.getSupplierName());
            vo.setType(RiskTypeEnum.QUOTE_IP.getValue());
            vo.setResult(sourceIp);
            String key1 = vo.getSourceName() + ":" + vo.getToName() + ":" + vo.getType() + ":" + vo.getResult();
            String key2 = vo.getToName() + ":" + vo.getSourceName() + ":" + vo.getType() + ":" + vo.getResult();
            if (resultMap == null || resultMap != null && resultMap.get(key1) == null && resultMap.get(key2) == null) {
                result.add(vo);
            }
        }
    }

    public static void compareEbiddingIpLp(String sourceAccountIp, String targetAccountIp, Map<String, PurchaseEbiddingSupplierLp> supplierMap, List<SupplierRelationFindResultVO> result) {
        String sourceAccount = sourceAccountIp.split("_")[0];
        String targetAccount = targetAccountIp.split("_")[0];
        String sourceIp = sourceAccountIp.split("_")[1];
        String targetIp = targetAccountIp.split("_")[1];
        Map<String, List<SupplierRelationFindResultVO>> resultMap = null;
        if (result != null && result.size() > 0) {
            resultMap = result.stream().collect(Collectors.groupingBy(o -> o.getSourceName() + ":" + o.getToName() + ":" + o.getType() + ":" + o.getResult()));
        }
        if (IpV4Util.isSameAddress(sourceIp, targetIp)) {
            PurchaseEbiddingSupplierLp sourceSupplier = supplierMap.get(sourceAccount);
            PurchaseEbiddingSupplierLp targetSupplier = supplierMap.get(targetAccount);
            SupplierRelationFindResultVO vo = new SupplierRelationFindResultVO();
            vo.setSourceName(sourceSupplier.getSupplierName());
            vo.setToName(targetSupplier.getSupplierName());
            vo.setType(RiskTypeEnum.QUOTE_IP.getValue());
            vo.setResult(sourceIp);
            String key1 = vo.getSourceName() + ":" + vo.getToName() + ":" + vo.getType() + ":" + vo.getResult();
            String key2 = vo.getToName() + ":" + vo.getSourceName() + ":" + vo.getType() + ":" + vo.getResult();
            if (resultMap == null || resultMap != null && resultMap.get(key1) == null && resultMap.get(key2) == null) {
                result.add(vo);
            }
        }
    }

    public static void compareEnquiryLpIp(String sourceAccountIp, String targetAccountIp, Map<String, PurchaseEnquiryItemLp> supplierMap, List<SupplierRelationFindResultVO> result) {
        String sourceAccount = sourceAccountIp.split("_")[0];
        String targetAccount = targetAccountIp.split("_")[0];
        String sourceIp = sourceAccountIp.split("_")[1];
        String targetIp = targetAccountIp.split("_")[1];
        Map<String, List<SupplierRelationFindResultVO>> resultMap = null;
        if (result != null && result.size() > 0) {
            resultMap = result.stream().collect(Collectors.groupingBy(o -> o.getSourceName() + ":" + o.getToName() + ":" + o.getType() + ":" + o.getResult()));
        }
        if (IpV4Util.isSameAddress(sourceIp, targetIp)) {
            PurchaseEnquiryItemLp sourceSupplier = supplierMap.get(sourceAccount);
            PurchaseEnquiryItemLp targetSupplier = supplierMap.get(targetAccount);
            SupplierRelationFindResultVO vo = new SupplierRelationFindResultVO();
            vo.setSourceName(sourceSupplier.getSupplierName());
            vo.setToName(targetSupplier.getSupplierName());
            vo.setType(RiskTypeEnum.QUOTE_IP.getValue());
            vo.setResult(sourceIp);
            String key1 = vo.getSourceName() + ":" + vo.getToName() + ":" + vo.getType() + ":" + vo.getResult();
            String key2 = vo.getToName() + ":" + vo.getSourceName() + ":" + vo.getType() + ":" + vo.getResult();
            if (resultMap == null || resultMap != null && resultMap.get(key1) == null && resultMap.get(key2) == null) {
                result.add(vo);
            }
        }
    }

    public static void compareEnquiryIp(String sourceAccountIp, String targetAccountIp, Map<String, PurchaseEnquiryItem> supplierMap, List<SupplierRelationFindResultVO> result) {
        String sourceAccount = sourceAccountIp.split("_")[0];
        String targetAccount = targetAccountIp.split("_")[0];
        String sourceIp = sourceAccountIp.split("_")[1];
        String targetIp = targetAccountIp.split("_")[1];
        Map<String, List<SupplierRelationFindResultVO>> resultMap = null;
        if (result != null && result.size() > 0) {
            resultMap = result.stream().collect(Collectors.groupingBy(o -> o.getSourceName() + ":" + o.getToName() + ":" + o.getType() + ":" + o.getResult()));
        }
        if (IpV4Util.isSameAddress(sourceIp, targetIp)) {
            PurchaseEnquiryItem sourceSupplier = supplierMap.get(sourceAccount);
            PurchaseEnquiryItem targetSupplier = supplierMap.get(targetAccount);
            SupplierRelationFindResultVO vo = new SupplierRelationFindResultVO();
            vo.setSourceName(sourceSupplier.getSupplierName());
            vo.setToName(targetSupplier.getSupplierName());
            vo.setType(RiskTypeEnum.QUOTE_IP.getValue());
            vo.setResult(sourceIp);
            String key1 = vo.getSourceName() + ":" + vo.getToName() + ":" + vo.getType() + ":" + vo.getResult();
            String key2 = vo.getToName() + ":" + vo.getSourceName() + ":" + vo.getType() + ":" + vo.getResult();
            if (resultMap == null || resultMap != null && resultMap.get(key1) == null && resultMap.get(key2) == null) {
                result.add(vo);
            }
        }
    }

    public static void compareTenderIp(String sourceAccountIp, String targetAccountIp, Map<String, TenderProjectSupplier> supplierMap, List<SupplierRelationFindResultVO> result) {
        String sourceAccount = sourceAccountIp.split("_")[0];
        String targetAccount = targetAccountIp.split("_")[0];
        String sourceIp = sourceAccountIp.split("_")[1];
        String targetIp = targetAccountIp.split("_")[1];
        Map<String, List<SupplierRelationFindResultVO>> resultMap = null;
        if (result != null && result.size() > 0) {
            resultMap = result.stream().collect(Collectors.groupingBy(o -> o.getSourceName() + ":" + o.getToName() + ":" + o.getType() + ":" + o.getResult()));
        }
        if (sourceIp.equals(targetIp)) {
            TenderProjectSupplier sourceSupplier = supplierMap.get(sourceAccount);
            TenderProjectSupplier targetSupplier = supplierMap.get(targetAccount);
            SupplierRelationFindResultVO vo = new SupplierRelationFindResultVO();
            vo.setSourceName(sourceSupplier.getSupplierName());
            vo.setToName(targetSupplier.getSupplierName());
            vo.setType(RiskTypeEnum.QUOTE_IP.getValue());
            vo.setResult(sourceIp);
            String key1 = vo.getSourceName() + ":" + vo.getToName() + ":" + vo.getType() + ":" + vo.getResult();
            String key2 = vo.getToName() + ":" + vo.getSourceName() + ":" + vo.getType() + ":" + vo.getResult();
            if (resultMap == null || resultMap != null && resultMap.get(key1) == null && resultMap.get(key2) == null) {
                result.add(vo);
            }
        }
    }
}

