/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.forecast.entity.SaleForecastHead;
import com.els.modules.forecast.entity.SaleForecastMonthItem;
import com.els.modules.forecast.entity.SaleForecastWeekItem;
import com.els.modules.forecast.enumerate.ForecastStatusEnum;
import com.els.modules.forecast.service.SaleForecastHeadService;
import com.els.modules.forecast.service.SaleForecastMonthItemService;
import com.els.modules.forecast.service.SaleForecastWeekItemService;
import com.els.modules.forecast.utils.ForecastUtil;
import com.els.modules.forecast.vo.SaleForecastHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/forecast/saleForecastHead"})
@Api(tags={"\u9500\u552e\u9700\u6c42\u9884\u6d4b\u5934"})
public class SaleForecastHeadController
extends BaseController<SaleForecastHead, SaleForecastHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleForecastHeadController.class);
    @Autowired
    private SaleForecastMonthItemService saleForecastMonthItemService;
    @Autowired
    private SaleForecastWeekItemService saleForecastWeekItemService;
    @Autowired
    private DictAspect dictAspect;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"forecast#saleForecastHead:list"})
    public Result<?> queryPageList(SaleForecastHead saleForecastHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleForecastHead), (Map)req.getParameterMap());
        queryWrapper.lambda().ne(SaleForecastHead::getForecastStatus, (Object)ForecastStatusEnum.CANCEL.getValue());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((SaleForecastHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u9500\u552e\u9700\u6c42\u9884\u6d4b\u5934", value="\u786e\u8ba4")
    @ApiOperation(value="\u786e\u8ba4", notes="\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"forecast#saleForecastHead:confirm"})
    @SrmValidated
    public Result<?> confirm(@RequestBody SaleForecastHeadVO headVO) {
        SaleForecastHead head = new SaleForecastHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        ((SaleForecastHeadService)this.service).confirm(head, headVO.getMonthItemList(), headVO.getWeekItemList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"forecast#saleForecastHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleForecastHead head = (SaleForecastHead)((Object)((SaleForecastHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleForecastHeadVO headVO = new SaleForecastHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<SaleForecastMonthItem> monthItemList = this.saleForecastMonthItemService.selectByMainId(id);
        headVO.setMonthItemList(monthItemList);
        List<SaleForecastWeekItem> weekItemList = this.saleForecastWeekItemService.selectByMainId(id);
        headVO.setWeekItemList(weekItemList);
        Result result = Result.ok((Object)((Object)headVO));
        this.dictAspect.parseDictText((Object)result);
        JSONObject object = (JSONObject)result.getResult();
        ForecastUtil.assemblyResultData(object);
        return Result.ok((Object)object);
    }
}

