/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySubstituteHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySubstituteItemLp;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySupplierListLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.mapper.EnquirySubstituteHeadLpMapper;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySubstituteHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySubstituteItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySupplierListLpService;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class EnquirySubstituteHeadLpServiceImpl
extends BaseServiceImpl<EnquirySubstituteHeadLpMapper, EnquirySubstituteHeadLp>
implements EnquirySubstituteHeadLpService {
    @Autowired
    private EnquirySubstituteItemLpService enquirySubstituteItemService;
    @Autowired
    private EnquirySupplierListLpService enquirySupplierListService;

    private List<EnquirySubstituteItemLp> copyItem(List<SaleEnquiryItemLp> saleItemList) {
        ArrayList<EnquirySubstituteItemLp> substituteItemList = new ArrayList<EnquirySubstituteItemLp>();
        for (SaleEnquiryItemLp saleItem : saleItemList) {
            EnquirySubstituteItemLp item = new EnquirySubstituteItemLp();
            BeanUtils.copyProperties((Object)((Object)saleItem), (Object)((Object)item));
            substituteItemList.add(item);
        }
        return substituteItemList;
    }

    private List<EnquirySubstituteHeadLp> copyHead(List<SaleEnquiryHeadLp> saleHeadList) {
        ArrayList<EnquirySubstituteHeadLp> substituteHeadList = new ArrayList<EnquirySubstituteHeadLp>();
        for (SaleEnquiryHeadLp saleHead : saleHeadList) {
            EnquirySubstituteHeadLp head = new EnquirySubstituteHeadLp();
            BeanUtils.copyProperties((Object)((Object)saleHead), (Object)((Object)head));
            substituteHeadList.add(head);
        }
        return substituteHeadList;
    }

    @Override
    public void add(List<SaleEnquiryHeadLp> saleHeadList, List<SaleEnquiryItemLp> saleItemList, List<EnquirySupplierListLp> supplierList) {
        List needInsertSupplier = supplierList.stream().filter(supplier -> SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(supplier.getNeedCoordination()) || SupplierCoordinationWayEnum.EMAIL_COORDINATIONWAY.getValue().equals(supplier.getNeedCoordination())).map(EnquirySupplierListLp::getToElsAccount).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(needInsertSupplier)) {
            List<SaleEnquiryHeadLp> needInsertHeadList = saleHeadList.stream().filter(head -> needInsertSupplier.contains(head.getElsAccount())).collect(Collectors.toList());
            List<EnquirySubstituteHeadLp> insertHeadList = this.copyHead(needInsertHeadList);
            this.saveBatch(insertHeadList, 2000);
            List insertHeadId = needInsertHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<SaleEnquiryItemLp> needInsertItemList = saleItemList.stream().filter(item -> insertHeadId.contains(item.getHeadId())).collect(Collectors.toList());
            List<EnquirySubstituteItemLp> insertItemList = this.copyItem(needInsertItemList);
            this.enquirySubstituteItemService.saveBatch(insertItemList);
        }
    }

    @Override
    public void quoteConfirm(SaleEnquiryHeadLp dbHead, List<SaleEnquiryItemLp> dbItemList) {
        this.updateMain(dbHead, dbItemList);
    }

    @Override
    public void save(SaleEnquiryHeadLp updateHead, List<SaleEnquiryItemLp> updateItemList) {
        this.updateMain(updateHead, updateItemList);
    }

    @Override
    public void quote(SaleEnquiryHeadLp updateHead, List<SaleEnquiryItemLp> updateItemList) {
        this.updateMain(updateHead, updateItemList);
    }

    private void updateMain(SaleEnquiryHeadLp updateHead, List<SaleEnquiryItemLp> updateItemList) {
        if (CollectionUtil.isNotEmpty(updateItemList)) {
            String supplierId = updateItemList.get(0).getSupplierId();
            EnquirySupplierListLp supplier = (EnquirySupplierListLp)((Object)this.enquirySupplierListService.getById((Serializable)((Object)supplierId)));
            if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(supplier.getNeedCoordination()) || SupplierCoordinationWayEnum.EMAIL_COORDINATIONWAY.getValue().equals(supplier.getNeedCoordination())) {
                EnquirySubstituteHeadLp head = new EnquirySubstituteHeadLp();
                BeanUtils.copyProperties((Object)((Object)updateHead), (Object)((Object)head));
                boolean b = this.updateById((Object)head);
                Assert.isTrue((boolean)b, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
                List<EnquirySubstituteItemLp> updateList = this.copyItem(updateItemList);
                this.enquirySubstituteItemService.updateBatchById(updateList);
            }
        }
    }

    @Override
    public void updateQuoteEntTime(String purchaseHeadId, Date quoteEndTime, List<String> idList) {
        List<EnquirySubstituteHeadLp> headList = ((EnquirySubstituteHeadLpMapper)this.baseMapper).selectByMainId(purchaseHeadId);
        if (CollectionUtil.isNotEmpty(headList)) {
            headList.forEach(head -> {
                head.setQuoteEndTime(quoteEndTime);
                if (EnquiryLpStatusEnum.NO_QUOTE.getValue().equals(head.getEnquiryStatus())) {
                    head.setEnquiryStatus(EnquiryLpStatusEnum.QUOTING.getValue());
                }
            });
            this.updateBatchById(headList);
            List itemList = this.enquirySubstituteItemService.listByIds(idList);
            for (EnquirySubstituteItemLp item : itemList) {
                item.setQuoteEndTime(quoteEndTime);
                if (!EnquiryLpStatusEnum.NO_QUOTE.getValue().equals(item.getItemStatus())) continue;
                item.setItemStatus(EnquiryLpStatusEnum.QUOTING.getValue());
            }
            this.enquirySubstituteItemService.updateBatchById(itemList);
        }
    }

    @Override
    public void openBid(String purchaseHeadId, List<String> idList) {
        List<EnquirySubstituteHeadLp> headList = ((EnquirySubstituteHeadLpMapper)this.baseMapper).selectByMainId(purchaseHeadId);
        if (CollectionUtil.isNotEmpty(headList)) {
            Map<String, List<EnquirySubstituteHeadLp>> accountHeadMap = headList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
            List itemList = this.enquirySubstituteItemService.listByIds(idList);
            Map<String, List<EnquirySubstituteItemLp>> accountItemMap = itemList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
            accountItemMap.forEach((key, value) -> {
                List accountHeadList = (List)accountHeadMap.get(key);
                List quotingList = value.stream().filter(item -> EnquiryLpStatusEnum.QUOTING.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                String enquiryStatus = value.size() == quotingList.size() ? EnquiryLpStatusEnum.NO_QUOTE.getValue() : EnquiryLpStatusEnum.BARGAIN.getValue();
                accountHeadList.forEach(head -> head.setEnquiryStatus(enquiryStatus));
            });
            headList.forEach(head -> {
                String key = head.getElsAccount();
                head.setEnquiryStatus(((EnquirySubstituteHeadLp)((Object)((Object)((List)accountHeadMap.get(key)).get(0)))).getEnquiryStatus());
            });
            this.updateBatchById(headList);
            itemList.forEach(item -> {
                String itemStatus = EnquiryLpStatusEnum.QUOTING.getValue().equals(item.getItemStatus()) ? EnquiryLpStatusEnum.NO_QUOTE.getValue() : item.getItemStatus();
                item.setItemStatus(itemStatus);
            });
            this.enquirySubstituteItemService.updateBatchById(itemList);
        }
    }

    @Override
    public void reQuote(PurchaseEnquiryHeadLp dbHead, List<SaleEnquiryItemLp> reQuoteList) {
        List<EnquirySubstituteItemLp> updateList = this.getUpdateItemList(reQuoteList);
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.enquirySubstituteItemService.updateBatchById(updateList);
            List elsAccountList = updateList.stream().map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SaleEnquiryHeadLp::getEnquiryStatus, (Object)dbHead.getEnquiryStatus())).eq(SaleEnquiryHeadLp::getRelationId, (Object)dbHead.getId())).in(BaseEntity::getElsAccount, elsAccountList));
        }
    }

    @Override
    public void priced(PurchaseEnquiryHeadLp dbHead, List<SaleEnquiryItemLp> pricedList) {
        List<EnquirySubstituteItemLp> updateList = this.getUpdateItemList(pricedList);
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.enquirySubstituteItemService.updateBatchById(updateList);
            if (EnquiryLpStatusEnum.PRICED.getValue().equals(dbHead.getEnquiryStatus())) {
                this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEnquiryHeadLp::getRelationId, (Object)dbHead.getId())).set(SaleEnquiryHeadLp::getEnquiryStatus, (Object)EnquiryLpStatusEnum.PRICED.getValue()));
            }
        }
    }

    @Override
    public void cancel(String purchaseHeadId) {
        List<EnquirySubstituteHeadLp> headList = ((EnquirySubstituteHeadLpMapper)this.baseMapper).selectByMainId(purchaseHeadId);
        if (CollectionUtil.isNotEmpty(headList)) {
            headList.forEach(head -> head.setEnquiryStatus(EnquiryLpStatusEnum.CANCEL.getValue()));
            this.updateBatchById(headList);
            List headIdList = headList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.enquirySubstituteItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEnquiryItemLp::getHeadId, headIdList)).set(SaleEnquiryItemLp::getItemStatus, (Object)EnquiryLpStatusEnum.CANCEL.getValue()));
        }
    }

    @Override
    public void regret(PurchaseEnquiryHeadLp head, List<SaleEnquiryItemLp> regretList) {
        List<EnquirySubstituteItemLp> updateList = this.getUpdateItemList(regretList);
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.enquirySubstituteItemService.updateBatchById(updateList);
            List elsAccountList = updateList.stream().map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(BaseEntity::getElsAccount, elsAccountList)).eq(SaleEnquiryHeadLp::getRelationId, (Object)head.getId())).set(SaleEnquiryHeadLp::getEnquiryStatus, (Object)head.getEnquiryStatus()));
        }
    }

    private List<EnquirySubstituteItemLp> getUpdateItemList(List<SaleEnquiryItemLp> itemList) {
        List<EnquirySubstituteItemLp> substituteItemList = new ArrayList<EnquirySubstituteItemLp>();
        List supplierIds = itemList.stream().map(SaleEnquiryItemLp::getSupplierId).collect(Collectors.toList());
        List supplierIdList = this.enquirySupplierListService.listByIds(supplierIds).stream().filter(supplier -> SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(supplier.getNeedCoordination()) || SupplierCoordinationWayEnum.EMAIL_COORDINATIONWAY.getValue().equals(supplier.getNeedCoordination())).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(supplierIdList)) {
            List<SaleEnquiryItemLp> updateItemList = itemList.stream().filter(item -> supplierIdList.contains(item.getSupplierId())).collect(Collectors.toList());
            substituteItemList = this.copyItem(updateItemList);
        }
        return substituteItemList;
    }
}

