/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.specialist.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.specialist.entity.SpecialistEducationExperienceInfo;
import com.els.modules.specialist.entity.SpecialistHistoryBiddingInfo;
import com.els.modules.specialist.entity.SpecialistInfo;
import com.els.modules.specialist.entity.SpecialistProfessionalResumeInfo;
import com.els.modules.specialist.entity.SpecialistProfessionalSuccessInfo;
import com.els.modules.specialist.entity.SpecialistSpecialty;
import com.els.modules.specialist.service.SpecialistEducationExperienceInfoService;
import com.els.modules.specialist.service.SpecialistHistoryBiddingInfoService;
import com.els.modules.specialist.service.SpecialistInfoService;
import com.els.modules.specialist.service.SpecialistProfessionalResumeInfoService;
import com.els.modules.specialist.service.SpecialistProfessionalSuccessInfoService;
import com.els.modules.specialist.service.SpecialistSpecialtyService;
import com.els.modules.specialist.vo.SpecialistInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/specialist/specialistInfo"})
@Api(tags={"\u4e13\u5bb6\u4fe1\u606f"})
public class SpecialistInfoController
extends BaseController<SpecialistInfo, SpecialistInfoService> {
    private static final Logger log = LoggerFactory.getLogger(SpecialistInfoController.class);
    @Autowired
    private SpecialistInfoService specialistInfoService;
    @Autowired
    private SpecialistEducationExperienceInfoService specialistEducationExperienceInfoService;
    @Autowired
    private SpecialistHistoryBiddingInfoService specialistHistoryBiddingInfoService;
    @Autowired
    private SpecialistProfessionalResumeInfoService specialistProfessionalResumeInfoService;
    @Autowired
    private SpecialistProfessionalSuccessInfoService specialistProfessionalSuccessInfoService;
    @Autowired
    private SpecialistSpecialtyService specialistSpecialtyService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @RequiresPermissions(value={"specialist#specialistInfo:list"})
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="specialistInfo")
    public Result<?> queryPageList(SpecialistInfo specialistInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)specialistInfo), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.specialistInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u4e13\u5bb6\u4fe1\u606f-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"specialist#specialistInfo:add"})
    @SrmValidated
    public Result<?> add(@RequestBody SpecialistInfoVO specialistInfoPage) {
        SpecialistInfo specialistInfo = new SpecialistInfo();
        BeanUtils.copyProperties((Object)((Object)specialistInfoPage), (Object)((Object)specialistInfo));
        this.specialistInfoService.saveMain(specialistInfo, specialistInfoPage.getSpecialistEducationExperienceInfoList(), specialistInfoPage.getSpecialistHistoryBiddingInfoList(), specialistInfoPage.getSpecialistProfessionalResumeInfoList(), specialistInfoPage.getSpecialistProfessionalSuccessInfoList());
        return Result.ok((Object)((Object)specialistInfo));
    }

    @AutoLog(value="\u4e13\u5bb6\u4fe1\u606f-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"specialist#specialistInfo:edit"})
    @SrmValidated
    public Result<?> edit(@RequestBody SpecialistInfoVO specialistInfoPage) {
        SpecialistInfo specialistInfo = new SpecialistInfo();
        BeanUtils.copyProperties((Object)((Object)specialistInfoPage), (Object)((Object)specialistInfo));
        this.specialistInfoService.updateMain(specialistInfo, specialistInfoPage.getSpecialistEducationExperienceInfoList(), specialistInfoPage.getSpecialistHistoryBiddingInfoList(), specialistInfoPage.getSpecialistProfessionalResumeInfoList(), specialistInfoPage.getSpecialistProfessionalSuccessInfoList());
        String id = specialistInfo.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u4e13\u5bb6\u4fe1\u606f-\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"specialist#specialistInfo:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.specialistInfoService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u4e13\u5bb6\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"specialist#specialistInfo:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.specialistInfoService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @RequiresPermissions(value={"specialist#specialistInfo:queryById"})
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SpecialistInfo specialistInfo = (SpecialistInfo)((Object)this.specialistInfoService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SpecialistInfoVO specialistInfoVO = new SpecialistInfoVO();
        BeanUtils.copyProperties((Object)((Object)specialistInfo), (Object)((Object)specialistInfoVO));
        List<SpecialistEducationExperienceInfo> specialistEducationExperienceInfoList = this.specialistEducationExperienceInfoService.selectByMainId(id);
        specialistInfoVO.setSpecialistEducationExperienceInfoList(specialistEducationExperienceInfoList);
        List<SpecialistHistoryBiddingInfo> specialistHistoryBiddingInfoList = this.specialistHistoryBiddingInfoService.selectByMainId(id);
        specialistInfoVO.setSpecialistHistoryBiddingInfoList(specialistHistoryBiddingInfoList);
        List<SpecialistProfessionalResumeInfo> specialistProfessionalResumeInfoList = this.specialistProfessionalResumeInfoService.selectByMainId(id);
        specialistInfoVO.setSpecialistProfessionalResumeInfoList(specialistProfessionalResumeInfoList);
        List<SpecialistProfessionalSuccessInfo> specialistProfessionalSuccessInfoList = this.specialistProfessionalSuccessInfoService.selectByMainId(id);
        specialistInfoVO.setSpecialistProfessionalSuccessInfoList(specialistProfessionalSuccessInfoList);
        List<SpecialistSpecialty> specialistSpecialtyList = this.specialistSpecialtyService.selectByMainId(id);
        if (CollectionUtil.isNotEmpty(specialistSpecialtyList)) {
            Set specialistSpecialtyCodeList = specialistSpecialtyList.stream().map(SpecialistSpecialty::getSpecialtyCode).collect(Collectors.toSet());
            String specialistSpecialtyCodeStr = StringUtils.join(specialistSpecialtyCodeList, (String)",");
            specialistInfoVO.setSpecialized(specialistSpecialtyCodeStr);
        }
        return Result.ok((Object)((Object)specialistInfoVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4e13\u5bb6\u4fe1\u606fid\u67e5\u8be2\u4e13\u5bb6\u6559\u80b2\u7ecf\u5386\u4fe1\u606f", notes="\u901a\u8fc7\u4e13\u5bb6\u4fe1\u606fid\u67e5\u8be2\u4e13\u5bb6\u6559\u80b2\u7ecf\u5386\u4fe1\u606f")
    @RequiresPermissions(value={"specialist#specialistInfo:queryById"})
    @GetMapping(value={"/querySpecialistEducationExperienceInfoByMainId"})
    public Result<?> querySpecialistEducationExperienceInfoListByMainId(@RequestParam(name="id") String id) {
        List<SpecialistEducationExperienceInfo> specialistEducationExperienceInfoList = this.specialistEducationExperienceInfoService.selectByMainId(id);
        return Result.ok(specialistEducationExperienceInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e13\u5bb6\u4fe1\u606fid\u67e5\u8be2\u4e13\u5bb6\u5386\u53f2\u5bfb\u6e90\u4fe1\u606f", notes="\u901a\u8fc7\u4e13\u5bb6\u4fe1\u606fid\u67e5\u8be2\u4e13\u5bb6\u5386\u53f2\u5bfb\u6e90\u4fe1\u606f")
    @RequiresPermissions(value={"specialist#specialistInfo:queryById"})
    @GetMapping(value={"/querySpecialistHistoryBiddingInfoByMainId"})
    public Result<?> querySpecialistHistoryBiddingInfoListByMainId(@RequestParam(name="id") String id) {
        List<SpecialistHistoryBiddingInfo> specialistHistoryBiddingInfoList = this.specialistHistoryBiddingInfoService.selectByMainId(id);
        return Result.ok(specialistHistoryBiddingInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e13\u5bb6\u4fe1\u606fid\u67e5\u8be2\u4e13\u5bb6\u804c\u4e1a\u5c65\u5386\u4fe1\u606f", notes="\u901a\u8fc7\u4e13\u5bb6\u4fe1\u606fid\u67e5\u8be2\u4e13\u5bb6\u804c\u4e1a\u5c65\u5386\u4fe1\u606f")
    @RequiresPermissions(value={"specialist#specialistInfo:queryById"})
    @GetMapping(value={"/querySpecialistProfessionalResumeInfoByMainId"})
    public Result<?> querySpecialistProfessionalResumeInfoListByMainId(@RequestParam(name="id") String id) {
        List<SpecialistProfessionalResumeInfo> specialistProfessionalResumeInfoList = this.specialistProfessionalResumeInfoService.selectByMainId(id);
        return Result.ok(specialistProfessionalResumeInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e13\u5bb6\u4fe1\u606fid\u67e5\u8be2\u4e13\u5bb6\u4e13\u4e1a\u6210\u679c\u4fe1\u606f ", notes="\u901a\u8fc7\u4e13\u5bb6\u4fe1\u606fid\u67e5\u8be2\u4e13\u5bb6\u4e13\u4e1a\u6210\u679c\u4fe1\u606f ")
    @RequiresPermissions(value={"specialist#specialistInfo:queryById"})
    @GetMapping(value={"/querySpecialistProfessionalSuccessInfoByMainId"})
    public Result<?> querySpecialistProfessionalSuccessInfoListByMainId(@RequestParam(name="id") String id) {
        List<SpecialistProfessionalSuccessInfo> specialistProfessionalSuccessInfoList = this.specialistProfessionalSuccessInfoService.selectByMainId(id);
        return Result.ok(specialistProfessionalSuccessInfoList);
    }
}

