/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaSupplierResult;
import com.els.modules.tender.evaluation.mapper.PurchaseTenderProjectBidEvaSupplierResultMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaSupplierResultService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTenderProjectBidEvaSupplierResultServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectBidEvaSupplierResultMapper, PurchaseTenderProjectBidEvaSupplierResult>
implements PurchaseTenderProjectBidEvaSupplierResultService {
    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveBatchEvaSupplierResult(List<TenderProjectSupplier> tenderProjectSupplier, String evaInfoId) {
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderCurrentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        ArrayList<PurchaseTenderProjectBidEvaSupplierResult> supplierResultList = new ArrayList<PurchaseTenderProjectBidEvaSupplierResult>();
        for (TenderProjectSupplier supplier : tenderProjectSupplier) {
            PurchaseTenderProjectBidEvaSupplierResult supplierResult = new PurchaseTenderProjectBidEvaSupplierResult();
            supplierResult.setEvaInfoId(evaInfoId);
            supplierResult.setElsAccount(TenantContext.getTenant());
            supplierResult.setSubpackageId(supplier.getSubpackageId());
            supplierResult.setTenderProjectId(supplier.getTenderProjectId());
            supplierResult.setInvalid(supplier.getInvalid());
            supplierResult.setCheckType(tenderCheckType);
            supplierResult.setProcessType(tenderProcessType);
            supplierResult.setCurrentStep(tenderCurrentStep);
            supplierResult.setSupplierAccount(supplier.getSupplierAccount());
            supplierResult.setSupplierName(supplier.getSupplierName());
            supplierResultList.add(supplierResult);
        }
        this.saveBatch(supplierResultList, 1000);
    }

    @Override
    public List<PurchaseTenderProjectBidEvaSupplierResult> selectByMainId(String evaInfoId) {
        return ((PurchaseTenderProjectBidEvaSupplierResultMapper)this.baseMapper).selectByMainId(evaInfoId);
    }

    @Override
    public void updateInvalidStatusByMainId(String evaInfoId, List<String> invalidSupplierAccountList) {
        if (CollectionUtil.isEmpty(invalidSupplierAccountList)) {
            return;
        }
        LambdaUpdateWrapper supplierResultLambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)supplierResultLambdaUpdateWrapper.eq(PurchaseTenderProjectBidEvaSupplierResult::getEvaInfoId, (Object)evaInfoId)).in(PurchaseTenderProjectBidEvaSupplierResult::getSupplierAccount, invalidSupplierAccountList)).set(PurchaseTenderProjectBidEvaSupplierResult::getInvalid, (Object)"1");
        this.update((Wrapper)supplierResultLambdaUpdateWrapper);
    }
}

