/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.UUIDGenerator;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.service.ElsTenantRpcService;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.service.FileRpcService;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryScopeEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.job.utils.EnquiryJobUtil;
import com.els.modules.enquiry.mapper.PurchaseEnquiryHeadMapper;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemMapper;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PublicEnquiryService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.enumerate.ReviewStatusEnum;
import com.els.modules.inquiry.qualification.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.qualification.service.PurchaseQualificationReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.inquiry.service.PublicInquiryService;
import com.els.modules.inquiry.vo.PublicInquiryVO;
import com.els.modules.job.api.dto.QuartzJobDTO;
import com.els.modules.notice.api.dto.PurchaseNoticeDTO;
import com.els.modules.notice.api.enumerate.NoticeScopeEnum;
import com.els.modules.supplier.api.dto.RegisterDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierEnterpriseInfoRegisterRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PublicEnquiryServiceImpl
extends BaseServiceImpl<PurchaseEnquiryHeadMapper, PurchaseEnquiryHead>
implements PublicEnquiryService,
PublicInquiryService {
    private static final Logger log = LoggerFactory.getLogger(PublicEnquiryServiceImpl.class);
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    @Resource
    private PurchaseEnquiryItemMapper purchaseEnquiryItemMapper;
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Autowired
    private EnquirySupplierListService supplierService;
    @Autowired
    private PurchaseQualificationReviewService reviewService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private FileRpcService fileRpcService;
    @Resource
    private SupplierEnterpriseInfoRegisterRpcService enterpriseInfoRegisterRpcService;
    @Resource
    private ElsTenantRpcService elsTenantRpcService;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmsssssZ");
    private static final SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
    @Value(value="${enquiry.jutongbao.quotationUrl}")
    private String quotation_url;
    @Value(value="${enquiry.jutongbao.supplierQueryUrl}")
    private String supplier_query_url;
    @Value(value="${enquiry.jutongbao.appkey}")
    private String appkey;
    @Value(value="${enquiry.jutongbao.appsecret}")
    private String appsecret;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private static final String BIZ_PATH = "files";
    private static final String STR_FORMAT = "yyyyMMdd";
    @Value(value="${enquiry.jutongbao.closeQuoteUrl}")
    private String close_quote_url;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void B2BQuote(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> itemList, List<EnquirySupplierList> supplierList) {
        if (EnquiryStatusEnum.QUOTING.getValue().equals(dbHead.getEnquiryStatus())) {
            this.purchaseEnquiryItemMapper.deleteByMainId(dbHead.getId());
        }
        TenantContext.setTenant((String)dbHead.getElsAccount());
        LoginUser user = SysUtil.getLoginUser();
        dbHead.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
        this.purchaseEnquiryHeadService.publishEnquiry(dbHead, itemList, supplierList, new ArrayList<PurchaseAttachmentDemandDTO>(), user.getEnterpriseName(), user, true);
        String toElsAccount = supplierList.get(0).getToElsAccount();
        TenantContext.setTenant((String)toElsAccount);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SaleEnquiryHead::getRelationId, (Object)dbHead.getId())).eq(BaseEntity::getElsAccount, (Object)toElsAccount);
        SaleEnquiryHead saleHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getOne((Wrapper)queryWrapper));
        List<SaleEnquiryItem> saleItemList = this.saleEnquiryItemService.selectByMainId(saleHead.getId());
        this.saleEnquiryHeadService.quote(saleHead, saleItemList, null);
    }

    @Override
    public void publishNotice(PurchaseEnquiryHead dbHead) {
        LoginUser user = SysUtil.getLoginUser();
        String enquiryDesc = dbHead.getEnquiryDesc() == null ? "" : dbHead.getEnquiryDesc();
        PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
        notice.setBusAccount(dbHead.getBusAccount());
        notice.setNoticeTitle(user.getEnterpriseName() + "_" + enquiryDesc + "\u516c\u5f00\u8be2\u4ef7");
        notice.setNoticeContent("\u6709\u610f\u5411\u8005\u53ef\u53c2\u4e0e\u62a5\u540d");
        notice.setNoticeType("2");
        notice.setNoticeScope(NoticeScopeEnum.IN_STATION_OPEN.getValue());
        notice.setTop("1");
        notice.setEffectiveTime(new Date());
        notice.setBusinessId(dbHead.getId());
        notice.setBusinessType(SourceTypeEnum.ENQUIRY.getValue());
        notice.setTemplateNumber(dbHead.getTemplateNumber());
        notice.setTemplateVersion(dbHead.getTemplateVersion());
        notice.setExpiryTime(dbHead.getApplyEndTime());
        notice.setTemplateAccount(dbHead.getTemplateAccount());
        PurchaseNoticeDTO notice1 = new PurchaseNoticeDTO();
        BeanUtils.copyProperties((Object)notice, (Object)notice1);
        notice1.setNoticeContent("\u6ce8\u518c\u540e\u5373\u53ef\u4e8e\u7cfb\u7edf\u5185\u516c\u544a\u51fa\u53c2\u4e0e\u62a5\u540d");
        notice1.setNoticeScope(NoticeScopeEnum.OPEN.getValue());
        this.inquiryInvokeMessageRpcService.publish(notice, Lists.newArrayList(), Lists.newArrayList());
        this.inquiryInvokeMessageRpcService.publish(notice1, Lists.newArrayList(), Lists.newArrayList());
        if (EnquiryScopeEnum.PUBLIC.getValue().equals(dbHead.getEnquiryScope())) {
            try {
                this.publishToJuTongBao(dbHead, notice, user);
            }
            catch (Exception e) {
                log.error("\u5546\u673a\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    public void publishToJuTongBao(PurchaseEnquiryHead dbHead, PurchaseNoticeDTO notice, LoginUser user) {
        JSONObject businessObject = new JSONObject();
        businessObject.put("businessNo", (Object)dbHead.getEnquiryNumber());
        businessObject.put("title", (Object)notice.getNoticeTitle());
        Object link = this.address.endsWith("/") ? this.address : this.address + "/";
        link = (String)link + "user/noticeTemDetail?id=1&businessId=" + notice.getBusinessId() + "&businessType=" + notice.getBusinessType() + "&noticeTitle=" + notice.getNoticeTitle() + "&templateAccount=" + notice.getTemplateAccount() + "&templateVersion=" + notice.getTemplateVersion() + "&templateNumber=" + notice.getTemplateNumber();
        businessObject.put("link", link);
        businessObject.put("dataSource", (Object)"SRM");
        businessObject.put("dataType", (Object)SourceTypeEnum.ENQUIRY.getDesc());
        JSONObject body = new JSONObject();
        body.put("subject", (Object)notice.getNoticeTitle());
        body.put("contact", (Object)user.getRealname());
        body.put("phone", (Object)user.getPhone());
        body.put("url", link);
        body.put("gmtQuotationExpire", (Object)sdf.format(dbHead.getQuoteEndTime()));
        body.put("gmtRegistrationDeadline", (Object)sdf.format(dbHead.getApplyEndTime()));
        body.put("receiveStreetAddress", (Object)"-");
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemMapper.selectByMainId(notice.getBusinessId());
        if (!itemList.isEmpty()) {
            JSONArray items = new JSONArray();
            for (PurchaseEnquiryItem entity : itemList) {
                JSONObject item = new JSONObject();
                item.put("purchaseAmount", (Object)entity.getRequireQuantity());
                item.put("unit", (Object)entity.getPurchaseUnit());
                item.put("desc", (Object)entity.getMaterialDesc());
                item.put("gmtDeliveryDeadline", entity.getDeliveryDate() != null ? sdf2.format(entity.getDeliveryDate()) : null);
                item.put("gmtRegistrationDeadline", (Object)sdf2.format(dbHead.getQuoteEndTime()));
                item.put("productCode", (Object)entity.getMaterialNumber());
                item.put("quotationURL", link);
                item.put("subject", (Object)entity.getMaterialName());
                item.put("prItemId", (Object)entity.getId());
                items.add((Object)item);
            }
            body.put("items", (Object)items);
        }
        ElsEnterpriseInfoDTO enterprise = this.elsEnterpriseInfoRpcService.getByElsAccount(dbHead.getElsAccount());
        body.put("corpid", (Object)enterprise.getCreditCode());
        JSONObject requestObject = new JSONObject();
        requestObject.put("businessObject", (Object)businessObject);
        requestObject.put("body", (Object)body);
        JSONObject responseObject = this.invokeBaseRpcService.callIPaasInterface(requestObject, "businessOpportunity", this.invokeBaseRpcService.getIpaasInterfaceCode("jutongbao_price_enquiry"));
        if (responseObject.getBooleanValue("code")) {
            JSONObject result = responseObject.getJSONObject("result");
            String buyofferId = result.getString("buyofferId");
            if ("200".equals(result.getString("code")) && StringUtils.isNotBlank((CharSequence)buyofferId)) {
                dbHead.setBuyOfferId(buyofferId);
                this.updateById((Object)dbHead);
                result.put("businessType", (Object)SourceTypeEnum.ENQUIRY.getValue());
                result.put("id", (Object)dbHead.getId());
                QuartzJobDTO job = new QuartzJobDTO();
                long currentTime = System.currentTimeMillis();
                Date executeDate = new Date(currentTime += 14400000L);
                job.setCronExpression(DateUtil.format((Date)executeDate, (String)"ss mm HH dd MM ? yyyy"));
                job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
                job.setStatus(CommonConstant.STATUS_NORMAL);
                String JOB_NAME = "jutongbaoEnquiryJobServiceImpl";
                job.setJobNameKey("jutongbaoEnquiryJobServiceImpl_" + buyofferId + "_" + dbHead.getElsAccount());
                result.put("jobid", (Object)buyofferId);
                result.put("elsAccount", (Object)dbHead.getElsAccount());
                result.put("jobKey", (Object)job.getJobNameKey());
                result.put("corpid", (Object)enterprise.getCreditCode());
                result.put("businessId", (Object)notice.getBusinessId());
                result.put("jobImplName", (Object)"jutongbaoEnquiryJobServiceImpl");
                job.setParameter(result.toJSONString());
                job.setElsAccount(dbHead.getElsAccount());
                EnquiryJobUtil.createJob(job);
            }
        }
    }

    @Override
    public Result<?> getPublicResult(String headId) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.getById((Serializable)((Object)headId)));
        PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        String supplierAccount = TenantContext.getTenant();
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEnquiryItem.class);
        headVO.setInitItemList(initItemList);
        List<PurchaseAttachmentDTO> collect = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(headId).stream().filter(x -> x.getUploadElsAccount().equals(supplierAccount)).collect(Collectors.toList());
        log.info("getPublicResult_supplierAccount:{}, collect:{}", (Object)supplierAccount, (Object)JSONObject.toJSONString(collect));
        headVO.setPurchaseAttachmentList(collect);
        headVO.setPurchaseAttachmentDemandList(this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId));
        return Result.ok((Object)((Object)headVO));
    }

    @Override
    public void apply(PublicInquiryVO inquiryVO) {
        String headId = inquiryVO.getId();
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.getById((Serializable)((Object)headId)));
        String supplierAccount = TenantContext.getTenant();
        Assert.isTrue((!dbHead.getEnquiryStatus().equals(EnquiryStatusEnum.CANCEL.getValue()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__WWWWWWWIkuWShsR_ea64282", (String)"[${0}]\uff0c\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u62a5\u540d", (String[])new String[]{dbHead.getEnquiryNumber()}));
        Assert.isTrue((!supplierAccount.equals(dbHead.getElsAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sReyUhxeyxOdeW_b8464f65", (String)"\u62a5\u540d\u8d26\u53f7\u4e0e\u53d1\u5e03\u8d26\u53f7\u4e0d\u80fd\u76f8\u540c\uff01"));
        Assert.isTrue((boolean)dbHead.getApplyEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_fail_registration_time_time_out", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u62a5\u540d"));
        List<PurchaseQualificationReview> reviewList = this.reviewService.selectByMainId(headId).stream().filter(review -> supplierAccount.equals(review.getToElsAccount())).toList();
        List<PurchaseQualificationReview> notRejectList = reviewList.stream().filter(review -> !ReviewStatusEnum.REJECT.getValue().equals(review.getReviewStatus())).toList();
        Assert.isTrue((boolean)CollectionUtil.isEmpty(notRejectList), (String)I18nUtil.translate((String)"i18n_alert_fail_registration_repeat", (String)"\u65e0\u9700\u91cd\u590d\u62a5\u540d"));
        if (QualificationReviewEnum.BEFORE_REVIEW.getValue().equals(dbHead.getQualificationReview())) {
            List<String> toElsAccountList = this.supplierService.selectByMainId(headId).stream().map(EnquirySupplierList::getToElsAccount).toList();
            Assert.isTrue((!toElsAccountList.contains(supplierAccount) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_IqPVsUvmhuSJRUJIeRWSTsR_654bc38d", (String)"\u5df2\u88ab\u9080\u8bf7\u53c2\u4e0e\u672c\u6b21\u8be2\u4ef7\u6216\u8d44\u8d28\u5ba1\u67e5\u5df2\u901a\u8fc7\uff0c\u65e0\u9700\u62a5\u540d"));
        }
        List<PurchaseAttachmentDemandDTO> demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId).stream().filter(demand -> "1".equals(demand.getRequired())).filter(demand -> StageTypeEnum.APPLY.getValue().equals(demand.getStageType())).toList();
        List<SaleAttachmentDTO> saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(dbHead.getId()).stream().filter(attachment -> attachment.getUploadElsAccount().equals(supplierAccount)).toList();
        Map<String, List<SaleAttachmentDTO>> checkMap = saleAttachmentList.stream().filter(attachment -> !StringUtils.isEmpty((CharSequence)attachment.getFileType())).collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType));
        for (PurchaseAttachmentDemandDTO demand2 : demandList) {
            Assert.isTrue((boolean)checkMap.containsKey(demand2.getFileType()), (String)I18nUtil.translate((String)"i18n_alert_VpYPVXVIdAcjQIW_61f8e1a5", (String)"\u8bf7\u6309\u7167\u8981\u6c42\u4e0a\u4f20\u5bf9\u5e94\u7c7b\u578b\u7684\u6587\u4ef6\uff01"));
        }
        SupplierMasterDataDTO masterData = this.inquiryInvokeSupplierRpcService.getByAccount(dbHead.getElsAccount(), supplierAccount);
        if (masterData == null) {
            masterData = this.inquiryInvokeSupplierRpcService.addUnfamiliarSupplier(dbHead.getElsAccount());
        }
        PurchaseQualificationReview review2 = new PurchaseQualificationReview();
        review2.setElsAccount(dbHead.getElsAccount());
        review2.setRelationId(dbHead.getId());
        review2.setSupplierQualification(dbHead.getSupplierQualification());
        review2.setContacts(inquiryVO.getContacts());
        review2.setPhone(inquiryVO.getPhone());
        review2.setEmail(inquiryVO.getEmail());
        review2.setAddress(inquiryVO.getAddress());
        review2.setToElsAccount(supplierAccount);
        review2.setSupplierCode(masterData.getSupplierCode());
        review2.setSupplierName(masterData.getSupplierName());
        review2.setNeedCoordination(masterData.getNeedCoordination());
        LoginUser user = SysUtil.getLoginUser();
        review2.setBidder(user.getSubAccount() + "_" + user.getRealname());
        review2.setSourceType(SourceTypeEnum.ENQUIRY.getValue());
        review2.setSourceNumber(dbHead.getEnquiryNumber());
        review2.setReviewTime(dbHead.getQuoteEndTime());
        this.reviewService.add(review2);
        saleAttachmentList.forEach(attachment -> attachment.setHeadId(review2.getId()));
        this.invokeBaseRpcService.updateSaleAttachmentBatchById(saleAttachmentList);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(review2.getId());
        ArrayList purchaseAttachmentList = SysUtil.copyProperties(saleAttachmentList, PurchaseAttachmentDTO.class);
        purchaseAttachmentList.forEach(attachment -> {
            attachment.setId(null);
            attachment.setHeadId(review2.getId());
            attachment.setBusinessType("qualification");
        });
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn((List)purchaseAttachmentList);
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(dbHead.getId());
        sendVO.setElsAccount(supplierAccount);
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        toSend.put(dbHead.getId(), dbHead.getElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        if (CollectionUtil.isEmpty(reviewList) && QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            ElsEnterpriseInfoDTO infoDTO = this.elsEnterpriseInfoRpcService.getByElsAccount(dbHead.getElsAccount());
            dbHead.setIgnoreUploadType(Lists.newArrayList((Object[])new String[]{"enquirySubstitute"}));
            this.purchaseEnquiryHeadService.executeReview(dbHead, review2, infoDTO.getName(), SysUtil.getLoginUser());
        }
        super.sendMessage(dbHead.getElsAccount(), "enquiry", "check", dbHead.getId(), "enquiryBusinessDataRpcService", Collections.singletonList(dbHead.getElsAccount()));
    }

    @Override
    public String jutongbaoQuote(String parameter) {
        log.info(" \u5927\u4f01\u6c47\u62a5\u4ef7\u67e5\u8be2 \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)id)));
        List<String> statusList = Arrays.asList(EnquiryStatusEnum.QUOTING.getValue(), EnquiryStatusEnum.BARGAIN.getValue(), EnquiryStatusEnum.REGRET.getValue());
        Assert.isTrue((boolean)statusList.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_APzExiTsu_3e65ad91", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u62a5\u4ef7"));
        JSONObject request = new JSONObject();
        request.put("corpid", (Object)paramObj.getString("corpid"));
        request.put("buyofferId", (Object)paramObj.getString("buyofferId"));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("appkey", this.appkey);
        header.put("appsecret", this.appsecret);
        String response = ((HttpRequest)HttpRequest.post((String)this.quotation_url).addHeaders(header)).body(request.toJSONString()).execute().body();
        JSONObject responseObject = JSONObject.parseObject((String)response);
        Object supplierMemberIds = paramObj.getString("supplierMemberIds");
        if (responseObject != null && responseObject.getBooleanValue("success")) {
            if (StringUtils.isBlank((CharSequence)supplierMemberIds)) {
                supplierMemberIds = "";
            }
            JSONArray quotationList = responseObject.getJSONObject("data").getJSONArray("quotationList");
            for (Object object : quotationList) {
                JSONObject quotationItem = JSONObject.parseObject((String)object.toString());
                String supplierMemberId = quotationItem.getString("supplierMemberId");
                if (((String)supplierMemberIds).contains(supplierMemberId)) continue;
                supplierMemberIds = (String)supplierMemberIds + "," + supplierMemberId;
                request.put("memberId", (Object)supplierMemberId);
                String supplier = ((HttpRequest)HttpRequest.post((String)this.supplier_query_url).addHeaders(header)).body(request.toJSONString()).execute().body();
                JSONObject supplierObject = JSONObject.parseObject((String)supplier);
                if (!supplierObject.getBooleanValue("success")) continue;
                JSONObject contactInfo = supplierObject.getJSONObject("data").getJSONObject("contactInfo");
                JSONObject companyInfo = supplierObject.getJSONObject("data").getJSONObject("companyInfo");
                String supplierName = companyInfo.getJSONObject("icrInfo").getString("name");
                boolean registerflag = false;
                String supplierAccount = null;
                List dtos = this.elsEnterpriseInfoRpcService.selectList(supplierName, null);
                if (!dtos.isEmpty()) {
                    for (ElsEnterpriseInfoDTO dto : dtos) {
                        ElsTenantDTO elsTenantDTO = this.elsTenantRpcService.getElsTenantByAccount(dto.getElsAccount());
                        if (elsTenantDTO == null) continue;
                        registerflag = true;
                        supplierAccount = dto.getElsAccount();
                        break;
                    }
                }
                try {
                    if (!registerflag) {
                        RegisterDTO registerDTO = new RegisterDTO();
                        registerDTO.setCompanyName(supplierName);
                        registerDTO.setContactsName(contactInfo.getString("name"));
                        registerDTO.setPhoneNumber(contactInfo.getString("mobile"));
                        registerDTO.setEmail(contactInfo.getString("email"));
                        registerDTO.setPassword("123abc");
                        registerDTO.setSourceType("0");
                        registerDTO.setSupplierType("1");
                        this.enterpriseInfoRegisterRpcService.enterpriseInfoRegister(registerDTO);
                        supplierAccount = ((ElsEnterpriseInfoDTO)this.elsEnterpriseInfoRpcService.selectList(supplierName, null).get(0)).getElsAccount();
                    }
                    TenantContext.setTenant(supplierAccount);
                    PublicInquiryService inquiryService = SourceTypeEnum.getPublicService(paramObj.getString("businessType"));
                    PublicInquiryVO inquiryVO = new PublicInquiryVO();
                    inquiryVO.setEmail(contactInfo.getString("email"));
                    inquiryVO.setId(paramObj.getString("id"));
                    inquiryVO.setPhone(contactInfo.getString("mobile"));
                    inquiryVO.setContacts(contactInfo.getString("name"));
                    inquiryVO.setBusinessType(paramObj.getString("businessType"));
                    inquiryService.apply(inquiryVO);
                    SaleEnquiryHead enquiryHead = new SaleEnquiryHead();
                    enquiryHead.setEnquiryNumber(dbHead.getEnquiryNumber());
                    QueryWrapper wrapper = new QueryWrapper((Object)enquiryHead);
                    if ((enquiryHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getOne((Wrapper)wrapper))) == null) continue;
                    Map taxMap = this.invokeBaseRpcService.getAllTax(supplierAccount);
                    List<SaleEnquiryItem> itemList = this.saleEnquiryItemService.selectByMainId(enquiryHead.getId());
                    Map mapItem = itemList.stream().collect(Collectors.toMap(SaleEnquiryItem::getRelationId, Function.identity()));
                    JSONArray supplyNoteItems = quotationItem.getJSONArray("supplyNoteItems");
                    ArrayList<SaleEnquiryItem> items = new ArrayList<SaleEnquiryItem>();
                    boolean taxCodeQueryFlag = false;
                    for (Object object2 : supplyNoteItems) {
                        JSONObject supplyNoteItem = JSONObject.parseObject((String)object2.toString());
                        SaleEnquiryItem saleEnquiryItem = (SaleEnquiryItem)((Object)mapItem.get(supplyNoteItem.getString("prItemId")));
                        saleEnquiryItem.setTaxRate(supplyNoteItem.getString("taxRate"));
                        for (String taxCode : taxMap.keySet()) {
                            if (((BigDecimal)taxMap.get(taxCode)).compareTo(new BigDecimal(saleEnquiryItem.getTaxRate())) != 0) continue;
                            saleEnquiryItem.setTaxCode(taxCode);
                            taxCodeQueryFlag = true;
                            break;
                        }
                        saleEnquiryItem.setPrice(supplyNoteItem.getBigDecimal("priceNew"));
                        saleEnquiryItem.setNetPrice(supplyNoteItem.getBigDecimal("excludeTaxPrice"));
                        saleEnquiryItem.setTaxAmount(saleEnquiryItem.getPrice().min(saleEnquiryItem.getRequireQuantity()));
                        saleEnquiryItem.setNetAmount(saleEnquiryItem.getNetPrice().min(saleEnquiryItem.getRequireQuantity()));
                        saleEnquiryItem.setEffectiveDate(new Date());
                        items.add(saleEnquiryItem);
                    }
                    ArrayList<SaleAttachmentDTO> attachmentDTOs = null;
                    if (StringUtils.isNotBlank((CharSequence)quotationItem.getString("attachments"))) {
                        attachmentDTOs = new ArrayList<SaleAttachmentDTO>();
                        JSONArray attachments = quotationItem.getJSONArray("attachments");
                        for (Object object2 : attachments) {
                            JSONObject attachment = JSONObject.parseObject((String)object2.toString());
                            attachmentDTOs.add(this.getAttachment(attachment, enquiryHead));
                        }
                    }
                    if (taxCodeQueryFlag) {
                        this.saleEnquiryHeadService.quote(enquiryHead, items, attachmentDTOs);
                        continue;
                    }
                    this.saleEnquiryHeadService.save(enquiryHead, items, attachmentDTOs);
                }
                catch (Exception e) {
                    throw new ELSBootException("", (Throwable)e, new String[0]);
                }
            }
        }
        log.info("\u5927\u4f01\u6c47\u62a5\u4ef7\u67e5\u8be2 \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        return supplierMemberIds;
    }

    public SaleAttachmentDTO getAttachment(JSONObject attachment, SaleEnquiryHead enquiryHead) {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        Object documentLocation = File.separator + BIZ_PATH + File.separator + enquiryHead.getElsAccount() + File.separator + nowDay + File.separator + attachment.getString("displayName");
        if (((String)documentLocation).contains("\\")) {
            documentLocation = ((String)documentLocation).replace("\\", "/");
        }
        if (((String)documentLocation).startsWith("\\")) {
            ((String)documentLocation).replace("\\", "");
        }
        if (((String)documentLocation).startsWith("/")) {
            documentLocation = ((String)documentLocation).substring(1);
        }
        this.fileRpcService.uploadFiles(this.getByUrl(attachment.getString("fileUrl")), (String)documentLocation, attachment.getString("displayName"), "oss");
        SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
        saleAttachmentDTO.setElsAccount(enquiryHead.getElsAccount());
        saleAttachmentDTO.setHeadId(enquiryHead.getId());
        saleAttachmentDTO.setBusinessType("fadada");
        saleAttachmentDTO.setFileType("5");
        LoginUser loginUser = SysUtil.getLoginUser();
        saleAttachmentDTO.setUploadElsAccount(loginUser.getElsAccount());
        saleAttachmentDTO.setUploadSubAccount(loginUser.getSubAccount());
        saleAttachmentDTO.setUploadTime(new Date());
        saleAttachmentDTO.setFileName(attachment.getString("displayName"));
        saleAttachmentDTO.setFilePath((String)documentLocation);
        saleAttachmentDTO.setSourceType("2");
        saleAttachmentDTO.setSaveType("oss");
        saleAttachmentDTO.setId(UUIDGenerator.generate());
        this.invokeBaseRpcService.insertSaleAttachment(saleAttachmentDTO);
        return saleAttachmentDTO;
    }

    public byte[] getByUrl(String path) {
        try {
            int bytesRead;
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            InputStream inputStream = connection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new ELSBootException("", (Throwable)e, new String[0]);
        }
    }

    @Override
    public void closeJutongbaoQuote(PurchaseEnquiryHead dbHead) {
        if (StringUtils.isNotBlank((CharSequence)dbHead.getBuyOfferId())) {
            ElsEnterpriseInfoDTO enterprise = this.elsEnterpriseInfoRpcService.getByElsAccount(dbHead.getElsAccount());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("corpid", (Object)enterprise.getCreditCode());
            jsonObject.put("buyOfferId", (Object)dbHead.getBuyOfferId());
            jsonObject.put("closeReason", (Object)"\u62a5\u4ef7\u65f6\u95f4\u622a\u6b62");
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("appkey", this.appkey);
            header.put("appsecret", this.appsecret);
            ((HttpRequest)HttpRequest.post((String)this.close_quote_url).addHeaders(header)).body(jsonObject.toJSONString()).execute().body();
        }
    }
}

