/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.clarification.entity.PurchaseTenderClarificationInfo;
import com.els.modules.tender.clarification.entity.SaleTenderClarificationInfo;
import com.els.modules.tender.clarification.service.PurchaseTenderClarificationInfoService;
import com.els.modules.tender.clarification.service.SaleTenderClarificationInfoService;
import com.els.modules.tender.clarification.vo.PurchaseTenderClarificationInfoVO;
import com.els.modules.tender.clarification.vo.SaleTenderClarificationInfoVO;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f9b\u5e94\u5546\u62db\u6807\u6f84\u6e05"})
@RestController
@RequestMapping(value={"/tender/saleTenderClarificationInfo"})
public class SaleTenderClarificationInfoController
extends BaseController<SaleTenderClarificationInfo, SaleTenderClarificationInfoService> {
    @Autowired
    private SaleTenderClarificationInfoService saleTenderClarificationInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderClarificationInfoService purchaseClarificationInfoService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService supplierService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryPageList(SaleTenderClarificationInfo saleTenderClarificationInfo) {
        List<SaleTenderClarificationInfoVO> saleTenderClarificationInfos = this.saleTenderClarificationInfoService.selectByMainId(saleTenderClarificationInfo.getSubpackageId());
        return Result.ok(saleTenderClarificationInfos);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseTenderClarificationInfo purchaseTenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)this.purchaseClarificationInfoService.getById((Serializable)((Object)id)));
        TenderProjectSupplier supplier = new TenderProjectSupplier();
        supplier.setSubpackageId(purchaseTenderClarificationInfo.getSubpackageId());
        supplier.setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> supplierList = this.supplierService.selectBySubpackageId(supplier);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(supplierList), (String)I18nUtil.translate((String)"i18n_alert_APeyLsUmmYB_1655988d", (String)"\u5f53\u524d\u8d26\u53f7\u672a\u53c2\u4e0e\u6b64\u6b21\u62db\u6807\uff01"));
        List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        PurchaseTenderClarificationInfoVO purchaseTenderClarificationInfoVO = (PurchaseTenderClarificationInfoVO)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderClarificationInfo), PurchaseTenderClarificationInfoVO.class));
        purchaseTenderClarificationInfoVO.setPurchaseAttachmentList(purchaseAttachmentDTOS);
        return Result.ok((Object)((Object)purchaseTenderClarificationInfoVO));
    }

    @ApiOperation(value="\u786e\u8ba4", notes="\u901a\u8fc7id\u67e5\u8be2")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> confirm(@RequestParam(name="id") String id) {
        SaleTenderClarificationInfo saleTenderClarificationInfo = this.saleTenderClarificationInfoService.confirm(id);
        return Result.ok((Object)((Object)saleTenderClarificationInfo));
    }
}

