/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.excel;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.logisticspurchase.base.entity.OriginatingAddressLibrary;
import com.els.modules.logisticspurchase.base.enumerate.StatusEnum;
import com.els.modules.logisticspurchase.base.service.OriginatingAddressLibraryService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="OriginatingAddressLibraryExcelHandler")
public class OriginatingAddressLibraryExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private OriginatingAddressLibraryService originatingAddressLibraryService;
    @Autowired
    private InvokeBaseRpcService baseRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        String elsAccount = TenantContext.getTenant();
        List addressTypeDictDTOS = this.baseRpcService.queryDictItemsByCode("addressType", TenantContext.getTenant());
        ArrayList<OriginatingAddressLibrary> OriginatingAddressLibraryList = new ArrayList<OriginatingAddressLibrary>();
        List dbList = this.originatingAddressLibraryService.list();
        List<Object> dbUniqueKeys = new ArrayList();
        if (dbList.size() > 0) {
            dbUniqueKeys = dbList.stream().map(item -> item.getStartProvince() + "_" + item.getStartCity() + "_" + item.getStartCounty() + "_" + item.getStartAddressType()).collect(Collectors.toList());
        }
        ArrayList<CallSite> uniqueKeys = new ArrayList<CallSite>();
        int index = 2;
        for (Map data : dataList) {
            String msg;
            String addressTypeDictText;
            String startProvince = data.get("startProvince") == null ? "" : data.get("startProvince");
            String startCity = data.get("startCity") == null ? "" : data.get("startCity");
            String startCounty = data.get("startCounty") == null ? "" : data.get("startCounty");
            String startAddressType = data.get("startAddressType") == null ? "" : data.get("startAddressType");
            String uniqueKey = startProvince + "_" + startCity + "_" + startCounty + "_" + startAddressType;
            ++index;
            if (uniqueKeys.contains(uniqueKey)) {
                addressTypeDictText = addressTypeDictDTOS.parallelStream().filter(o -> o.getValue().equals(startAddressType)).map(DictDTO::getText).collect(Collectors.joining());
                msg = "\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684\u6570\u636e\uff0c\u91cd\u590d\u6570\u636e\u4e3a\u5bfc\u5165\u8868\u4e2d\u7b2c" + index + " \u884c";
                data.put("arriveAddressType", addressTypeDictText);
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (CollUtil.isNotEmpty(dbUniqueKeys) && dbUniqueKeys.contains(uniqueKey)) {
                addressTypeDictText = addressTypeDictDTOS.parallelStream().filter(o -> o.getValue().equals(startAddressType)).map(DictDTO::getText).collect(Collectors.joining());
                msg = "\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u5bfc\u5165\u8868\u4e2d\u7b2c" + index + "\u884c\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01";
                data.put("arriveAddressType", addressTypeDictText);
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            uniqueKeys.add((CallSite)((Object)uniqueKey));
            OriginatingAddressLibrary entity = (OriginatingAddressLibrary)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), OriginatingAddressLibrary.class));
            entity.setStartNumber(this.baseRpcService.getNextCode("srmStartNumber", OriginatingAddressLibrary.class));
            entity.setStatus(StatusEnum.EFFECTIVE.getValue());
            entity.setDeleted(CommonConstant.DEL_FLAG_0);
            entity.setElsAccount(elsAccount);
            OriginatingAddressLibraryList.add(entity);
        }
        if (!CollectionUtils.isEmpty(OriginatingAddressLibraryList)) {
            this.originatingAddressLibraryService.saveBatch(OriginatingAddressLibraryList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

