/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.bidding.entity.PurchaseBiddingChange;
import com.els.modules.bidding.service.PurchaseBiddingChangeItemService;
import com.els.modules.bidding.service.PurchaseBiddingChangeService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseBiddingChangeAuditCallBackServiceImpl")
public class PurchaseBiddingChangeAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseBiddingChangeService purchaseBiddingChangeService;
    @Autowired
    private PurchaseBiddingChangeItemService purchaseBiddingChangeItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    @SrmTransaction
    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    @SrmTransaction
    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseBiddingChange head = (PurchaseBiddingChange)((Object)this.purchaseBiddingChangeService.getById((Serializable)((Object)id)));
        if (head != null) {
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseBiddingChange updateHead = new PurchaseBiddingChange();
        updateHead.setId(flowCallbackDTO.getBusinessId());
        updateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        updateHead.setAuditStatus(auditStatus);
        this.purchaseBiddingChangeService.updateById((Object)updateHead);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            this.purchaseBiddingChangeService.publish(flowCallbackDTO.getBusinessId());
        }
    }
}

