/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.entity.EbiddingConfirmItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingConfirm;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingConfirm;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.enumerate.EbiddingConfirmStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.mapper.PurchaseEbiddingConfirmMapper;
import com.els.modules.ebidding.service.EbiddingConfirmItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingConfirmService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingConfirmService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingHeadServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingConfirmServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingHeadServiceImpl;
import com.els.modules.ebidding.vo.PurchaseEbiddingConfirmVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchaseEbiddingConfirmServiceImpl
extends BaseServiceImpl<PurchaseEbiddingConfirmMapper, PurchaseEbiddingConfirm>
implements PurchaseEbiddingConfirmService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingConfirmServiceImpl.class);
    @Autowired
    private EbiddingConfirmItemService ebiddingConfirmItemService;
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;

    @Override
    public void addBatch(PurchaseEbiddingHead head, List<PurchaseEbiddingConfirmVO> confirmList) {
        if (CollectionUtil.isNotEmpty(confirmList)) {
            ArrayList<PurchaseEbiddingConfirmVO> insertList = new ArrayList<PurchaseEbiddingConfirmVO>();
            ArrayList<EbiddingConfirmItem> insertItemList = new ArrayList<EbiddingConfirmItem>();
            for (PurchaseEbiddingConfirmVO confirm : confirmList) {
                confirm.setId(IdWorker.getIdStr());
                confirm.setHeadId(head.getId());
                confirm.setStatus(EbiddingConfirmStatusEnum.NEW.getValue());
                SysUtil.setSysParam((BaseEntity)confirm, (BaseEntity)head);
                insertList.add(confirm);
                this.insertItemToList(head, confirm, insertItemList);
            }
            this.saveBatch(insertList, 2000);
            if (CollectionUtil.isNotEmpty(insertItemList)) {
                this.ebiddingConfirmItemService.saveBatch(insertItemList, 2000);
            }
        }
    }

    private void insertItemToList(PurchaseEbiddingHead head, PurchaseEbiddingConfirmVO confirm, List<EbiddingConfirmItem> insertItemList) {
        if (CollectionUtil.isNotEmpty(confirm.getConfirmItemList())) {
            for (EbiddingConfirmItem item : confirm.getConfirmItemList()) {
                EbiddingConfirmItem insert = new EbiddingConfirmItem();
                BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)insert));
                insert.setId(IdWorker.getIdStr());
                insert.setHeadId(confirm.getId());
                SysUtil.setSysParam((BaseEntity)insert, (BaseEntity)head);
                insertItemList.add(insert);
            }
        }
    }

    @Override
    public List<PurchaseEbiddingConfirm> publish(PurchaseEbiddingHead head, List<PurchaseEbiddingConfirmVO> confirmList, List<PurchaseEbiddingSupplier> supplierList) {
        ArrayList<PurchaseEbiddingConfirm> insertList = new ArrayList<PurchaseEbiddingConfirm>();
        if (CollectionUtil.isNotEmpty(confirmList)) {
            ArrayList<EbiddingConfirmItem> insertItemList = new ArrayList<EbiddingConfirmItem>();
            for (PurchaseEbiddingSupplier supplier : supplierList) {
                for (PurchaseEbiddingConfirmVO confirm : confirmList) {
                    confirm.setId(IdWorker.getIdStr());
                    PurchaseEbiddingConfirm insert = new PurchaseEbiddingConfirm();
                    BeanUtils.copyProperties((Object)((Object)confirm), (Object)((Object)insert));
                    SysUtil.setSysParam((BaseEntity)insert, (BaseEntity)head);
                    insert.setHeadId(head.getId());
                    insert.setRelationId(IdWorker.getIdStr());
                    insert.setStatus(EbiddingConfirmStatusEnum.WAITE_REPLY.getValue());
                    insert.setToElsAccount(supplier.getToElsAccount());
                    insert.setSupplierCode(supplier.getSupplierCode());
                    insert.setSupplierName(supplier.getSupplierName());
                    insertList.add(insert);
                    this.insertItemToList(head, confirm, insertItemList);
                }
            }
            log.info("confirm->insertList:{}", (Object)JSONObject.toJSONString(insertList));
            this.saveBatch(insertList, 2000);
            if (CollectionUtil.isNotEmpty(insertItemList)) {
                this.ebiddingConfirmItemService.saveBatch(insertItemList, 2000);
            }
        }
        return insertList;
    }

    @Override
    public void deleteByMainId(String mainId) {
        List<PurchaseEbiddingConfirm> confirmList = ((PurchaseEbiddingConfirmMapper)this.baseMapper).selectByMainId(mainId);
        ((PurchaseEbiddingConfirmMapper)this.baseMapper).deleteByMainId(mainId);
        List<String> idList = confirmList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        this.ebiddingConfirmItemService.deleteByMainId(idList);
    }

    @Override
    public List<PurchaseEbiddingConfirmVO> selectByMainId(String mainId) {
        List<PurchaseEbiddingConfirm> confirmList = ((PurchaseEbiddingConfirmMapper)this.baseMapper).selectByMainId(mainId);
        ArrayList result = SysUtil.copyProperties(confirmList, PurchaseEbiddingConfirmVO.class);
        if (CollectionUtil.isNotEmpty(confirmList)) {
            List idList = confirmList.stream().map(ParentEntity::getId).collect(Collectors.toList());
            List itemList = this.ebiddingConfirmItemService.list((Wrapper)new LambdaQueryWrapper().in(EbiddingConfirmItem::getHeadId, idList));
            Map<String, List<EbiddingConfirmItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(EbiddingConfirmItem::getHeadId));
            for (PurchaseEbiddingConfirmVO vo : result) {
                List<EbiddingConfirmItem> list = itemMap.get(vo.getId());
                vo.setConfirmItemList(list);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void confirm(List<PurchaseEbiddingConfirm> webConfirmList) {
        List<PurchaseEbiddingConfirm> confirmList = this.getOptionList(webConfirmList, EbiddingConfirmStatusEnum.CONFIRM.getValue());
        this.updateBatchById(confirmList);
        this.updateSaleConfirm(confirmList, EbiddingStatusEnum.WAIT_BIDDING.getValue());
        SaleEbiddingHeadService saleEbiddingHeadService = (SaleEbiddingHeadService)SpringContextUtils.getBean(SaleEbiddingHeadServiceImpl.class);
        saleEbiddingHeadService.updatePurchaseWaiteEbidding(confirmList.get(0).getHeadId());
        List toElsAccountList = confirmList.stream().map(PurchaseEbiddingConfirm::getToElsAccount).distinct().collect(Collectors.toList());
        super.sendMessage(TenantContext.getTenant(), "ebidding", "confirmPurchase", confirmList.get(0).getHeadId(), "ebiddingBusDataServiceImpl", toElsAccountList);
    }

    @Override
    @Transactional
    public void refuse(List<PurchaseEbiddingConfirm> webConfirmList) {
        List<PurchaseEbiddingConfirm> refuseList = this.getOptionList(webConfirmList, EbiddingConfirmStatusEnum.REFUSE.getValue());
        this.updateBatchById(refuseList);
        this.updateSaleConfirm(refuseList, EbiddingStatusEnum.REPLY_REFUSE.getValue());
        List toElsAccountList = refuseList.stream().map(PurchaseEbiddingConfirm::getToElsAccount).distinct().collect(Collectors.toList());
        this.purchaseEbiddingSupplierService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingSupplier::getHeadId, (Object)refuseList.get(0).getHeadId())).in(PurchaseEbiddingSupplier::getToElsAccount, toElsAccountList)).set(PurchaseEbiddingSupplier::getReplyStatus, (Object)EbiddingReplyStatusEnum.REPLY_REFUSE.getValue()));
        super.sendMessage(TenantContext.getTenant(), "ebidding", "purchaseReject", refuseList.get(0).getHeadId(), "ebiddingBusDataServiceImpl", toElsAccountList);
    }

    @Override
    @Transactional
    public void replyAgain(List<PurchaseEbiddingConfirm> webConfirmList) {
        List<PurchaseEbiddingConfirm> replyAgainList = this.getOptionList(webConfirmList, EbiddingConfirmStatusEnum.WAITE_REPLY.getValue());
        this.updateBatchById(replyAgainList);
        this.updateSaleConfirm(replyAgainList, EbiddingStatusEnum.WAIT_REPLY.getValue());
        List toElsAccountList = replyAgainList.stream().map(PurchaseEbiddingConfirm::getToElsAccount).distinct().collect(Collectors.toList());
        PurchaseEbiddingHeadService purchaseEbiddingHeadService = (PurchaseEbiddingHeadService)SpringContextUtils.getBean(PurchaseEbiddingHeadServiceImpl.class);
        PurchaseEbiddingHead dbPurchaseHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadServiceImpl)SpringContextUtils.getBean(PurchaseEbiddingHeadServiceImpl.class)).getById((Serializable)((Object)replyAgainList.get(0).getHeadId())));
        Integer replyQuantity = dbPurchaseHead.getReplyQuantity() == null ? 0 : dbPurchaseHead.getReplyQuantity() - toElsAccountList.size();
        dbPurchaseHead.setReplyQuantity(replyQuantity);
        purchaseEbiddingHeadService.updateById((Object)dbPurchaseHead);
        super.sendMessage(TenantContext.getTenant(), "ebidding", "reply", replyAgainList.get(0).getHeadId(), "ebiddingBusDataServiceImpl", toElsAccountList);
    }

    private List<PurchaseEbiddingConfirm> getOptionList(List<PurchaseEbiddingConfirm> webConfirmList, String status) {
        String headId = webConfirmList.get(0).getHeadId();
        List<String> toElsAccountList = webConfirmList.stream().map(PurchaseEbiddingConfirm::getToElsAccount).distinct().toList();
        List<PurchaseEbiddingConfirm> dbConfirmList = ((PurchaseEbiddingConfirmMapper)this.baseMapper).selectByMainId(headId);
        List<PurchaseEbiddingConfirm> optionList = dbConfirmList.stream().filter(confirm -> toElsAccountList.contains(confirm.getToElsAccount())).collect(Collectors.toList());
        optionList.forEach(confirm -> {
            Assert.isTrue((boolean)EbiddingConfirmStatusEnum.ALREADY_REPLY.getValue().equals(confirm.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_IMBjcnqtk_65622fda", (String)"\u5df2\u56de\u590d\u7684\u884c\u624d\u53ef\u64cd\u4f5c"));
            confirm.setStatus(status);
        });
        return optionList;
    }

    private void updateSaleConfirm(List<PurchaseEbiddingConfirm> optionList, String ebiddingStatus) {
        List relationIdList = optionList.stream().map(PurchaseEbiddingConfirm::getRelationId).collect(Collectors.toList());
        SaleEbiddingConfirmService saleEbiddingConfirmService = (SaleEbiddingConfirmService)SpringContextUtils.getBean(SaleEbiddingConfirmServiceImpl.class);
        List saleDbConfirmList = saleEbiddingConfirmService.listByIds(relationIdList);
        List<String> headIdList = saleDbConfirmList.stream().map(SaleEbiddingConfirm::getHeadId).distinct().toList();
        ArrayList<SaleEbiddingHead> headList = new ArrayList<SaleEbiddingHead>();
        for (String id : headIdList) {
            SaleEbiddingHead head = new SaleEbiddingHead();
            head.setId(id);
            head.setEbiddingStatus(ebiddingStatus);
            headList.add(head);
        }
        SaleEbiddingHeadService saleEbiddingHeadService = (SaleEbiddingHeadService)SpringContextUtils.getBean(SaleEbiddingHeadServiceImpl.class);
        saleEbiddingHeadService.updateBatchById(headList);
        ArrayList<SaleEbiddingConfirm> updateList = new ArrayList<SaleEbiddingConfirm>();
        for (PurchaseEbiddingConfirm confirm : optionList) {
            SaleEbiddingConfirm saleConfirm = new SaleEbiddingConfirm();
            saleConfirm.setId(confirm.getRelationId());
            saleConfirm.setStatus(confirm.getStatus());
            updateList.add(saleConfirm);
        }
        saleEbiddingConfirmService.updateBatchById(updateList);
    }
}

