/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemMapper;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.service.impl.SaleEbiddingItemServiceImpl;
import com.els.modules.ebidding.utils.CompareIPUtils;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseEbiddingItemServiceImpl
extends ServiceImpl<PurchaseEbiddingItemMapper, PurchaseEbiddingItem>
implements PurchaseEbiddingItemService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingItemServiceImpl.class);
    @Autowired
    @Lazy
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    @Lazy
    private PurchaseEbiddingItemHisService purchaseEbiddingItemHisService;
    @Autowired
    @Lazy
    private PurchaseEbiddingSupplierService ebiddingSupplierService;

    @Override
    public List<PurchaseEbiddingItem> selectByMainId(String mainId) {
        return ((PurchaseEbiddingItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEbiddingItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void deleteStatus(String mainId, String itemStatus) {
        ((PurchaseEbiddingItemMapper)this.baseMapper).deleteStatus(mainId, itemStatus);
    }

    @Override
    public void addBatch(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            int itemNumber = 1;
            for (PurchaseEbiddingItem item : itemList) {
                item.setId(IdWorker.getIdStr());
                item.setHeadId(head.getId());
                item.setDocumentId(head.getDocumentId());
                item.setEbiddingNumber(head.getEbiddingNumber());
                item.setItemStatus(EbiddingItemStatusEnum.NEW.getValue());
                item.setAuditStatus(head.getResultAuditStatus());
                item.setSendStatus("0");
                item.setItemNumber(String.valueOf(itemNumber++));
                item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.saveBatch(itemList, 2000);
        }
    }

    @Override
    public List<PurchaseEbiddingItem> publish(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, Map<String, PurchaseMaterialRelationDTO> relationMap) {
        ArrayList<PurchaseEbiddingItem> insertList = new ArrayList<PurchaseEbiddingItem>();
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            int itemNumber = 1;
            for (PurchaseEbiddingItem item : itemList) {
                PurchaseEbiddingItem insertItem = new PurchaseEbiddingItem();
                BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)insertItem));
                SysUtil.setSysParam((BaseEntity)insertItem, (BaseEntity)head);
                insertItem.setId(IdWorker.getIdStr());
                insertItem.setRelationId(IdWorker.getIdStr());
                insertItem.setHeadId(head.getId());
                insertItem.setEbiddingNumber(head.getEbiddingNumber());
                insertItem.setItemNumber(String.valueOf(itemNumber++));
                insertItem.setToElsAccount(supplier.getToElsAccount());
                insertItem.setSupplierCode(supplier.getSupplierCode());
                insertItem.setSupplierName(supplier.getSupplierName());
                insertItem.setItemStatus(EbiddingItemStatusEnum.PUBLISHED.getValue());
                insertItem.setCurrentRound(head.getCurrentRound());
                if (StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())) {
                    PurchaseMaterialRelationDTO relation = relationMap.get(item.getMaterialNumber() + supplier.getToElsAccount());
                    insertItem.setSaleMaterialNumber(relation == null ? null : relation.getSaleMaterialNumber());
                }
                insertList.add(insertItem);
            }
        }
        this.saveBatch(insertList, 2000);
        return insertList;
    }

    @Override
    public void updateBidByHeadId(List<PurchaseEbiddingItem> purchaseItemList) {
        ((PurchaseEbiddingItemMapper)this.baseMapper).updateBidByHeadId(purchaseItemList);
    }

    @Override
    public PurchaseEbiddingItem selectOneByMainIdAndItemNumber(String headId, String itemNumber) {
        return ((PurchaseEbiddingItemMapper)this.baseMapper).selectOneByMainIdAndItemNumber(headId, itemNumber);
    }

    @Override
    public void replenishMaterialNumber(PurchaseEbiddingItem webItem) {
        List<PurchaseEbiddingItem> itemList = this.selectByMainId(webItem.getHeadId());
        this.checkMaterialNumber(webItem, itemList);
        List<PurchaseEbiddingItem> items = itemList.stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        items.forEach(item -> {
            item.setMaterialNumber(webItem.getMaterialNumber());
            item.setMaterialDesc(webItem.getMaterialDesc());
            item.setMaterialGroup(webItem.getMaterialGroup());
            item.setMaterialSpec(webItem.getMaterialSpec());
            item.setMaterialGroupName(webItem.getMaterialGroupName());
        });
        this.updateBatchById(items);
        SaleEbiddingItemService saleEbiddingItemService = (SaleEbiddingItemService)SpringContextUtils.getBean(SaleEbiddingItemServiceImpl.class);
        saleEbiddingItemService.replenishMaterialNumber(items);
        PurchaseEbiddingItem item2 = items.get(0);
        if (SourceTypeEnum.REQUEST.getValue().equals(item2.getSourceType()) && StrUtil.isNotBlank((CharSequence)item2.getSourceItemId())) {
            this.purchaseRequestItemService.replenishMaterial(item2.getSourceItemId(), item2.getMaterialNumber(), item2.getMaterialDesc(), item2.getMaterialGroup(), item2.getMaterialSpec());
        }
    }

    private void checkMaterialNumber(PurchaseEbiddingItem webItem, List<PurchaseEbiddingItem> itemList) {
        List materialNumbers = itemList.stream().map(PurchaseEbiddingItem::getMaterialNumber).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialNumbers)) {
            return;
        }
        boolean b = materialNumbers.stream().anyMatch(item -> item.equals(webItem.getMaterialNumber()));
        if (b) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__SLAoxOVB_f1d5e3eb", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u91cd\u590d"));
        }
    }

    @Override
    public Map<String, Long> getSupplierPortraitCount(String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEbiddingItem::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        List allList = this.list((Wrapper)queryWrapper);
        long participationCount = allList.stream().map(PurchaseEbiddingItem::getHeadId).distinct().count();
        long biddingWinCount = allList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItem::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return returnMap;
    }

    @Override
    public List<SupplierRelationFindResultVO> probeIP(String headId, Map<String, PurchaseEbiddingSupplier> supplierMap) {
        ArrayList<SupplierRelationFindResultVO> result = new ArrayList<SupplierRelationFindResultVO>();
        List<PurchaseEbiddingItem> dbItemList = ((PurchaseEbiddingItemMapper)this.baseMapper).selectByMainId(headId);
        List accountIpList = dbItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getQuoteIp())).map(item -> item.getToElsAccount() + "_" + item.getQuoteIp()).distinct().collect(Collectors.toList());
        for (String sourceAccountIp : accountIpList) {
            for (String targetAccountIp : accountIpList) {
                if (sourceAccountIp.equals(targetAccountIp)) continue;
                CompareIPUtils.compareEbiddingIp(sourceAccountIp, targetAccountIp, supplierMap, result);
            }
        }
        return result;
    }

    @Override
    public List<PurchaseEbiddingItem> queryEbiddingByDesc(List<String> materialDescs) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BID_WIN.getValue())).in(PurchaseEbiddingItem::getMaterialDesc, materialDescs)).and(qw -> ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(PurchaseEbiddingItem::getMaterialNumber)).or()).eq(PurchaseEbiddingItem::getMaterialNumber, (Object)""));
        return ((PurchaseEbiddingItemMapper)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<PurchaseEbiddingItem> selectWithoutElsAccountByRelationId(List<String> relationIds) {
        return ((PurchaseEbiddingItemMapper)this.baseMapper).selectWithoutElsAccountByRelationId(relationIds);
    }

    @Override
    public List<PurchaseEbiddingItem> findBySourceItemId(List<String> headIdList, List<String> sourceIdList) {
        return ((PurchaseEbiddingItemMapper)this.baseMapper).findBySourceItemId(headIdList, sourceIdList);
    }

    @Override
    public void exportCompare(PurchaseEbiddingHead dbHead, HttpServletResponse response) {
        List<PurchaseEbiddingItem> itemList = ((PurchaseEbiddingItemMapper)this.baseMapper).selectByMainId(dbHead.getId());
        List itemHisList = this.purchaseEbiddingItemHisService.list((Wrapper)new LambdaQueryWrapper().eq(PurchaseEbiddingItemHis::getHeadId, (Object)dbHead.getId()));
        List toElsAccountList = itemHisList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getToElsAccount())).map(PurchaseEbiddingItemHis::getToElsAccount).distinct().collect(Collectors.toList());
        Comparator<PurchaseEbiddingItemHis> comparing = Comparator.comparing(PurchaseEbiddingItemHis::getQuoteCount);
        Map<String, Optional<PurchaseEbiddingItemHis>> eldestByClass = itemHisList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemHis::getToElsAccount, Collectors.reducing(BinaryOperator.maxBy(comparing))));
        List distinctList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEbiddingItem>(Comparator.comparing(PurchaseEbiddingItem::getItemNumber))), ArrayList::new));
        List<PurchaseEbiddingSupplier> supplierList = this.ebiddingSupplierService.selectByMainId(dbHead.getId()).stream().filter(item -> toElsAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
        ExcelWriter writer = new ExcelWriter(true, "\u6bd4\u4ef7\u62a5\u8868");
        writer.writeHeadRow(this.getHeaderList(supplierList, eldestByClass, "\u7ade\u4ef7\u5355\u53f7", "\u7ade\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u5bf9\u6bd4\u9879"));
        int firstRow = 1;
        List<PurchaseEbiddingItem> normalItemList = distinctList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.toList());
        List<JSONObject> data = this.getDictJsonObjects(normalItemList);
        int i = 0;
        for (PurchaseEbiddingItem item2 : normalItemList) {
            JSONObject jsonObject = data.get(i);
            writer.merge(firstRow, firstRow + 9, 0, 0, (Object)item2.getEbiddingNumber(), false);
            writer.merge(firstRow, firstRow + 9, 1, 1, (Object)item2.getItemNumber(), false);
            writer.merge(firstRow, firstRow + 9, 2, 2, (Object)item2.getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + 9, 3, 3, (Object)item2.getMaterialName(), false);
            writer.merge(firstRow, firstRow + 9, 4, 4, (Object)item2.getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + 9, 5, 5, (Object)item2.getMaterialSpec(), false);
            writer.merge(firstRow, firstRow + 9, 6, 6, (Object)item2.getRequireQuantity(), false);
            writer.merge(firstRow, firstRow + 9, 7, 7, (Object)jsonObject.getString("purchaseUnit_dictText"), false);
            writer.merge(firstRow, firstRow + 9, 8, 8, (Object)jsonObject.getString("factory_dictText"), false);
            writer.merge(firstRow, firstRow + 9, 9, 9, (Object)jsonObject.getString("storageLocation_dictText"), false);
            ++i;
            writer.writeCellValue(11, firstRow, (Object)"\u542b\u7a0e\u4ef7");
            writer.writeCellValue(11, firstRow + 1, (Object)"\u672a\u7a0e\u5355\u4ef7");
            writer.writeCellValue(11, firstRow + 2, (Object)"\u7a0e\u7387");
            writer.writeCellValue(11, firstRow + 3, (Object)"\u4ea4\u8d27\u65e5\u671f");
            writer.writeCellValue(11, firstRow + 4, (Object)"\u62a5\u4ef7\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 5, (Object)"\u6700\u5c0f\u5305\u88c5\u91cf");
            writer.writeCellValue(11, firstRow + 6, (Object)"\u6700\u5c0f\u8ba2\u5355\u91cf");
            writer.writeCellValue(11, firstRow + 7, (Object)"\u4ef7\u683c\u751f\u6548\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 8, (Object)"\u4ef7\u683c\u5931\u6548\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 9, (Object)"\u62a5\u4ef7\u8f6e\u6b21");
            firstRow += 10;
        }
        Map<String, Integer> collect = normalItemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getItemNumber, item -> normalItemList.indexOf(item)));
        AtomicInteger x = new AtomicInteger(12);
        if (!CollectionUtils.isEmpty(normalItemList)) {
            for (PurchaseEbiddingSupplier supplier : supplierList) {
                List dataList = itemHisList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
                Map<String, List<PurchaseEbiddingItemHis>> itemByNumberMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemHis::getItemNumber));
                AtomicReference<AtomicInteger> y = new AtomicReference<AtomicInteger>(new AtomicInteger(1));
                int[] row = new int[]{0};
                itemByNumberMap.forEach((itemNumber, v) -> {
                    if (v.size() > row[0]) {
                        row[0] = v.size();
                    }
                    y.set(new AtomicInteger((Integer)collect.get(itemNumber) * 10 + 1));
                    AtomicInteger finalX = new AtomicInteger(x.get());
                    v.stream().sorted(Comparator.comparing(PurchaseEbiddingItemHis::getQuoteCount)).forEach(item -> {
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get(), (Object)item.getPrice().setScale(6));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 1, (Object)item.getNetPrice().setScale(6));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 2, (Object)item.getTaxRate());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 3, item.getDeliveryDate() == null ? null : DateUtil.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 4, item.getQuoteTime() == null ? null : DateUtil.format((Date)item.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 5, (Object)item.getMinPackQuantity());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 6, (Object)item.getMinOrderQuantity());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 7, item.getEffectiveDate() == null ? null : DateUtil.format((Date)item.getEffectiveDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 8, item.getExpiryDate() == null ? null : DateUtil.format((Date)item.getExpiryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 9, (Object)item.getQuoteCount());
                        writer.setColumnWidth(finalX.get(), 16);
                        finalX.getAndIncrement();
                    });
                });
                if (row[0] > 1) {
                    writer.merge(0, 0, x.get(), x.addAndGet(row[0]) - 1, (Object)supplier.getSupplierName(), true);
                    continue;
                }
                x.addAndGet(row[0]);
            }
        }
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u6bd4\u4ef7\u62a5\u8868.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }

    private List<String> getHeaderList(List<PurchaseEbiddingSupplier> supplierList, Map<String, Optional<PurchaseEbiddingItemHis>> eldestByClass, String ... headText) {
        ArrayList<String> excelHeader = new ArrayList<String>(Arrays.asList(headText));
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            if (eldestByClass.containsKey(supplier.getToElsAccount())) {
                Optional<PurchaseEbiddingItemHis> purchaseEnquiryItemHis = eldestByClass.get(supplier.getToElsAccount());
                Integer quoteCount = purchaseEnquiryItemHis.get().getQuoteCount();
                for (int i = 0; i < quoteCount; ++i) {
                    excelHeader.add(supplier.getSupplierName());
                }
                continue;
            }
            excelHeader.add(supplier.getSupplierName());
        }
        return excelHeader;
    }

    private List<JSONObject> getDictJsonObjects(List<PurchaseEbiddingItem> distinctList) {
        ArrayList itemList1 = new ArrayList();
        distinctList.forEach(e -> {
            PurchaseEbiddingItem item = new PurchaseEbiddingItem();
            BeanUtils.copyProperties((Object)e, (Object)((Object)item));
            itemList1.add(item);
        });
        Result dbResult = Result.ok(itemList1);
        ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)dbResult, new DictTranslateAspectParam());
        return (List)dbResult.getResult();
    }
}

