/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.ebidding.constant.EbiddingConstant;
import com.els.modules.ebidding.entity.PurchaseEbiddingConfirm;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.entity.SaleEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingDelayRuleEnum;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingRangeUnitEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.mapper.PurchaseEbiddingHeadMapper;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemHisMapper;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemMapper;
import com.els.modules.ebidding.mapper.SaleEbiddingHeadMapper;
import com.els.modules.ebidding.mapper.SaleEbiddingItemMapper;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingConfirmService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemHisService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingHeadServiceImpl;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingItemHisServiceImpl;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingItemServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingItemHisServiceImpl;
import com.els.modules.ebidding.vo.PurchaseEbiddingMessageVO;
import com.els.modules.ebidding.vo.SaleEbiddingConfirmVO;
import com.els.modules.ebidding.vo.SaleEbiddingHeadVO;
import com.els.modules.socket.utils.SocketUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class SaleEbiddingHeadServiceImpl
extends BaseServiceImpl<SaleEbiddingHeadMapper, SaleEbiddingHead>
implements SaleEbiddingHeadService {
    private static final Logger log = LoggerFactory.getLogger(SaleEbiddingHeadServiceImpl.class);
    @Resource
    private SaleEbiddingItemMapper saleEbiddingItemMapper;
    @Resource
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Resource
    private PurchaseEbiddingHeadMapper purchaseEbiddingHeadMapper;
    @Resource
    private PurchaseEbiddingItemMapper purchaseEbiddingItemMapper;
    @Autowired
    private SaleEbiddingItemService saleEbiddingItemService;
    @Autowired
    private SaleEbiddingConfirmService saleEbiddingConfirmService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private SaleEbiddingItemHisService saleEbiddingItemHisService;
    @Resource
    private PurchaseEbiddingItemHisMapper purchaseEbiddingItemHisMapper;
    @Autowired
    private RedisUtil redis;
    @Autowired
    private ThreadPoolExecutor srmPoolExecutor;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public Map<String, String> publish(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseEbiddingConfirm> confirmList) {
        ArrayList<SaleEbiddingHead> saleHeadList = new ArrayList<SaleEbiddingHead>();
        LoginUserDTO user = SysUtil.getLoginUser();
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SaleEbiddingHead saleHead = new SaleEbiddingHead();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)saleHead));
            SysUtil.setSysParam((BaseEntity)saleHead, (BaseEntity)head);
            saleHead.setId(IdWorker.getIdStr());
            saleHead.setRelationId(head.getId());
            saleHead.setElsAccount(supplier.getToElsAccount());
            saleHead.setToElsAccount(supplier.getElsAccount());
            saleHead.setPurchaseName(user.getCompanyName());
            saleHead.setSupplierListId(supplier.getId());
            saleHead.setTargetTotalAmount("1".equals(head.getSendTargetPrice()) ? head.getTargetTotalAmount() : null);
            saleHead.setStartTotalAmount("1".equals(head.getSetStartPrice()) ? head.getStartTotalAmount() : null);
            saleHead.setEbiddingStatus("1".equals(head.getNeedEcho()) ? EbiddingStatusEnum.WAIT_REPLY.getValue() : EbiddingStatusEnum.WAIT_BIDDING.getValue());
            saleHeadList.add(saleHead);
        }
        this.saveBatch(saleHeadList, 2000);
        Map<String, String> idMap = saleHeadList.stream().collect(Collectors.toMap(ParentEntity::getElsAccount, ParentEntity::getId));
        this.saleEbiddingItemService.publish(head, itemList, idMap);
        this.saleEbiddingConfirmService.publish(head, confirmList, idMap);
        return idMap;
    }

    @Override
    public void acceptResponse(SaleEbiddingHeadVO webVO) {
        List<SaleAttachmentDTO> attachmentList;
        List<SaleEbiddingConfirmVO> confirmList = webVO.getPurchaseEbiddingConfirmList();
        SaleEbiddingHead saleHead = new SaleEbiddingHead();
        saleHead.setId(webVO.getId());
        saleHead.setEbiddingStatus(CollectionUtil.isEmpty(confirmList) ? EbiddingStatusEnum.WAIT_BIDDING.getValue() : EbiddingStatusEnum.ALREADY_REPLY.getValue());
        saleHead.setTaxCode(webVO.getTaxCode());
        saleHead.setTaxRate(webVO.getTaxRate());
        ((SaleEbiddingHeadMapper)this.baseMapper).updateById((Object)saleHead);
        PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
        supplier.setId(webVO.getSupplierListId());
        supplier.setReplyTime(new Date());
        supplier.setReplyStatus(EbiddingReplyStatusEnum.HAS_REPLY.getValue());
        this.purchaseEbiddingSupplierService.updateById((Object)supplier);
        PurchaseEbiddingHead dbPurchaseHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)webVO.getRelationId())));
        Integer replyQuantity = dbPurchaseHead.getReplyQuantity() == null ? 1 : dbPurchaseHead.getReplyQuantity() + 1;
        dbPurchaseHead.setReplyQuantity(replyQuantity);
        this.purchaseEbiddingHeadMapper.updateById((Object)dbPurchaseHead);
        if (EbiddingStatusEnum.WAIT_BIDDING.getValue().equals(saleHead.getEbiddingStatus())) {
            this.updatePurchaseWaiteEbidding(webVO.getRelationId());
        }
        if (CollectionUtil.isNotEmpty(attachmentList = webVO.getSaleAttachmentList())) {
            this.invokeBaseRpcService.updateSaleAttachmentBatchById(attachmentList);
        }
        this.saleEbiddingItemService.acceptResponse(webVO);
        this.saleEbiddingConfirmService.acceptResponse(confirmList);
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(webVO.getId());
        sendVO.setElsAccount(webVO.getElsAccount());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        toSend.put(webVO.getRelationId(), webVO.getToElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        String purchaseElsAccount = dbPurchaseHead.getElsAccount();
        super.sendMessage(purchaseElsAccount, "ebidding", "acceptResponse", dbPurchaseHead.getId(), "ebiddingBusDataServiceImpl", Arrays.asList(purchaseElsAccount));
    }

    private Map<String, List<String>> getReceiveElsAccountMap(String elsAccount, String purchasePrincipal) {
        String subAccount = StrUtil.isBlank((CharSequence)purchasePrincipal) ? "1001" : purchasePrincipal.split("_")[0];
        ArrayList<String> subAccountList = new ArrayList<String>();
        subAccountList.add(subAccount);
        HashMap<String, List<String>> receiveElsAccountMap = new HashMap<String, List<String>>();
        receiveElsAccountMap.put(elsAccount, subAccountList);
        return receiveElsAccountMap;
    }

    @Override
    public void updatePurchaseWaiteEbidding(String purchaseHeadId) {
        List<SaleEbiddingHead> dbHeadList = this.getByRelationId(purchaseHeadId);
        long waiteCount = dbHeadList.stream().filter(head -> EbiddingStatusEnum.WAIT_BIDDING.getValue().equals(head.getEbiddingStatus())).count();
        if (waiteCount == (long)dbHeadList.size()) {
            PurchaseEbiddingHead update = new PurchaseEbiddingHead();
            update.setId(purchaseHeadId);
            update.setEbiddingStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
            this.purchaseEbiddingHeadMapper.updateById((Object)update);
        }
    }

    @Override
    public void refuseResponse(SaleEbiddingHead dbHead) {
        dbHead.setEbiddingStatus(EbiddingStatusEnum.NOT_JOINING.getValue());
        ((SaleEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
        supplier.setId(dbHead.getSupplierListId());
        supplier.setReplyTime(new Date());
        supplier.setReplyStatus(EbiddingReplyStatusEnum.REJECT.getValue());
        this.purchaseEbiddingSupplierService.updateById((Object)supplier);
        PurchaseEbiddingMessageVO messageVO = new PurchaseEbiddingMessageVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)messageVO));
        messageVO.setSupplierName(SysUtil.getLoginUser().getCompanyName());
        String purchaseElsAccount = dbHead.getToElsAccount();
        String url = "id=" + dbHead.getRelationId() + "&templateNumber=" + dbHead.getTemplateNumber() + "&=templateAccount" + dbHead.getTemplateAccount() + "&templateVersion=" + dbHead.getTemplateVersion();
        super.sendMessage(dbHead.getBusAccount(), "ebidding", "refuseResponse", dbHead.getId(), "ebiddingBusDataServiceImpl", Arrays.asList(purchaseElsAccount));
    }

    @Override
    public void startEbidding(PurchaseEbiddingHead dbHead, List<String> itemIdList) {
        SaleEbiddingHead saleHead = new SaleEbiddingHead();
        saleHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
        saleHead.setCurrentItemNumber(dbHead.getCurrentItemNumber());
        saleHead.setCurrentMaterialDesc(dbHead.getCurrentMaterialDesc());
        saleHead.setBeginTime(dbHead.getBeginTime());
        saleHead.setStartTime(dbHead.getStartTime());
        saleHead.setEndTime(dbHead.getEndTime());
        saleHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
        this.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.WAIT_BIDDING.getValue()));
        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getRelationId, itemIdList)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING.getValue()));
    }

    @Override
    public void endEbidding(PurchaseEbiddingHead dbHead, List<String> itemIdList) {
        SaleEbiddingHead saleHead = new SaleEbiddingHead();
        saleHead.setEbiddingStatus(dbHead.getEbiddingStatus());
        saleHead.setCurrentItemNumber(dbHead.getCurrentItemNumber());
        saleHead.setCurrentMaterialDesc(dbHead.getCurrentMaterialDesc());
        saleHead.setBeginTime(dbHead.getBeginTime());
        saleHead.setStartTime(dbHead.getStartTime());
        saleHead.setEndTime(dbHead.getEndTime());
        saleHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
        saleHead.setQuoteFlag(dbHead.getQuoteFlag());
        this.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getRelationId, itemIdList)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
    }

    private BigDecimal getPrice(String ebiddingType, String ebiddingWay, String quoteType, List<PurchaseEbiddingItem> purchaseItemList) {
        BigDecimal resultPrice = null;
        if (EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay) || EbiddingWayEnum.DISPOSABLE.getValue().equals(ebiddingWay)) {
            if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
                for (PurchaseEbiddingItem item : purchaseItemList) {
                    BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getPrice() : item.getNetPrice();
                    if (price == null || resultPrice != null && price.compareTo(resultPrice) <= 0) continue;
                    resultPrice = price;
                }
            } else {
                for (PurchaseEbiddingItem item : purchaseItemList) {
                    BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getPrice() : item.getNetPrice();
                    if (price == null || resultPrice != null && price.compareTo(resultPrice) >= 0) continue;
                    resultPrice = price;
                }
            }
        } else if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getTotalAmount() : item.getNetTotalAmount();
                if (price == null || resultPrice != null && price.compareTo(resultPrice) <= 0) continue;
                resultPrice = price;
            }
        } else {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getTotalAmount() : item.getNetTotalAmount();
                if (price == null || resultPrice != null && price.compareTo(resultPrice) >= 0) continue;
                resultPrice = price;
            }
        }
        return resultPrice;
    }

    private void checkStartPrice(SaleEbiddingHead dbHead, String ebiddingType, BigDecimal startPrice, BigDecimal webPrice) {
        boolean flag;
        if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) && "1".equals(dbHead.getSetStartPrice())) {
            flag = startPrice == null || startPrice.compareTo(BigDecimal.ZERO) == 0 || startPrice.compareTo(webPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_idOuWsulTfUEUAAu_dc6d22a8", (String)"\u6b63\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
        }
        if (EbiddingTypeEnum.REVERSE_BID.getValue().equals(ebiddingType) && "1".equals(dbHead.getSetStartPrice())) {
            flag = startPrice == null || startPrice.compareTo(BigDecimal.ZERO) == 0 || startPrice.compareTo(webPrice) >= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_vdOuWsulTXUEUAAu_53224de6", (String)"\u53cd\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
        }
    }

    private void checkQuote(SaleEbiddingHead dbSaleHead, List<SaleEbiddingItem> quoteList, Map<String, SaleEbiddingItem> dbItemMap, Date currentTime, PurchaseEbiddingSupplier supplier, Map<String, List<PurchaseEbiddingItem>> purchaseMap) {
        String supplierShow;
        Assert.isTrue((boolean)dbSaleHead.getEndTime().after(currentTime), (String)I18nUtil.translate((String)"i18n_alert_OuyWKIIuWxOsuW_f1045134", (String)"\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u5df2\u5230\uff0c\u4e0d\u80fd\u62a5\u4ef7\uff01"));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(dbSaleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjOuszEnqsu_10a99734", (String)"\u53ea\u6709\u7ade\u4ef7\u4e2d\u72b6\u6001\u624d\u53ef\u62a5\u4ef7"));
        if ("1".equals(dbSaleHead.getNeedEcho())) {
            Assert.isTrue((boolean)EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus()), (String)I18nUtil.translate((String)"i18n_alert_dBSnqsu_7140f4af", (String)"\u5e94\u6807\u540e\u624d\u53ef\u62a5\u4ef7"));
        }
        for (SaleEbiddingItem quoteItem : quoteList) {
            if (quoteItem.getExpiryDate() == null || quoteItem.getEffectiveDate() == null || !quoteItem.getEffectiveDate().after(quoteItem.getExpiryDate())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBAxOfUKXBAW_70448216", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\uff01"));
        }
        String ebiddingType = dbSaleHead.getEbiddingType();
        String string = supplierShow = dbSaleHead.getSupplierShow() == null ? "" : dbSaleHead.getSupplierShow();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItem quoteItem = quoteList.get(0);
            SaleEbiddingItem currentItem = dbItemMap.get(quoteItem.getItemNumber());
            Assert.isTrue((boolean)quoteItem.getItemNumber().equals(dbSaleHead.getCurrentItemNumber()), (String)I18nUtil.translate((String)"i18n_alert_rSLxqsu_4c371469", (String)"\u8be5\u7269\u6599\u4e0d\u53ef\u62a5\u4ef7"));
            webPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getPrice() : quoteItem.getNetPrice();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            this.checkStartPrice(dbSaleHead, ebiddingType, currentItem.getStartPrice(), webPrice);
            dbPrice = supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) ? this.getPrice(ebiddingType, EbiddingWayEnum.SINGLE.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get(quoteItem.getItemNumber())) : (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getPrice() : currentItem.getNetPrice());
            this.checkChangeRange(dbSaleHead, ebiddingType, dbPrice, webPrice);
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItem quoteItem = quoteList.get(0);
            SaleEbiddingItem currentItem = dbItemMap.get("1");
            webPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getTotalAmount() : quoteItem.getNetTotalAmount();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            this.checkStartPrice(dbSaleHead, ebiddingType, dbSaleHead.getStartTotalAmount(), webPrice);
            dbPrice = supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) ? this.getPrice(ebiddingType, EbiddingWayEnum.PACKAGE.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get("1")) : (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getTotalAmount() : currentItem.getNetTotalAmount());
            this.checkChangeRange(dbSaleHead, ebiddingType, dbPrice, webPrice);
        } else if (EbiddingWayEnum.DISPOSABLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            for (SaleEbiddingItem quoteItem : quoteList) {
                SaleEbiddingItem currentItem = dbItemMap.get(quoteItem.getItemNumber());
                webPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getPrice() : quoteItem.getNetPrice();
                Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                this.checkStartPrice(dbSaleHead, ebiddingType, currentItem.getStartPrice(), webPrice);
                dbPrice = supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) ? this.getPrice(ebiddingType, EbiddingWayEnum.DISPOSABLE.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get(quoteItem.getItemNumber())) : (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getPrice() : currentItem.getNetPrice());
                this.checkChangeRange(dbSaleHead, ebiddingType, dbPrice, webPrice);
            }
        } else {
            SaleEbiddingItem currentItem = dbItemMap.get("1");
            BigDecimal quotePrice = BigDecimal.ZERO;
            for (SaleEbiddingItem quoteItem : quoteList) {
                BigDecimal itemPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getPrice() : quoteItem.getNetPrice();
                Assert.notNull((Object)itemPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                BigDecimal requireQuantity = quoteItem.getRequireQuantity() == null ? BigDecimal.ONE : quoteItem.getRequireQuantity();
                quotePrice = quotePrice.add(itemPrice.multiply(requireQuantity));
            }
            webPrice = quotePrice;
            this.checkStartPrice(dbSaleHead, ebiddingType, dbSaleHead.getStartTotalAmount(), webPrice);
            dbPrice = supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) ? this.getPrice(ebiddingType, EbiddingWayEnum.BATCH.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get("1")) : (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getTotalAmount() : currentItem.getNetTotalAmount());
            this.checkChangeRange(dbSaleHead, ebiddingType, dbPrice, webPrice);
        }
    }

    private void checkChangeRange(SaleEbiddingHead dbSaleHead, String ebiddingType, BigDecimal dbPrice, BigDecimal webPrice) {
        if (dbPrice != null) {
            BigDecimal changeRange = dbSaleHead.getChangeRange();
            String rangeUnit = dbSaleHead.getRangeUnit();
            if (EbiddingRangeUnitEnum.PERCENT.getValue().equals(rangeUnit)) {
                changeRange = dbPrice.multiply(changeRange.divide(BigDecimal.valueOf(100L), 6, 4));
            }
            boolean flag = EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) ? webPrice.subtract(changeRange).compareTo(dbPrice) >= 0 : webPrice.add(changeRange).compareTo(dbPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_APsuxBnOuBzWVVVsuW_6e488384", (String)"\u5f53\u524d\u62a5\u4ef7\u4e0d\u7b26\u5408\u7ade\u4ef7\u5e45\u5ea6\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
            BigDecimal changeRangeUpper = dbSaleHead.getChangeRangeUpper();
            if (changeRangeUpper != null && changeRangeUpper.compareTo(BigDecimal.ZERO) != 0) {
                if (EbiddingRangeUnitEnum.PERCENT.getValue().equals(rangeUnit)) {
                    changeRangeUpper = dbPrice.multiply(changeRangeUpper.divide(BigDecimal.valueOf(100L), 6, 4));
                }
                boolean upperFlag = EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) ? webPrice.subtract(changeRangeUpper).compareTo(dbPrice) < 0 : webPrice.add(changeRangeUpper).compareTo(dbPrice) > 0;
                Assert.isTrue((boolean)upperFlag, (String)I18nUtil.translate((String)"i18n_alert_APsuBRBzXWWVVVsuW_d9dc1bcc", (String)"\u5f53\u524d\u62a5\u4ef7\u8d85\u8fc7\u5e45\u5ea6\u4e0a\u9650\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
            }
        }
    }

    private void autoDelay(SaleEbiddingHead dbSaleHead) {
        String endTimeStr = DateUtil.formatDateTime((Date)dbSaleHead.getEndTime());
        if (!this.redis.tryGetDistributedLock(dbSaleHead.getRelationId(), endTimeStr, 600000L)) {
            return;
        }
        int delayMinute = dbSaleHead.getDelayMinute() == null ? 1 : dbSaleHead.getDelayMinute();
        DateTime endTime = DateUtil.offsetMinute((Date)dbSaleHead.getEndTime(), (int)delayMinute);
        SaleEbiddingHead updateSaleHead = new SaleEbiddingHead();
        updateSaleHead.setEndTime((Date)endTime);
        int currentDelayCount = dbSaleHead.getCurrentDelayCount() == null ? 0 : dbSaleHead.getCurrentDelayCount();
        updateSaleHead.setCurrentDelayCount(currentDelayCount + 1);
        ((SaleEbiddingHeadMapper)this.baseMapper).update((Object)updateSaleHead, (Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbSaleHead.getRelationId()));
        PurchaseEbiddingHead purchaseHead = new PurchaseEbiddingHead();
        purchaseHead.setId(dbSaleHead.getRelationId());
        purchaseHead.setEndTime((Date)endTime);
        purchaseHead.setCurrentDelayCount(updateSaleHead.getCurrentDelayCount());
        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
        EbiddingJobUtil.updateEndJob(dbSaleHead, (Date)endTime);
    }

    private void checkDelay(SaleEbiddingHead dbSaleHead, Date currentTime) {
        String delayRule = dbSaleHead.getDelayRule();
        if (!EbiddingDelayRuleEnum.NOT_ALLOW_DELAY.getValue().equals(delayRule)) {
            int beforeEndMinute = dbSaleHead.getBeforeEndMinute() == null ? 1 : dbSaleHead.getBeforeEndMinute();
            Date endTime = dbSaleHead.getEndTime();
            DateTime checkDate = DateUtil.offsetMinute((Date)currentTime, (int)beforeEndMinute);
            if (checkDate.compareTo(endTime) > 0) {
                if (EbiddingDelayRuleEnum.LIMIT_DELAY_COUNT.getValue().equals(delayRule)) {
                    int currentDelayCount;
                    int delayCount = dbSaleHead.getDelayCount() == null ? 1 : dbSaleHead.getDelayCount();
                    int n = currentDelayCount = dbSaleHead.getCurrentDelayCount() == null ? 0 : dbSaleHead.getCurrentDelayCount();
                    if (delayCount > currentDelayCount) {
                        this.autoDelay(dbSaleHead);
                    }
                } else {
                    this.autoDelay(dbSaleHead);
                }
            }
        }
    }

    private void compute(SaleEbiddingHead dbSaleHead, List<SaleEbiddingItem> quoteList, Map<String, SaleEbiddingItem> dbItemMap, Date currentTime) {
        SaleEbiddingItem currentItem;
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay()) || EbiddingWayEnum.DISPOSABLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            for (SaleEbiddingItem quoteItem : quoteList) {
                BigDecimal requireQuantity;
                currentItem = dbItemMap.get(quoteItem.getItemNumber());
                BigDecimal bigDecimal = requireQuantity = currentItem.getRequireQuantity() == null ? BigDecimal.ONE : currentItem.getRequireQuantity();
                if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                    BigDecimal price = quoteItem.getPrice();
                    BigDecimal netPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(currentItem.getTaxRate(), price);
                    quoteItem.setNetPrice(netPrice);
                    quoteItem.setTaxAmount(price.multiply(requireQuantity));
                    quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
                } else {
                    BigDecimal netPrice = quoteItem.getNetPrice();
                    BigDecimal price = EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(currentItem.getTaxRate(), netPrice);
                    quoteItem.setPrice(price);
                    quoteItem.setTaxAmount(price.multiply(requireQuantity));
                    quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
                }
                if (!EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) continue;
                break;
            }
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItem quoteItem = quoteList.get(0);
            SaleEbiddingItem currentItem2 = dbItemMap.get(quoteItem.getItemNumber());
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                BigDecimal totalAmount = quoteItem.getTotalAmount();
                BigDecimal netTotalAmount = EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(currentItem2.getTaxRate(), totalAmount);
                quoteItem.setNetTotalAmount(netTotalAmount);
            } else {
                BigDecimal netTotalAmount = quoteItem.getNetTotalAmount();
                BigDecimal totalAmount = EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(currentItem2.getTaxRate(), netTotalAmount);
                quoteItem.setTotalAmount(totalAmount);
            }
        } else {
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal netTotalAmount = BigDecimal.ZERO;
            for (SaleEbiddingItem quoteItem : quoteList) {
                BigDecimal requireQuantity;
                SaleEbiddingItem currentItem3 = dbItemMap.get(quoteItem.getItemNumber());
                BigDecimal bigDecimal = requireQuantity = currentItem3.getRequireQuantity() == null ? BigDecimal.ONE : currentItem3.getRequireQuantity();
                if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                    BigDecimal price = quoteItem.getPrice();
                    BigDecimal netPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(currentItem3.getTaxRate(), price);
                    quoteItem.setNetPrice(netPrice);
                    quoteItem.setTaxAmount(price.multiply(requireQuantity));
                    totalAmount = totalAmount.add(quoteItem.getTaxAmount());
                    quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
                    netTotalAmount = netTotalAmount.add(quoteItem.getNetAmount());
                    continue;
                }
                BigDecimal netPrice = quoteItem.getNetPrice();
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(currentItem3.getTaxRate(), netPrice);
                quoteItem.setPrice(price);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                totalAmount = totalAmount.add(quoteItem.getTaxAmount());
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
                netTotalAmount = netTotalAmount.add(quoteItem.getNetAmount());
            }
            for (SaleEbiddingItem quoteItem : quoteList) {
                quoteItem.setTotalAmount(totalAmount);
                quoteItem.setNetTotalAmount(netTotalAmount);
            }
        }
        for (SaleEbiddingItem quoteItem : quoteList) {
            currentItem = dbItemMap.get(quoteItem.getItemNumber());
            quoteItem.setHeadId(dbSaleHead.getId());
            quoteItem.setQuoteTime(currentTime);
            quoteItem.setQuoteCount(currentItem.getQuoteCount() == null ? 1 : currentItem.getQuoteCount() + 1);
            quoteItem.setQuoteIp(IPUtils.getIpAddr());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quotePrice(SaleEbiddingHeadVO saleHeadVO) {
        Date currentTime = new Date();
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)saleHeadVO.getId())));
        List<SaleEbiddingItem> quoteList = saleHeadVO.getPurchaseEbiddingItemList().stream().filter(item -> !"1".equals(item.getNotQuote())).collect(Collectors.toList());
        Map<String, SaleEbiddingItem> dbItemMap = this.saleEbiddingItemService.selectByMainId(saleHeadVO.getId()).stream().collect(Collectors.toMap(SaleEbiddingItem::getItemNumber, Function.identity(), (newVal, oldVal) -> oldVal));
        PurchaseEbiddingSupplier supplier = (PurchaseEbiddingSupplier)((Object)this.purchaseEbiddingSupplierService.getById((Serializable)((Object)dbSaleHead.getSupplierListId())));
        Map<String, List<PurchaseEbiddingItem>> purchaseMap = this.purchaseEbiddingItemMapper.selectByMainId(dbSaleHead.getRelationId()).stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
        this.checkQuote(dbSaleHead, quoteList, dbItemMap, currentTime, supplier, purchaseMap);
        this.checkDelay(dbSaleHead, currentTime);
        this.compute(dbSaleHead, quoteList, dbItemMap, currentTime);
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItem quoteItem = quoteList.get(0);
            quoteItem.setItemStatus(null);
            int count = this.saleEbiddingItemMapper.updateById((Object)quoteItem);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbSaleHead, quoteItem);
            purchaseItem.setItemStatus(null);
            this.purchaseEbiddingItemMapper.updateById((Object)purchaseItem);
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItem quoteItem = quoteList.get(0);
            this.saleEbiddingItemMapper.quotePriceByHeadId(quoteItem);
            PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbSaleHead, quoteItem);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
        } else {
            ArrayList<PurchaseEbiddingItem> purchaseList = new ArrayList<PurchaseEbiddingItem>();
            for (SaleEbiddingItem quoteItem : quoteList) {
                PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbSaleHead, quoteItem);
                purchaseList.add(purchaseItem);
                quoteItem.setItemStatus(null);
                purchaseItem.setItemStatus(null);
            }
            this.saleEbiddingItemService.updateBatchById(quoteList);
            this.purchaseEbiddingItemService.updateBatchById(purchaseList);
            if (EbiddingWayEnum.DISPOSABLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
                ArrayList otherList = new ArrayList();
                List quoteItemNumberList = quoteList.stream().map(SaleEbiddingItem::getItemNumber).distinct().collect(Collectors.toList());
                dbItemMap.forEach((key, value) -> {
                    if (!quoteItemNumberList.contains(key)) {
                        otherList.add(value);
                    }
                });
                if (!otherList.isEmpty()) {
                    otherList.forEach(item -> item.setNotQuote("1"));
                    this.saleEbiddingItemService.updateBatchById(otherList);
                }
            }
        }
        this.saleEbiddingItemHisService.save(dbSaleHead, quoteList, supplier);
        this.redis.publish("quote-price-topic", (Object)dbSaleHead.getRelationId());
    }

    private PurchaseEbiddingItem getPurchaseItemByQuote(SaleEbiddingHead dbSaleHead, SaleEbiddingItem quoteItem) {
        PurchaseEbiddingItem purchaseItem = new PurchaseEbiddingItem();
        BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)purchaseItem));
        purchaseItem.setId(quoteItem.getRelationId());
        purchaseItem.setHeadId(dbSaleHead.getRelationId());
        purchaseItem.setRelationId(quoteItem.getId());
        purchaseItem.setToElsAccount(dbSaleHead.getElsAccount());
        purchaseItem.setElsAccount(dbSaleHead.getToElsAccount());
        return purchaseItem;
    }

    @Override
    public void priced(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> purchaseItemList, List<PurchaseEbiddingSupplier> supplierList) {
        ArrayList<SaleEbiddingItem> saleItemList = new ArrayList<SaleEbiddingItem>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                saleItem = new SaleEbiddingItem();
                saleItem.setId(item.getRelationId());
                saleItem.setItemStatus(item.getItemStatus());
                saleItem.setQuota(item.getQuota());
                saleItemList.add(saleItem);
            }
            this.saleEbiddingItemService.updateBatchById(saleItemList);
        } else {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                saleItem = new SaleEbiddingItem();
                saleItem.setEbiddingNumber(dbHead.getEbiddingNumber());
                saleItem.setElsAccount(item.getToElsAccount());
                saleItem.setToElsAccount(item.getElsAccount());
                saleItem.setCurrentRound(item.getCurrentRound());
                saleItem.setQuota(item.getQuota());
                saleItem.setItemStatus(item.getItemStatus());
                saleItemList.add(saleItem);
            }
            this.saleEbiddingItemMapper.updateBidResultByNumber(saleItemList);
        }
        ArrayList<SaleEbiddingHead> updateHeadList = new ArrayList<SaleEbiddingHead>();
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SaleEbiddingHead head = new SaleEbiddingHead();
            head.setRelationId(dbHead.getId());
            head.setElsAccount(supplier.getToElsAccount());
            head.setEbiddingStatus(supplier.getBiddingStatus());
            updateHeadList.add(head);
        }
        ((SaleEbiddingHeadMapper)this.baseMapper).updateBidResultByRelationId(updateHeadList);
    }

    @Override
    public void pricedByHis(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItemHis> purchaseItemList, List<PurchaseEbiddingSupplier> supplierList) {
        ArrayList<SaleEbiddingItemHis> saleItemList = new ArrayList<SaleEbiddingItemHis>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItemHis item : purchaseItemList) {
                saleItem = new SaleEbiddingItemHis();
                saleItem.setId(item.getRelationId());
                saleItem.setItemStatus(item.getItemStatus());
                saleItem.setQuota(item.getQuota());
                saleItemList.add(saleItem);
            }
            this.saleEbiddingItemHisService.updateBatchById(saleItemList);
        } else {
            for (PurchaseEbiddingItemHis item : purchaseItemList) {
                saleItem = new SaleEbiddingItemHis();
                saleItem.setEbiddingNumber(dbHead.getEbiddingNumber());
                saleItem.setElsAccount(item.getToElsAccount());
                saleItem.setToElsAccount(item.getElsAccount());
                saleItem.setCurrentRound(item.getCurrentRound());
                saleItem.setQuota(item.getQuota());
                saleItem.setItemStatus(item.getItemStatus());
                saleItemList.add(saleItem);
            }
            this.saleEbiddingItemHisService.updateBidResultByNumber(saleItemList);
        }
        ArrayList<SaleEbiddingHead> updateHeadList = new ArrayList<SaleEbiddingHead>();
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SaleEbiddingHead head = new SaleEbiddingHead();
            head.setRelationId(dbHead.getId());
            head.setElsAccount(supplier.getToElsAccount());
            head.setEbiddingStatus(supplier.getBiddingStatus());
            updateHeadList.add(head);
        }
        ((SaleEbiddingHeadMapper)this.baseMapper).updateBidResultByRelationId(updateHeadList);
    }

    @Override
    public void regret(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList) {
        List<SaleEbiddingHead> dbHeadList = ((SaleEbiddingHeadMapper)this.baseMapper).selectByMainId(dbHead.getId());
        dbHeadList.forEach(head -> head.setEbiddingStatus(EbiddingStatusEnum.REGRET.getValue()));
        this.updateBatchById(dbHeadList);
        List headIdList = dbHeadList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.REGRET.getValue()));
    }

    @Override
    public void failed(PurchaseEbiddingHead dbHead) {
        List<SaleEbiddingHead> dbHeadList = ((SaleEbiddingHeadMapper)this.baseMapper).selectByMainId(dbHead.getId());
        dbHeadList.forEach(head -> head.setEbiddingStatus(EbiddingStatusEnum.BID_FAILED.getValue()));
        this.updateBatchById(dbHeadList);
    }

    @Override
    @SrmTransaction
    public void quoteAccept(SaleEbiddingHead dbHead, SaleEbiddingItemHis dbItemHis, SaleEbiddingItem quoteItem, BigDecimal acceptPrice) {
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            if (quoteItem.getRemainingQuantity().compareTo(BigDecimal.ZERO) <= 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bUeBWRL0xqsu_bb4735b8", (String)"\u5269\u4f59\u6295\u6807\u6570\u91cf\u4e3a0\uff0c\u4e0d\u53ef\u62a5\u4ef7\uff01"));
            }
            if (quoteItem.getRemainingQuantity().compareTo(quoteItem.getBidNumber()) < 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_suWRfUbUeBWRVVVHcsu_2caea7b7", (String)"\u62a5\u4ef7\u6570\u91cf\u5927\u4e8e\u5269\u4f59\u6295\u6807\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u62a5\u4ef7\uff01"));
            }
            boolean hasNextQuote = quoteItem.getRemainingQuantity().compareTo(quoteItem.getBidNumber()) != 0;
            List<String> headIdList = this.getByRelationId(dbHead.getRelationId()).stream().map(ParentEntity::getId).collect(Collectors.toList());
            List<SaleEbiddingItem> saleEbiddingItemList = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? this.saleEbiddingItemService.selectWithoutElsAccountByHeadId(headIdList).stream().filter(i -> dbHead.getCurrentItemNumber().equals(i.getItemNumber())).collect(Collectors.toList()) : this.saleEbiddingItemService.selectWithoutElsAccountByHeadId(headIdList);
            List<String> itemIdList = saleEbiddingItemList.stream().map(ParentEntity::getId).collect(Collectors.toList());
            List<PurchaseEbiddingItem> purchaseEbiddingItemList = this.purchaseEbiddingItemService.selectWithoutElsAccountByRelationId(itemIdList);
            if (purchaseEbiddingItemList == null || purchaseEbiddingItemList.size() == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SMxuIdjnRXjOucVH_c0e7408b", (String)"\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u5546\u7684\u7ade\u4ef7\u884c\u4fe1\u606f\uff01"));
            }
            this.processDataStatus(dbHead, dbItemHis, quoteItem, true);
            this.calculateRemainingQuantity(dbHead, quoteItem, headIdList);
            BigDecimal purchaseBidNumber = purchaseEbiddingItemList.get(0).getBidNumber();
            this.calculateBidNumber(dbHead, quoteItem, headIdList, purchaseEbiddingItemList, purchaseBidNumber);
            if (quoteItem.getBidNumber().compareTo(purchaseBidNumber) > 0) {
                this.srmPoolExecutor.execute(() -> this.updateQuoteSaleBidNumber(dbHead, purchaseBidNumber));
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXeBWR0fUnRXjeBWR1VVVHcsu_32df13af", (String)"\u4f9b\u5e94\u5546\u6295\u6807\u6570\u91cf${0}\u5927\u4e8e\u91c7\u8d2d\u5546\u7684\u6295\u6807\u6570\u91cf${1}\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u62a5\u4ef7\uff01", (String[])new String[]{String.valueOf(quoteItem.getBidNumber()), String.valueOf(purchaseBidNumber)}));
            }
            if (quoteItem.getBidNumber().compareTo(purchaseBidNumber) == 0) {
                if (hasNextQuote) {
                    this.updateEbiddingHisItemNotAccept(dbHead);
                    this.dutchHasNextQuote(dbHead);
                } else {
                    this.endEbiddingByDutch(dbHead, headIdList);
                }
            } else {
                this.dutchHasNextQuoteByAccept(dbHead);
            }
            this.updateQuoteSaleBidNumber(dbHead, purchaseBidNumber.subtract(quoteItem.getBidNumber()));
            SaleEbiddingHead saleHead = new SaleEbiddingHead();
            saleHead.setHasQuote("1");
            ((SaleEbiddingHeadMapper)this.baseMapper).update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getRelationId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
            PurchaseEbiddingHead head = new PurchaseEbiddingHead();
            head.setId(dbHead.getRelationId());
            head.setHasQuote("1");
            this.purchaseEbiddingHeadMapper.updateById((Object)head);
        } else {
            this.processDataStatus(dbHead, dbItemHis, quoteItem, true);
            List<String> headIdList = this.getByRelationId(dbHead.getRelationId()).stream().map(ParentEntity::getId).collect(Collectors.toList());
            if (EbiddingTypeEnum.REVERSE_BID.getValue().equals(dbHead.getEbiddingType()) && acceptPrice.compareTo(BigDecimal.ZERO) <= 0) {
                this.endEbiddingByJapan(dbHead, quoteItem, headIdList);
            } else if ("1".equals(dbHead.getPurchaseAutoQuote()) && acceptPrice.compareTo(BigDecimal.ZERO) > 0) {
                this.autoQuotePrice(dbHead.getRelationId(), quoteItem.getRelationId());
            }
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getRelationId());
    }

    private void updateQuoteSaleBidNumber(SaleEbiddingHead dbHead, BigDecimal purchaseBidNumber) {
        SaleEbiddingItemHisService saleEbiddingItemHisService = (SaleEbiddingItemHisService)SpringContextUtils.getBean(SaleEbiddingItemHisServiceImpl.class);
        List<SaleEbiddingHead> saleEbiddingHeadList = ((SaleEbiddingHeadMapper)this.baseMapper).selectByMainId(dbHead.getRelationId());
        List<String> saleHeadIdList = saleEbiddingHeadList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        List<SaleEbiddingItemHis> saleEbiddingItemHisList = saleEbiddingItemHisService.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
        if ((saleEbiddingItemHisList = saleEbiddingItemHisList.stream().filter(item -> StrUtil.isBlank((CharSequence)item.getAccept())).collect(Collectors.toList())) != null && saleEbiddingItemHisList.size() > 0) {
            for (SaleEbiddingItemHis itemHis : saleEbiddingItemHisList) {
                SaleEbiddingItemHis his = new SaleEbiddingItemHis();
                his.setId(itemHis.getId());
                his.setBidNumber(purchaseBidNumber);
                saleEbiddingItemHisService.updateById((Object)his);
            }
            List itemIdList = saleEbiddingItemHisList.stream().map(ParentEntity::getId).collect(Collectors.toList());
            this.purchaseEbiddingItemHisMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(PurchaseEbiddingItemHis::getRelationId, itemIdList)).set(PurchaseEbiddingItemHis::getBidNumber, (Object)purchaseBidNumber));
        }
    }

    private boolean checkQuoteQuantity(SaleEbiddingItem quoteItem) {
        if (quoteItem.getRemainingQuantity().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bUeBWRL0xqsu_bb4735b8", (String)"\u5269\u4f59\u6295\u6807\u6570\u91cf\u4e3a0\uff0c\u4e0d\u53ef\u62a5\u4ef7\uff01"));
        }
        if (quoteItem.getRemainingQuantity().compareTo(quoteItem.getBidNumber()) < 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_suWRfUbUeBWRVVVHcsu_2caea7b7", (String)"\u62a5\u4ef7\u6570\u91cf\u5927\u4e8e\u5269\u4f59\u6295\u6807\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u62a5\u4ef7\uff01"));
        }
        boolean hasNextQuote = quoteItem.getRemainingQuantity().compareTo(quoteItem.getBidNumber()) != 0;
        return hasNextQuote;
    }

    @Override
    @SrmTransaction
    public void processDataStatus(SaleEbiddingHead dbHead, SaleEbiddingItemHis dbItemHis, SaleEbiddingItem quoteItem, Boolean isFirst) {
        SaleEbiddingItemHisService hisService = (SaleEbiddingItemHisService)SpringContextUtils.getBean(SaleEbiddingItemHisServiceImpl.class);
        if (isFirst.booleanValue()) {
            hisService.quoteAccept(dbItemHis);
        } else {
            hisService.quoteReject(dbItemHis);
        }
        quoteItem.setQuoteIp(IPUtils.getIpAddr());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            this.saleEbiddingItemService.updateById((Object)quoteItem);
            PurchaseEbiddingItem item = this.getPurchaseItemByQuote(dbHead, quoteItem);
            this.purchaseEbiddingItemService.updateById((Object)item);
        } else {
            this.saleEbiddingItemMapper.quotePriceByHeadId(quoteItem);
            PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbHead, quoteItem);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
        }
    }

    public void calculateRemainingQuantity(SaleEbiddingHead dbHead, SaleEbiddingItem quoteItem, List<String> headIdList) {
        BigDecimal remainingQuantity = quoteItem.getRemainingQuantity().subtract(quoteItem.getBidNumber());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).eq(SaleEbiddingItem::getItemNumber, (Object)dbHead.getCurrentItemNumber())).set(SaleEbiddingItem::getRemainingQuantity, (Object)remainingQuantity));
            PurchaseEbiddingItem item = this.getPurchaseItemByQuote(dbHead, quoteItem);
            item.setRemainingQuantity(remainingQuantity);
            List saleEbiddingItemList = this.saleEbiddingItemService.selectWithoutElsAccountByHeadId(headIdList).stream().filter(i -> dbHead.getCurrentItemNumber().equals(i.getItemNumber())).collect(Collectors.toList());
            List itemIdList = saleEbiddingItemList.stream().map(ParentEntity::getId).collect(Collectors.toList());
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(PurchaseEbiddingItem::getRelationId, itemIdList)).eq(PurchaseEbiddingItem::getItemNumber, (Object)dbHead.getCurrentItemNumber())).set(PurchaseEbiddingItem::getRemainingQuantity, (Object)remainingQuantity));
        } else {
            SaleEbiddingItem saleEbiddingItem = new SaleEbiddingItem();
            BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)saleEbiddingItem));
            this.saleEbiddingItemMapper.quotePriceByHeadId(saleEbiddingItem);
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).set(SaleEbiddingItem::getRemainingQuantity, (Object)remainingQuantity));
            PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbHead, saleEbiddingItem);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).set(PurchaseEbiddingItem::getRemainingQuantity, (Object)remainingQuantity));
        }
    }

    private void calculateBidNumber(SaleEbiddingHead dbHead, SaleEbiddingItem quoteItem, List<String> headIdList, List<PurchaseEbiddingItem> purchaseEbiddingItemList, BigDecimal purchaseBidNumber) {
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).eq(SaleEbiddingItem::getItemNumber, (Object)dbHead.getCurrentItemNumber())).set(SaleEbiddingItem::getBidNumber, (Object)purchaseBidNumber.subtract(quoteItem.getBidNumber())));
            for (PurchaseEbiddingItem item : purchaseEbiddingItemList) {
                this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ParentEntity::getId, (Object)item.getId())).set(PurchaseEbiddingItem::getBidNumber, (Object)purchaseBidNumber.subtract(quoteItem.getBidNumber())));
            }
        } else {
            SaleEbiddingItem saleEbiddingItem = new SaleEbiddingItem();
            BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)saleEbiddingItem));
            BigDecimal subtract = purchaseBidNumber.subtract(quoteItem.getBidNumber());
            this.saleEbiddingItemMapper.quotePriceByHeadId(saleEbiddingItem);
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).set(SaleEbiddingItem::getBidNumber, (Object)subtract));
            PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbHead, saleEbiddingItem);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).set(PurchaseEbiddingItem::getBidNumber, (Object)subtract));
        }
    }

    private void endEbiddingByDutch(SaleEbiddingHead dbHead, List<String> headIdList) {
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            String currentItemNumber = dbHead.getCurrentItemNumber();
            String nextItemNumber = String.valueOf(Integer.parseInt(currentItemNumber) + 1);
            SaleEbiddingItem nextItem = this.saleEbiddingItemService.selectOneByMainIdAndItemNumber(dbHead.getId(), nextItemNumber);
            String updateItemNumber = nextItem != null ? nextItemNumber : "";
            String updateMaterialDesc = nextItem != null ? nextItem.getMaterialDesc() : "";
            String updateEbiddingStatus = nextItem != null ? EbiddingStatusEnum.WAIT_BIDDING.getValue() : EbiddingStatusEnum.BIDDING_END.getValue();
            SaleEbiddingHead saleHead = new SaleEbiddingHead();
            saleHead.setCurrentItemNumber(updateItemNumber);
            saleHead.setCurrentMaterialDesc(updateMaterialDesc);
            saleHead.setEbiddingStatus(updateEbiddingStatus);
            ((SaleEbiddingHeadMapper)this.baseMapper).update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getRelationId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
            PurchaseEbiddingHead head = new PurchaseEbiddingHead();
            head.setId(dbHead.getRelationId());
            head.setCurrentItemNumber(updateItemNumber);
            head.setCurrentMaterialDesc(updateMaterialDesc);
            head.setEbiddingStatus(updateEbiddingStatus);
            head.setCurrentDelayCount(0);
            head.setEbiddingNumber(dbHead.getEbiddingNumber());
            head.setElsAccount(dbHead.getBusAccount());
            this.purchaseEbiddingHeadMapper.updateById((Object)head);
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).eq(SaleEbiddingItem::getItemNumber, (Object)currentItemNumber)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).eq(PurchaseEbiddingItem::getItemNumber, (Object)currentItemNumber)).set(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            if (nextItem != null) {
                head.setQuoteFlag("0");
                head.setEbiddingStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
                head.setBeginTime(new Date());
                head.setEndTime((Date)DateUtil.offsetSecond((Date)head.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getIntervalMinute(), (int)1)));
                this.purchaseEbiddingHeadMapper.updateById((Object)head);
                EbiddingJobUtil.createStartJob(head, head.getEndTime());
                saleHead.setQuoteFlag("0");
            }
            EbiddingJobUtil.deleteDutchQuoteJob(head);
            saleHead.setBeginTime(head.getBeginTime());
            saleHead.setStartTime(dbHead.getStartTime());
            saleHead.setEndTime(head.getEndTime());
            saleHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
            ((SaleEbiddingHeadMapper)this.baseMapper).update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getRelationId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.WAIT_BIDDING.getValue()));
            this.updateEbiddingHisItemNotAccept(dbHead);
        } else {
            SaleEbiddingHead saleHead = new SaleEbiddingHead();
            saleHead.setCurrentMaterialDesc("");
            saleHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
            ((SaleEbiddingHeadMapper)this.baseMapper).update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getRelationId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
            PurchaseEbiddingHead head = new PurchaseEbiddingHead();
            head.setId(dbHead.getRelationId());
            head.setCurrentMaterialDesc(dbHead.getCurrentMaterialDesc());
            head.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
            this.purchaseEbiddingHeadMapper.updateById((Object)head);
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).set(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            head.setEbiddingNumber(dbHead.getEbiddingNumber());
            head.setElsAccount(dbHead.getBusAccount());
            EbiddingJobUtil.deleteDutchQuoteJob(head);
        }
    }

    private void updateEbiddingHisItemNotAccept(SaleEbiddingHead dbHead) {
        SaleEbiddingItemHisService saleEbiddingItemHisService = (SaleEbiddingItemHisService)SpringContextUtils.getBean(SaleEbiddingItemHisServiceImpl.class);
        List<SaleEbiddingHead> saleEbiddingHeadList = ((SaleEbiddingHeadMapper)this.baseMapper).selectByMainId(dbHead.getRelationId());
        List<String> saleHeadIdList = saleEbiddingHeadList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        List<SaleEbiddingItemHis> saleEbiddingItemHisList = saleEbiddingItemHisService.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
        saleEbiddingItemHisList = saleEbiddingItemHisList.stream().filter(item -> StrUtil.isBlank((CharSequence)item.getAccept())).collect(Collectors.toList());
        for (SaleEbiddingItemHis itemHis : saleEbiddingItemHisList) {
            itemHis.setAccept("3");
            saleEbiddingItemHisService.updateById((Object)itemHis);
            PurchaseEbiddingItemHis purchaseHis = new PurchaseEbiddingItemHis();
            purchaseHis.setId(itemHis.getRelationId());
            purchaseHis.setAccept("3");
            this.purchaseEbiddingItemHisMapper.updateById((Object)purchaseHis);
        }
    }

    @Override
    @SrmTransaction
    public void quoteReject(SaleEbiddingHead dbHead, SaleEbiddingItemHis dbItemHis, SaleEbiddingItem quoteItem) {
        BigDecimal price;
        SaleEbiddingItemHisService hisService = (SaleEbiddingItemHisService)SpringContextUtils.getBean(SaleEbiddingItemHisServiceImpl.class);
        long rejectCount = hisService.quoteReject(dbItemHis);
        BigDecimal bigDecimal = price = dbHead.getEbiddingWay().equals(EbiddingWayEnum.PACKAGE.getValue()) ? dbItemHis.getTotalAmount() : dbItemHis.getPrice();
        if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod())) {
            int quoteRejections;
            int n = quoteRejections = dbHead.getQuoteRejections() == null ? 5 : dbHead.getQuoteRejections();
            if ((long)quoteRejections <= rejectCount || BigDecimal.ZERO.compareTo(price) >= 0) {
                List<String> headIdList = this.getByRelationId(dbHead.getRelationId()).stream().map(ParentEntity::getId).collect(Collectors.toList());
                this.endEbiddingByJapan(dbHead, quoteItem, headIdList);
            } else if ("1".equals(dbHead.getPurchaseAutoQuote())) {
                this.autoQuotePrice(dbHead.getRelationId(), quoteItem.getRelationId());
            }
        } else if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            this.dutchHasNextQuoteByAccept(dbHead);
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getRelationId());
    }

    private void dutchHasNextQuoteByAccept(SaleEbiddingHead dbHead) {
        SaleEbiddingItemHisService saleEbiddingItemHisService = (SaleEbiddingItemHisService)SpringContextUtils.getBean(SaleEbiddingItemHisServiceImpl.class);
        List<SaleEbiddingHead> saleEbiddingHeadList = ((SaleEbiddingHeadMapper)this.baseMapper).selectByMainId(dbHead.getRelationId());
        List<String> saleHeadIdList = saleEbiddingHeadList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        List<SaleEbiddingItemHis> saleEbiddingItemHisList = saleEbiddingItemHisService.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
        if ((saleEbiddingItemHisList = saleEbiddingItemHisList.stream().filter(item -> StrUtil.isBlank((CharSequence)item.getAccept())).collect(Collectors.toList())).isEmpty()) {
            this.dutchHasNextQuote(dbHead);
        }
    }

    private void dutchHasNextQuote(SaleEbiddingHead dbHead) {
        PurchaseEbiddingHead purchaseEbiddingHead = this.purchaseEbiddingHeadMapper.selectWithoutElsAccountById(dbHead.getRelationId());
        EbiddingJobUtil.deleteDutchQuoteJob(purchaseEbiddingHead);
        purchaseEbiddingHead.setQuoteFlag("0");
        purchaseEbiddingHead.setBeginTime(new Date());
        purchaseEbiddingHead.setEndTime((Date)DateUtil.offsetSecond((Date)purchaseEbiddingHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)purchaseEbiddingHead.getKeepMinute(), (int)1)));
        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseEbiddingHead);
        SaleEbiddingHead saleHead = new SaleEbiddingHead();
        saleHead.setBeginTime(purchaseEbiddingHead.getBeginTime());
        saleHead.setStartTime(purchaseEbiddingHead.getStartTime());
        saleHead.setEndTime(purchaseEbiddingHead.getEndTime());
        saleHead.setCurrentDelayCount(purchaseEbiddingHead.getCurrentDelayCount());
        saleHead.setQuoteFlag("0");
        SaleEbiddingHeadService saleEbiddingHeadService = (SaleEbiddingHeadService)SpringContextUtils.getBean(SaleEbiddingHeadServiceImpl.class);
        saleEbiddingHeadService.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)purchaseEbiddingHead.getId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
        if ("1".equals(purchaseEbiddingHead.getPurchaseAutoQuote())) {
            PurchaseEbiddingHeadService purchaseEbiddingHeadService = (PurchaseEbiddingHeadService)SpringContextUtils.getBean(PurchaseEbiddingHeadServiceImpl.class);
            PurchaseEbiddingItemService purchaseEbiddingItemService = (PurchaseEbiddingItemService)SpringContextUtils.getBean(PurchaseEbiddingItemServiceImpl.class);
            List<PurchaseEbiddingItem> dbItemList = purchaseEbiddingItemService.selectByMainId(purchaseEbiddingHead.getId());
            String itemNumber = StrUtil.isNotBlank((CharSequence)purchaseEbiddingHead.getCurrentItemNumber()) ? purchaseEbiddingHead.getCurrentItemNumber() : "1";
            List<PurchaseEbiddingItem> quoteList = dbItemList.stream().filter(item -> itemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
            boolean successQuotePrice = purchaseEbiddingHeadService.autoQuotePricePublic(purchaseEbiddingHead, quoteList);
            if (successQuotePrice) {
                purchaseEbiddingHead.setBeginTime(new Date());
                purchaseEbiddingHead.setEndTime((Date)DateUtil.offsetSecond((Date)purchaseEbiddingHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)purchaseEbiddingHead.getKeepMinute(), (int)1)));
                purchaseEbiddingHead.setQuoteFlag("1");
                purchaseEbiddingHeadService.updateById((Object)purchaseEbiddingHead);
                EbiddingJobUtil.createDutchQuoteJob(purchaseEbiddingHead, purchaseEbiddingHead.getEndTime());
                saleHead.setBeginTime(purchaseEbiddingHead.getBeginTime());
                saleHead.setStartTime(purchaseEbiddingHead.getStartTime());
                saleHead.setEndTime(purchaseEbiddingHead.getEndTime());
                saleHead.setCurrentDelayCount(purchaseEbiddingHead.getCurrentDelayCount());
                saleHead.setQuoteFlag("1");
                saleEbiddingHeadService.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)purchaseEbiddingHead.getId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
                purchaseEbiddingHeadService.autoSetBindnumber(purchaseEbiddingHead, dbItemList, quoteList);
            }
        }
        this.sendWsMsg(dbHead);
    }

    private void sendWsMsg(SaleEbiddingHead dbHead) {
        HashMap<String, Object> mapMsg = new HashMap<String, Object>();
        mapMsg.put("relationId", dbHead.getRelationId());
        mapMsg.put("time", new Date());
        mapMsg.put("code", 210);
        mapMsg.put("message", "[quotePriceTopic]\u76d1\u542c\u5230\u62d2\u7edd\u62a5\u4ef7\u6d88\u606f-\u4f9b\u5e94\u5546\u5168\u90e8\u62d2\u7edd\uff0c\u7ade\u4ef7ID\u4e3a[{" + dbHead.getRelationId() + "}]");
        SocketUtil bean1 = (SocketUtil)SpringContextUtils.getBean(SocketUtil.class);
        bean1.sendToSale(mapMsg, "CHANNEL_EBIDDING", dbHead.getRelationId());
    }

    private void endEbiddingByJapan(SaleEbiddingHead dbHead, SaleEbiddingItem quoteItem, List<String> headIdList) {
        PurchaseEbiddingHead purchaseHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)dbHead.getRelationId())));
        List<String> notJoiningStatusList = EbiddingConstant.NOT_JOINING_STATUS_LIST;
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            String saleItemId = quoteItem.getId();
            String purchaseItemId = quoteItem.getRelationId();
            SaleEbiddingItem saleItem = new SaleEbiddingItem();
            saleItem.setId(saleItemId);
            saleItem.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue());
            this.saleEbiddingItemService.updateById((Object)saleItem);
            PurchaseEbiddingItem purchaseItem = new PurchaseEbiddingItem();
            purchaseItem.setId(purchaseItemId);
            purchaseItem.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue());
            this.purchaseEbiddingItemMapper.updateById((Object)purchaseItem);
            if ("1".equals(purchaseHead.getRespectiveQuotations())) {
                List<SaleEbiddingItem> dbSaleItemList;
                long endItemCount;
                List<SaleEbiddingHead> dbHeadList = this.getByRelationId(dbHead.getRelationId());
                List needEndList = dbHeadList.stream().filter(head -> notJoiningStatusList.contains(head.getEbiddingStatus())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(needEndList)) {
                    List endAccountList = needEndList.stream().map(ParentEntity::getElsAccount).distinct().collect(Collectors.toList());
                    List<PurchaseEbiddingItem> endItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> endAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
                    endItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
                    List endItemIdList = endItemList.stream().map(PurchaseEbiddingItem::getRelationId).collect(Collectors.toList());
                    this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue())).in(ParentEntity::getId, endItemIdList));
                    this.purchaseEbiddingItemService.updateBatchById(endItemList);
                }
                if ((endItemCount = (dbSaleItemList = this.saleEbiddingItemService.selectByMainId(dbHead.getId())).stream().filter(item -> EbiddingItemStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).count()) == (long)dbSaleItemList.size()) {
                    dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
                    dbHead.setEndTime(new Date());
                    this.updateById((Object)dbHead);
                    List<SaleEbiddingHead> nowDbHeadList = this.getByRelationId(dbHead.getRelationId());
                    List<String> endCountStatusList = EbiddingConstant.END_STATUS_LIST;
                    long endHeadCount = nowDbHeadList.stream().filter(head -> endCountStatusList.contains(head.getEbiddingStatus())).count();
                    if (endHeadCount == (long)nowDbHeadList.size()) {
                        purchaseHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
                        purchaseHead.setEndTime(new Date());
                        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
                    }
                }
            } else {
                String currentItemNumber = dbHead.getCurrentItemNumber() == null ? "1" : dbHead.getCurrentItemNumber();
                List<SaleEbiddingHead> dbHeadList = this.getByRelationId(dbHead.getRelationId());
                List endAccountList = dbHeadList.stream().filter(head -> notJoiningStatusList.contains(head.getEbiddingStatus())).map(ParentEntity::getElsAccount).distinct().collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(endAccountList)) {
                    List<PurchaseEbiddingItem> endItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> endAccountList.contains(item.getToElsAccount())).filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                    endItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
                    List endItemIdList = endItemList.stream().map(PurchaseEbiddingItem::getRelationId).collect(Collectors.toList());
                    this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue())).in(ParentEntity::getId, endItemIdList));
                    this.purchaseEbiddingItemService.updateBatchById(endItemList);
                }
                String nextItemNumber = String.valueOf(Integer.parseInt(currentItemNumber) + 1);
                SaleEbiddingItem nextItem = this.saleEbiddingItemService.selectOneByMainIdAndItemNumber(dbHead.getId(), nextItemNumber);
                if (nextItem == null) {
                    dbHead.setCurrentItemNumber("");
                    dbHead.setCurrentMaterialDesc("");
                    dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
                    dbHead.setEndTime(new Date());
                    this.updateById((Object)dbHead);
                    List<SaleEbiddingHead> newDbHeadList = this.getByRelationId(dbHead.getRelationId());
                    List<String> endCountStatusList = EbiddingConstant.END_STATUS_LIST;
                    long endHeadCount = newDbHeadList.stream().filter(head -> endCountStatusList.contains(head.getEbiddingStatus())).count();
                    if (endHeadCount == (long)newDbHeadList.size()) {
                        purchaseHead.setCurrentItemNumber("");
                        purchaseHead.setCurrentMaterialDesc("");
                        purchaseHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
                        purchaseHead.setEndTime(new Date());
                        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
                    }
                } else {
                    dbHead.setEndTime(new Date());
                    this.updateById((Object)dbHead);
                    List currentItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                    long endCount = currentItemList.stream().filter(item -> EbiddingItemStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).count();
                    if (endCount == (long)currentItemList.size()) {
                        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getRelationId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue())).set(SaleEbiddingHead::getCurrentItemNumber, (Object)nextItemNumber)).set(SaleEbiddingHead::getCurrentMaterialDesc, (Object)nextItem.getMaterialDesc()));
                        PurchaseEbiddingHead head2 = new PurchaseEbiddingHead();
                        head2.setId(dbHead.getRelationId());
                        head2.setCurrentItemNumber(nextItemNumber);
                        head2.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                        head2.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
                        head2.setEndTime(new Date());
                        this.purchaseEbiddingHeadMapper.updateById((Object)head2);
                        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).eq(SaleEbiddingItem::getItemNumber, (Object)nextItemNumber)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING.getValue()));
                        this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).eq(PurchaseEbiddingItem::getItemNumber, (Object)nextItemNumber)).set(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING.getValue()));
                        if ("1".equals(dbHead.getPurchaseAutoQuote())) {
                            List<String> purchaseItemIdList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> item.getItemNumber().equals(nextItemNumber)).map(ParentEntity::getId).collect(Collectors.toList());
                            this.autoQuotePrice(dbHead.getRelationId(), purchaseItemIdList);
                        }
                    } else {
                        dbHead.setCurrentItemNumber(nextItemNumber);
                        dbHead.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                        this.updateById((Object)dbHead);
                    }
                }
            }
        } else {
            List<SaleEbiddingHead> dbHeadList = this.getByRelationId(dbHead.getRelationId());
            List endAccountList = dbHeadList.stream().filter(head -> notJoiningStatusList.contains(head.getEbiddingStatus())).map(ParentEntity::getElsAccount).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(endAccountList)) {
                List<PurchaseEbiddingItem> endItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> endAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
                endItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
                List endItemIdList = endItemList.stream().map(PurchaseEbiddingItem::getRelationId).collect(Collectors.toList());
                this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue())).in(ParentEntity::getId, endItemIdList));
                this.purchaseEbiddingItemService.updateBatchById(endItemList);
            }
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItem::getHeadId, (Object)dbHead.getId())).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).eq(PurchaseEbiddingItem::getToElsAccount, (Object)dbHead.getElsAccount())).set(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
            dbHead.setEndTime(new Date());
            this.updateById((Object)dbHead);
            List<SaleEbiddingHead> newDbHeadList = this.getByRelationId(dbHead.getRelationId());
            List<String> endCountStatusList = EbiddingConstant.END_STATUS_LIST;
            long endHeadCount = newDbHeadList.stream().filter(head -> endCountStatusList.contains(head.getEbiddingStatus())).count();
            if (endHeadCount == (long)newDbHeadList.size()) {
                purchaseHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
                purchaseHead.setEndTime(new Date());
                this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
            }
        }
    }

    private void autoQuotePrice(PurchaseEbiddingHead purchaseDbHead, String purchaseItemId) {
        BigDecimal quotePrice;
        PurchaseEbiddingItemService purchaseEbiddingItemService = (PurchaseEbiddingItemService)SpringContextUtils.getBean(PurchaseEbiddingItemServiceImpl.class);
        PurchaseEbiddingItem dbItem = (PurchaseEbiddingItem)((Object)purchaseEbiddingItemService.getById((Serializable)((Object)purchaseItemId)));
        PurchaseEbiddingItemHisService purchaseEbiddingItemHisService = (PurchaseEbiddingItemHisService)SpringContextUtils.getBean(PurchaseEbiddingItemHisServiceImpl.class);
        PurchaseEbiddingItem quoteItem = new PurchaseEbiddingItem();
        BeanUtils.copyProperties((Object)((Object)dbItem), (Object)((Object)quoteItem));
        purchaseEbiddingItemHisService.queryAddQuoteSite(purchaseDbHead, quoteItem);
        if (EbiddingWayEnum.SINGLE.getValue().equals(purchaseDbHead.getEbiddingWay())) {
            quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(purchaseDbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
        } else {
            BigDecimal bigDecimal = quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(purchaseDbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
        }
        if (quotePrice != null) {
            PurchaseEbiddingHeadService purchaseEbiddingHeadService = (PurchaseEbiddingHeadService)SpringContextUtils.getBean(PurchaseEbiddingHeadServiceImpl.class);
            purchaseEbiddingHeadService.quote(purchaseDbHead, dbItem, quoteItem);
        }
    }

    private void autoQuotePrice(String purchaseHeadId, List<String> purchaseItemIdList) {
        PurchaseEbiddingHead purchaseDbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)purchaseHeadId)));
        for (String purchaseItemId : purchaseItemIdList) {
            this.autoQuotePrice(purchaseDbHead, purchaseItemId);
        }
    }

    private void autoQuotePrice(String purchaseHeadId, String purchaseItemId) {
        PurchaseEbiddingHead purchaseDbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)purchaseHeadId)));
        this.autoQuotePrice(purchaseDbHead, purchaseItemId);
    }

    @Override
    public List<SaleEbiddingHead> getByRelationId(String relationId) {
        return ((SaleEbiddingHeadMapper)this.baseMapper).selectByMainId(relationId);
    }

    @Override
    public SaleEbiddingHead selectByAccount(String relationId, String elsAccount) {
        return ((SaleEbiddingHeadMapper)this.baseMapper).selectByElsAccount(relationId, elsAccount);
    }

    @Override
    public void processRemainingQuantity(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> dbItemList) {
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            for (PurchaseEbiddingItem item : dbItemList) {
                if (!EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
                    this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItem::getRelationId, (Object)item.getId())).set(SaleEbiddingItem::getRemainingQuantity, (Object)item.getRequireQuantity()));
                    continue;
                }
                this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItem::getRelationId, (Object)item.getId())).set(SaleEbiddingItem::getRemainingQuantity, (Object)1));
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void priceSubmission(SaleEbiddingHeadVO headVO) {
        List<SaleEbiddingItem> saleEbiddingItemList = headVO.getPurchaseEbiddingItemList();
        PurchaseEbiddingHead purchaseEbiddingHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)headVO.getRelationId())));
        this.handleSaleItemPrice(headVO, saleEbiddingItemList);
        this.checkTotalMaterialPrice(saleEbiddingItemList, purchaseEbiddingHead);
        this.editEbiddingItemList(saleEbiddingItemList);
    }

    private void checkTotalMaterialPrice(List<SaleEbiddingItem> saleEbiddingItemList, PurchaseEbiddingHead purchaseEbiddingHead) {
        BigDecimal totalMaterialPrice = saleEbiddingItemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).map(item -> item.getPrice().multiply(item.getRequireQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
        Assert.isTrue((totalMaterialPrice.compareTo(purchaseEbiddingHead.getEbiddingAmount()) < 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_SLxftuTVWRsBjfsu_23ceb937", (String)"\u7269\u6599\uff08\u542b\u7a0e\u5355\u4ef7*\u9700\u6c42\u6570\u91cf\uff09<=\u4e2d\u6807\u7684\u6253\u5305\u4ef7"));
    }

    private void editEbiddingItemList(List<SaleEbiddingItem> saleEbiddingItemList) {
        List purchaseEbiddingItems = saleEbiddingItemList.stream().map(item -> {
            PurchaseEbiddingItem purchaseItem = new PurchaseEbiddingItem();
            purchaseItem.setPrice(item.getPrice());
            purchaseItem.setNetPrice(item.getNetPrice());
            purchaseItem.setId(item.getRelationId());
            return purchaseItem;
        }).collect(Collectors.toList());
        this.saleEbiddingItemService.updateBatchById(saleEbiddingItemList);
        this.purchaseEbiddingItemService.updateBatchById(purchaseEbiddingItems);
    }

    private void handleSaleItemPrice(SaleEbiddingHeadVO headVO, List<SaleEbiddingItem> saleEbiddingItemList) {
        saleEbiddingItemList.forEach(saleItem -> {
            if (EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(headVO.getQuoteType())) {
                saleItem.setPrice(EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(saleItem.getTaxRate(), saleItem.getNetPrice()));
            } else {
                saleItem.setNetPrice(EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(saleItem.getTaxRate(), saleItem.getPrice()));
            }
            Assert.isTrue((!ObjectUtils.isEmpty((Object)saleItem.getNetPrice()) && !ObjectUtils.isEmpty((Object)saleItem.getPrice()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_import_SLBjtuxObLumdWF_b116e581", (String)"\u7269\u6599\u6ca1\u6709\u5355\u4ef7\uff0c\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e"));
        });
    }
}

