/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="publishEnquiryRpcAdapter")
public class PublishEnquiryAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    private PurchaseEnquiryHeadVO getHeadVO(String id) {
        PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(id);
        headVO.setPurchaseEnquiryItemList(itemList);
        List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(id);
        headVO.setEnquirySupplierListList(supplierList);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        headVO.setPurchaseAttachmentDemandList(demandList);
        return headVO;
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseEnquiryHead head = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(id);
            headVO.setPurchaseEnquiryItemList(itemList);
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseEnquiryHead updateHead = new PurchaseEnquiryHead();
        updateHead.setId(flowCallbackDTO.getBusinessId());
        updateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        updateHead.setAuditStatus(auditStatus);
        this.purchaseEnquiryHeadService.updateById((Object)updateHead);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            PurchaseEnquiryHeadVO headVO = this.getHeadVO(flowCallbackDTO.getBusinessId());
            this.purchaseEnquiryHeadService.publish(headVO);
        }
    }
}

