/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingConfirmLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingSupplierLpService;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingHeadLpVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PublishEbiddingLpAdapter
implements WorkflowAuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PublishEbiddingLpAdapter.class);
    @Autowired
    private PurchaseEbiddingHeadLpService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEbiddingItemLpService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingSupplierLpService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingConfirmLpService purchaseEbiddingConfirmService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseEbiddingHeadLpVO headVO = (PurchaseEbiddingHeadLpVO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchaseEbiddingHeadLpVO.class));
        PurchaseEbiddingHeadLp head = new PurchaseEbiddingHeadLp();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setEbiddingStatus(EbiddingLpStatusEnum.NEW.getValue());
        head.setPublishTime(null);
        head.setPublishUser(null);
        this.purchaseEbiddingHeadService.updateMain(head, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        PurchaseEbiddingHeadLpVO headVO = new PurchaseEbiddingHeadLpVO();
        String id = flowCallbackDTO.getBusinessId();
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        headVO.setPurchaseEbiddingItemList(this.purchaseEbiddingItemService.selectByMainId(id));
        headVO.setPurchaseEbiddingSupplierList(this.purchaseEbiddingSupplierService.selectByMainId(id));
        headVO.setPurchaseEbiddingConfirmList(this.purchaseEbiddingConfirmService.selectByMainId(id));
        headVO.setPurchaseAttachmentDemandList(this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id));
        this.purchaseEbiddingHeadService.publish(headVO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseEbiddingHeadLp head = (PurchaseEbiddingHeadLp)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseEbiddingHeadLpVO headVO = new PurchaseEbiddingHeadLpVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseEbiddingItemLp> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
            headVO.setPurchaseEbiddingItemList(itemList);
            return SrmUtil.toJSONObject((Object)((Object)headVO));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseEbiddingHeadLp updateHead = new PurchaseEbiddingHeadLp();
        updateHead.setId(flowCallbackDTO.getBusinessId());
        updateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        updateHead.setAuditStatus(auditStatus);
        this.purchaseEbiddingHeadService.updateById((Object)updateHead);
    }
}

