/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.DateUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemHisMapper;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemHisService;
import com.els.modules.ebidding.service.impl.SaleEbiddingHeadServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingItemHisServiceImpl;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.job.utils.LpEbiddingJobUtil;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.impl.PurchaseEbiddingHeadLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.service.impl.PurchaseEbiddingItemLpServiceImpl;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="logisticsPurchaseEbiddingDutchQuoteJobServiceImpl")
public class LogisticsPurchaseEbiddingDutchQuoteJobDubboServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsPurchaseEbiddingDutchQuoteJobDubboServiceImpl.class);
    @Autowired
    private RedisUtil redis;
    @Resource
    private PurchaseEbiddingItemHisMapper purchaseEbiddingItemHisMapper;

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void execute(String parameter) {
        log.info("\u7269\u6d41\u91c7\u8d2d-\u8377\u5f0f\u7ade\u4ef7\u62a5\u4ef7\u5b9a\u65f6\u4efb\u52a1 logisticsPurchaseEbiddingDutchQuoteJobServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            log.error("parameter must contain id.");
            return;
        }
        String tenantId = StrUtil.isBlank((CharSequence)paramObj.getString("tenantId")) ? "100000" : paramObj.getString("tenantId");
        TenantContext.setTenant((String)tenantId);
        PurchaseEbiddingHeadLpService purchaseEbiddingHeadService = (PurchaseEbiddingHeadLpService)SpringContextUtils.getBean(PurchaseEbiddingHeadLpServiceImpl.class);
        PurchaseEbiddingHeadLp purchaseEbiddingHead = (PurchaseEbiddingHeadLp)((Object)purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
        if (!EbiddingMethodEnum.DUTCH.getValue().equals(purchaseEbiddingHead.getEbiddingMethod())) {
            log.error("\u7269\u6d41\u91c7\u8d2d-\u8377\u5f0f\u7ade\u4ef7\u62a5\u4ef7\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u7684\u7ade\u4ef7\u65b9\u5f0f\u4e3a[{}]\uff0c\u505c\u6b62\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u5bf9\u5e94\u7684\u7ade\u4ef7\u5355\u5934ID\u4e3a[{}]", (Object)purchaseEbiddingHead.getEbiddingMethod(), (Object)id);
            String jobKey = paramObj.getString("jobKey");
            LpEbiddingJobUtil.deleteJob(jobKey);
            return;
        }
        if (!EbiddingStatusEnum.BIDDING.getValue().equals(purchaseEbiddingHead.getEbiddingStatus())) {
            log.error("\u7269\u6d41\u91c7\u8d2d-\u8377\u5f0f\u7ade\u4ef7\u62a5\u4ef7\u5b9a\u65f6\u4efb\u52a1\uff0c\u7ade\u4ef7\u72b6\u6001\u4e0d\u662f[\u7ade\u4ef7\u4e2d]\uff0c\u505c\u6b62\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u5bf9\u5e94\u7684\u7ade\u4ef7\u5355\u5934ID\u4e3a[{}]", (Object)purchaseEbiddingHead.getEbiddingMethod(), (Object)id);
            String jobKey = paramObj.getString("jobKey");
            LpEbiddingJobUtil.deleteJob(jobKey);
            return;
        }
        purchaseEbiddingHead.setQuoteFlag("0");
        purchaseEbiddingHeadService.updateById((Object)purchaseEbiddingHead);
        SaleEbiddingHead saleHead = new SaleEbiddingHead();
        saleHead.setQuoteFlag("0");
        SaleEbiddingHeadService saleEbiddingHeadService = (SaleEbiddingHeadService)SpringContextUtils.getBean(SaleEbiddingHeadServiceImpl.class);
        saleEbiddingHeadService.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)purchaseEbiddingHead.getId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
        SaleEbiddingItemHisService saleEbiddingItemHisService = (SaleEbiddingItemHisService)SpringContextUtils.getBean(SaleEbiddingItemHisServiceImpl.class);
        List<SaleEbiddingHead> saleEbiddingHeadList = saleEbiddingHeadService.getByRelationId(purchaseEbiddingHead.getId());
        List<String> saleHeadIdList = saleEbiddingHeadList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        List<SaleEbiddingItemHis> saleEbiddingItemHisList = saleEbiddingItemHisService.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
        saleEbiddingItemHisList = saleEbiddingItemHisList.stream().filter(item -> StrUtil.isBlank((CharSequence)item.getAccept())).collect(Collectors.toList());
        for (SaleEbiddingItemHis itemHis : saleEbiddingItemHisList) {
            itemHis.setAccept("3");
            saleEbiddingItemHisService.updateById((Object)itemHis);
            PurchaseEbiddingItemHis purchaseHis = new PurchaseEbiddingItemHis();
            purchaseHis.setId(itemHis.getRelationId());
            purchaseHis.setAccept("3");
            this.purchaseEbiddingItemHisMapper.updateById((Object)purchaseHis);
        }
        String jobKey = paramObj.getString("jobKey");
        LpEbiddingJobUtil.deleteJob(jobKey);
        if ("1".equals(purchaseEbiddingHead.getPurchaseAutoQuote())) {
            PurchaseEbiddingItemLpService purchaseEbiddingItemService = (PurchaseEbiddingItemLpService)SpringContextUtils.getBean(PurchaseEbiddingItemLpServiceImpl.class);
            List<PurchaseEbiddingItemLp> dbItemList = purchaseEbiddingItemService.selectByMainId(id);
            String itemNumber = StrUtil.isNotBlank((CharSequence)purchaseEbiddingHead.getCurrentItemNumber()) ? purchaseEbiddingHead.getCurrentItemNumber() : "1";
            List<PurchaseEbiddingItemLp> quoteList = dbItemList.stream().filter(item -> itemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
            boolean successQuotePrice = purchaseEbiddingHeadService.autoQuotePricePublic(purchaseEbiddingHead, quoteList);
            if (successQuotePrice) {
                purchaseEbiddingHead.setQuoteFlag("1");
                purchaseEbiddingHead.setBeginTime(new Date());
                purchaseEbiddingHead.setEndTime((Date)DateUtil.offsetSecond((Date)purchaseEbiddingHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)purchaseEbiddingHead.getKeepMinute(), (int)1)));
                purchaseEbiddingHeadService.updateById((Object)purchaseEbiddingHead);
                LpEbiddingJobUtil.createDutchQuoteJob(purchaseEbiddingHead, purchaseEbiddingHead.getEndTime());
                saleHead.setQuoteFlag("1");
                saleHead.setBeginTime(purchaseEbiddingHead.getBeginTime());
                saleHead.setStartTime(purchaseEbiddingHead.getStartTime());
                saleHead.setEndTime(purchaseEbiddingHead.getEndTime());
                saleHead.setCurrentDelayCount(purchaseEbiddingHead.getCurrentDelayCount());
                saleEbiddingHeadService.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)purchaseEbiddingHead.getId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
                purchaseEbiddingHeadService.autoSetBindnumber(purchaseEbiddingHead, dbItemList, quoteList);
            }
        }
        this.redis.publish("lp-quote-price-topic", (Object)purchaseEbiddingHead.getId());
        log.info("[lp-quotePriceTopic]\u7269\u6d41\u91c7\u8d2d-\u8377\u5f0f\u7ade\u4ef7\u5b9a\u65f6\u4efb\u52a1\u6267\u884c-\u7ade\u4ef7\u5355\u53f7[{}]\u53d1\u5e03\u6d88\u606f\uff0c\u7ade\u4ef7ID\u4e3a[{}]", (Object)purchaseEbiddingHead.getEbiddingNumber(), (Object)purchaseEbiddingHead.getId());
        log.info("\u7269\u6d41\u91c7\u8d2d-\u8377\u5f0f\u7ade\u4ef7\u62a5\u4ef7\u5b9a\u65f6\u4efb\u52a1 logisticsPurchaseEbiddingDutchQuoteJobServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

