/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSAgainException;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.WorkFlowUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.impl.PurchaseClarificationInfoServiceImpl;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.PurchaseContractItemDTO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.enumerate.EbiddingDelayRuleEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingRangeUnitEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingScopeEnum;
import com.els.modules.ebidding.enumerate.EbiddingStartWayEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.vo.PurchaseEbiddingMessageVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.PricingNoticeEnum;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.enumerate.QuotaWayEnum;
import com.els.modules.inquiry.enumerate.RegretFlagEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.enumerate.SrmPublicScopeEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceHead;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceItem;
import com.els.modules.logisticspurchase.base.entity.LogisticsPurchasePriceRecords;
import com.els.modules.logisticspurchase.base.entity.SubjectFileHead;
import com.els.modules.logisticspurchase.base.enumerate.LineSourceTypeEnum;
import com.els.modules.logisticspurchase.base.service.LineDifferenceHeadService;
import com.els.modules.logisticspurchase.base.service.LineDifferenceItemService;
import com.els.modules.logisticspurchase.base.service.LogisticsPurchasePriceRecordsService;
import com.els.modules.logisticspurchase.base.service.SubjectFileHeadService;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingConfirmLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingSupplierLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingItemLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.enumerate.LpEbiddingTypeEnum;
import com.els.modules.logisticspurchase.ebidding.enumerate.LpEbiddingTypeHisEnum;
import com.els.modules.logisticspurchase.ebidding.job.utils.LpEbiddingJobUtil;
import com.els.modules.logisticspurchase.ebidding.mapper.PurchaseEbiddingHeadLpMapper;
import com.els.modules.logisticspurchase.ebidding.mapper.PurchaseEbiddingItemHisLpMapper;
import com.els.modules.logisticspurchase.ebidding.service.PublicEbiddingLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingConfirmLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemHisLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingSupplierLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingItemHisLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.impl.SaleEbiddingHeadLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.service.impl.SaleEbiddingItemHisLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.service.impl.SaleEbiddingItemLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseAwardOpinionLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingConfirmLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingHeadLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingPrintLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingSupplierLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseOverviewSubmitPriceVO;
import com.els.modules.logisticspurchase.ebidding.vo.QuoteHisDictCodeVO;
import com.els.modules.logisticspurchase.ebidding.vo.QuoteHisReportLpVO;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.vo.PurchaseEnquiryHeadLpVO;
import com.els.modules.logisticspurchase.inquiry.service.PublishToB2BLpService;
import com.els.modules.logisticspurchase.inquiry.service.PurchaseAwardOpinionLpService;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PriceStatusEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.rocketMq.util.InitTableMqUtil;
import com.els.modules.rpc.service.InquiryInvokeContractService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.SubmitAuditDTO;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseEbiddingHeadLpServiceImpl
extends BaseServiceImpl<PurchaseEbiddingHeadLpMapper, PurchaseEbiddingHeadLp>
implements PurchaseEbiddingHeadLpService,
PurchaseExecuteReviewService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingHeadLpServiceImpl.class);
    @Autowired
    private PurchaseEbiddingSupplierLpService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingItemLpService purchaseEbiddingItemService;
    @Autowired
    private LogisticsPurchasePriceRecordsService logisticsPurchasePriceRecordsService;
    @Autowired
    private PurchaseEbiddingConfirmLpService purchaseEbiddingConfirmService;
    @Autowired
    private SaleEbiddingHeadLpService saleEbiddingHeadService;
    @Autowired
    @Lazy
    private PublicEbiddingLpService publicEbiddingService;
    @Autowired
    private PublishToB2BLpService publishToB2BService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseAwardOpinionLpService purchaseAwardOpinionService;
    @Autowired
    private PurchaseEbiddingItemHisLpService purchaseEbiddingItemHisService;
    @Autowired
    private RedisUtil redis;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Autowired
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Autowired
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Autowired
    private PurchaseEbiddingSupplierLpService ebiddingSupplierService;
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private InquiryInvokeContractService inquiryInvokeContractService;
    @Autowired
    private PurchaseEbiddingItemHisLpMapper purchaseEbiddingItemHisMapper;
    @Autowired
    private SubjectFileHeadService subjectFileHeadService;
    @Autowired
    private LineDifferenceHeadService nbeLineDifferenceHeadService;
    @Resource(name="srmPoolExecutor")
    private ThreadPoolExecutor executor;
    private static final String EBIDDING_END_KEY = "sys:ebidding:end";
    private static final String START_PRICE_FLAG = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmLpVO> confirmList) {
        SysUtil.setNullCreate((BaseEntity)head);
        head.setEbiddingStatus(EbiddingLpStatusEnum.NEW.getValue());
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setDeleted(CommonConstant.DEL_FLAG_0);
        head.setCurrentRound(head.getCurrentRound() == null ? 1 : head.getCurrentRound());
        head.setQuoteFlag(null);
        head.setInviteQuantity(null);
        head.setReplyQuantity(null);
        super.setHeadDefaultValue((ParentEntity)head);
        head.setSubjectYear((String)ObjectUtil.defaultIfBlank((CharSequence)head.getSubjectYear(), (CharSequence)String.valueOf(DateUtil.year((Date)new Date()))));
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).insert((Object)head);
        if (StrUtil.isNotBlank((CharSequence)head.getDocumentId())) {
            this.invokeBaseRpcService.updateIntegratedDocumentMain("ebiddingHeadId", head.getDocumentId(), head.getDocumentParentId(), head.getId());
        }
        itemList.forEach(i -> i.setSubjectYear((String)ObjectUtil.defaultIfBlank((CharSequence)i.getSubjectYear(), (CharSequence)String.valueOf(DateUtil.year((Date)new Date())))));
        this.insertData(head, itemList, supplierList, attachmentDemandList, confirmList);
        this.sendLink(head, itemList);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveTestMain(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmLpVO> confirmList) {
        SysUtil.setNullCreate((BaseEntity)head);
        head.setEbiddingStatus(EbiddingLpStatusEnum.NEW.getValue());
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setDeleted(CommonConstant.DEL_FLAG_0);
        head.setCurrentRound(head.getCurrentRound() == null ? 1 : head.getCurrentRound());
        head.setQuoteFlag(null);
        head.setInviteQuantity(null);
        head.setReplyQuantity(null);
        super.setHeadDefaultValue((ParentEntity)head);
        head.setSubjectYear((String)ObjectUtil.defaultIfBlank((CharSequence)head.getSubjectYear(), (CharSequence)String.valueOf(DateUtil.year((Date)new Date()))));
        SysUtil.setNullCreate((BaseEntity)head);
        head.setEbiddingType(LpEbiddingTypeHisEnum.REVERSE_BID.getValue());
        head.setEbiddingMethod(EbiddingMethodEnum.BRITISH.getValue());
        head.setEbiddingWay(EbiddingWayEnum.PACKAGE.getValue());
        head.setRangeUnit(EbiddingRangeUnitEnum.PERCENT.getValue());
        head.setEbiddingScope(EbiddingScopeEnum.INVITE.getValue());
        head.setChangeRange(new BigDecimal("0.5"));
        head.setCurrency("CNY");
        head.setIntervalMinute(BigDecimal.ZERO);
        head.setParticipateQuantity(supplierList.size());
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).insert((Object)head);
        if (StrUtil.isNotBlank((CharSequence)head.getDocumentId())) {
            this.invokeBaseRpcService.updateIntegratedDocumentMain("ebiddingHeadId", head.getDocumentId(), head.getDocumentParentId(), head.getId());
        }
        itemList.forEach(i -> i.setSubjectYear((String)ObjectUtil.defaultIfBlank((CharSequence)i.getSubjectYear(), (CharSequence)String.valueOf(DateUtil.year((Date)new Date())))));
        if (CollUtil.isNotEmpty(itemList) && CollUtil.isNotEmpty(supplierList)) {
            Map<String, PurchaseEbiddingItemLp> map = itemList.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getToElsAccount())).collect(Collectors.toMap(PurchaseEbiddingItemLp::getToElsAccount, p -> p, (o, n) -> o));
            ArrayList items = new ArrayList();
            PurchaseEbiddingItemLp temp = itemList.get(0);
            supplierList.forEach(supplier -> {
                PurchaseEbiddingItemLp currentItem = new PurchaseEbiddingItemLp();
                if (CollUtil.isNotEmpty((Map)map) && map.containsKey(supplier.getToElsAccount())) {
                    BeanUtils.copyProperties(map.get(supplier.getToElsAccount()), (Object)((Object)currentItem));
                } else {
                    BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)currentItem));
                    currentItem.setStandardPrice(BigDecimal.ZERO);
                    currentItem.setNetTotalAmount(currentItem.getStandardPrice());
                    currentItem.setTaxCode(null);
                    currentItem.setTaxRate(null);
                }
                currentItem.setId(null);
                currentItem.setToElsAccount(supplier.getToElsAccount());
                currentItem.setSupplierName(supplier.getSupplierName());
                currentItem.setEffectiveDate(head.getEffectiveDate());
                currentItem.setExpiryDate(head.getExpiryDate());
                currentItem.setSubjectType(head.getSubjectType());
                currentItem.setSubjectNumber(head.getSubjectNumber());
                currentItem.setSubjectName(head.getSubjectName());
                currentItem.setItemNumber(START_PRICE_FLAG);
                currentItem.setStandardPrice((BigDecimal)ObjectUtil.defaultIfNull((Object)currentItem.getStandardPrice(), (Object)BigDecimal.ZERO));
                currentItem.setNetTotalAmount(currentItem.getStandardPrice());
                items.add(currentItem);
            });
            itemList.clear();
            itemList.addAll(items);
        }
        if (CollectionUtil.isNotEmpty(itemList)) {
            for (PurchaseEbiddingItemLp item : itemList) {
                item.setId(IdWorker.getIdStr());
                item.setHeadId(head.getId());
                item.setDocumentId(head.getDocumentId());
                item.setEbiddingNumber(head.getEbiddingNumber());
                item.setItemStatus(EbiddingItemLpStatusEnum.NEW.getValue());
                item.setAuditStatus(head.getResultAuditStatus());
                item.setSendStatus("0");
                item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.purchaseEbiddingItemService.saveBatch(itemList, 2000);
        }
        this.purchaseEbiddingSupplierService.addBatch(head, supplierList);
        this.purchaseEbiddingConfirmService.addBatch(head, confirmList);
        this.invokeBaseRpcService.addPurchaseAttachmentDemandBatch(attachmentDemandList, head.getId(), "ebidding");
        this.sendLink(head, itemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmLpVO> confirmList) {
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setSubjectYear((String)ObjectUtil.defaultIfBlank((CharSequence)head.getSubjectYear(), (CharSequence)String.valueOf(DateUtil.year((Date)new Date()))));
        itemList.forEach(i -> i.setSubjectYear((String)ObjectUtil.defaultIfBlank((CharSequence)i.getSubjectYear(), (CharSequence)String.valueOf(DateUtil.year((Date)new Date())))));
        itemList.forEach(i -> i.setItemNumber(START_PRICE_FLAG));
        int count = ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)head);
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        this.deleteSubTable(head.getId());
        this.insertData(head, itemList, supplierList, attachmentDemandList, confirmList);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
        this.sendLink(head, itemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateTestMain(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmLpVO> confirmList) {
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setSubjectYear((String)ObjectUtil.defaultIfBlank((CharSequence)head.getSubjectYear(), (CharSequence)String.valueOf(DateUtil.year((Date)new Date()))));
        SysUtil.setNullCreate((BaseEntity)head);
        head.setEbiddingStatus(EbiddingLpStatusEnum.NEW.getValue());
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setDeleted(CommonConstant.DEL_FLAG_0);
        head.setCurrentRound(head.getCurrentRound() == null ? 1 : head.getCurrentRound());
        head.setQuoteFlag(null);
        head.setInviteQuantity(null);
        head.setReplyQuantity(null);
        head.setEbiddingType(LpEbiddingTypeHisEnum.REVERSE_BID.getValue());
        head.setEbiddingMethod(EbiddingMethodEnum.BRITISH.getValue());
        head.setEbiddingWay(EbiddingWayEnum.PACKAGE.getValue());
        head.setRangeUnit(EbiddingRangeUnitEnum.PERCENT.getValue());
        head.setEbiddingScope(EbiddingScopeEnum.INVITE.getValue());
        head.setChangeRange(new BigDecimal("0.5"));
        head.setCurrency("CNY");
        head.setIntervalMinute(BigDecimal.ZERO);
        itemList.forEach(i -> i.setSubjectYear((String)ObjectUtil.defaultIfBlank((CharSequence)i.getSubjectYear(), (CharSequence)String.valueOf(DateUtil.year((Date)new Date())))));
        head.setParticipateQuantity(supplierList.size());
        int count = ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)head);
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        this.deleteSubTable(head.getId());
        if (CollUtil.isNotEmpty(itemList)) {
            if (CollUtil.isEmpty(supplierList)) {
                itemList.clear();
            } else {
                Map<String, PurchaseEbiddingItemLp> map = itemList.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getToElsAccount())).collect(Collectors.toMap(PurchaseEbiddingItemLp::getToElsAccount, p -> p, (o, n) -> o));
                ArrayList items = new ArrayList();
                PurchaseEbiddingItemLp temp = itemList.get(0);
                supplierList.forEach(supplier -> {
                    PurchaseEbiddingItemLp currentItem = new PurchaseEbiddingItemLp();
                    if (CollUtil.isNotEmpty((Map)map) && map.containsKey(supplier.getToElsAccount())) {
                        BeanUtils.copyProperties(map.get(supplier.getToElsAccount()), (Object)((Object)currentItem));
                    } else {
                        BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)currentItem));
                        currentItem.setStandardPrice(BigDecimal.ZERO);
                        currentItem.setNetTotalAmount(currentItem.getStandardPrice());
                        currentItem.setTaxCode(null);
                        currentItem.setTaxRate(null);
                    }
                    currentItem.setId(null);
                    currentItem.setToElsAccount(supplier.getToElsAccount());
                    currentItem.setSupplierName(supplier.getSupplierName());
                    currentItem.setEffectiveDate(head.getEffectiveDate());
                    currentItem.setExpiryDate(head.getExpiryDate());
                    currentItem.setSubjectType(head.getSubjectType());
                    currentItem.setSubjectNumber(head.getSubjectNumber());
                    currentItem.setSubjectName(head.getSubjectName());
                    currentItem.setItemNumber(START_PRICE_FLAG);
                    currentItem.setStandardPrice((BigDecimal)ObjectUtil.defaultIfNull((Object)currentItem.getStandardPrice(), (Object)BigDecimal.ZERO));
                    currentItem.setNetTotalAmount(currentItem.getStandardPrice());
                    items.add(currentItem);
                });
                itemList.clear();
                itemList.addAll(items);
            }
        }
        if (CollectionUtil.isNotEmpty(itemList)) {
            for (PurchaseEbiddingItemLp item : itemList) {
                item.setId(IdWorker.getIdStr());
                item.setHeadId(head.getId());
                item.setDocumentId(head.getDocumentId());
                item.setEbiddingNumber(head.getEbiddingNumber());
                item.setItemStatus(EbiddingItemLpStatusEnum.NEW.getValue());
                item.setAuditStatus(head.getResultAuditStatus());
                item.setSendStatus("0");
                item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.purchaseEbiddingItemService.saveBatch(itemList, 2000);
        }
        this.purchaseEbiddingSupplierService.addBatch(head, supplierList);
        this.purchaseEbiddingConfirmService.addBatch(head, confirmList);
        this.invokeBaseRpcService.addPurchaseAttachmentDemandBatch(attachmentDemandList, head.getId(), "ebidding");
        this.sendLink(head, itemList);
    }

    @Override
    @SrmTransaction
    public void copy(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmLpVO> confirmList) {
        List<String> headFieldList = Arrays.asList("id", "documentId", "publishTime", "publishUser", "updateBy", "updateTime", "updateById", "createBy", "createTime", "createById", "currentRound", "endTime", "currentDelayCount", "ebiddingAmount", "savingAmount", "savingRate", "savingAmount", "startTime", "currentItemNumber", "flowId", "resultFlowId", "hasQuote");
        super.setFieldValueNull((Object)head, headFieldList);
        head.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)head));
        if (CollectionUtil.isNotEmpty(supplierList)) {
            supplierList.forEach(e -> e.setNeedCoordination(null));
        }
        this.saveMain(head, itemList, supplierList, attachmentDemandList, confirmList);
    }

    private void sendLink(PurchaseEbiddingHeadLp headVO, List<PurchaseEbiddingItemLp> items) {
        JSONArray objects = new JSONArray();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        JSONObject object = new JSONObject();
        if (headVO != null) {
            object.put("integratedId", (Object)headVO.getDocumentId());
            object.put("elsAccount", (Object)TenantContext.getTenant());
            object.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("businessType", (Object)"ebidding");
            object.put("businessParentType", null);
            object.put("businessId", (Object)headVO.getId());
            object.put("businessParentId", (Object)headVO.getDocumentParentId());
            object.put("businessDataType", (Object)"head");
            objects.add((Object)object);
        }
        if (!CollectionUtils.isEmpty(items)) {
            for (PurchaseEbiddingItemLp item : items) {
                JSONObject objectItem = new JSONObject();
                objectItem.put("integratedId", (Object)item.getDocumentItemId());
                objectItem.put("elsAccount", (Object)TenantContext.getTenant());
                objectItem.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("businessType", (Object)"ebidding");
                objectItem.put("businessParentType", null);
                objectItem.put("businessId", (Object)item.getId());
                objectItem.put("businessParentId", (Object)item.getDocumentParentId());
                objectItem.put("businessDataType", (Object)"item");
                objects.add((Object)objectItem);
            }
        }
        if (!objects.isEmpty()) {
            MqUtil.sendIntegrateDataLinkMsg((JSONArray)objects, null, null);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        PurchaseEbiddingHeadLp head = (PurchaseEbiddingHeadLp)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)head.getDocumentId())) {
            this.invokeBaseRpcService.delIntegratedDocumentMain("ebiddingHeadId", head.getDocumentId(), head.getDocumentParentId(), head.getId());
        }
        Assert.isTrue((boolean)EbiddingLpStatusEnum.NEW.getValue().equals(head.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjVIzEIjtFqQG_85452cad", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u4e0b\u7684\u5355\u636e\u53ef\u5220\u9664"));
        List<PurchaseEbiddingItemLp> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.deleteSubTable(id);
        if (StrUtil.isNotBlank((CharSequence)head.getEnquiryId())) {
            PurchaseEnquiryHeadLpService purchaseEnquiryHeadService = (PurchaseEnquiryHeadLpService)SpringContextUtils.getBean(PurchaseEnquiryHeadLpService.class);
            PurchaseEnquiryHeadLp updateEnquiryHead = new PurchaseEnquiryHeadLp();
            updateEnquiryHead.setId(head.getEnquiryId());
            updateEnquiryHead.setEnquiryStatus(EnquiryLpStatusEnum.BARGAIN.getValue());
            purchaseEnquiryHeadService.updateById((Object)updateEnquiryHead);
        }
    }

    private void deleteSubTable(String headId) {
        List<PurchaseEbiddingItemLp> items = this.purchaseEbiddingItemService.selectByMainId(headId);
        if (!CollectionUtils.isEmpty(items)) {
            List stringList = items.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
            MqUtil.sendIntegrateDataLinkMsg(null, stringList, null);
        }
        this.purchaseEbiddingItemService.deleteByMainId(headId);
        this.purchaseEbiddingSupplierService.deleteByMainId(headId);
        this.purchaseEbiddingConfirmService.deleteByMainId(headId);
        this.goBackDemandUseForDel(items, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(headId);
    }

    private void insertData(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmLpVO> confirmList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            for (PurchaseEbiddingItemLp item : itemList) {
                item.setId(IdWorker.getIdStr());
                item.setHeadId(head.getId());
                item.setDocumentId(head.getDocumentId());
                item.setEbiddingNumber(head.getEbiddingNumber());
                item.setItemStatus(EbiddingItemLpStatusEnum.NEW.getValue());
                item.setAuditStatus(head.getResultAuditStatus());
                item.setSendStatus("0");
                item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.purchaseEbiddingItemService.saveBatch(itemList, 2000);
        }
        this.purchaseEbiddingSupplierService.addBatch(head, supplierList);
        this.purchaseEbiddingConfirmService.addBatch(head, confirmList);
        this.invokeBaseRpcService.addPurchaseAttachmentDemandBatch(attachmentDemandList, head.getId(), "ebidding");
    }

    @Override
    public void goBackDemand(List<PurchaseEbiddingItemLp> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            ArrayList<String> idList = new ArrayList<String>();
            List<String> idList1 = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId()) && SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType())).map(PurchaseEbiddingItemLp::getSourceItemId).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(idList1)) {
                idList1.forEach(str -> idList.addAll(Arrays.stream(str.split(",")).collect(Collectors.toList())));
            }
            if (PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(status) && CollectionUtil.isNotEmpty(idList)) {
                List<String> headIdList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getHeadId())).map(PurchaseEbiddingItemLp::getHeadId).distinct().collect(Collectors.toList());
                List<PurchaseEbiddingItemLp> list = this.purchaseEbiddingItemService.findBySourceItemId(headIdList, idList);
                if (!CollectionUtils.isEmpty(list)) {
                    Map<String, List> collect = list.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).collect(Collectors.toMap(PurchaseEbiddingItemLp::getSourceItemId, p -> {
                        ArrayList<PurchaseEbiddingItemLp> enquiryItems = new ArrayList<PurchaseEbiddingItemLp>();
                        enquiryItems.add((PurchaseEbiddingItemLp)((Object)p));
                        return enquiryItems;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    ArrayList<String> ListDauctionsBuilt = new ArrayList<String>();
                    ArrayList<String> ListCompletionOfTheAuction = new ArrayList<String>();
                    Set<String> strings = collect.keySet();
                    for (String string : strings) {
                        List purchaseEbiddingItems = collect.get(string);
                        if (purchaseEbiddingItems.isEmpty()) continue;
                        List collect2 = purchaseEbiddingItems.stream().map(PurchaseEbiddingItemLp::getHeadId).distinct().collect(Collectors.toList());
                        List purchaseEbiddingHeads = this.listByIds(collect2);
                        List collect3 = purchaseEbiddingHeads.stream().filter(item -> EbiddingLpStatusEnum.BID_SUCCESS.equals(item.getEbiddingStatus())).collect(Collectors.toList());
                        if (collect3.isEmpty()) {
                            ListDauctionsBuilt.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                            continue;
                        }
                        ListCompletionOfTheAuction.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                    }
                    idList.removeAll(ListDauctionsBuilt);
                    idList.removeAll(ListCompletionOfTheAuction);
                    if (!ListDauctionsBuilt.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListDauctionsBuilt, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
                    }
                    if (!ListCompletionOfTheAuction.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListCompletionOfTheAuction, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
                    }
                    if (!idList.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(idList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                    }
                } else {
                    this.purchaseRequestItemService.updateStatusById(idList, status);
                }
            } else {
                this.purchaseRequestItemService.updateStatusById(idList, status);
            }
        }
    }

    public void goBackDemandUseForDel(List<PurchaseEbiddingItemLp> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            ArrayList<String> idList = new ArrayList<String>();
            List<String> idList1 = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId()) && SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType())).map(PurchaseEbiddingItemLp::getSourceItemId).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(idList1)) {
                idList1.forEach(str -> idList.addAll(Arrays.stream(str.split(",")).collect(Collectors.toList())));
            }
            if (PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(status) && CollectionUtil.isNotEmpty(idList)) {
                List<String> headIdList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getHeadId())).map(PurchaseEbiddingItemLp::getHeadId).distinct().collect(Collectors.toList());
                List<PurchaseEbiddingItemLp> list = this.purchaseEbiddingItemService.findBySourceItemId(headIdList, idList);
                if (!CollectionUtils.isEmpty(list)) {
                    Map<String, List> collect = list.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).collect(Collectors.toMap(PurchaseEbiddingItemLp::getSourceItemId, p -> {
                        ArrayList<PurchaseEbiddingItemLp> enquiryItems = new ArrayList<PurchaseEbiddingItemLp>();
                        enquiryItems.add((PurchaseEbiddingItemLp)((Object)p));
                        return enquiryItems;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    ArrayList<String> ListDauctionsBuilt = new ArrayList<String>();
                    ArrayList<String> ListCompletionOfTheAuction = new ArrayList<String>();
                    Set<String> strings = collect.keySet();
                    for (String string : strings) {
                        List purchaseEbiddingItems = collect.get(string);
                        if (purchaseEbiddingItems.isEmpty()) continue;
                        List collect2 = purchaseEbiddingItems.stream().map(PurchaseEbiddingItemLp::getHeadId).distinct().collect(Collectors.toList());
                        List purchaseEbiddingHeads = this.listByIds(collect2);
                        List collect3 = purchaseEbiddingHeads.stream().filter(item -> EbiddingLpStatusEnum.BID_SUCCESS.equals(item.getEbiddingStatus())).collect(Collectors.toList());
                        if (collect3.isEmpty()) {
                            ListDauctionsBuilt.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                            continue;
                        }
                        ListCompletionOfTheAuction.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                    }
                    idList.removeAll(ListDauctionsBuilt);
                    idList.removeAll(ListCompletionOfTheAuction);
                    if (!ListDauctionsBuilt.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListDauctionsBuilt, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
                    }
                    if (!ListCompletionOfTheAuction.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListCompletionOfTheAuction, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
                    }
                    if (!idList.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(idList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                    }
                } else {
                    ArrayList<PurchaseRequestItem> purchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
                    for (String id : idList) {
                        PurchaseRequestItem purchaseRequestItem = (PurchaseRequestItem)((Object)this.purchaseRequestItemService.getById((Serializable)((Object)id)));
                        purchaseRequestItemList.add(purchaseRequestItem);
                    }
                    if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
                        this.purchaseRequestHeadService.matchPrice(purchaseRequestItemList);
                    }
                }
            } else {
                this.purchaseRequestItemService.updateStatusById(idList, status);
            }
        }
    }

    private void checkAndSetParam(PurchaseEbiddingHeadLpVO headVO) {
        List startPriceList;
        Date beginTime = headVO.getBeginTime();
        Assert.notNull((Object)beginTime, (String)I18nUtil.translate((String)"i18n_alert_OuvKKIxOLVW_50f9240f", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)beginTime.after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_OuvKKIlTfUAPKIW_22eb88a", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff01"));
        BigDecimal keepMinute = headVO.getKeepMinute();
        Assert.notNull((Object)headVO.getChangeRange(), (String)I18nUtil.translate((String)"i18n_alert_umDiBzxOLV_2cd60c7", (String)"\u4ef7\u683c\u8c03\u6574\u5e45\u5ea6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getRangeUnit(), (String)I18nUtil.translate((String)"i18n_alert_BztLxOLV_3b65a2e9", (String)"\u5e45\u5ea6\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a"));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.notNull((Object)keepMinute, (String)I18nUtil.translate((String)"i18n_alert_uTKIWzsWKIxOLVW_78c93f21", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (START_PRICE_FLAG.equals(headVO.getPurchaseAutoQuote()) && !EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getSetStartPrice()), (String)I18nUtil.translate((String)"i18n_alert_JOsuWlTGRAAu_6bbab75f", (String)"\u81ea\u52a8\u62a5\u4ef7\uff0c\u5fc5\u987b\u8bbe\u7f6e\u8d77\u62cd\u4ef7"));
        }
        if (!EbiddingDelayRuleEnum.NOT_ALLOW_DELAY.getValue().equals(headVO.getDelayRule()) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)headVO.getKeepMinute()) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)headVO.getBeforeEndMinute())) {
            Integer keepMinute1 = Double.valueOf(String.valueOf(headVO.getKeepMinute())).intValue();
            Assert.isTrue((headVO.getBeforeEndMinute() <= keepMinute1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__yWPORzslTXUuTKI_8cb9e8b0", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6301\u7eed\u65f6\u95f4"));
        }
        Integer participateQuantity = headVO.getParticipateQuantity();
        Assert.notNull((Object)participateQuantity, (String)I18nUtil.translate((String)"i18n_alert_sUWRxOLV_988f07b", (String)"\u53c2\u4e0e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        List<PurchaseEbiddingSupplierLp> supplierList = headVO.getPurchaseEbiddingSupplierList();
        headVO.setInviteQuantity(supplierList.size());
        String ebiddingScope = StrUtil.isNotBlank((CharSequence)headVO.getEbiddingScope()) ? headVO.getEbiddingScope() : EbiddingScopeEnum.INVITE.getValue();
        headVO.setEbiddingScope(ebiddingScope);
        if (EbiddingScopeEnum.INVITE.getValue().equals(ebiddingScope)) {
            Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_RdXABxOLV_453a9d0e", (String)"\u4f9b\u5e94\u5546\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List<String> checkWayList = Arrays.asList(EbiddingWayEnum.PACKAGE.getValue(), EbiddingWayEnum.BATCH.getValue());
        if (START_PRICE_FLAG.equals(headVO.getSetStartPrice()) && checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getStartTotalAmount(), (String)I18nUtil.translate((String)"i18n_alert_eVHAAuxOLV_8dad61ef", (String)"\u5934\u4fe1\u606f\u8d77\u62cd\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((headVO.getStartTotalAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__AAtudrfUW_6a4d7760", (String)"\u8d77\u62cd\u5355\u4ef7\u5e94\u8be5\u5927\u4e8e0"));
        }
        if (START_PRICE_FLAG.equals(headVO.getSendTargetPrice()) && checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getTargetTotalAmount(), (String)I18nUtil.translate((String)"i18n_alert_eVHIBuxOLV_6094452c", (String)"\u5934\u4fe1\u606f\u76ee\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getSupplierTaxRate())) {
            // empty if block
        }
        if (START_PRICE_FLAG.equals(headVO.getNeedEcho())) {
            Assert.notNull((Object)headVO.getEchoEndTime(), (String)I18nUtil.translate((String)"i18n_alert_dByRKIxOLV_29c03139", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((boolean)headVO.getEchoEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_dByRKIlTfUAPKI_bc6345de", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
            Assert.isTrue((boolean)headVO.getEchoEndTime().before(beginTime), (String)I18nUtil.translate((String)"i18n_alert_dByRKIlTXUOuvKKI_e41cb500", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4"));
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                Assert.notNull((Object)headVO.getIntervalMinute(), (String)I18nUtil.translate((String)"i18n_alert_ImKIxOLV_f1534aee", (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((headVO.getIntervalMinute().compareTo(BigDecimal.ONE) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_ImKIlTfUEUW_39975591", (String)"\u95f4\u9694\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1"));
            }
            String delayRule = headVO.getDelayRule();
            if (EbiddingDelayRuleEnum.UNLIMITED_DELAY_COUNT.getValue().equals(delayRule)) {
                Assert.notNull((Object)headVO.getBeforeEndMinute(), (String)I18nUtil.translate((String)"i18n_alert_yWPORzsxOLV_61d00fc1", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notNull((Object)headVO.getDelayMinute(), (String)I18nUtil.translate((String)"i18n_alert_OAzsWxOLV_1b9f0ebe", (String)"\u5ef6\u671f\u5206\u949f\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (EbiddingDelayRuleEnum.LIMIT_DELAY_COUNT.getValue().equals(delayRule)) {
                Assert.notNull((Object)headVO.getBeforeEndMinute(), (String)I18nUtil.translate((String)"i18n_alert_yWPORzsxOLV_61d00fc1", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notNull((Object)headVO.getDelayMinute(), (String)I18nUtil.translate((String)"i18n_alert_OAzsWxOLV_1b9f0ebe", (String)"\u5ef6\u671f\u5206\u949f\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notNull((Object)headVO.getDelayCount(), (String)I18nUtil.translate((String)"i18n_alert_qOAmWxOLV_b027dc17", (String)"\u53ef\u5ef6\u671f\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((headVO.getDelayCount() >= 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__qIOAmWlTfUEU1_be835c81", (String)"\u53ef\u4ee5\u5ef6\u671f\u6b21\u6570\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1"));
            }
            if (EbiddingScopeEnum.PUBLIC.getValue().equals(ebiddingScope)) {
                Assert.notNull((Object)headVO.getApplyEndTime(), (String)I18nUtil.translate((String)"i18n_alert_RvOuWsRyRKIxOLV_e89e5a4d", (String)"\u516c\u5f00\u7ade\u4ef7\uff0c\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Date time = START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? headVO.getEchoEndTime() : headVO.getBeginTime();
                String message = START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? I18nUtil.translate((String)"i18n_alert_sRyRKIlTXUdByRKI_3a02a1dc", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u5e94\u6807\u622a\u6b62\u65f6\u95f4") : I18nUtil.translate((String)"i18n_alert_sRyRKIlTXUOuvKKI_1d1b5655", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4");
                Assert.isTrue((boolean)time.after(headVO.getApplyEndTime()), (String)message);
            }
        } else if (headVO.getPurchaseAutoQuote().equals(START_PRICE_FLAG) && EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay()) && (CollectionUtils.isEmpty(startPriceList = headVO.getPurchaseEbiddingItemList().stream().filter(e -> e.getStartPrice().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList())) || headVO.getPurchaseEbiddingItemList().size() != startPriceList.size())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__AAtudrfUW_6a4d7760", (String)"\u8d77\u62cd\u5355\u4ef7\u5e94\u8be5\u5927\u4e8e0"));
        }
        if (EbiddingMethodEnum.DUTCH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.notNull((Object)keepMinute, (String)I18nUtil.translate((String)"i18n_alert_uTKIWzsWKIxOLVW_78c93f21", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                Assert.notNull((Object)headVO.getIntervalMinute(), (String)I18nUtil.translate((String)"i18n_alert_ImKIxOLV_f1534aee", (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((headVO.getIntervalMinute().compareTo(BigDecimal.ONE) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_ImKIlTfUEUW_39975591", (String)"\u95f4\u9694\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1"));
            }
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) || EbiddingMethodEnum.DUTCH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.notNull((Object)keepMinute, (String)I18nUtil.translate((String)"i18n_alert_uTKIWzsWKIxOLVW_78c93f21", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((keepMinute.compareTo(BigDecimal.ONE) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_uTKIzslTfUEU1_c98a9b5d", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1"));
        }
        List<PurchaseEbiddingItemLp> itemList = headVO.getPurchaseEbiddingItemList();
        Assert.notEmpty(itemList, (String)I18nUtil.translate((String)"i18n_alert_cVHxOLV_c6f5290a", (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        for (PurchaseEbiddingItemLp item : itemList) {
            PurchaseEbiddingHeadLpServiceImpl.headToItem(headVO, item);
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                if (START_PRICE_FLAG.equals(headVO.getSendTargetPrice())) {
                    Assert.notNull((Object)item.getTargetPrice(), (String)I18nUtil.translate((String)"i18n_alert_cVHIBuxOLV_c33b9114", (String)"\u884c\u4fe1\u606f\u76ee\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (START_PRICE_FLAG.equals(headVO.getSetStartPrice())) {
                    Assert.notNull((Object)item.getStartPrice(), (String)I18nUtil.translate((String)"i18n_alert_cVHAAuxOLV_f054add7", (String)"\u884c\u4fe1\u606f\u8d77\u62cd\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.isTrue((item.getStartPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__AAtudrfUW_6a4d7760", (String)"\u8d77\u62cd\u5355\u4ef7\u5e94\u8be5\u5927\u4e8e0"));
                }
                if (!START_PRICE_FLAG.equals(headVO.getSupplierTaxRate())) {
                    Assert.hasText((String)item.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_cVHfoxOLV_76b200bd", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.hasText((String)item.getTaxRate(), (String)I18nUtil.translate((String)"i18n_alert_cVHfIxOLV_379cc943", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            }
            if (item.getDeliveryDate() != null) continue;
            item.setDeliveryDate(item.getRequireDate());
        }
        List needEchoList = headVO.getPurchaseAttachmentDemandList().stream().filter(demand -> START_PRICE_FLAG.equals(demand.getRequired())).filter(demand -> StageTypeEnum.RESPONSE.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(needEchoList)) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWBIlVWTPdBlTLK_1eae1d00", (String)"[${0}]\u9644\u4ef6\u5fc5\u4f20\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f", (String[])new String[]{StageTypeEnum.RESPONSE.getDesc()}));
        }
        this.checkConfirm(headVO);
        List purchaseEbiddingConfirmList = headVO.getPurchaseEbiddingConfirmList().stream().filter(confirm -> START_PRICE_FLAG.equals(confirm.getMust())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(purchaseEbiddingConfirmList)) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWjRLdlSWTPdBlTLK_74e3d92d", (String)"[${0}]\u6709\u786e\u8ba4\u9879\u5fc5\u586b\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f", (String[])new String[]{StageTypeEnum.RESPONSE.getDesc()}));
        }
        headVO.setEbiddingStatus(START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? EbiddingLpStatusEnum.WAIT_REPLY.getValue() : EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
        DateTime endTime = DateUtil.offsetSecond((Date)beginTime, (int)SysUtil.minuteToSecond((BigDecimal)keepMinute, (int)1));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) || EbiddingMethodEnum.DUTCH.getValue().equals(headVO.getEbiddingMethod())) {
            headVO.setEndTime((Date)endTime);
        }
        headVO.setStartTime(beginTime);
        headVO.setCurrentRound(headVO.getCurrentRound() == null ? 1 : headVO.getCurrentRound());
        LoginUserDTO user = SysUtil.getLoginUser();
        headVO.setPublishUser(user.getSubAccount() + "_" + user.getRealname());
        headVO.setPublishTime(new Date());
        headVO.setDeleted(CommonConstant.DEL_FLAG_0);
        if ((EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) || EbiddingMethodEnum.DUTCH.getValue().equals(headVO.getEbiddingMethod())) && !EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
            headVO.setIntervalMinute(BigDecimal.ZERO);
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) && headVO.getIntervalMinute() == null) {
            headVO.setIntervalMinute(BigDecimal.ZERO);
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) && EbiddingDelayRuleEnum.NOT_ALLOW_DELAY.getValue().equals(headVO.getDelayRule())) {
            headVO.setBeforeEndMinute(0);
            headVO.setDelayMinute(0);
            headVO.setDelayCount(0);
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) && EbiddingDelayRuleEnum.UNLIMITED_DELAY_COUNT.getValue().equals(headVO.getDelayRule())) {
            headVO.setDelayCount(0);
        }
        if (!EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            if (!EbiddingMethodEnum.DUTCH.getValue().equals(headVO.getEbiddingMethod())) {
                headVO.setKeepMinute(BigDecimal.ZERO);
                headVO.setIntervalMinute(BigDecimal.ZERO);
            }
            headVO.setDelayRule("");
            headVO.setBeforeEndMinute(0);
            headVO.setDelayMinute(0);
            headVO.setDelayCount(0);
        }
        if ("0".equals(headVO.getNeedEcho())) {
            headVO.setEchoEndTime(null);
        }
        if (EbiddingScopeEnum.INVITE.getValue().equals(headVO.getEbiddingScope())) {
            headVO.setApplyEndTime(null);
        }
    }

    private void checkConfirm(PurchaseEbiddingHeadLpVO headVO) {
        List<PurchaseEbiddingConfirmLpVO> confirmList = headVO.getPurchaseEbiddingConfirmList();
        if (CollectionUtils.isEmpty(confirmList)) {
            return;
        }
        AtomicInteger i = new AtomicInteger(1);
        confirmList.forEach(e -> {
            if (!"2".equals(e.getWriteType())) {
                Assert.isTrue((!CollectionUtils.isEmpty(e.getConfirmItemList()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__n[0]cURidBjSM_9579f2", (String)"\u786e\u8ba4\u9879\uff0c\u7b2c[${0}]\u884c\u9884\u5236\u9009\u9879\u6ca1\u6709\u586b\u5199", (String[])new String[]{i.toString()}));
            }
            i.getAndIncrement();
        });
    }

    private static void headToItem(PurchaseEbiddingHeadLp head, PurchaseEbiddingItemLp item) {
        List<String> checkWayList = Arrays.asList(EbiddingWayEnum.PACKAGE.getValue(), EbiddingWayEnum.BATCH.getValue());
        if (checkWayList.contains(head.getEbiddingWay())) {
            item.setTaxRate(StrUtil.isBlank((CharSequence)head.getTaxRate()) ? item.getTaxRate() : head.getTaxRate());
            item.setTaxCode(StrUtil.isBlank((CharSequence)head.getTaxCode()) ? item.getTaxCode() : head.getTaxCode());
            item.setCurrency(StrUtil.isBlank((CharSequence)head.getCurrency()) ? item.getCurrency() : head.getCurrency());
        } else {
            item.setTaxRate(StrUtil.isBlank((CharSequence)item.getTaxRate()) ? head.getTaxRate() : item.getTaxRate());
            item.setTaxCode(StrUtil.isBlank((CharSequence)item.getTaxCode()) ? head.getTaxCode() : item.getTaxCode());
            item.setCurrency(StrUtil.isBlank((CharSequence)item.getCurrency()) ? head.getCurrency() : item.getCurrency());
        }
        item.setEffectiveDate(item.getEffectiveDate() == null ? head.getEffectiveDate() : item.getEffectiveDate());
        item.setExpiryDate(item.getExpiryDate() == null ? head.getExpiryDate() : item.getExpiryDate());
        item.setAuditStatus(head.getResultAuditStatus());
        item.setEffectiveDate(head.getEffectiveDate());
        item.setExpiryDate(head.getExpiryDate());
    }

    private boolean publishAudit(PurchaseEbiddingHeadLpVO headVO) {
        if (START_PRICE_FLAG.equals(headVO.getPublishAudit()) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(headVO.getAuditStatus())) {
            List<PurchaseEbiddingItemLp> itemList = headVO.getPurchaseEbiddingItemList();
            List<PurchaseEbiddingSupplierLp> supplierList = headVO.getPurchaseEbiddingSupplierList();
            List<PurchaseAttachmentDemandDTO> demandList = headVO.getPurchaseAttachmentDemandList();
            List<PurchaseEbiddingConfirmLpVO> confirmList = headVO.getPurchaseEbiddingConfirmList();
            if (StrUtil.isBlank((CharSequence)headVO.getId())) {
                this.saveMain(headVO, itemList, supplierList, demandList, confirmList);
            } else {
                this.updateMain(headVO, itemList, supplierList, demandList, confirmList);
            }
            String name = StrUtil.isNotBlank((CharSequence)headVO.getProjectName()) ? headVO.getProjectName() : "";
            SubmitAuditDTO dto = SubmitAuditDTO.builder().businessId(headVO.getId()).businessType("publishEbidding").processTitle("\u7ade\u4ef7\u53d1\u5e03\u524d\u5ba1\u6279\uff0c\u5355\u53f7\uff1a" + headVO.getEbiddingNumber() + " " + name).businessObj((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)headVO)))).build();
            WorkFlowUtil.submit((SubmitAuditDTO)dto);
            return true;
        }
        return false;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseEbiddingHeadLpVO headVO) {
        this.checkAndSetParam(headVO);
        if (this.publishAudit(headVO)) {
            return;
        }
        PurchaseEbiddingHeadLp head = new PurchaseEbiddingHeadLp();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        if (StrUtil.isBlank((CharSequence)head.getId())) {
            ((PurchaseEbiddingHeadLpMapper)this.baseMapper).insert((Object)head);
        } else {
            int count = ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)head);
            this.updatePurchaseEbiddingHead(head);
            Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            this.deleteSubTable(head.getId());
        }
        headVO.setId(head.getId());
        if (EbiddingStartWayEnum.AUTO.getValue().equals(head.getStartWay())) {
            LpEbiddingJobUtil.createStartJob(head, head.getBeginTime());
        }
        this.insertInitTable(head.getId(), headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingConfirmList());
        List<PurchaseEbiddingSupplierLp> supplierList = headVO.getPurchaseEbiddingSupplierList();
        this.handleEnquirySupplierList(head, supplierList);
        if (CollectionUtil.isNotEmpty(supplierList)) {
            this.publishEbidding(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        } else {
            this.insertData(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        }
        if (EbiddingScopeEnum.PUBLIC.getValue().equals(headVO.getEbiddingScope())) {
            String publicScope;
            String string = publicScope = head.getPublicScope() == null ? "" : head.getPublicScope();
            if (publicScope.equals(SrmPublicScopeEnum.SRM.getValue()) || publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                this.publicEbiddingService.publishNotice(head);
                if (publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                    this.publishToB2BService.publishToB2B(head, headVO.getPurchaseEbiddingItemList());
                }
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishTest(PurchaseEbiddingHeadLpVO headVO) {
        List<PurchaseEbiddingItemLp> items = headVO.getPurchaseEbiddingItemList();
        List<PurchaseEbiddingSupplierLp> suppliers = headVO.getPurchaseEbiddingSupplierList();
        List itemToElsAccounts = items.stream().map(PurchaseEbiddingItemLp::getToElsAccount).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        List supplierToElsAccounts = suppliers.stream().map(PurchaseEbiddingSupplierLp::getToElsAccount).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(itemToElsAccounts)) {
            throw new ELSBootException("\u6d4b\u8bd5\u6807\u8bf7\u5148\u4fdd\u5b58\u751f\u6210\u4f9b\u5e94\u5546\u7ade\u4ef7\u884c\u540e\u518d\u6267\u884c\u53d1\u5e03\u64cd\u4f5c");
        }
        if (items.size() != supplierToElsAccounts.size()) {
            throw new ELSBootException("\u4f9b\u5e94\u5546\u6570\u91cf\u548c\u7ade\u4ef7\u884c\u6570\u91cf\u4e0d\u76f8\u7b49, \u8bf7\u5148\u4fdd\u5b58\u5237\u65b0\u4f9b\u5e94\u5546\u7ade\u4ef7\u884c\u540e\u518d\u6267\u884c\u53d1\u5e03\u64cd\u4f5c");
        }
        if (!itemToElsAccounts.containsAll(supplierToElsAccounts)) {
            throw new ELSBootException("\u4f9b\u5e94\u5546\u5217\u8868\u548c\u7ade\u4ef7\u884c\u7684\u4f9b\u5e94\u5546\u5217\u8868\u4e0d\u4e00\u81f4, \u8bf7\u5148\u4fdd\u5b58\u5237\u65b0\u4f9b\u5e94\u5546\u7ade\u4ef7\u884c\u540e\u518d\u6267\u884c\u53d1\u5e03\u64cd\u4f5c");
        }
        items.forEach(item -> {
            if (ObjectUtil.isEmpty((Object)item.getTaxCode())) {
                throw new ELSBootException("\u4f9b\u5e94\u5546\u3010" + item.getSupplierName() + "\u3011\u7684\u7ade\u4ef7\u884c\u4e2d\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)item.getNetTotalAmount()) && item.getNetTotalAmount().compareTo(BigDecimal.ZERO) > 0) {
                throw new ELSBootException("\u4f9b\u5e94\u5546\u3010" + item.getSupplierName() + "\u3011\u7684\u7ade\u4ef7\u884c\u4e2d\u7efc\u5408\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            if (ObjectUtil.isEmpty((Object)item.getStandardPrice()) && item.getStandardPrice().compareTo(BigDecimal.ZERO) > 0) {
                throw new ELSBootException("\u4f9b\u5e94\u5546\u3010" + item.getSupplierName() + "\u3011\u7684\u7ade\u4ef7\u884c\u4e2d\u57fa\u51c6\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
        });
        this.publish(headVO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void newRoundPublish(PurchaseEbiddingHeadLpVO headVO) {
        this.checkAndSetParam(headVO);
        if (this.publishAudit(headVO)) {
            return;
        }
        PurchaseEbiddingHeadLp head = new PurchaseEbiddingHeadLp();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        if (StrUtil.isBlank((CharSequence)head.getId())) {
            ((PurchaseEbiddingHeadLpMapper)this.baseMapper).insert((Object)head);
        } else {
            int count = ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)head);
            this.updatePurchaseEbiddingHead(head);
            Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            this.deleteSubTable(head.getId());
        }
        headVO.setId(head.getId());
        this.saveNewPurchaseAttachmentList(headVO);
        if (EbiddingStartWayEnum.AUTO.getValue().equals(head.getStartWay())) {
            LpEbiddingJobUtil.createStartJob(head, head.getBeginTime());
        }
        this.insertInitTable(head.getId(), headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingConfirmList());
        List<PurchaseEbiddingSupplierLp> supplierList = headVO.getPurchaseEbiddingSupplierList();
        this.handleEnquirySupplierList(head, supplierList);
        if (CollectionUtil.isNotEmpty(supplierList)) {
            this.publishEbidding(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        } else {
            this.insertData(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        }
        if (EbiddingScopeEnum.PUBLIC.getValue().equals(headVO.getEbiddingScope())) {
            String publicScope;
            String string = publicScope = head.getPublicScope() == null ? "" : head.getPublicScope();
            if (publicScope.equals(SrmPublicScopeEnum.SRM.getValue()) || publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                this.publicEbiddingService.publishNotice(head);
                if (publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                    this.publishToB2BService.publishToB2B(head, headVO.getPurchaseEbiddingItemList());
                }
            }
        }
    }

    @Override
    public List<PurchaseContractHeadDTO> generateContract(PurchaseEbiddingHeadLpVO headVO) {
        String templateNumber = headVO.getTemplateNumber();
        String templateName = headVO.getTemplateName();
        String templateAccount = headVO.getTemplateAccount();
        Integer templateVersion = headVO.getTemplateVersion();
        String id = headVO.getId();
        PurchaseEbiddingHeadLp purchaseEbiddingHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItemLp> purchaseEbiddingItems = this.purchaseEbiddingItemService.selectByMainId(id);
        Map<String, List> collect = purchaseEbiddingItems.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toMap(PurchaseEbiddingItemLp::getToElsAccount, p -> {
            ArrayList<PurchaseEbiddingItemLp> getNameList = new ArrayList<PurchaseEbiddingItemLp>();
            getNameList.add((PurchaseEbiddingItemLp)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        if (!CollectionUtils.isEmpty(collect)) {
            Iterator iterator = collect.keySet().stream().iterator();
            ArrayList<PurchaseContractHeadDTO> headDTOS = new ArrayList<PurchaseContractHeadDTO>();
            ArrayList<PurchaseContractItemDTO> itemDTOList = new ArrayList<PurchaseContractItemDTO>();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                List purchaseEbiddingItems1 = collect.get(next);
                PurchaseContractHeadDTO purchaseContractHeadDTO = this.generateContractheadDTO(purchaseEbiddingHead, (PurchaseEbiddingItemLp)((Object)purchaseEbiddingItems1.get(0)));
                purchaseContractHeadDTO.setTemplateName(templateName);
                purchaseContractHeadDTO.setTemplateAccount(templateAccount);
                purchaseContractHeadDTO.setTemplateNumber(templateNumber);
                purchaseContractHeadDTO.setTemplateVersion("" + templateVersion);
                List<PurchaseContractItemDTO> itemDTOList1 = this.generateContractItemDTO(purchaseEbiddingHead, purchaseEbiddingItems1, purchaseContractHeadDTO.getId());
                headDTOS.add(purchaseContractHeadDTO);
                itemDTOList.addAll(itemDTOList1);
            }
            List<PurchaseContractHeadDTO> strings = this.inquiryInvokeContractService.generateContract(headDTOS, itemDTOList, null);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseEbiddingHeadLp::getGenerateContract, (Object)START_PRICE_FLAG)).eq(ParentEntity::getId, (Object)id)).update((Object)new PurchaseEbiddingHeadLp());
            return strings;
        }
        return null;
    }

    @Override
    public List<PurchaseContractHeadDTO> generateContractByHis(PurchaseEbiddingHeadLpVO headVO) {
        String templateNumber = headVO.getTemplateNumber();
        String templateName = headVO.getTemplateName();
        String templateAccount = headVO.getTemplateAccount();
        Integer templateVersion = headVO.getTemplateVersion();
        String id = headVO.getId();
        PurchaseEbiddingHeadLp purchaseEbiddingHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItemHisLp> purchaseEbiddingItems = this.purchaseEbiddingItemHisService.selectByMainId(id);
        Map<String, List> collect = purchaseEbiddingItems.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toMap(PurchaseEbiddingItemHisLp::getToElsAccount, p -> {
            ArrayList<PurchaseEbiddingItemHisLp> getNameList = new ArrayList<PurchaseEbiddingItemHisLp>();
            getNameList.add((PurchaseEbiddingItemHisLp)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        if (!CollectionUtils.isEmpty(collect)) {
            Iterator iterator = collect.keySet().stream().iterator();
            ArrayList<PurchaseContractHeadDTO> headDTOS = new ArrayList<PurchaseContractHeadDTO>();
            ArrayList<PurchaseContractItemDTO> itemDTOList = new ArrayList<PurchaseContractItemDTO>();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                List purchaseEbiddingItems1 = collect.get(next);
                PurchaseContractHeadDTO purchaseContractHeadDTO = this.generateContractheadDTOByHis(purchaseEbiddingHead, (PurchaseEbiddingItemHisLp)((Object)purchaseEbiddingItems1.get(0)));
                purchaseContractHeadDTO.setTemplateName(templateName);
                purchaseContractHeadDTO.setTemplateAccount(templateAccount);
                purchaseContractHeadDTO.setTemplateNumber(templateNumber);
                purchaseContractHeadDTO.setTemplateVersion("" + templateVersion);
                List<PurchaseContractItemDTO> itemDTOList1 = this.generateContractItemDTOByHis(purchaseEbiddingHead, purchaseEbiddingItems1, purchaseContractHeadDTO.getId());
                headDTOS.add(purchaseContractHeadDTO);
                itemDTOList.addAll(itemDTOList1);
            }
            List<PurchaseContractHeadDTO> strings = this.inquiryInvokeContractService.generateContract(headDTOS, itemDTOList, null);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseEbiddingHeadLp::getGenerateContract, (Object)START_PRICE_FLAG)).eq(ParentEntity::getId, (Object)id)).update((Object)new PurchaseEbiddingHeadLp());
            return strings;
        }
        return null;
    }

    public PurchaseContractHeadDTO generateContractheadDTO(PurchaseEbiddingHeadLp head, PurchaseEbiddingItemLp item) {
        PurchaseContractHeadDTO purchaseContractHeadDTO = new PurchaseContractHeadDTO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)purchaseContractHeadDTO);
        purchaseContractHeadDTO.setId(IdWorker.getIdStr());
        purchaseContractHeadDTO.setToElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setSupplierName(item.getSupplierName());
        purchaseContractHeadDTO.setSupplierCode(item.getSupplierCode());
        purchaseContractHeadDTO.setInvoicedElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setInvoicedErpCode(item.getSupplierCode());
        purchaseContractHeadDTO.setInvoicedName(item.getSupplierName());
        purchaseContractHeadDTO.setPerformingPartyElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setPerformingPartyName(item.getSupplierName());
        purchaseContractHeadDTO.setPerformingPartyCode(item.getSupplierCode());
        purchaseContractHeadDTO.setPayeeElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setPayeeName(item.getSupplierName());
        purchaseContractHeadDTO.setPayeeErpCode(item.getSupplierCode());
        purchaseContractHeadDTO.setDocumentId(head.getDocumentId());
        purchaseContractHeadDTO.setDocumentParentId(head.getId());
        purchaseContractHeadDTO.setContractDesc(head.getEbiddingDesc());
        purchaseContractHeadDTO.setContractName(head.getProjectName());
        purchaseContractHeadDTO.setContractName(head.getProjectName());
        purchaseContractHeadDTO.setAuditStatus(null);
        purchaseContractHeadDTO.setFlowId(null);
        purchaseContractHeadDTO.setCreateBy(null);
        purchaseContractHeadDTO.setCreateTime(null);
        purchaseContractHeadDTO.setCreateById(null);
        purchaseContractHeadDTO.setUpdateBy(null);
        purchaseContractHeadDTO.setUpdateTime(null);
        return purchaseContractHeadDTO;
    }

    public PurchaseContractHeadDTO generateContractheadDTOByHis(PurchaseEbiddingHeadLp head, PurchaseEbiddingItemHisLp item) {
        PurchaseContractHeadDTO purchaseContractHeadDTO = new PurchaseContractHeadDTO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)purchaseContractHeadDTO);
        purchaseContractHeadDTO.setId(IdWorker.getIdStr());
        purchaseContractHeadDTO.setToElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setSupplierName(item.getSupplierName());
        purchaseContractHeadDTO.setSupplierCode(item.getSupplierCode());
        purchaseContractHeadDTO.setInvoicedElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setInvoicedErpCode(item.getSupplierCode());
        purchaseContractHeadDTO.setInvoicedName(item.getSupplierName());
        purchaseContractHeadDTO.setPerformingPartyElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setPerformingPartyName(item.getSupplierName());
        purchaseContractHeadDTO.setPerformingPartyCode(item.getSupplierCode());
        purchaseContractHeadDTO.setPayeeElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setPayeeName(item.getSupplierName());
        purchaseContractHeadDTO.setPayeeErpCode(item.getSupplierCode());
        purchaseContractHeadDTO.setDocumentId(head.getDocumentId());
        purchaseContractHeadDTO.setDocumentParentId(head.getId());
        purchaseContractHeadDTO.setContractDesc(head.getEbiddingDesc());
        purchaseContractHeadDTO.setContractName(head.getProjectName());
        purchaseContractHeadDTO.setContractName(head.getProjectName());
        purchaseContractHeadDTO.setAuditStatus(null);
        purchaseContractHeadDTO.setFlowId(null);
        purchaseContractHeadDTO.setCreateBy(null);
        purchaseContractHeadDTO.setCreateTime(null);
        purchaseContractHeadDTO.setCreateById(null);
        purchaseContractHeadDTO.setUpdateBy(null);
        purchaseContractHeadDTO.setUpdateTime(null);
        return purchaseContractHeadDTO;
    }

    public List<PurchaseContractItemDTO> generateContractItemDTO(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, String id) {
        ArrayList<PurchaseContractItemDTO> itemDTOList = new ArrayList<PurchaseContractItemDTO>();
        for (PurchaseEbiddingItemLp purchaseEbiddingItem : itemList) {
            PurchaseContractItemDTO purchaseContractItemDTO = new PurchaseContractItemDTO();
            BeanUtils.copyProperties((Object)((Object)purchaseEbiddingItem), (Object)purchaseContractItemDTO);
            purchaseContractItemDTO.setHeadId(id);
            purchaseContractItemDTO.setDocumentParentId(purchaseEbiddingItem.getId());
            purchaseContractItemDTO.setQuantity(purchaseEbiddingItem.getQuotaQuantity());
            purchaseContractItemDTO.setTaxAmount(purchaseEbiddingItem.getQuotaTaxAmount());
            purchaseContractItemDTO.setNetAmount(purchaseEbiddingItem.getQuotaNetAmount());
            purchaseContractItemDTO.setId(null);
            purchaseContractItemDTO.setCreateBy(null);
            purchaseContractItemDTO.setCreateTime(null);
            purchaseContractItemDTO.setCreateById(null);
            purchaseContractItemDTO.setUpdateBy(null);
            purchaseContractItemDTO.setUpdateTime(null);
            purchaseContractItemDTO.setSourceItemId(purchaseEbiddingItem.getId());
            purchaseContractItemDTO.setSourceType("ebidding");
            purchaseContractItemDTO.setSourceId(purchaseEbiddingItem.getHeadId());
            purchaseContractItemDTO.setSourceItemNumber(purchaseEbiddingItem.getItemNumber());
            purchaseContractItemDTO.setSourceNumber(purchaseEbiddingItem.getEbiddingNumber());
            itemDTOList.add(purchaseContractItemDTO);
        }
        return itemDTOList;
    }

    public List<PurchaseContractItemDTO> generateContractItemDTOByHis(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemHisLp> itemList, String id) {
        ArrayList<PurchaseContractItemDTO> itemDTOList = new ArrayList<PurchaseContractItemDTO>();
        for (PurchaseEbiddingItemHisLp purchaseEbiddingItem : itemList) {
            PurchaseContractItemDTO purchaseContractItemDTO = new PurchaseContractItemDTO();
            BeanUtils.copyProperties((Object)((Object)purchaseEbiddingItem), (Object)purchaseContractItemDTO);
            purchaseContractItemDTO.setHeadId(id);
            purchaseContractItemDTO.setDocumentParentId(purchaseEbiddingItem.getId());
            purchaseContractItemDTO.setQuantity(purchaseEbiddingItem.getQuotaQuantity());
            purchaseContractItemDTO.setTaxAmount(purchaseEbiddingItem.getQuotaTaxAmount());
            purchaseContractItemDTO.setNetAmount(purchaseEbiddingItem.getQuotaNetAmount());
            purchaseContractItemDTO.setId(null);
            purchaseContractItemDTO.setCreateBy(null);
            purchaseContractItemDTO.setCreateTime(null);
            purchaseContractItemDTO.setCreateById(null);
            purchaseContractItemDTO.setUpdateBy(null);
            purchaseContractItemDTO.setUpdateTime(null);
            purchaseContractItemDTO.setSourceItemId(purchaseEbiddingItem.getId());
            purchaseContractItemDTO.setSourceType("ebidding");
            purchaseContractItemDTO.setSourceId(purchaseEbiddingItem.getHeadId());
            purchaseContractItemDTO.setSourceItemNumber(purchaseEbiddingItem.getItemNumber());
            purchaseContractItemDTO.setSourceNumber(purchaseEbiddingItem.getEbiddingNumber());
            itemDTOList.add(purchaseContractItemDTO);
        }
        return itemDTOList;
    }

    private void handleEnquirySupplierList(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingSupplierLp> supplierList) {
        if (CollectionUtils.isEmpty(supplierList)) {
            return;
        }
        List<String> toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplierLp::getToElsAccount).distinct().collect(Collectors.toList());
        List<SupplierMasterDataDTO> supplierMasterDataDTOS = this.inquiryInvokeSupplierRpcService.selectSupplerList(head.getElsAccount(), toElsAccountList);
        supplierList.forEach(e -> supplierMasterDataDTOS.forEach(a -> {
            if (e.getToElsAccount().equals(a.getToElsAccount())) {
                e.setNeedCoordination(a.getNeedCoordination());
            }
        }));
    }

    private void updatePurchaseEbiddingHead(PurchaseEbiddingHeadLp head) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(ParentEntity::getId, (Object)head.getId());
        updateWrapper.set(ParentEntity::getId, (Object)head.getId());
        updateWrapper.set(head.getIntervalMinute() != null, PurchaseEbiddingHeadLp::getIntervalMinute, (Object)head.getIntervalMinute());
        updateWrapper.set(head.getBeforeEndMinute() != null, PurchaseEbiddingHeadLp::getBeforeEndMinute, (Object)head.getBeforeEndMinute());
        updateWrapper.set(head.getDelayCount() != null, PurchaseEbiddingHeadLp::getDelayCount, (Object)head.getDelayCount());
        updateWrapper.set(head.getDelayMinute() != null, PurchaseEbiddingHeadLp::getDelayMinute, (Object)head.getDelayMinute());
        updateWrapper.set(head.getKeepMinute() != null, PurchaseEbiddingHeadLp::getKeepMinute, (Object)head.getKeepMinute());
        updateWrapper.set(head.getDelayRule() != null, PurchaseEbiddingHeadLp::getDelayRule, (Object)head.getDelayRule());
        updateWrapper.set(head.getEchoEndTime() != null, PurchaseEbiddingHeadLp::getEchoEndTime, (Object)head.getEchoEndTime());
        updateWrapper.set(head.getApplyEndTime() != null, PurchaseEbiddingHeadLp::getApplyEndTime, (Object)head.getApplyEndTime());
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    private Map<String, JSONObject> getReceiveParamMap2(Map<String, SaleEbiddingHeadLp> idMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(idMap)) {
            idMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", (Object)value.getId());
                object.put("templateNumber", (Object)value.getTemplateNumber());
                object.put("templateVersion", (Object)value.getTemplateVersion());
                object.put("templateAccount", (Object)value.getTemplateAccount());
                object.put("busAccount", (Object)value.getBusAccount());
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, String> idMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(idMap)) {
            idMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", value);
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    @Override
    public void insertInitTable(String headId, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingConfirmLpVO> confirmList) {
        JSONObject itemObject = new JSONObject();
        itemObject.put("relationId", (Object)headId);
        itemObject.put("businessType", (Object)"itemLp");
        itemObject.put("businessInfoJson", (Object)JSON.toJSONString(itemList));
        InitTableMqUtil.sendInitMsg(itemObject.toJSONString());
        JSONObject confirmObject = new JSONObject();
        confirmObject.put("relationId", (Object)headId);
        confirmObject.put("businessType", (Object)"confirmLP");
        confirmObject.put("businessInfoJson", (Object)JSON.toJSONString(confirmList));
        InitTableMqUtil.sendInitMsg(confirmObject.toJSONString());
    }

    private AttachmentSendDTO publishEbidding(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList, List<PurchaseAttachmentDemandDTO> demandList, List<PurchaseEbiddingConfirmLpVO> confirmList) {
        List<String> toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplierLp::getToElsAccount).distinct().collect(Collectors.toList());
        List<String> materialNumberList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).map(PurchaseEbiddingItemLp::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.inquiryInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        this.purchaseEbiddingSupplierService.publish(head, supplierList);
        List<PurchaseEbiddingItemLp> insertItemList = this.purchaseEbiddingItemService.publish(head, itemList, supplierList, relationMap);
        List<PurchaseEbiddingConfirmLp> insertConfirmList = this.purchaseEbiddingConfirmService.publish(head, confirmList, supplierList);
        Map<String, String> idMap = this.saleEbiddingHeadService.publish(head, insertItemList, supplierList, insertConfirmList);
        AttachmentSendDTO sendDTO = this.sendAttachment(head, idMap, demandList);
        Map<String, String> supplierMap = supplierList.stream().collect(Collectors.toMap(PurchaseEbiddingSupplierLp::getToElsAccount, PurchaseEbiddingSupplierLp::getSupplierName, (newVal, oldVal) -> oldVal));
        for (String toElsAccount : toElsAccountList) {
            PurchaseEbiddingMessageVO messageVO = new PurchaseEbiddingMessageVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)messageVO));
            messageVO.setToElsAccount(toElsAccount);
            messageVO.setPurchaseCompanyName(SysUtil.getLoginUser().getCompanyName());
            messageVO.setSupplierName(supplierMap.get(toElsAccount));
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(toElsAccount);
            if (START_PRICE_FLAG.equals(head.getNeedEcho())) {
                super.sendMessage(head.getElsAccount(), "ebidding", "biddingReply_publish", head.getId(), "ebiddLpBusDataServiceImpl", arrayList);
                continue;
            }
            super.sendMessage(head.getElsAccount(), "ebidding", "not_biddingReply_publish", head.getId(), "ebiddLpBusDataServiceImpl", arrayList);
        }
        return sendDTO;
    }

    private AttachmentSendDTO sendAttachment(PurchaseEbiddingHeadLp purchaseHead, Map<String, String> idMap, List<PurchaseAttachmentDemandDTO> demandList) {
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(purchaseHead.getId());
        sendVO.setElsAccount(purchaseHead.getElsAccount());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        for (String elsAccount : idMap.keySet()) {
            toSend.put(idMap.get(elsAccount), elsAccount);
        }
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendPurchaseFile(sendVO, true);
        this.invokeBaseRpcService.sendPurchaseAttachmentDemandDemand(demandList, purchaseHead.getId(), "ebidding", idMap);
        return sendVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishNewSupplier(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingSupplierLp> webSupplierList) {
        String headId = dbHead.getId();
        List hadList = this.purchaseEbiddingSupplierService.selectByMainId(headId).stream().map(PurchaseEbiddingSupplierLp::getToElsAccount).collect(Collectors.toList());
        List<PurchaseEbiddingSupplierLp> supplierList = webSupplierList.stream().filter(supplier -> !hadList.contains(supplier.getToElsAccount())).collect(Collectors.toList());
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_APiFjRdOIOhxRrWSTKmhx_fda6d18a", (String)"\u5f53\u524d\u9009\u62e9\u7684\u4f9b\u5e94\u90fd\u5df2\u7ecf\u53d1\u5e03\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03"));
        ElsInitialTableDTO itemInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "itemLp");
        List itemList = JSON.parseArray((String)itemInitInfo.getBusinessInfoJson(), PurchaseEbiddingItemLp.class);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "confirmLP");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmLpVO.class);
        dbHead.setEbiddingStatus(START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? EbiddingLpStatusEnum.WAIT_REPLY.getValue() : EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
        this.updateById((Object)dbHead);
        this.publishEbidding(dbHead, itemList, supplierList, demandList, confirmList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        for (PurchaseEbiddingSupplierLp supplier2 : supplierList) {
            purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.EBIDDING.getValue(), dbHead.getEbiddingNumber(), supplier2.getToElsAccount(), supplier2.getSupplierName());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void startBidding(String id) {
        List<PurchaseEbiddingItemLp> quoteList;
        List<String> itemIdList;
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        dbHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING.getValue());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations())) {
                dbItemList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING.getValue()));
                itemIdList = dbItemList.stream().map(ParentEntity::getId).collect(Collectors.toList());
                this.purchaseEbiddingItemService.updateBatchById(dbItemList);
                quoteList = dbItemList;
            } else {
                String itemNumber = StrUtil.isNotBlank((CharSequence)dbHead.getCurrentItemNumber()) ? dbHead.getCurrentItemNumber() : START_PRICE_FLAG;
                List<PurchaseEbiddingItemLp> updateList = dbItemList.stream().filter(item -> itemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                dbHead.setCurrentItemNumber(itemNumber);
                dbHead.setCurrentMaterialDesc(((PurchaseEbiddingItemLp)((Object)updateList.get(0))).getMaterialDesc());
                dbHead.setCurrentDelayCount(0);
                updateList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING.getValue()));
                itemIdList = updateList.stream().map(ParentEntity::getId).collect(Collectors.toList());
                PurchaseEbiddingHeadLpServiceImpl.processRemainingQuantity(dbHead, updateList);
                this.purchaseEbiddingItemService.updateBatchById(updateList);
                quoteList = updateList;
                this.saleEbiddingHeadService.processRemainingQuantity(dbHead, updateList);
            }
        } else {
            String currentMaterialDesc = EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay()) ? EbiddingWayEnum.PACKAGE.getDesc() : EbiddingWayEnum.BATCH.getDesc();
            dbHead.setCurrentMaterialDesc(currentMaterialDesc);
            dbItemList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING.getValue()));
            itemIdList = dbItemList.stream().map(ParentEntity::getId).collect(Collectors.toList());
            PurchaseEbiddingHeadLpServiceImpl.processRemainingQuantity(dbHead, dbItemList);
            this.purchaseEbiddingItemService.updateBatchById(dbItemList);
            quoteList = dbItemList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEbiddingItemLp>(Comparator.comparing(PurchaseEbiddingItemLp::getToElsAccount))), ArrayList::new));
            this.saleEbiddingHeadService.processRemainingQuantity(dbHead, dbItemList);
        }
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEbiddingHeadService.startEbidding(dbHead, itemIdList);
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            LpEbiddingJobUtil.deleteDutchQuoteJob(dbHead);
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            LpEbiddingJobUtil.createEndJob(dbHead, dbHead.getEndTime());
        } else if (START_PRICE_FLAG.equals(dbHead.getPurchaseAutoQuote())) {
            this.autoQuotePrice(dbHead, quoteList);
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
                dbHead.setBeginTime(new Date());
                dbHead.setEndTime((Date)DateUtil.offsetSecond((Date)dbHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1)));
                dbHead.setQuoteFlag(START_PRICE_FLAG);
                ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
                SaleEbiddingHeadLp saleHead2 = new SaleEbiddingHeadLp();
                saleHead2.setQuoteFlag(START_PRICE_FLAG);
                saleHead2.setBeginTime(dbHead.getBeginTime());
                saleHead2.setStartTime(dbHead.getStartTime());
                saleHead2.setEndTime(dbHead.getEndTime());
                saleHead2.setCurrentDelayCount(dbHead.getCurrentDelayCount());
                SaleEbiddingHeadLpService saleEbiddingHeadService = (SaleEbiddingHeadLpService)SpringContextUtils.getBean(SaleEbiddingHeadLpServiceImpl.class);
                saleEbiddingHeadService.update((Object)saleHead2, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbHead.getId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.BIDDING.getValue()));
                this.autoSetBindnumber(dbHead, dbItemList, quoteList);
                LpEbiddingJobUtil.createDutchQuoteJob(dbHead, dbHead.getEndTime());
            }
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getId());
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(dbHead.getId());
        List<SaleEbiddingHeadLp> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        List<PurchaseEbiddingSupplierLp> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        for (PurchaseEbiddingSupplierLp supplier : supplierList) {
            SaleEbiddingHeadLp sale = saleHeadList.stream().filter(saleHead -> saleHead.getElsAccount().equals(supplier.getToElsAccount())).findFirst().orElse(new SaleEbiddingHeadLp());
            supplier.setKeyWord(sale.getPurchaseName());
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(supplier.getToElsAccount());
            super.sendMessage(dbHead.getElsAccount(), "ebidding", "start", dbHead.getId(), "ebiddLpBusDataServiceImpl", arrayList);
        }
    }

    @Override
    public void autoSetBindnumber(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> dbItemList, List<PurchaseEbiddingItemLp> quoteList) {
        List<PurchaseEbiddingItemLp> updateList = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? quoteList : dbItemList;
        for (PurchaseEbiddingItemLp item : updateList) {
            BigDecimal bidNumber = quoteList.get(0).getBidNumber();
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ParentEntity::getId, (Object)item.getId())).set(PurchaseEbiddingItemLp::getBidNumber, (Object)bidNumber));
            SaleEbiddingItemLpService saleEbiddingItemService = (SaleEbiddingItemLpService)SpringContextUtils.getBean(SaleEbiddingItemLpServiceImpl.class);
            saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItemLp::getRelationId, (Object)item.getId())).set(SaleEbiddingItemLp::getBidNumber, (Object)bidNumber));
        }
    }

    private static void processRemainingQuantity(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> updateList) {
        block4: {
            if (!EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) break block4;
            if (!EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
                for (PurchaseEbiddingItemLp item : updateList) {
                    item.setRemainingQuantity(item.getRequireQuantity());
                }
            } else {
                for (PurchaseEbiddingItemLp item : updateList) {
                    item.setRemainingQuantity(BigDecimal.ONE);
                }
            }
        }
    }

    private Map<String, JSONObject> getReceiveParamMap(String headId) {
        List<SaleEbiddingHeadLp> dbSaleHeadList = this.saleEbiddingHeadService.getByRelationId(headId);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        for (SaleEbiddingHeadLp saleHead : dbSaleHeadList) {
            JSONObject urlParam = new JSONObject();
            urlParam.put("id", (Object)saleHead.getId());
            urlParam.put("templateNumber", (Object)saleHead.getTemplateNumber());
            urlParam.put("templateVersion", (Object)saleHead.getTemplateVersion());
            urlParam.put("templateAccount", (Object)saleHead.getTemplateAccount());
            urlParam.put("busAccount", (Object)saleHead.getBusAccount());
            receiveParamMap.put(saleHead.getElsAccount(), urlParam);
        }
        return receiveParamMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void endLogisticsBidding(String id) {
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)dbHead)), (String)"\u7ade\u4ef7\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.redis.tryGetDistributedLock(EBIDDING_END_KEY, dbHead.getId(), 3600000L)) {
            throw new ELSBootException("\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u7ed3\u675f\u7ade\u4ef7\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c");
        }
        List lineDifferenceHeads = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.nbeLineDifferenceHeadService.lambdaQuery().eq(LineDifferenceHead::getSourceType, (Object)LineSourceTypeEnum.EBIDDING_SOURCE.getValue())).eq(LineDifferenceHead::getSourceNumber, (Object)dbHead.getEbiddingNumber())).orderByAsc(LineDifferenceHead::getTotalNetAmount)).list().stream().limit(3L).toList();
        List toElsAccountList = lineDifferenceHeads.stream().map(LineDifferenceHead::getToElsAccount).collect(Collectors.toList());
        List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        dbHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING_END.getValue());
        dbHead.setEndTime(new Date());
        dbHead.setFbk4(START_PRICE_FLAG);
        dbItemList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
        this.purchaseEbiddingItemService.updateBatchById(dbItemList);
        List<String> idList = dbItemList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        this.updateById((Object)dbHead);
        this.saleEbiddingHeadService.endEbidding(dbHead, idList);
        PurchaseEbiddingHeadLpService purchaseEbiddingHeadService = (PurchaseEbiddingHeadLpService)SpringContextUtils.getBean(PurchaseEbiddingHeadLpService.class);
        if (EbiddingLpStatusEnum.BIDDING_END.getValue().equals(dbHead.getEbiddingStatus())) {
            LoginUserDTO loginUser = SysUtil.getLoginUser();
            if (ObjectUtil.isEmpty((Object)loginUser)) {
                loginUser = new LoginUserDTO();
                loginUser.setElsAccount(dbHead.getElsAccount());
                loginUser.setSubAccount("1001");
            }
            List finalToElsAccountList = toElsAccountList;
            LoginUserDTO finalLoginUser = loginUser;
            this.executor.execute(() -> {
                try {
                    LoginUserContext.setUser((LoginUserDTO)finalLoginUser);
                    TenantContext.setTenant((String)finalLoginUser.getElsAccount());
                    ((LineDifferenceItemService)SpringContextUtils.getBean(LineDifferenceItemService.class)).generateLineDifferenceItems(dbHead, dbItemList, (List<String>)finalToElsAccountList);
                }
                catch (Exception e) {
                    log.error("ebidding_end_failed:", (Throwable)e);
                    PurchaseEbiddingHeadLp updateHead = new PurchaseEbiddingHeadLp();
                    updateHead.setId(dbHead.getId());
                    updateHead.setFbk3(e.getMessage());
                    updateHead.setFbk4("0");
                    purchaseEbiddingHeadService.updateById((Object)updateHead);
                }
                finally {
                    this.redis.releaseDistributedLock(EBIDDING_END_KEY, dbHead.getId());
                    LoginUserContext.clear();
                    TenantContext.clear();
                }
            });
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void endBidding(String id, List<String> itemNumberList) {
        ArrayList<String> itemIdList = new ArrayList<String>();
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        dbHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING_END.getValue());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations())) {
                List<PurchaseEbiddingItemLp> currentItemList = dbItemList.stream().filter(item -> itemNumberList.contains(item.getItemNumber())).collect(Collectors.toList());
                currentItemList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
                List idList = currentItemList.stream().map(ParentEntity::getId).collect(Collectors.toList());
                itemIdList.addAll(idList);
                this.purchaseEbiddingItemService.updateBatchById(currentItemList);
                List biddingEndList = dbItemList.stream().filter(item -> EbiddingItemLpStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                dbHead.setEbiddingStatus(dbItemList.size() == biddingEndList.size() ? EbiddingLpStatusEnum.BIDDING_END.getValue() : EbiddingLpStatusEnum.BIDDING.getValue());
            } else {
                List<PurchaseEbiddingItemLp> currentItemList;
                String currentItemNumber = dbHead.getCurrentItemNumber();
                String nextItemNumber = String.valueOf(Integer.parseInt(currentItemNumber) + 1);
                PurchaseEbiddingItemLp nextItem = this.purchaseEbiddingItemService.selectOneByMainIdAndItemNumber(id, nextItemNumber);
                if (nextItem != null) {
                    dbHead.setCurrentItemNumber(nextItemNumber);
                    dbHead.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                    dbHead.setCurrentDelayCount(0);
                    if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
                        dbHead.setEbiddingStatus(EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
                        dbHead.setBeginTime((Date)DateUtil.offsetSecond((Date)dbHead.getEndTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getIntervalMinute(), (int)1)));
                        dbHead.setEndTime((Date)DateUtil.offsetSecond((Date)dbHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1)));
                        LpEbiddingJobUtil.createStartJob(dbHead, dbHead.getBeginTime());
                    }
                    if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
                        dbHead.setQuoteFlag("0");
                        dbHead.setEbiddingStatus(EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
                        dbHead.setBeginTime(new Date());
                        dbHead.setEndTime((Date)DateUtil.offsetSecond((Date)dbHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getIntervalMinute(), (int)1)));
                        LpEbiddingJobUtil.createStartJob(dbHead, dbHead.getEndTime());
                        LpEbiddingJobUtil.deleteDutchQuoteJob(dbHead);
                        SaleEbiddingItemHisLpService saleEbiddingItemHisService = (SaleEbiddingItemHisLpService)SpringContextUtils.getBean(SaleEbiddingItemHisLpServiceImpl.class);
                        List<SaleEbiddingHeadLp> saleEbiddingHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
                        List<String> saleHeadIdList = saleEbiddingHeadList.stream().map(ParentEntity::getId).collect(Collectors.toList());
                        List<SaleEbiddingItemHisLp> saleEbiddingItemHisList = saleEbiddingItemHisService.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
                        saleEbiddingItemHisList = saleEbiddingItemHisList.stream().filter(item -> StrUtil.isBlank((CharSequence)item.getAccept())).collect(Collectors.toList());
                        for (SaleEbiddingItemHisLp itemHis : saleEbiddingItemHisList) {
                            itemHis.setAccept("3");
                            saleEbiddingItemHisService.updateById((Object)itemHis);
                            PurchaseEbiddingItemHisLp purchaseHis = new PurchaseEbiddingItemHisLp();
                            purchaseHis.setId(itemHis.getRelationId());
                            purchaseHis.setAccept("3");
                            this.purchaseEbiddingItemHisMapper.updateById((Object)purchaseHis);
                        }
                    }
                    if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod())) {
                        dbHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING.getValue());
                        dbHead.setEndTime(new Date());
                        List<PurchaseEbiddingItemLp> nextItemList = dbItemList.stream().filter(item -> nextItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                        nextItemList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING.getValue()));
                        this.purchaseEbiddingItemService.updateBatchById(nextItemList);
                        SaleEbiddingItemLpService saleEbiddingItemService = (SaleEbiddingItemLpService)SpringContextUtils.getBean(SaleEbiddingItemLpServiceImpl.class);
                        saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItemLp::getRelationId, (Collection)nextItemList.stream().map(ParentEntity::getId).collect(Collectors.toList()))).set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING.getValue()));
                        this.autoQuotePrice(dbHead, nextItemList);
                    }
                } else {
                    dbHead.setCurrentItemNumber("");
                    dbHead.setCurrentMaterialDesc("");
                    dbHead.setBeginTime(dbHead.getBeginTime());
                    dbHead.setEndTime(dbHead.getEndTime());
                    dbHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
                    if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod())) {
                        dbHead.setEndTime(new Date());
                    }
                }
                if (CollectionUtil.isNotEmpty(currentItemList = dbItemList.stream().filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList()))) {
                    currentItemList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
                    this.purchaseEbiddingItemService.updateBatchById(currentItemList);
                    List idList = currentItemList.stream().map(ParentEntity::getId).collect(Collectors.toList());
                    itemIdList.addAll(idList);
                }
            }
        } else {
            String currentMaterialDesc = EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay()) ? EbiddingWayEnum.PACKAGE.getDesc() : EbiddingWayEnum.BATCH.getDesc();
            dbHead.setCurrentMaterialDesc(currentMaterialDesc);
            dbHead.setEndTime(new Date());
            dbItemList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.updateBatchById(dbItemList);
            List idList = dbItemList.stream().map(ParentEntity::getId).collect(Collectors.toList());
            itemIdList.addAll(idList);
        }
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEbiddingHeadService.endEbidding(dbHead, itemIdList);
        this.redis.publish("quote-price-topic", (Object)dbHead.getId());
    }

    private void autoQuotePrice(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> quoteList) {
        if (START_PRICE_FLAG.equals(dbHead.getPurchaseAutoQuote())) {
            List<SaleEbiddingHeadLp> saleList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
            List biddingList = saleList.stream().filter(sale -> EbiddingLpStatusEnum.BIDDING.getValue().equals(sale.getEbiddingStatus())).map(ParentEntity::getElsAccount).collect(Collectors.toList());
            log.info("autoQuotePrice->quoteList:{}", (Object)JSONObject.toJSONString(quoteList));
            for (PurchaseEbiddingItemLp dbItem : quoteList) {
                BigDecimal quotePrice;
                if (!biddingList.contains(dbItem.getToElsAccount())) continue;
                PurchaseEbiddingItemLp quoteItem = new PurchaseEbiddingItemLp();
                BeanUtils.copyProperties((Object)((Object)dbItem), (Object)((Object)quoteItem));
                this.purchaseEbiddingItemHisService.queryAddQuoteSite(dbHead, quoteItem);
                dbItem.setBidNumber(quoteItem.getBidNumber());
                log.info("autoQuotePrice->quoteItem:{}", (Object)JSONObject.toJSONString((Object)((Object)quoteItem)));
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
                } else {
                    BigDecimal bigDecimal = quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
                }
                if (quotePrice != null && quotePrice.compareTo(BigDecimal.ZERO) >= 0) {
                    this.quote(dbHead, dbItem, quoteItem);
                    continue;
                }
                log.error("\u7ade\u4ef7\u5355\u53f7[{}]->\u884c\u53f7[{}]\uff0c\u81ea\u52a8\u62a5\u4ef7\u5931\u8d25\uff0c\u62a5\u4ef7\u5c0f\u4e8e0", (Object)JSONObject.toJSONString((Object)((Object)quoteItem)));
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JOsuKmsuXU0_71c3596a", (String)"\u81ea\u52a8\u62a5\u4ef7\u5931\u8d25\uff0c\u62a5\u4ef7\u5c0f\u4e8e0\uff01"));
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public boolean autoQuotePricePublic(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> quoteList) {
        try {
            this.autoQuotePrice(dbHead, quoteList);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void manualStartBid(PurchaseEbiddingHeadLpVO headVO) {
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Date currentTime = new Date();
        Assert.isTrue((boolean)currentTime.after(dbHead.getBeginTime()), (String)I18nUtil.translate((String)"i18n_alert_OuvKKILuWPxOvAOuW_ecf2e58b", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u672a\u5230\uff0c\u6682\u4e0d\u80fd\u5f00\u542f\u7ade\u4ef7\uff01"));
        List<String> status = Arrays.asList(EbiddingLpStatusEnum.WAIT_REPLY.getValue(), EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjoOunodBntFqvA_7f51a7cc", (String)"\u53ea\u6709\u5f85\u7ade\u4ef7\u548c\u5f85\u5e94\u6807\u7684\u5355\u636e\u53ef\u5f00\u542f"));
        PurchaseEbiddingHeadLp update = new PurchaseEbiddingHeadLp();
        update.setId(headVO.getId());
        update.setStartTime(currentTime);
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            DateTime endTime = DateUtil.offsetSecond((Date)currentTime, (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1));
            update.setEndTime((Date)endTime);
        }
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)update);
        this.startBidding(headVO.getId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void manualEndBid(PurchaseEbiddingHeadLpVO headVO) {
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Date currentTime = new Date();
        Assert.isTrue((boolean)EbiddingLpStatusEnum.BIDDING.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_ROyWOusntFW_48f68479", (String)"\u53ea\u80fd\u7ed3\u675f\u7ade\u4ef7\u4e2d\u7684\u5355\u636e\uff01"));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            Assert.isTrue((boolean)currentTime.after(dbHead.getEndTime()), (String)I18nUtil.translate((String)"i18n_alert_OuyWKILuWxOyWOuW_5c8cb549", (String)"\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u80fd\u7ed3\u675f\u7ade\u4ef7\uff01"));
        }
        ArrayList itemNumberList = new ArrayList();
        if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            Assert.notEmpty(headVO.getPurchaseEbiddingItemList(), (String)I18nUtil.translate((String)"i18n_alert_ViFTPyWOujSL_a62fc5f7", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed3\u675f\u7ade\u4ef7\u7684\u7269\u6599"));
            headVO.getPurchaseEbiddingItemList().forEach(item -> itemNumberList.add(item.getItemNumber()));
        }
        this.endLogisticsBidding(dbHead.getId());
    }

    private Map<String, BigDecimal> getStartPriceMap(PurchaseEbiddingHeadLpVO headVO, List<PurchaseEbiddingItemLp> dbItemList) {
        HashMap<String, BigDecimal> startPriceMap = new HashMap<String, BigDecimal>(16);
        String startPriceFlag = headVO.getStartPriceFlag();
        if (START_PRICE_FLAG.equals(startPriceFlag)) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                Map<String, List<PurchaseEbiddingItemLp>> itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemLp::getItemNumber));
                for (String itemNumber : itemMap.keySet()) {
                    List itemList = itemMap.get(itemNumber).stream().filter(item -> item.getPrice() != null && item.getPrice().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
                    if (itemList.isEmpty()) continue;
                    if (LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(headVO.getEbiddingType())) {
                        BigDecimal maxPrice = itemList.stream().max(Comparator.comparing(PurchaseEbiddingItemLp::getPrice)).map(PurchaseEbiddingItemLp::getPrice).orElse(null);
                        startPriceMap.put(itemNumber, maxPrice);
                        continue;
                    }
                    BigDecimal minPrice = itemList.stream().min(Comparator.comparing(PurchaseEbiddingItemLp::getPrice)).map(PurchaseEbiddingItemLp::getPrice).orElse(null);
                    startPriceMap.put(itemNumber, minPrice);
                }
            } else {
                List itemList = dbItemList.stream().filter(item -> item.getTaxAmount() != null && item.getTaxAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
                if (!itemList.isEmpty()) {
                    if (LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(headVO.getEbiddingType())) {
                        BigDecimal maxTotalAmount = itemList.stream().max(Comparator.comparing(PurchaseEbiddingItemLp::getTotalAmount)).map(PurchaseEbiddingItemLp::getTotalAmount).orElse(null);
                        startPriceMap.put(headVO.getId(), maxTotalAmount);
                    } else {
                        BigDecimal minTotalAmount = itemList.stream().min(Comparator.comparing(PurchaseEbiddingItemLp::getTotalAmount)).map(PurchaseEbiddingItemLp::getTotalAmount).orElse(null);
                        startPriceMap.put(headVO.getId(), minTotalAmount);
                    }
                }
            }
        }
        return startPriceMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void createNewRound(PurchaseEbiddingHeadLpVO headVO) {
        String headId = headVO.getId();
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)this.getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingLpStatusEnum.BIDDING_END.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_OuyWjtFnqcIVVm_91ffe3ea", (String)"\u7ade\u4ef7\u7ed3\u675f\u7684\u5355\u636e\u624d\u53ef\u521b\u5efa\u65b0\u8f6e\u6b21"));
        String startPriceFlag = headVO.getStartPriceFlag();
        List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "itemLp");
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItemLp.class);
        Map<String, BigDecimal> startPriceMap = this.getStartPriceMap(headVO, dbItemList);
        for (PurchaseEbiddingItemLp item : initItemList) {
            if (!START_PRICE_FLAG.equals(startPriceFlag)) continue;
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                item.setStartPrice(startPriceMap.get(item.getItemNumber()));
                continue;
            }
            headVO.setStartTotalAmount(startPriceMap.get(headId));
            break;
        }
        headVO.setPurchaseEbiddingItemList(initItemList);
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "confirmLP");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmLpVO.class);
        if (!CollectionUtils.isEmpty(headVO.getPurchaseEbiddingConfirmList())) {
            headVO.getPurchaseEbiddingConfirmList().forEach(e -> {
                if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)e.getId())) {
                    confirmList.add(e);
                }
            });
        }
        headVO.setPurchaseEbiddingConfirmList(confirmList);
        List<PurchaseEbiddingSupplierLp> supplierList = headVO.getPurchaseEbiddingSupplierList();
        supplierList.forEach(supplier -> supplier.setReplyTime(null));
        headVO.setPurchaseEbiddingSupplierList(supplierList);
        headVO.setAuditStatus(START_PRICE_FLAG.equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setResultAuditStatus(START_PRICE_FLAG.equals(headVO.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setCurrentRound(headVO.getCurrentRound() + 1);
        headVO.setCurrentDelayCount(0);
        headVO.setReplyQuantity(0);
        headVO.setId(null);
        headVO.setQuoteFlag(null);
        this.newRoundPublish(headVO);
        PurchaseEbiddingHeadLp purchaseHead = new PurchaseEbiddingHeadLp();
        purchaseHead.setId(headId);
        purchaseHead.setEbiddingStatus(EbiddingLpStatusEnum.NEW_ROUND.getValue());
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)purchaseHead);
    }

    private void saveNewPurchaseAttachmentList(PurchaseEbiddingHeadLpVO headVO) {
        List<PurchaseAttachmentDTO> purchaseAttachmentList = headVO.getPurchaseAttachmentList();
        if (CollectionUtils.isEmpty(purchaseAttachmentList)) {
            return;
        }
        purchaseAttachmentList.forEach(e -> {
            e.setId(null);
            e.setSendStatus("0");
            e.setHeadId(headVO.getId());
        });
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submitPrice(PurchaseEbiddingHeadLp dbHead, PurchaseAwardOpinionLpVO opinionVO, List<PurchaseEbiddingItemLp> dbItemList) {
        ArrayList<PurchaseEbiddingItemLp> itemList = new ArrayList<PurchaseEbiddingItemLp>();
        List<PurchaseEbiddingSupplierLpVO> supplierVOList = opinionVO.getPurchaseEbiddingSupplierQuoteList();
        for (PurchaseEbiddingSupplierLpVO supplierVO : supplierVOList) {
            itemList.addAll(supplierVO.getPurchaseEbiddingItemList());
        }
        this.checkSubmitPrice(dbHead, itemList, opinionVO.getAcceptMinPrice());
        this.purchaseAwardOpinionService.save((Object)opinionVO);
        String quotaWay = dbHead.getQuotaWay();
        log.warn("submitPrice,ebiddingWay:{},flag:{},size:{}", new Object[]{dbHead.getEbiddingWay(), EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), itemList.size()});
        ArrayList<PurchaseEbiddingSupplierLp> supplierList = new ArrayList<PurchaseEbiddingSupplierLp>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItemLp item2 : itemList) {
                item2.setQuota((BigDecimal)(EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : (item2.getQuota() == null ? null : BigDecimal.ZERO)));
                item2.setItemStatus(EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingItemLpStatusEnum.BID_WIN.getValue() : EbiddingItemLpStatusEnum.UN_BID_WIN.getValue());
                log.warn("submitPrice,quota:{},requireQuantity:{},quotaWay:{}", new Object[]{item2.getQuota(), item2.getRequireQuantity(), quotaWay});
                if (item2.getRequireQuantity() == null || !EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus())) continue;
                if (QuotaWayEnum.SCALE.getValue().equals(quotaWay)) {
                    BigDecimal multiply = item2.getRequireQuantity().multiply(item2.getQuota().divide(BigDecimal.valueOf(100L), 6, 5));
                    item2.setQuotaQuantity(multiply);
                    item2.setQuotaTaxAmount(multiply.multiply(item2.getPrice()));
                    item2.setQuotaNetAmount(multiply.multiply(item2.getNetPrice()));
                } else {
                    item2.setQuotaQuantity(item2.getQuota());
                    item2.setQuotaTaxAmount(item2.getQuota().multiply(item2.getPrice()));
                    item2.setQuotaNetAmount(item2.getQuota().multiply(item2.getNetPrice()));
                }
                log.error("\u66f4\u65b0\u4e2d\u6807\u4fe1\u606f\u62c6\u5206\u91d1\u989d,\u7ade\u4ef7\u5355\u53f7:" + dbHead.getEbiddingNumber() + "\u884c\u53f7:" + item2.getItemNumber() + ",\u62c6\u5206\u6570\u91cf:" + item2.getQuotaQuantity() + ",\u542b\u7a0e\u91d1\u989d" + item2.getQuotaTaxAmount() + ",\u4e0d\u542b\u7a0e\u91d1\u989d" + item2.getQuotaNetAmount());
            }
            this.purchaseEbiddingItemService.updateBatchById(itemList);
            Map<String, String> supplierMap = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItemLp::getToElsAccount, PurchaseEbiddingItemLp::getItemStatus, (oldVal, newVal) -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
            supplierMap.forEach((key, value) -> {
                PurchaseEbiddingSupplierLp supplier = new PurchaseEbiddingSupplierLp();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount((String)key);
                supplier.setBiddingStatus((String)value);
                supplierList.add(supplier);
            });
        } else {
            for (PurchaseEbiddingItemLp item2 : itemList) {
                String itemStatus = EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingItemLpStatusEnum.BID_WIN.getValue() : EbiddingItemLpStatusEnum.UN_BID_WIN.getValue();
                BigDecimal quota = EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : null;
                item2.setQuota(quota);
                item2.setItemStatus(itemStatus);
                if (item2.getTaxAmount() != null && quota != null) {
                    BigDecimal divide = quota.divide(BigDecimal.valueOf(100L), 6, 5);
                    item2.setQuotaTaxAmount(item2.getTaxAmount().multiply(divide));
                    item2.setQuotaTaxAmount(item2.getNetAmount().multiply(divide));
                }
                PurchaseEbiddingSupplierLp supplier = new PurchaseEbiddingSupplierLp();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount(item2.getToElsAccount());
                supplier.setQuota(quota == null ? null : quota.toString());
                supplier.setBiddingStatus(itemStatus);
                supplierList.add(supplier);
            }
            this.purchaseEbiddingItemService.updateBidByHeadId(itemList);
        }
        this.purchaseEbiddingSupplierService.updateBidResultBatch(supplierList);
        if ("0".equals(dbHead.getResultAudit())) {
            this.priced(dbHead, itemList, supplierList);
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEbiddingItemLp> acceptList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.generatePriceRecord(dbHead, acceptList);
            }
        } else {
            PurchaseEbiddingHeadLpVO headVO = new PurchaseEbiddingHeadLpVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            headVO.setPurchaseEbiddingItemList(dbItemList);
            String projectName = StrUtil.isNotBlank((CharSequence)dbHead.getProjectName()) ? dbHead.getProjectName() : "";
            SubmitAuditDTO dto = SubmitAuditDTO.builder().businessId(dbHead.getId()).businessType("resultEbidding").processTitle("\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6279\uff0c\u5355\u53f7\uff1a" + dbHead.getEbiddingNumber() + " " + projectName).businessObj((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)headVO)))).build();
            WorkFlowUtil.submit((SubmitAuditDTO)dto);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submitPriceByHis(PurchaseEbiddingHeadLp dbHead, PurchaseAwardOpinionLpVO opinionVO, List<PurchaseEbiddingItemHisLp> dbItemList) {
        ArrayList<PurchaseEbiddingItemHisLp> itemList = new ArrayList<PurchaseEbiddingItemHisLp>();
        List<PurchaseEbiddingSupplierLpVO> supplierVOList = opinionVO.getPurchaseEbiddingSupplierQuoteList();
        for (PurchaseEbiddingSupplierLpVO supplierVO : supplierVOList) {
            itemList.addAll(supplierVO.getPurchaseEbiddingItemHis());
        }
        itemList.forEach(item -> item.setQuota(item.getBidNumber()));
        this.checkSubmitPriceByHis(dbHead, itemList, opinionVO.getAcceptMinPrice());
        this.purchaseAwardOpinionService.save((Object)opinionVO);
        String quotaWay = dbHead.getQuotaWay();
        log.warn("submitPrice,ebiddingWay:{},flag:{},size:{}", new Object[]{dbHead.getEbiddingWay(), EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), itemList.size()});
        ArrayList<PurchaseEbiddingSupplierLp> supplierList = new ArrayList<PurchaseEbiddingSupplierLp>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItemHisLp item2 : itemList) {
                item2.setQuota((BigDecimal)(EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : (item2.getQuota() == null ? null : BigDecimal.ZERO)));
                item2.setItemStatus(EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingItemLpStatusEnum.BID_WIN.getValue() : EbiddingItemLpStatusEnum.UN_BID_WIN.getValue());
                log.warn("submitPrice,quota:{},requireQuantity:{},quotaWay:{}", new Object[]{item2.getQuota(), item2.getRequireQuantity(), quotaWay});
                if (item2.getRequireQuantity() == null || !EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus())) continue;
                if (QuotaWayEnum.SCALE.getValue().equals(quotaWay)) {
                    BigDecimal multiply = item2.getRequireQuantity().multiply(item2.getQuota().divide(BigDecimal.valueOf(100L), 6, 5));
                    item2.setQuotaQuantity(multiply);
                    item2.setQuotaTaxAmount(multiply.multiply(item2.getPrice()));
                    item2.setQuotaNetAmount(multiply.multiply(item2.getNetPrice()));
                } else {
                    item2.setQuotaQuantity(item2.getQuota());
                    item2.setQuotaTaxAmount(item2.getQuota().multiply(item2.getPrice()));
                    item2.setQuotaNetAmount(item2.getQuota().multiply(item2.getNetPrice()));
                }
                log.error("\u66f4\u65b0\u4e2d\u6807\u4fe1\u606f\u62c6\u5206\u91d1\u989d,\u7ade\u4ef7\u5355\u53f7:" + dbHead.getEbiddingNumber() + "\u884c\u53f7:" + item2.getItemNumber() + ",\u62c6\u5206\u6570\u91cf:" + item2.getQuotaQuantity() + ",\u542b\u7a0e\u91d1\u989d" + item2.getQuotaTaxAmount() + ",\u4e0d\u542b\u7a0e\u91d1\u989d" + item2.getQuotaNetAmount());
            }
            this.purchaseEbiddingItemHisService.updateBatchById(itemList);
            Map<String, String> supplierMap = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItemHisLp::getToElsAccount, PurchaseEbiddingItemHisLp::getItemStatus, (oldVal, newVal) -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
            supplierMap.forEach((key, value) -> {
                PurchaseEbiddingSupplierLp supplier = new PurchaseEbiddingSupplierLp();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount((String)key);
                supplier.setBiddingStatus((String)value);
                supplierList.add(supplier);
            });
        } else {
            for (PurchaseEbiddingItemHisLp item2 : itemList) {
                String itemStatus = EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingItemLpStatusEnum.BID_WIN.getValue() : EbiddingItemLpStatusEnum.UN_BID_WIN.getValue();
                BigDecimal quota = EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : null;
                item2.setQuota(quota);
                item2.setItemStatus(itemStatus);
                if (item2.getTaxAmount() != null && quota != null) {
                    BigDecimal divide = quota.divide(BigDecimal.valueOf(100L), 6, 5);
                    item2.setQuotaTaxAmount(item2.getTaxAmount().multiply(divide));
                    item2.setQuotaTaxAmount(item2.getNetAmount().multiply(divide));
                }
                PurchaseEbiddingSupplierLp supplier = new PurchaseEbiddingSupplierLp();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount(item2.getToElsAccount());
                supplier.setQuota(quota == null ? null : quota.toString());
                supplier.setBiddingStatus(itemStatus);
                supplierList.add(supplier);
            }
            this.purchaseEbiddingItemHisService.updateBidByHeadId(itemList);
        }
        this.purchaseEbiddingSupplierService.updateBidResultBatch(supplierList);
        if ("0".equals(dbHead.getResultAudit())) {
            this.pricedByHis(dbHead, itemList, supplierList);
            List ids = itemList.stream().map(PurchaseEbiddingItemHisLp::getItemId).distinct().collect(Collectors.toList());
            List byIds = this.purchaseEbiddingItemService.listByIds(ids);
            this.goBackDemand(byIds, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEbiddingItemHisLp> acceptList = this.purchaseEbiddingItemHisService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.generatePriceRecordByHis(dbHead, acceptList);
            }
        } else {
            String projectName = StrUtil.isNotBlank((CharSequence)dbHead.getProjectName()) ? dbHead.getProjectName() : "";
            PurchaseEbiddingHeadLpVO headVO = new PurchaseEbiddingHeadLpVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            headVO.setPurchaseEbiddingItemHisList(dbItemList);
            SubmitAuditDTO dto = SubmitAuditDTO.builder().businessId(dbHead.getId()).businessType("resultEbidding").processTitle("\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6279\uff0c\u5355\u53f7\uff1a" + dbHead.getEbiddingNumber() + " " + projectName).businessObj((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)headVO)))).build();
            WorkFlowUtil.submit((SubmitAuditDTO)dto);
        }
    }

    private void checkSubmitPrice(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> itemList, String acceptMinPrice) {
        Map<String, List<PurchaseEbiddingItemLp>> itemMap = itemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemLp::getItemNumber));
        Map<String, String> itemStatusMap = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItemLp::getItemNumber, PurchaseEbiddingItemLp::getItemStatus, (oldVal, newVal) -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
        ArrayList<String> checkList = new ArrayList<String>();
        for (String itemNumber : itemMap.keySet()) {
            List<PurchaseEbiddingItemLp> list;
            String itemStatus = itemStatusMap.get(itemNumber);
            if (START_PRICE_FLAG.equals(acceptMinPrice) && !EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(itemStatus)) {
                list = itemMap.get(itemNumber);
                List<PurchaseEbiddingItemLp> sortList = LpEbiddingTypeEnum.getEnumByValue(dbHead.getEbiddingType()).sort(dbHead.getEbiddingWay(), list);
                if (CollectionUtil.isNotEmpty(sortList)) {
                    PurchaseEbiddingItemLp appropriate = sortList.get(0);
                    for (PurchaseEbiddingItemLp item2 : list) {
                        if (!item2.getId().equals(appropriate.getId())) continue;
                        item2.setItemStatus(EbiddingItemLpStatusEnum.BID_WIN.getValue());
                        BigDecimal quota = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay()) ? BigDecimal.valueOf(100L) : appropriate.getRequireQuantity();
                        item2.setQuota(quota);
                    }
                    continue;
                }
                list.forEach(item -> {
                    item.setItemStatus(EbiddingItemLpStatusEnum.UN_BID_WIN.getValue());
                    item.setQuota(null);
                });
                continue;
            }
            if (EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(itemStatus) || (list = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? itemMap.get(itemNumber).stream().filter(item -> item.getPrice() != null && item.getPrice().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList()) : itemMap.get(itemNumber).stream().filter(item -> item.getTotalAmount() != null && item.getTotalAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList())).isEmpty()) continue;
            checkList.add(itemNumber);
        }
        if (!checkList.isEmpty()) {
            List materialList = itemList.stream().filter(item -> checkList.contains(item.getItemNumber())).map(PurchaseEbiddingItemLp::getMaterialDesc).distinct().collect(Collectors.toList());
            String message = LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? I18nUtil.translate((String)"i18n_alert_WWWWWLlBWKQCLexusBW_39c42088", (String)"${0} \u672a\u6388\u6807\uff0c\u662f\u5426\u9ed8\u8ba4\u6700\u9ad8\u4ef7\u4e2d\u6807\uff1f", (String[])new String[]{String.join((CharSequence)"\uff0c", materialList)}) : I18nUtil.translate((String)"i18n_alert_KQCLexusBW_86c45c09", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u9ad8\u4ef7\u4e2d\u6807\uff1f")) : (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? I18nUtil.translate((String)"i18n_alert_WWWWWLlBWKQCLenusBW_1148a9fe", (String)"${0} \u672a\u6388\u6807\uff0c\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f", (String[])new String[]{String.join((CharSequence)"\uff0c", materialList)}) : I18nUtil.translate((String)"i18n_alert_KQCLenusBW_5e48e57f", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f"));
            throw new ELSAgainException(message);
        }
        List<PurchaseEbiddingItemLp> acceptList = itemList.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(acceptList)) {
            acceptList.forEach(item -> {
                Assert.isTrue((item.getPrice() != null || item.getTotalAmount() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_LsujRdXxqsB_92e6b4a1", (String)"\u672a\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546\u4e0d\u53ef\u4e2d\u6807"));
                if (QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay())) {
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sBjWFWvzlvlTfUW_88b8f618", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0"));
                } else {
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sBjWFWvzWRlTfUW_8d48d2f0", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
                }
            });
            Map<String, List<PurchaseEbiddingItemLp>> acceptMap = acceptList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemLp::getItemNumber));
            for (String itemNumber : acceptMap.keySet()) {
                List<PurchaseEbiddingItemLp> list = acceptMap.get(itemNumber);
                BigDecimal quotaTotal = list.stream().map(PurchaseEbiddingItemLp::getQuota).reduce(BigDecimal.ZERO, BigDecimal::add);
                boolean isScale = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay());
                BigDecimal quota = isScale ? BigDecimal.valueOf(100L) : list.get(0).getRequireQuantity();
                String message = isScale ? I18nUtil.translate((String)"i18n_alert_vzlvRnlTEUWWWW_ffbb0603", (String)"\u62c6\u5206\u6bd4\u4f8b\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100\uff01") : I18nUtil.translate((String)"i18n_alert_vzWRRnlTEUTVWRW_11dd4a65", (String)"\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u9700\u6c42\u6570\u91cf\uff01");
                Assert.isTrue((quotaTotal.compareTo(quota) == 0 ? 1 : 0) != 0, (String)message);
            }
        }
    }

    private void checkSubmitPriceByHis(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemHisLp> itemList, String acceptMinPrice) {
        Map<String, List<PurchaseEbiddingItemHisLp>> itemMap = itemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemHisLp::getItemNumber));
        Map<String, String> itemStatusMap = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItemHisLp::getItemNumber, PurchaseEbiddingItemHisLp::getItemStatus, (oldVal, newVal) -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
        ArrayList<String> checkList = new ArrayList<String>();
        for (String itemNumber : itemMap.keySet()) {
            List<PurchaseEbiddingItemHisLp> list;
            String itemStatus = itemStatusMap.get(itemNumber);
            if (START_PRICE_FLAG.equals(acceptMinPrice) && !EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(itemStatus)) {
                list = itemMap.get(itemNumber);
                List<PurchaseEbiddingItemHisLp> sortList = LpEbiddingTypeHisEnum.getEnumByValue(dbHead.getEbiddingType()).sort(dbHead.getEbiddingWay(), list);
                if (CollectionUtil.isNotEmpty(sortList)) {
                    PurchaseEbiddingItemHisLp appropriate = sortList.get(0);
                    for (PurchaseEbiddingItemHisLp item2 : list) {
                        if (!item2.getId().equals(appropriate.getId())) continue;
                        item2.setItemStatus(EbiddingItemLpStatusEnum.BID_WIN.getValue());
                        BigDecimal quota = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay()) ? BigDecimal.valueOf(100L) : appropriate.getRequireQuantity();
                        item2.setQuota(quota);
                    }
                    continue;
                }
                list.forEach(item -> {
                    item.setItemStatus(EbiddingItemLpStatusEnum.UN_BID_WIN.getValue());
                    item.setQuota(null);
                });
                continue;
            }
            if (EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(itemStatus) || (list = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? itemMap.get(itemNumber).stream().filter(item -> item.getPrice() != null && item.getPrice().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList()) : itemMap.get(itemNumber).stream().filter(item -> item.getTotalAmount() != null && item.getTotalAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList())).isEmpty()) continue;
            checkList.add(itemNumber);
        }
        if (!checkList.isEmpty()) {
            List materialList = itemList.stream().filter(item -> checkList.contains(item.getItemNumber())).map(PurchaseEbiddingItemHisLp::getMaterialDesc).distinct().collect(Collectors.toList());
            String message = LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? I18nUtil.translate((String)"i18n_alert_WWWWWLlBWKQCLexusBW_39c42088", (String)"${0} \u672a\u6388\u6807\uff0c\u662f\u5426\u9ed8\u8ba4\u6700\u9ad8\u4ef7\u4e2d\u6807\uff1f", (String[])new String[]{String.join((CharSequence)"\uff0c", materialList)}) : I18nUtil.translate((String)"i18n_alert_KQCLexusBW_86c45c09", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u9ad8\u4ef7\u4e2d\u6807\uff1f")) : (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? I18nUtil.translate((String)"i18n_alert_WWWWWLlBWKQCLenusBW_1148a9fe", (String)"${0} \u672a\u6388\u6807\uff0c\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f", (String[])new String[]{String.join((CharSequence)"\uff0c", materialList)}) : I18nUtil.translate((String)"i18n_alert_KQCLenusBW_5e48e57f", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f"));
            throw new ELSAgainException(message);
        }
        List<PurchaseEbiddingItemHisLp> acceptList = itemList.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(acceptList)) {
            acceptList.forEach(item -> {
                Assert.isTrue((item.getPrice() != null || item.getTotalAmount() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_LsujRdXxqsB_92e6b4a1", (String)"\u672a\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546\u4e0d\u53ef\u4e2d\u6807"));
                if (QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay())) {
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sBjWFWvzlvlTfUW_88b8f618", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0"));
                } else {
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sBjWFWvzWRlTfUW_8d48d2f0", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
                }
            });
            Map<String, List<PurchaseEbiddingItemHisLp>> acceptMap = acceptList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemHisLp::getItemNumber));
            for (String itemNumber : acceptMap.keySet()) {
                List<PurchaseEbiddingItemHisLp> list = acceptMap.get(itemNumber);
                BigDecimal quotaTotal = list.stream().map(PurchaseEbiddingItemHisLp::getQuota).reduce(BigDecimal.ZERO, BigDecimal::add);
                boolean isScale = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay());
                BigDecimal quota = isScale ? BigDecimal.valueOf(100L) : list.get(0).getRequireQuantity();
                String message = isScale ? I18nUtil.translate((String)"i18n_alert_vzlvRnlTEUWWWW_ffbb0603", (String)"\u62c6\u5206\u6bd4\u4f8b\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100\uff01") : I18nUtil.translate((String)"i18n_alert_vzWRRnlTEUTVWRW_11dd4a65", (String)"\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u9700\u6c42\u6570\u91cf\uff01");
                Assert.isTrue((quotaTotal.compareTo(quota) == 0 ? 1 : 0) != 0, (String)message);
            }
        }
    }

    @Override
    public void priced(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList) {
        block12: {
            List limit;
            List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
            Date pricedTime = new Date();
            dbItemList.forEach(item -> item.setPricedTime(pricedTime));
            this.purchaseEbiddingItemService.updateBatchById(dbItemList);
            dbHead.setEbiddingStatus(EbiddingLpStatusEnum.BID_SUCCESS.getValue());
            BigDecimal ebiddingAmount = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? itemList.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItemLp::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : ((limit = itemList.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).limit(1L).collect(Collectors.toList())).isEmpty() ? BigDecimal.ZERO : ((PurchaseEbiddingItemLp)((Object)limit.get(0))).getTotalAmount());
            dbHead.setEbiddingAmount(ebiddingAmount);
            if (dbHead.getProjectBudget() != null && dbHead.getProjectBudget().compareTo(BigDecimal.ZERO) != 0) {
                dbHead.setSavingAmount(dbHead.getProjectBudget().subtract(ebiddingAmount));
                if (BigDecimal.ZERO.compareTo(dbHead.getProjectBudget()) != 0) {
                    dbHead.setSavingRate(dbHead.getSavingAmount().divide(dbHead.getProjectBudget(), 6, 4).multiply(BigDecimal.valueOf(100L)));
                }
            }
            ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
            this.saleEbiddingHeadService.priced(dbHead, itemList, supplierList);
            if (PricingNoticeEnum.NOT.getValue().equals(dbHead.getPricingNotice())) break block12;
            ArrayList sendAccountList = new ArrayList();
            List<PurchaseEbiddingSupplierLp> dbSupplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            if (PricingNoticeEnum.WIN.getValue().equals(dbHead.getPricingNotice())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(supplier.getBiddingStatus())).map(PurchaseEbiddingSupplierLp::getToElsAccount).collect(Collectors.toList()));
            } else if (PricingNoticeEnum.ALL.getValue().equals(dbHead.getPricingNotice()) && START_PRICE_FLAG.equals(dbHead.getNeedEcho())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus())).map(PurchaseEbiddingSupplierLp::getToElsAccount).collect(Collectors.toList()));
            }
            List<PurchaseEbiddingItemLp> sendItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> sendAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
            sendItemList.forEach(item -> item.setKeyWord(SysUtil.getLoginUser().getCompanyName()));
            if (CollectionUtil.isNotEmpty(sendItemList)) {
                Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(dbHead.getId());
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    for (PurchaseEbiddingItemLp item2 : sendItemList) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(item2.getToElsAccount());
                        if (EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus())) {
                            super.sendMessage(dbHead.getElsAccount(), "ebidding", "confirm", item2.getHeadId(), "ebiddLpBusDataServiceImpl", arrayList);
                            continue;
                        }
                        super.sendMessage(dbHead.getElsAccount(), "ebidding", "refundPurchase", item2.getHeadId(), "ebiddLpBusDataServiceImpl", arrayList);
                    }
                } else {
                    sendItemList.forEach(item -> item.setPrice(item.getTotalAmount()));
                    Map packageMap = sendItemList.stream().collect(Collectors.toMap(PurchaseEbiddingItemLp::getToElsAccount, Function.identity(), (newVal, oldVal) -> {
                        String materialNumber = oldVal.getMaterialNumber();
                        oldVal.setMaterialNumber(materialNumber + "," + newVal.getMaterialNumber());
                        BigDecimal oldRequireQuantity = oldVal.getRequireQuantity() == null ? BigDecimal.ZERO : oldVal.getRequireQuantity();
                        BigDecimal newRequireQuantity = newVal.getRequireQuantity() == null ? BigDecimal.ZERO : newVal.getRequireQuantity();
                        oldVal.setRequireQuantity(oldRequireQuantity.add(newRequireQuantity));
                        return oldVal;
                    }));
                    for (PurchaseEbiddingItemLp item3 : packageMap.values()) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(item3.getToElsAccount());
                        if (EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item3.getItemStatus())) {
                            super.sendMessage(dbHead.getElsAccount(), "ebidding", "confirm", item3.getHeadId(), "ebiddLpBusDataServiceImpl", arrayList);
                            continue;
                        }
                        super.sendMessage(dbHead.getElsAccount(), "ebidding", "refundPurchase", item3.getHeadId(), "ebiddLpBusDataServiceImpl", arrayList);
                    }
                }
            }
        }
    }

    @Override
    public void pricedByHis(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemHisLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList) {
        block12: {
            List limit;
            List<PurchaseEbiddingItemHisLp> dbItemList = this.purchaseEbiddingItemHisService.queryAcceptDetail(dbHead);
            Date pricedTime = new Date();
            dbItemList.forEach(item -> item.setPricedTime(pricedTime));
            this.purchaseEbiddingItemHisService.updateBatchById(dbItemList);
            dbHead.setEbiddingStatus(EbiddingLpStatusEnum.BID_SUCCESS.getValue());
            BigDecimal ebiddingAmount = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? itemList.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItemHisLp::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : ((limit = itemList.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).limit(1L).collect(Collectors.toList())).isEmpty() ? BigDecimal.ZERO : ((PurchaseEbiddingItemHisLp)((Object)limit.get(0))).getTotalAmount());
            dbHead.setEbiddingAmount(ebiddingAmount);
            if (dbHead.getProjectBudget() != null && dbHead.getProjectBudget().compareTo(BigDecimal.ZERO) != 0) {
                dbHead.setSavingAmount(dbHead.getProjectBudget().subtract(ebiddingAmount));
                if (BigDecimal.ZERO.compareTo(dbHead.getProjectBudget()) != 0) {
                    dbHead.setSavingRate(dbHead.getSavingAmount().divide(dbHead.getProjectBudget(), 6, 4).multiply(BigDecimal.valueOf(100L)));
                }
            }
            ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
            this.saleEbiddingHeadService.pricedByHis(dbHead, itemList, supplierList);
            if (PricingNoticeEnum.NOT.getValue().equals(dbHead.getPricingNotice())) break block12;
            ArrayList sendAccountList = new ArrayList();
            List<PurchaseEbiddingSupplierLp> dbSupplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            if (PricingNoticeEnum.WIN.getValue().equals(dbHead.getPricingNotice())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(supplier.getBiddingStatus())).map(PurchaseEbiddingSupplierLp::getToElsAccount).collect(Collectors.toList()));
            } else if (PricingNoticeEnum.ALL.getValue().equals(dbHead.getPricingNotice()) && START_PRICE_FLAG.equals(dbHead.getNeedEcho())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus())).map(PurchaseEbiddingSupplierLp::getToElsAccount).collect(Collectors.toList()));
            }
            List<PurchaseEbiddingItemHisLp> sendItemList = this.purchaseEbiddingItemHisService.queryAcceptDetail(dbHead).stream().filter(item -> sendAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
            sendItemList.forEach(item -> item.setKeyWord(SysUtil.getLoginUser().getCompanyName()));
            if (CollectionUtil.isNotEmpty(sendItemList)) {
                Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(dbHead.getId());
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    for (PurchaseEbiddingItemHisLp item2 : sendItemList) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(item2.getToElsAccount());
                        if (EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus())) {
                            super.sendMessage(dbHead.getElsAccount(), "ebidding", "confirm", item2.getHeadId(), "ebiddLpBusDataServiceImpl", arrayList);
                            continue;
                        }
                        super.sendMessage(dbHead.getElsAccount(), "ebidding", "refundPurchase", item2.getHeadId(), "ebiddLpBusDataServiceImpl", arrayList);
                    }
                } else {
                    sendItemList.forEach(item -> item.setPrice(item.getTotalAmount()));
                    Map packageMap = sendItemList.stream().collect(Collectors.toMap(PurchaseEbiddingItemHisLp::getToElsAccount, Function.identity(), (newVal, oldVal) -> {
                        String materialNumber = oldVal.getMaterialNumber();
                        oldVal.setMaterialNumber(materialNumber + "," + newVal.getMaterialNumber());
                        BigDecimal oldRequireQuantity = oldVal.getRequireQuantity() == null ? BigDecimal.ZERO : oldVal.getRequireQuantity();
                        BigDecimal newRequireQuantity = newVal.getRequireQuantity() == null ? BigDecimal.ZERO : newVal.getRequireQuantity();
                        oldVal.setRequireQuantity(oldRequireQuantity.add(newRequireQuantity));
                        return oldVal;
                    }));
                    for (PurchaseEbiddingItemHisLp item3 : packageMap.values()) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(item3.getToElsAccount());
                        if (EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item3.getItemStatus())) {
                            super.sendMessage(dbHead.getElsAccount(), "ebidding", "confirm", item3.getHeadId(), "ebiddLpBusDataServiceImpl", arrayList);
                            continue;
                        }
                        super.sendMessage(dbHead.getElsAccount(), "ebidding", "refundPurchase", item3.getHeadId(), "ebiddLpBusDataServiceImpl", arrayList);
                    }
                }
            }
        }
    }

    @Override
    public void cancel(PurchaseEbiddingHeadLp dbHead) {
        dbHead.setEbiddingStatus(EbiddingLpStatusEnum.INVALID.getValue());
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
        List<PurchaseEbiddingItemLp> itemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
        this.saleEbiddingHeadService.remove((Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbHead.getId()));
        LpEbiddingJobUtil.deleteAllJob(dbHead);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        if (StrUtil.isNotBlank((CharSequence)dbHead.getEnquiryId())) {
            PurchaseEnquiryHeadLpService purchaseEnquiryHeadService = (PurchaseEnquiryHeadLpService)SpringContextUtils.getBean(PurchaseEnquiryHeadLpService.class);
            PurchaseEnquiryHeadLp updateEnquiryHead = new PurchaseEnquiryHeadLp();
            updateEnquiryHead.setId(dbHead.getEnquiryId());
            updateEnquiryHead.setEnquiryStatus(EnquiryLpStatusEnum.BARGAIN.getValue());
            purchaseEnquiryHeadService.updateById((Object)updateEnquiryHead);
        }
        this.inquiryInvokeMessageRpcService.delNotice(dbHead.getId());
        log.info("\u7ade\u4ef7\u4f5c\u5e9f\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        List<SaleEbiddingHeadLp> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        Map idMap = saleHeadList.stream().collect(Collectors.toMap(ParentEntity::getElsAccount, Function.identity()));
        List<PurchaseEbiddingSupplierLp> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        List toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplierLp::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, String> supplierMap = supplierList.stream().collect(Collectors.toMap(PurchaseEbiddingSupplierLp::getToElsAccount, PurchaseEbiddingSupplierLp::getSupplierName, (newVal, oldVal) -> oldVal));
        super.sendMessage(dbHead.getElsAccount(), "ebidding", "cancel", dbHead.getId(), "ebiddLpBusDataServiceImpl", toElsAccountList);
        log.info("\u7ade\u4ef7\u4f5c\u5e9f\u53d1\u9001\u6d88\u606f\u5b8c\u6bd5");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quote(PurchaseEbiddingHeadLp dbHead, PurchaseEbiddingItemLp dbItem, PurchaseEbiddingItemLp quoteItem) {
        this.checkQuotePrice(dbHead, dbItem, quoteItem);
        this.computeQuotePrice(dbHead, dbItem, quoteItem);
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            if (quoteItem.getBidNumber() == null || quoteItem.getBidNumber().compareTo(BigDecimal.ZERO) == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBWRxOLVSNL0_3f48889b", (String)"\u6295\u6807\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0\uff01"));
            }
            if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) && "0".equals(dbHead.getAllowModifyQuantity()) && quoteItem.getBidNumber().compareTo(dbItem.getRequireQuantity()) != 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_OutxiTcrBnWReBWRdrATVWRIR_3c58466c", (String)"\u7ade\u4ef7\u5355\u4e0d\u5141\u8bb8\u4fee\u6539\u6807\u7684\u6570\u91cf\uff0c\u6295\u6807\u6570\u91cf\u5e94\u8be5\u8ddf\u9700\u6c42\u6570\u91cf\u4e00\u81f4\uff01"));
            }
            if (START_PRICE_FLAG.equals(dbHead.getAllowModifyQuantity()) && quoteItem.getBidNumber().compareTo(dbItem.getRemainingQuantity()) > 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_OutiTcrBnWReBWRBReBbUWR_4e466e9b", (String)"\u7ade\u4ef7\u5355\u5141\u8bb8\u4fee\u6539\u6807\u7684\u6570\u91cf\uff0c\u6295\u6807\u6570\u91cf\u8d85\u8fc7\u6295\u6807\u5269\u4f59\u6570\u91cf\uff01"));
            }
        }
        List saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId()).stream().filter(head -> dbItem.getToElsAccount().equals(head.getElsAccount())).collect(Collectors.toList());
        SaleEbiddingHeadLp dbSaleHead = (SaleEbiddingHeadLp)((Object)saleHeadList.get(0));
        this.purchaseEbiddingItemHisService.save(quoteItem, dbSaleHead);
        RedisUtil redis = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        redis.publish("quote-price-topic", (Object)dbHead.getId());
    }

    private void checkQuotePrice(PurchaseEbiddingHeadLp dbHead, PurchaseEbiddingItemLp dbItem, PurchaseEbiddingItemLp quoteItem) {
        BigDecimal dbPrice;
        BigDecimal webPrice;
        BigDecimal startPrice;
        PurchaseEbiddingItemHisLp dbHisItem;
        List dbHisList = this.purchaseEbiddingItemHisService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseEbiddingItemHisLp::getItemId, (Object)dbItem.getId())).orderByDesc(PurchaseEbiddingItemHisLp::getQuoteTime));
        PurchaseEbiddingItemHisLp purchaseEbiddingItemHisLp = dbHisItem = dbHisList.isEmpty() ? new PurchaseEbiddingItemHisLp() : (PurchaseEbiddingItemHisLp)((Object)dbHisList.get(0));
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            startPrice = dbItem.getStartPrice();
            webPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            dbPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? dbHisItem.getNetPrice() : dbHisItem.getPrice();
        } else {
            startPrice = dbHead.getStartTotalAmount();
            webPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            BigDecimal bigDecimal = dbPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? dbHisItem.getNetTotalAmount() : dbHisItem.getTotalAmount();
        }
        if (startPrice != null && startPrice.compareTo(BigDecimal.ZERO) != 0 && START_PRICE_FLAG.equals(dbHead.getSetStartPrice())) {
            if (LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType())) {
                Assert.isTrue((startPrice.compareTo(webPrice) <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_idOuWsulTfUEUAAu_dc6d22a8", (String)"\u6b63\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            }
            if (LpEbiddingTypeHisEnum.REVERSE_BID.getValue().equals(dbHead.getEbiddingType())) {
                Assert.isTrue((startPrice.compareTo(webPrice) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vdOuWsulTXUEUAAu_53224de6", (String)"\u53cd\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            }
        }
        if (dbPrice != null) {
            BigDecimal changeRange;
            BigDecimal bigDecimal = changeRange = EbiddingRangeUnitEnum.PERCENT.getValue().equals(dbHead.getRangeUnit()) ? dbPrice.multiply(dbHead.getChangeRange().divide(BigDecimal.valueOf(100L), 6, 4)) : dbHead.getChangeRange();
            boolean flag = LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? webPrice.subtract(changeRange).compareTo(dbPrice) >= 0 : webPrice.add(changeRange).compareTo(dbPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_APsuxBnOuBzWVVVsuW_6e488384", (String)"\u5f53\u524d\u62a5\u4ef7\u4e0d\u7b26\u5408\u7ade\u4ef7\u5e45\u5ea6\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
        }
    }

    private void computeQuotePrice(PurchaseEbiddingHeadLp dbHead, PurchaseEbiddingItemLp dbItem, PurchaseEbiddingItemLp quoteItem) {
        BigDecimal taxRate;
        BigDecimal bigDecimal = taxRate = StrUtil.isNotBlank((CharSequence)dbItem.getTaxRate()) ? new BigDecimal(dbItem.getTaxRate()) : BigDecimal.ZERO;
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            BigDecimal requireQuantity;
            BigDecimal bigDecimal2 = requireQuantity = dbItem.getRequireQuantity() == null ? BigDecimal.ONE : dbItem.getRequireQuantity();
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType())) {
                BigDecimal price = quoteItem.getPrice();
                BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
                quoteItem.setNetPrice(netPrice);
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
            } else {
                BigDecimal netPrice = quoteItem.getNetPrice();
                BigDecimal price = netPrice.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L), 6, 4)));
                quoteItem.setPrice(price);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
            }
        } else if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType())) {
            BigDecimal totalAmount = quoteItem.getTotalAmount();
            BigDecimal netTotalAmount = totalAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
            quoteItem.setNetTotalAmount(netTotalAmount);
        } else {
            BigDecimal netTotalAmount = quoteItem.getNetTotalAmount();
            BigDecimal totalAmount = netTotalAmount.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L), 6, 4)));
            quoteItem.setTotalAmount(totalAmount);
        }
        quoteItem.setQuoteTime(new Date());
        quoteItem.setQuoteCount(dbItem.getQuoteCount() == null ? 1 : dbItem.getQuoteCount() + 1);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generatePriceRecord(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> acceptList) {
        if (CollectionUtil.isNotEmpty(acceptList) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) && !START_PRICE_FLAG.equals(dbHead.getTest())) {
            ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseEbiddingItemLp item : acceptList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                BeanUtils.copyProperties((Object)((Object)item), (Object)records);
                records.setPurchaseGroup(dbHead.getPurchaseGroup());
                records.setPurchaseOrg(dbHead.getPurchaseOrg());
                records.setPurchaseUnit(item.getPurchaseUnit());
                records.setCompany(dbHead.getCompany());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setSourceId(dbHead.getId());
                records.setSourceItemId(item.getId());
                records.setSourceType(PriceSourceTypeEnum.EBIDDING.getValue());
                records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
                records.setSourceNumber(dbHead.getEbiddingNumber());
                records.setCurrencyCode(item.getCurrency());
                records.setSourceItemNumber(item.getItemNumber());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                records.setCurrencyCode(item.getCurrency());
                recordsList.add(records);
            }
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
            ArrayList<PurchaseEbiddingItemLp> updateList = new ArrayList<PurchaseEbiddingItemLp>();
            for (PurchaseEbiddingItemLp item : acceptList) {
                PurchaseEbiddingItemLp update = new PurchaseEbiddingItemLp();
                update.setId(item.getId());
                update.setSendStatus(START_PRICE_FLAG);
                updateList.add(update);
            }
            this.purchaseEbiddingItemService.updateBatchById(updateList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generatePriceRecordByHis(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemHisLp> acceptList) {
        if (CollectionUtil.isNotEmpty(acceptList) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) && !START_PRICE_FLAG.equals(dbHead.getTest())) {
            ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseEbiddingItemHisLp item : acceptList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                BeanUtils.copyProperties((Object)((Object)item), (Object)records);
                records.setPurchaseGroup(dbHead.getPurchaseGroup());
                records.setPurchaseOrg(dbHead.getPurchaseOrg());
                records.setPurchaseUnit(item.getPurchaseUnit());
                records.setCompany(dbHead.getCompany());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setSourceId(dbHead.getId());
                records.setSourceItemId(item.getId());
                records.setSourceType(PriceSourceTypeEnum.EBIDDING.getValue());
                records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
                records.setSourceNumber(dbHead.getEbiddingNumber());
                records.setCurrencyCode(item.getCurrency());
                records.setSourceItemNumber(item.getItemNumber());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                records.setCurrencyCode(item.getCurrency());
                records.setAllowDuplicatePrice(START_PRICE_FLAG);
                records.setSupplierBidNumber(item.getBidNumber());
                recordsList.add(records);
            }
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
            ArrayList<PurchaseEbiddingItemHisLp> updateList = new ArrayList<PurchaseEbiddingItemHisLp>();
            for (PurchaseEbiddingItemHisLp item : acceptList) {
                PurchaseEbiddingItemHisLp update = new PurchaseEbiddingItemHisLp();
                update.setId(item.getId());
                update.setSendStatus(START_PRICE_FLAG);
                updateList.add(update);
            }
            this.purchaseEbiddingItemHisService.updateBatchById(updateList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void regret(PurchaseEbiddingHeadLpVO headVO) {
        String headId = headVO.getId();
        String regretFlag = headVO.getRegretFlag();
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingLpStatusEnum.BID_SUCCESS.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_IlBntFnqMB_6899e661", (String)"\u5df2\u6388\u6807\u7684\u5355\u636e\u624d\u53ef\u6094\u6807"));
        dbHead.setEbiddingStatus(EbiddingLpStatusEnum.REGRET.getValue());
        dbHead.setResultAuditStatus(START_PRICE_FLAG.equals(dbHead.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
        List<PurchaseEbiddingItemLp> itemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        itemList.forEach(item -> {
            item.setItemStatus(EbiddingItemLpStatusEnum.REGRET.getValue());
            item.setRegretFlag(regretFlag);
            item.setQuota(item.getQuota() == null ? null : BigDecimal.ZERO);
            item.setSendStatus("0");
            item.setAuditStatus(dbHead.getResultAuditStatus());
        });
        this.purchaseEbiddingItemService.updateBatchById(itemList);
        if (RegretFlagEnum.RE_SOURCE.getValue().equals(regretFlag)) {
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        } else if (RegretFlagEnum.RE_PRICED.getValue().equals(regretFlag)) {
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
        }
        this.saleEbiddingHeadService.regret(dbHead, itemList);
        String sourceNumber = dbHead.getEbiddingNumber();
        List<String> itemNumberList = itemList.stream().map(PurchaseEbiddingItemLp::getItemNumber).distinct().collect(Collectors.toList());
        this.logisticsPurchasePriceRecordsService.cancelBySourceNumber(PriceSourceTypeEnum.EBIDDING.getValue(), sourceNumber, itemNumberList);
        log.info("\u7ade\u4ef7\u6094\u6807\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        List<SaleEbiddingHeadLp> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        Map idMap = saleHeadList.stream().collect(Collectors.toMap(ParentEntity::getElsAccount, Function.identity()));
        List<PurchaseEbiddingSupplierLp> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        List toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplierLp::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, String> supplierMap = supplierList.stream().collect(Collectors.toMap(PurchaseEbiddingSupplierLp::getToElsAccount, PurchaseEbiddingSupplierLp::getSupplierName, (newVal, oldVal) -> oldVal));
        super.sendMessage(dbHead.getElsAccount(), "ebidding", "regret_" + regretFlag, dbHead.getId(), "ebiddLpBusDataServiceImpl", toElsAccountList);
        log.info("\u7ade\u4ef7\u6094\u6807\u53d1\u9001\u6d88\u606f\u5b8c\u6bd5");
    }

    private void sendMessage(PurchaseEbiddingHeadLp dbHead, String operateType) {
        List<SaleEbiddingHeadLp> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        Map<String, SaleEbiddingHeadLp> supplierMap = saleHeadList.stream().collect(Collectors.toMap(ParentEntity::getElsAccount, Function.identity()));
        Map<String, JSONObject> receiveParamMap = this.getSaleReceiveParamMap(supplierMap);
        List<PurchaseEbiddingSupplierLp> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        List toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplierLp::getToElsAccount).distinct().collect(Collectors.toList());
        super.sendMessage(dbHead.getElsAccount(), "ebidding", operateType, dbHead.getId(), "ebiddLpBusDataServiceImpl", toElsAccountList);
    }

    private Map<String, JSONObject> getSaleReceiveParamMap(Map<String, SaleEbiddingHeadLp> supplierMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(supplierMap)) {
            supplierMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", (Object)value.getId());
                object.put("templateNumber", (Object)value.getTemplateNumber());
                object.put("templateVersion", (Object)value.getTemplateVersion());
                object.put("templateAccount", (Object)value.getTemplateAccount());
                object.put("busAccount", (Object)value.getBusAccount());
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    @Override
    public void failed(PurchaseEbiddingHeadLp dbHead) {
        dbHead.setEbiddingStatus(EbiddingLpStatusEnum.BID_FAILED.getValue());
        this.updateById((Object)dbHead);
        this.saleEbiddingHeadService.failed(dbHead);
        LpEbiddingJobUtil.deleteAllJob(dbHead);
        dbHead = (PurchaseEbiddingHeadLp)((Object)this.getById((Serializable)((Object)dbHead.getId())));
        log.info("\u7ade\u4ef7\u6d41\u6807\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        List<SaleEbiddingHeadLp> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        Map idMap = saleHeadList.stream().collect(Collectors.toMap(ParentEntity::getElsAccount, Function.identity()));
        List<PurchaseEbiddingSupplierLp> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        List toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplierLp::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, String> supplierMap = supplierList.stream().collect(Collectors.toMap(PurchaseEbiddingSupplierLp::getToElsAccount, PurchaseEbiddingSupplierLp::getSupplierName, (newVal, oldVal) -> oldVal));
        super.sendMessage(dbHead.getElsAccount(), "ebidding", "failureOfBid", dbHead.getId(), "ebiddLpBusDataServiceImpl", toElsAccountList);
        log.info("\u7ade\u4ef7\u6d41\u6807\u53d1\u9001\u6d88\u606f\u5b8c\u6bd5");
    }

    private Map<String, Map<String, JSONObject>> getReceiveParamMap(List<SaleEbiddingHeadLp> dbSaleHeadList) {
        HashMap<String, Map<String, JSONObject>> result = new HashMap<String, Map<String, JSONObject>>();
        for (SaleEbiddingHeadLp saleHead : dbSaleHeadList) {
            HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
            JSONObject urlParam = new JSONObject();
            urlParam.put("id", (Object)saleHead.getId());
            urlParam.put("templateNumber", (Object)saleHead.getTemplateNumber());
            urlParam.put("templateVersion", (Object)saleHead.getTemplateVersion());
            urlParam.put("templateAccount", (Object)saleHead.getTemplateAccount());
            urlParam.put("busAccount", (Object)saleHead.getBusAccount());
            receiveParamMap.put(saleHead.getElsAccount(), urlParam);
            result.put(saleHead.getElsAccount(), receiveParamMap);
        }
        return result;
    }

    @Override
    public void pricingNotice(String headId, String pricingNotice) {
        PurchaseEbiddingHeadLp updateHead = new PurchaseEbiddingHeadLp();
        updateHead.setId(headId);
        updateHead.setPricingNotice(pricingNotice);
        this.updateById((Object)updateHead);
    }

    @Override
    public JSONObject getEbinddingDataById(String id) {
        PurchaseEbiddingHeadLpVO headVO = new PurchaseEbiddingHeadLpVO();
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        headVO.setPurchaseEbiddingItemList(dbItemList);
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
        return jsonObject;
    }

    @Override
    public JSONArray getEbinddingDataById(List<String> idList) {
        JSONArray array = new JSONArray();
        for (String id : idList) {
            array.add((Object)this.getEbinddingDataById(id));
        }
        return array;
    }

    @Override
    public void executeReview(PurchaseQualificationReview review) {
        String headId = review.getRelationId();
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)this.getById((Serializable)((Object)headId)));
        Date applyEndTime = START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? dbHead.getEchoEndTime() : dbHead.getBeginTime();
        Assert.isTrue((boolean)applyEndTime.after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_UJKIIRWxqUJ_b9732d1b", (String)"\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            return;
        }
        this.executeReview(dbHead, review);
    }

    @Override
    public void executeReview(PurchaseEbiddingHeadLp dbHead, PurchaseQualificationReview review) {
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "itemLp");
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItemLp.class);
        ArrayList supplierList = Lists.newArrayList();
        PurchaseEbiddingSupplierLp supplier = new PurchaseEbiddingSupplierLp();
        supplier.setToElsAccount(review.getToElsAccount());
        supplier.setSupplierCode(review.getSupplierCode());
        supplier.setSupplierName(review.getSupplierName());
        supplier.setNeedCoordination(review.getNeedCoordination());
        supplierList.add(supplier);
        List itemStatusList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemLpStatusEnum.NEW.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItemLp::getItemStatus).distinct().collect(Collectors.toList());
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(dbHead.getId());
        if (itemStatusList.contains(EbiddingLpStatusEnum.NEW.getValue())) {
            this.deleteSubTable(dbHead.getId());
        }
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "confirmLP");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmLpVO.class);
        dbHead.setEbiddingStatus(START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? EbiddingLpStatusEnum.WAIT_REPLY.getValue() : EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
        this.updateById((Object)dbHead);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(review.getId());
        purchaseAttachmentList.forEach(attachment -> {
            attachment.setId(null);
            attachment.setHeadId(dbHead.getId());
            attachment.setBusinessType("ebidding");
        });
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        AttachmentSendDTO sendVO = this.publishEbidding(dbHead, initItemList, supplierList, demandList, confirmList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.EBIDDING.getValue(), dbHead.getEbiddingNumber(), supplier.getToElsAccount(), supplier.getSupplierName());
        this.saveSaleAttachment(purchaseAttachmentList, sendVO);
    }

    private void saveSaleAttachment(List<PurchaseAttachmentDTO> purchaseAttachmentList, AttachmentSendDTO sendVO) {
        ArrayList saleAttachmentDTOList = new ArrayList();
        String saleHeadId = sendVO.getToSend().keySet().stream().findFirst().map(Object::toString).orElse("");
        purchaseAttachmentList.forEach(e -> {
            SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)e, (Object)saleAttachmentDTO);
            saleAttachmentDTO.setHeadId(saleHeadId);
            saleAttachmentDTO.setId(null);
            saleAttachmentDTO.setSendStatus(START_PRICE_FLAG);
            saleAttachmentDTOList.add(saleAttachmentDTO);
        });
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOList);
    }

    @Override
    public PurchaseEbiddingPrintLpVO printById(String id) {
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)this.getById((Serializable)((Object)id)));
        PurchaseEbiddingPrintLpVO printVO = new PurchaseEbiddingPrintLpVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)printVO));
        List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        String ebiddingWay = dbHead.getEbiddingWay();
        String ebiddingType = dbHead.getEbiddingType();
        dbItemList = this.rankEbiddingItemData(dbItemList, ebiddingWay, ebiddingType);
        this.processFirstQuotePrice(id, dbHead, dbItemList);
        printVO.setPurchaseEbiddingItemList(dbItemList);
        List<PurchaseEbiddingSupplierLp> dbSupplierList = this.ebiddingSupplierService.selectByMainId(id);
        printVO.setPurchaseEbiddingSupplierList(dbSupplierList);
        printVO.setPurchaseAwardOpinionList(this.purchaseAwardOpinionService.selectByMainId(id));
        if (printVO.getPurchaseAwardOpinionList().size() > 0) {
            printVO.setPricingInstructions(printVO.getPurchaseAwardOpinionList().get(0).getAwardOpinion());
        }
        if (!ObjectUtils.isEmpty((Object)printVO.getResultFlowId())) {
            // empty if block
        }
        printVO.setPurchaseEbiddingConfirmList(this.purchaseEbiddingConfirmService.selectByMainId(id));
        printVO.setPurchaseAttachmentDemandList(this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id));
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        printVO.setPurchaseAttachmentList(attachmentList);
        printVO.setSupplierCounts(dbSupplierList.size());
        return printVO;
    }

    @Override
    public void checkEnquirySameMaterial(List<PurchaseEbiddingItemLp> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        Map<String, List<PurchaseEbiddingItemLp>> groupMap = itemList.stream().collect(Collectors.groupingBy(item -> {
            String materialNumber = StrUtil.isNotBlank((CharSequence)item.getMaterialNumber()) ? item.getMaterialNumber() : "";
            String factory = StrUtil.isNotBlank((CharSequence)item.getFactory()) ? item.getFactory() : "";
            String storageLocation = StrUtil.isNotBlank((CharSequence)item.getStorageLocation()) ? item.getStorageLocation() : "";
            return materialNumber + "_" + factory + "_" + storageLocation;
        }));
        groupMap.forEach((key, values) -> {
            if (values.size() > 1) {
                List itemNumber = values.stream().map(PurchaseEbiddingItemLp::getItemNumber).collect(Collectors.toList());
                String msg = "\u884c\u53f7\uff1a${0}\uff0c\u540c\u4e00\u4e2a\u7269\u6599\u540c\u5de5\u5382\u540c\u5e93\u5b58\u5730\u70b9\uff0c\u65e0\u6cd5\u540c\u65f6\u7ade\u4ef7\uff01";
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_Ey0eImSLeRHeGMnCSheKOu_d05d927b", (String)msg, (String[])new String[]{"{" + StrUtil.join((CharSequence)"}\u3001{", itemNumber) + "}"}));
            }
        });
    }

    private void processFirstQuotePrice(String headId, PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> dbItemList) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)headId);
        wrapper.eq((Object)"quote_count", (Object)1);
        List itemHisList = this.purchaseEbiddingItemHisService.list((Wrapper)wrapper);
        if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
            Map<String, List<PurchaseEbiddingItemHisLp>> toElsAccountMap = itemHisList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount()));
            for (PurchaseEbiddingItemLp deItem : dbItemList) {
                List<PurchaseEbiddingItemHisLp> hisList = toElsAccountMap.get(deItem.getToElsAccount());
                if (hisList == null || hisList.size() <= 0) continue;
                PurchaseEbiddingItemHisLp his = hisList.get(0);
                deItem.setFirstQuotePrice(his.getNetTotalAmount());
            }
        } else {
            Map<String, List<PurchaseEbiddingItemHisLp>> toElsAccountMap = itemHisList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + ":" + o.getMaterialDesc()));
            for (PurchaseEbiddingItemLp deItem : dbItemList) {
                List<PurchaseEbiddingItemHisLp> hisList = toElsAccountMap.get(deItem.getToElsAccount() + ":" + deItem.getMaterialDesc());
                if (hisList == null || hisList.size() <= 0) continue;
                PurchaseEbiddingItemHisLp his = hisList.get(0);
                deItem.setFirstQuotePrice(his.getNetPrice());
            }
        }
    }

    private List<PurchaseEbiddingItemLp> rankEbiddingItemData(List<PurchaseEbiddingItemLp> dbItemList, String ebiddingWay, String ebiddingType) {
        if (EbiddingWayEnum.PACKAGE.getValue().equals(ebiddingWay)) {
            String itemNumber = START_PRICE_FLAG;
            List items = dbItemList.stream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
            List<PurchaseEbiddingItemLp> filterList = dbItemList.stream().filter(item -> item.getMaterialDesc().equals(((PurchaseEbiddingItemLp)((Object)((Object)items.get(0)))).getMaterialDesc())).collect(Collectors.toList());
            this.rank(filterList, ebiddingWay, ebiddingType);
            Map<String, List<PurchaseEbiddingItemLp>> filterSortMap = filterList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + "-" + o.getFactory()));
            Map<String, List<PurchaseEbiddingItemLp>> deItemMap = dbItemList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + "-" + o.getFactory()));
            for (Map.Entry<String, List<PurchaseEbiddingItemLp>> entry : deItemMap.entrySet()) {
                List<PurchaseEbiddingItemLp> filterMapItemList = filterSortMap.get(entry.getKey());
                if (filterMapItemList == null || filterMapItemList.size() <= 0) continue;
                for (PurchaseEbiddingItemLp dbMapItem : entry.getValue()) {
                    dbMapItem.setQuoteRank(filterMapItemList.get(0).getQuoteRank());
                }
            }
            for (PurchaseEbiddingItemLp deItem : dbItemList) {
                List<PurchaseEbiddingItemLp> sortList = filterSortMap.get(deItem.getToElsAccount() + "-" + deItem.getItemNumber());
                if (sortList == null || sortList.size() <= 0) continue;
                PurchaseEbiddingItemLp sortItem = sortList.get(0);
                deItem.setQuoteRank(sortItem.getQuoteRank());
            }
            dbItemList.sort(Comparator.comparing(PurchaseEbiddingItemLp::getQuoteRank, Comparator.nullsLast(Integer::compareTo)).thenComparing(PurchaseEbiddingItemLp::getItemNumber));
        } else {
            ArrayList<PurchaseEbiddingItemLp> sortItemList = new ArrayList<PurchaseEbiddingItemLp>();
            Map<String, List<PurchaseEbiddingItemLp>> itemNumberMap = dbItemList.stream().collect(Collectors.groupingBy(o -> o.getMaterialDesc()));
            for (Map.Entry<String, List<PurchaseEbiddingItemLp>> entry : itemNumberMap.entrySet()) {
                List<PurchaseEbiddingItemLp> itemList = entry.getValue();
                if (itemList == null || itemList.size() <= 0) continue;
                this.rank(itemList, ebiddingWay, ebiddingType);
                sortItemList.addAll(itemList);
            }
            Boolean flag = true;
            for (PurchaseEbiddingItemLp purchaseEbiddingItem : sortItemList) {
                if (!ObjectUtils.isEmpty((Object)purchaseEbiddingItem.getQuoteRank())) continue;
                flag = false;
                break;
            }
            if (flag.booleanValue()) {
                sortItemList.sort(Comparator.comparing(PurchaseEbiddingItemLp::getMaterialDesc, Comparator.nullsLast(String::compareTo)).thenComparing(PurchaseEbiddingItemLp::getQuoteRank));
            } else {
                sortItemList.sort(Comparator.comparing(PurchaseEbiddingItemLp::getMaterialDesc, Comparator.nullsLast(String::compareTo)));
            }
            dbItemList = sortItemList;
        }
        return dbItemList;
    }

    private void rank(List<PurchaseEbiddingItemLp> itemList, String ebiddingWay, String ebiddingType) {
        List<PurchaseEbiddingItemLp> sortList = LpEbiddingTypeEnum.getEnumByValue(ebiddingType).sort(ebiddingWay, itemList);
        block0: for (int i = 0; i < sortList.size(); ++i) {
            for (PurchaseEbiddingItemLp purchaseEbiddingItemLp : itemList) {
                if (!purchaseEbiddingItemLp.getId().equals(sortList.get(i).getId())) continue;
                int rank = i + 1;
                purchaseEbiddingItemLp.setQuoteRank(rank);
                continue block0;
            }
        }
        Map<String, List<PurchaseEbiddingItemLp>> itemMap = itemList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + "-" + o.getMaterialDesc()));
        for (Map.Entry entry : itemMap.entrySet()) {
            List itemSortList = (List)entry.getValue();
            if (itemSortList == null || itemSortList.size() <= 1) continue;
            itemSortList.sort(Comparator.comparing(PurchaseEbiddingItemLp::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
            for (int i = 1; i < itemSortList.size(); ++i) {
                PurchaseEbiddingItemLp firstItem = (PurchaseEbiddingItemLp)((Object)itemSortList.get(i - 1));
                PurchaseEbiddingItemLp secondItem = (PurchaseEbiddingItemLp)((Object)itemSortList.get(i));
                if (EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay)) {
                    if (firstItem.getPrice() == null || secondItem.getPrice() == null || firstItem.getPrice().compareTo(secondItem.getPrice()) != 0 || !firstItem.getQuoteTime().equals(secondItem.getQuoteTime())) continue;
                    secondItem.setQuoteRank(firstItem.getQuoteRank());
                    continue;
                }
                if (firstItem.getTotalAmount() == null || secondItem.getTotalAmount() == null || firstItem.getTotalAmount().compareTo(secondItem.getTotalAmount()) != 0 || !firstItem.getQuoteTime().equals(secondItem.getQuoteTime())) continue;
                secondItem.setQuoteRank(firstItem.getQuoteRank());
            }
        }
        itemList.sort(Comparator.comparing(PurchaseEbiddingItemLp::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public PurchaseEbiddingHeadLp enquiryToEbidding(PurchaseEnquiryHeadLpVO enquiryHeadVO) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)enquiryHeadVO.getId()), (String)"\u8be2\u4ef7\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)enquiryHeadVO.getTemplateNumber()), (String)"\u4e1a\u52a1\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)enquiryHeadVO.getTemplateVersion()), (String)"\u4e1a\u52a1\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)enquiryHeadVO.getTemplateName()), (String)"\u4e1a\u52a1\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)enquiryHeadVO.getTemplateAccount()), (String)"\u4e1a\u52a1\u6a21\u677f\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseEnquiryHeadLpService purchaseEnquiryHeadService = (PurchaseEnquiryHeadLpService)SpringContextUtils.getBean(PurchaseEnquiryHeadLpService.class);
        PurchaseEnquiryHeadLp dbEnquiryHead = (PurchaseEnquiryHeadLp)((Object)purchaseEnquiryHeadService.getById((Serializable)((Object)enquiryHeadVO.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)dbEnquiryHead)), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u8be2\u4ef7\u5355");
        Assert.isTrue((!EnquiryLpStatusEnum.TRANSFERRED.getValue().equals(dbEnquiryHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)"\u8be5\u8be2\u4ef7\u5355\u5df2\u8f6c\u7ade\u4ef7\u5355, \u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        Assert.isTrue((!EnquiryLpStatusEnum.PRICED.getValue().equals(dbEnquiryHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)"\u8be5\u8be2\u4ef7\u5355\u5df2\u5b9a\u4ef7, \u4e0d\u5141\u8bb8\u8f6c\u7ade\u4ef7\u5355");
        LineDifferenceHeadService lineDifferenceHeadService = (LineDifferenceHeadService)SpringContextUtils.getBean(LineDifferenceHeadService.class);
        List lineDifferenceHeads = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)lineDifferenceHeadService.lambdaQuery().eq(LineDifferenceHead::getSourceNumber, (Object)dbEnquiryHead.getEnquiryNumber())).eq(LineDifferenceHead::getSourceType, (Object)LineSourceTypeEnum.ENQUIRY_SOURCE.getValue())).orderByAsc(LineDifferenceHead::getTotalNetAmount)).list().stream().limit(8L).toList();
        Map<String, LineDifferenceHead> lineDifferenceHeadMap = lineDifferenceHeads.stream().collect(Collectors.toMap(LineDifferenceHead::getToElsAccount, d -> d, (o, n) -> o));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty(lineDifferenceHeads), (String)"\u8be5\u8be2\u4ef7\u5355\u6ca1\u6709\u5df2\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546, \u4e0d\u5141\u8bb8\u8f6c\u7ade\u4ef7\u5355");
        List<SaleEnquiryHeadLp> dbSaleEnquiryHeads = ((SaleEnquiryHeadLpService)SpringContextUtils.getBean(SaleEnquiryHeadLpService.class)).selectByMainId(dbEnquiryHead.getId());
        Map<String, SaleEnquiryHeadLp> dbSaleEnquiryHeadMap = dbSaleEnquiryHeads.stream().collect(Collectors.toMap(ParentEntity::getElsAccount, s -> s, (o, n) -> o));
        PurchaseEbiddingHeadLp ebiddingHead = new PurchaseEbiddingHeadLp();
        ebiddingHead.setTemplateNumber(enquiryHeadVO.getTemplateNumber());
        ebiddingHead.setTemplateVersion(enquiryHeadVO.getTemplateVersion());
        ebiddingHead.setTemplateName(enquiryHeadVO.getTemplateName());
        ebiddingHead.setTemplateAccount(enquiryHeadVO.getTemplateAccount());
        ebiddingHead.setElsAccount(dbEnquiryHead.getElsAccount());
        ebiddingHead.setBusAccount(dbEnquiryHead.getElsAccount());
        ebiddingHead.setCompany(dbEnquiryHead.getCompany());
        ebiddingHead.setPurchaseOrg(dbEnquiryHead.getPurchaseOrg());
        ebiddingHead.setPurchaseGroup(dbEnquiryHead.getPurchaseGroup());
        ebiddingHead.setSubjectFileHeadId(dbEnquiryHead.getSubjectFileHeadId());
        ebiddingHead.setSubjectNumber(dbEnquiryHead.getSubjectNumber());
        ebiddingHead.setSubjectName(dbEnquiryHead.getSubjectName());
        ebiddingHead.setSubjectType(dbEnquiryHead.getSubjectType());
        ebiddingHead.setSubjectYear(dbEnquiryHead.getSubjectYear());
        ebiddingHead.setTaxCode(dbEnquiryHead.getTaxCode());
        ebiddingHead.setTaxRate(dbEnquiryHead.getTaxRate());
        ebiddingHead.setSupplierTaxRate("0");
        ebiddingHead.setEffectiveDate(dbEnquiryHead.getEffectiveDate());
        ebiddingHead.setExpiryDate(dbEnquiryHead.getExpiryDate());
        ebiddingHead.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumberLp", (Object)ebiddingHead));
        SysUtil.setNullCreate((BaseEntity)ebiddingHead);
        ebiddingHead.setEbiddingStatus(EbiddingLpStatusEnum.NEW.getValue());
        ebiddingHead.setResultAuditStatus(START_PRICE_FLAG.equals(ebiddingHead.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ebiddingHead.setAuditStatus(START_PRICE_FLAG.equals(ebiddingHead.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ebiddingHead.setDeleted(CommonConstant.DEL_FLAG_0);
        ebiddingHead.setCurrentRound(ebiddingHead.getCurrentRound() == null ? 1 : ebiddingHead.getCurrentRound());
        ebiddingHead.setQuoteFlag(null);
        ebiddingHead.setInviteQuantity(null);
        ebiddingHead.setReplyQuantity(null);
        ebiddingHead.setEbiddingType(LpEbiddingTypeHisEnum.REVERSE_BID.getValue());
        ebiddingHead.setEbiddingMethod(EbiddingMethodEnum.BRITISH.getValue());
        ebiddingHead.setEbiddingWay(EbiddingWayEnum.PACKAGE.getValue());
        ebiddingHead.setRangeUnit(EbiddingRangeUnitEnum.PERCENT.getValue());
        ebiddingHead.setEbiddingScope(EbiddingScopeEnum.INVITE.getValue());
        ebiddingHead.setChangeRange(new BigDecimal("0.5"));
        ebiddingHead.setCurrency("CNY");
        ebiddingHead.setIntervalMinute(BigDecimal.ZERO);
        ebiddingHead.setEnquiryId(dbEnquiryHead.getId());
        ebiddingHead.setEnquiryNumber(dbEnquiryHead.getEnquiryNumber());
        super.setHeadDefaultValue((ParentEntity)ebiddingHead);
        ArrayList<PurchaseEbiddingSupplierLp> ebiddingSuppliers = new ArrayList<PurchaseEbiddingSupplierLp>(lineDifferenceHeads.size());
        for (int i = 0; i < lineDifferenceHeads.size(); ++i) {
            LineDifferenceHead lineDifferenceHead = (LineDifferenceHead)((Object)lineDifferenceHeads.get(i));
            PurchaseEbiddingSupplierLp ebiddingSupplier = new PurchaseEbiddingSupplierLp();
            SupplierMasterDataDTO supplierMasterDataDTO = this.inquiryInvokeSupplierRpcService.getByAccount(lineDifferenceHead.getElsAccount(), lineDifferenceHead.getToElsAccount());
            if (supplierMasterDataDTO != null && !StrUtil.isNotBlank((CharSequence)supplierMasterDataDTO.getSupplierName())) {
                ebiddingSupplier.setSupplierName(supplierMasterDataDTO.getSupplierName());
            } else {
                ebiddingSupplier.setSupplierName(lineDifferenceHead.getSupplierName());
            }
            ebiddingSupplier.setItemNumber(String.valueOf(i + 1));
            ebiddingSupplier.setElsAccount(lineDifferenceHead.getElsAccount());
            ebiddingSupplier.setToElsAccount(lineDifferenceHead.getToElsAccount());
            ebiddingSupplier.setSupplierCode(lineDifferenceHead.getSupplierCode());
            ebiddingSupplier.setBiddingStatus(EbiddingItemLpStatusEnum.NEW.getValue());
            ebiddingSuppliers.add(ebiddingSupplier);
        }
        ebiddingHead.setParticipateQuantity(ebiddingSuppliers.size());
        ((PurchaseEbiddingHeadLpMapper)this.baseMapper).insert((Object)ebiddingHead);
        ArrayList<PurchaseEbiddingItemLp> ebiddingItems = new ArrayList<PurchaseEbiddingItemLp>();
        int itemNumber = 1;
        for (PurchaseEbiddingSupplierLp supplier : ebiddingSuppliers) {
            PurchaseEbiddingItemLp ebiddingItem = new PurchaseEbiddingItemLp();
            ebiddingItem.setItemNumber(String.valueOf(itemNumber++));
            ebiddingItem.setItemStatus(EbiddingItemLpStatusEnum.NEW.getValue());
            ebiddingItem.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            ebiddingItem.setSendStatus("0");
            ebiddingItem.setSubjectFileHeadId(dbEnquiryHead.getSubjectFileHeadId());
            ebiddingItem.setSubjectNumber(dbEnquiryHead.getSubjectNumber());
            ebiddingItem.setSubjectName(dbEnquiryHead.getSubjectName());
            ebiddingItem.setSubjectYear(dbEnquiryHead.getSubjectYear());
            ebiddingItem.setSubjectType(dbEnquiryHead.getSubjectType());
            ebiddingItem.setEffectiveDate(dbEnquiryHead.getEffectiveDate());
            ebiddingItem.setExpiryDate(dbEnquiryHead.getExpiryDate());
            ebiddingItem.setSourceType("enquiry");
            ebiddingItem.setSourceNumber(dbEnquiryHead.getEnquiryNumber());
            ebiddingItem.setSourceId(dbEnquiryHead.getId());
            ebiddingItem.setCurrency("CNY");
            SysUtil.setSysParam((BaseEntity)ebiddingItem, (BaseEntity)ebiddingHead);
            ebiddingItem.setHeadId(ebiddingHead.getId());
            ebiddingItem.setEbiddingNumber(ebiddingHead.getEbiddingNumber());
            ebiddingItem.setToElsAccount(supplier.getToElsAccount());
            ebiddingItem.setSupplierCode(supplier.getSupplierCode());
            ebiddingItem.setSupplierName(supplier.getSupplierName());
            ebiddingItem.setItemStatus(EbiddingItemLpStatusEnum.NEW.getValue());
            ebiddingItem.setCurrentRound(ebiddingHead.getCurrentRound());
            if (CollUtil.isNotEmpty(lineDifferenceHeadMap) && lineDifferenceHeadMap.containsKey(supplier.getToElsAccount())) {
                ebiddingItem.setNetTotalAmount(lineDifferenceHeadMap.get(supplier.getToElsAccount()).getTotalNetAmount());
                ebiddingItem.setStandardPrice(lineDifferenceHeadMap.get(supplier.getToElsAccount()).getTotalNetAmount());
            }
            if (CollUtil.isNotEmpty(dbSaleEnquiryHeadMap) && dbSaleEnquiryHeadMap.containsKey(supplier.getToElsAccount())) {
                ebiddingItem.setTaxCode(dbSaleEnquiryHeadMap.get(supplier.getToElsAccount()).getTaxCode());
                ebiddingItem.setTaxRate(dbSaleEnquiryHeadMap.get(supplier.getToElsAccount()).getTaxRate());
            }
            ebiddingItems.add(ebiddingItem);
        }
        if (StrUtil.isNotBlank((CharSequence)ebiddingHead.getDocumentId())) {
            this.invokeBaseRpcService.updateIntegratedDocumentMain("ebiddingHeadId", ebiddingHead.getDocumentId(), ebiddingHead.getDocumentParentId(), ebiddingHead.getId());
        }
        if (CollectionUtil.isNotEmpty(ebiddingItems)) {
            for (PurchaseEbiddingItemLp item : ebiddingItems) {
                item.setId(IdWorker.getIdStr());
                item.setHeadId(ebiddingHead.getId());
                item.setDocumentId(ebiddingHead.getDocumentId());
                item.setEbiddingNumber(ebiddingHead.getEbiddingNumber());
                item.setItemStatus(EbiddingItemLpStatusEnum.NEW.getValue());
                item.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                item.setSendStatus("0");
                item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)ebiddingHead);
            }
            this.purchaseEbiddingItemService.saveBatch(ebiddingItems, 2000);
        }
        this.purchaseEbiddingSupplierService.addBatch(ebiddingHead, ebiddingSuppliers);
        this.sendLink(ebiddingHead, ebiddingItems);
        dbEnquiryHead.setEnquiryStatus(EnquiryLpStatusEnum.TRANSFERRED.getValue());
        purchaseEnquiryHeadService.updateById((Object)dbEnquiryHead);
        return ebiddingHead;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void overviewSubmitPrice(PurchaseOverviewSubmitPriceVO submitPriceVO) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)submitPriceVO.getEnquiryNumber()), (String)"\u9700\u8981\u5b9a\u6807\u7684\u7ade\u4ef7\u5355\u5bf9\u5e94\u7684\u8be2\u4ef7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)submitPriceVO.getToElsAccount()), (String)"\u5b9a\u6807\u9009\u62e9\u7684\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseEnquiryHeadLpService purchaseEnquiryHeadService = (PurchaseEnquiryHeadLpService)SpringContextUtils.getBean(PurchaseEnquiryHeadLpService.class);
        PurchaseEnquiryHeadLp purchaseEnquiryHead = (PurchaseEnquiryHeadLp)((Object)((LambdaQueryChainWrapper)purchaseEnquiryHeadService.lambdaQuery().eq(PurchaseEnquiryHeadLp::getEnquiryNumber, (Object)submitPriceVO.getEnquiryNumber())).one());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseEnquiryHead)), (String)("\u627e\u4e0d\u5230\u5355\u53f7\u4e3a[" + submitPriceVO.getEnquiryNumber() + "]\u7684\u8be2\u4ef7\u5355"));
        List dbHeads = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PurchaseEbiddingHeadLp::getEnquiryNumber, (Object)purchaseEnquiryHead.getEnquiryNumber())).eq(PurchaseEbiddingHeadLp::getEnquiryId, (Object)purchaseEnquiryHead.getId())).in(PurchaseEbiddingHeadLp::getEbiddingStatus, Arrays.asList(EbiddingLpStatusEnum.BID_SUCCESS.getValue(), EbiddingLpStatusEnum.BIDDING_END.getValue(), EbiddingLpStatusEnum.REGRET.getValue()))).list();
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)dbHeads), (String)("\u627e\u4e0d\u5230\u6765\u6e90\u8be2\u4ef7\u5355\u53f7\u4e3a[" + purchaseEnquiryHead.getEnquiryNumber() + "]\u7684\u7ade\u4ef7\u5355"));
        Assert.isTrue((dbHeads.size() == 1 ? 1 : 0) != 0, (String)("\u5b58\u5728\u591a\u4e2a\u7ade\u4ef7\u7ed3\u675f\u4e14\u6765\u6e90\u8be2\u4ef7\u5355\u53f7\u4e3a[" + purchaseEnquiryHead.getEnquiryNumber() + "]\u7684\u7ade\u4ef7\u5355, \u8bf7\u6838\u67e5"));
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)dbHeads.get(0));
        List<String> status = Arrays.asList(EbiddingLpStatusEnum.BID_SUCCESS.getValue(), EbiddingLpStatusEnum.BIDDING_END.getValue(), EbiddingLpStatusEnum.REGRET.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)"\u53ea\u6709\u5df2\u6388\u6807\u6216\u7ade\u4ef7\u7ed3\u675f\u6216\u5df2\u6094\u6807\u7684\u5355\u636e\u624d\u53ef\u5b9a\u4ef7");
        Assert.isTrue((!AuditStatusEnum.AUDIT_DOING.getValue().equals(dbHead.getResultAuditStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UzsntFxqtk_19b34519", (String)"\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u4e0d\u53ef\u64cd\u4f5c"));
        List<PurchaseEbiddingItemLp> dbItems = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
        PurchaseEbiddingItemLp bidWinDbItem = dbItems.stream().filter(p -> submitPriceVO.getToElsAccount().equals(p.getToElsAccount())).findFirst().orElseThrow(() -> new ELSBootException("\u7ade\u4ef7\u5355[" + dbHead.getEbiddingNumber() + "]\u4e2d\u627e\u4e0d\u5230\u4e2d\u6807\u4f9b\u5e94\u5546[" + submitPriceVO.getToElsAccount() + "]\u7684\u7ade\u4ef7\u884c"));
        bidWinDbItem.setItemStatus(EbiddingItemLpStatusEnum.BID_WIN.getValue());
        if (EbiddingLpStatusEnum.REGRET.getValue().equals(dbHead.getEbiddingStatus())) {
            Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(bidWinDbItem.getRegretFlag()), (String)I18nUtil.translate((String)"i18n_alert_MBAcLVVIujtFnqtk_d961a5f7", (String)"\u6094\u6807\u7c7b\u578b\u4e3a\u91cd\u65b0\u5b9a\u4ef7\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
        }
        ArrayList<PurchaseEbiddingSupplierLp> supplierList = new ArrayList<PurchaseEbiddingSupplierLp>();
        for (PurchaseEbiddingItemLp dbItem : dbItems) {
            String itemStatus = EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(dbItem.getItemStatus()) ? EbiddingItemLpStatusEnum.BID_WIN.getValue() : EbiddingItemLpStatusEnum.UN_BID_WIN.getValue();
            dbItem.setItemStatus(itemStatus);
            PurchaseEbiddingSupplierLp supplier = new PurchaseEbiddingSupplierLp();
            supplier.setHeadId(dbHead.getId());
            supplier.setToElsAccount(dbItem.getToElsAccount());
            supplier.setBiddingStatus(itemStatus);
            supplierList.add(supplier);
        }
        this.purchaseEbiddingItemService.updateBidByHeadId(dbItems);
        this.purchaseEbiddingSupplierService.updateBidResultBatch(supplierList);
        this.overviewPrice(dbHead, dbItems, supplierList);
        if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
            List acceptList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).filter(item -> submitPriceVO.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            this.generateLogisticsPriceRecord(dbHead, (PurchaseEbiddingItemLp)((Object)acceptList.get(0)));
        }
        PurchaseEnquiryHeadLp enquiryHead = new PurchaseEnquiryHeadLp();
        enquiryHead.setId(bidWinDbItem.getSourceId());
        enquiryHead.setEnquiryStatus(EnquiryLpStatusEnum.PRICED.getValue());
        purchaseEnquiryHeadService.updateById((Object)enquiryHead);
        List<SubjectFileHead> subjectFileHeads = this.subjectFileHeadService.selectBySubjectNumber(purchaseEnquiryHead.getSubjectNumber(), purchaseEnquiryHead.getSubjectYear());
        for (SubjectFileHead subjectFileHead : subjectFileHeads) {
            subjectFileHead.setStatus("3");
            this.subjectFileHeadService.updateById((Object)subjectFileHead);
        }
    }

    public void overviewPrice(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> items, List<PurchaseEbiddingSupplierLp> suppliers) {
        List<PurchaseEbiddingItemLp> dbItems = this.purchaseEbiddingItemService.selectByMainId(head.getId());
        Date pricedTime = new Date();
        dbItems.forEach(item -> item.setPricedTime(pricedTime));
        this.purchaseEbiddingItemService.updateBatchById(dbItems);
        head.setEbiddingStatus(EbiddingLpStatusEnum.BID_SUCCESS.getValue());
        List limit = items.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).limit(1L).collect(Collectors.toList());
        BigDecimal ebiddingAmount = limit.isEmpty() ? BigDecimal.ZERO : ((PurchaseEbiddingItemLp)((Object)limit.get(0))).getTotalAmount();
        head.setEbiddingAmount(ebiddingAmount);
        if (head.getProjectBudget() != null && head.getProjectBudget().compareTo(BigDecimal.ZERO) != 0) {
            head.setSavingAmount(head.getProjectBudget().subtract(ebiddingAmount));
            if (BigDecimal.ZERO.compareTo(head.getProjectBudget()) != 0) {
                head.setSavingRate(head.getSavingAmount().divide(head.getProjectBudget(), 6, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)));
            }
        }
        this.updateById((Object)head);
        this.saleEbiddingHeadService.priced(head, items, suppliers);
        if (!PricingNoticeEnum.NOT.getValue().equals(head.getPricingNotice())) {
            ArrayList sendAccountList = new ArrayList();
            List<PurchaseEbiddingSupplierLp> dbSupplierList = this.purchaseEbiddingSupplierService.selectByMainId(head.getId());
            if (PricingNoticeEnum.WIN.getValue().equals(head.getPricingNotice())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(supplier.getBiddingStatus())).map(PurchaseEbiddingSupplierLp::getToElsAccount).collect(Collectors.toList()));
            } else if (PricingNoticeEnum.ALL.getValue().equals(head.getPricingNotice()) && START_PRICE_FLAG.equals(head.getNeedEcho())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus())).map(PurchaseEbiddingSupplierLp::getToElsAccount).collect(Collectors.toList()));
            }
            List<PurchaseEbiddingItemLp> sendItemList = this.purchaseEbiddingItemService.selectByMainId(head.getId()).stream().filter(item -> sendAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
            sendItemList.forEach(item -> item.setKeyWord(SysUtil.getLoginUser().getCompanyName()));
            if (CollUtil.isNotEmpty(sendItemList)) {
                Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(head.getId());
                sendItemList.forEach(item -> item.setPrice(item.getTotalAmount()));
                Map packageMap = sendItemList.stream().collect(Collectors.toMap(PurchaseEbiddingItemLp::getToElsAccount, Function.identity(), (o, n) -> {
                    String sectionName = o.getSectionName();
                    o.setSectionName(sectionName + "," + n.getSectionName());
                    return o;
                }));
                for (PurchaseEbiddingItemLp item2 : packageMap.values()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(item2.getToElsAccount());
                    if (EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus())) {
                        super.sendMessage(head.getElsAccount(), "ebidding", "confirm", item2.getHeadId(), "ebiddLpBusDataServiceImpl", arrayList);
                        continue;
                    }
                    super.sendMessage(head.getElsAccount(), "ebidding", "confirm", item2.getHeadId(), "ebiddLpBusDataServiceImpl", arrayList);
                }
            }
        }
    }

    public void checkStatus(LogisticsPurchasePriceRecords record) {
        DateTime date = DateUtil.date();
        if (null != record.getEffectiveDate() && record.getEffectiveDate().before((Date)date)) {
            record.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
        }
        DateTime toDay = DateUtil.parseDate((CharSequence)DateUtil.today());
        if (null != record.getExpiryDate() && record.getExpiryDate().before((Date)toDay)) {
            record.setRecordStatus(PriceStatusEnum.INVALID.getValue());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void generateLogisticsPriceRecord(PurchaseEbiddingHeadLp dbHead, PurchaseEbiddingItemLp acceptItem) {
        if (ObjectUtil.isEmpty((Object)((Object)acceptItem)) && START_PRICE_FLAG.equals(dbHead.getTest())) {
            return;
        }
        if (!EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(acceptItem.getItemStatus())) {
            return;
        }
        LineDifferenceItemService lineDifferenceItemService = (LineDifferenceItemService)SpringContextUtils.getBean(LineDifferenceItemService.class);
        List lineDifferenceItems = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)lineDifferenceItemService.lambdaQuery().eq(LineDifferenceItem::getSourceNumber, (Object)dbHead.getEnquiryNumber())).eq(LineDifferenceItem::getSourceType, (Object)LineSourceTypeEnum.IMPORT_SOURCE.getValue())).eq(LineDifferenceItem::getToElsAccount, (Object)acceptItem.getToElsAccount())).list();
        ArrayList<LogisticsPurchasePriceRecords> recordsList = new ArrayList<LogisticsPurchasePriceRecords>();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("lpPriceRecords");
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)templateList), (String)"\u8bf7\u5148\u8bbe\u7f6e\u7269\u6d41\u4ef7\u683c\u4e3b\u6570\u636e\u6a21\u677f");
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        for (LineDifferenceItem lineItem : lineDifferenceItems) {
            LogisticsPurchasePriceRecords records = new LogisticsPurchasePriceRecords();
            BeanUtils.copyProperties((Object)((Object)lineItem), (Object)((Object)records));
            records.setId(null);
            records.setInfoRecordNumber(this.invokeBaseRpcService.getNextCode("srmPriceNumberLP", (Object)records));
            records.setTaxCode(acceptItem.getTaxCode());
            records.setTaxRate(acceptItem.getTaxRate());
            records.setPurchaseGroup(dbHead.getPurchaseGroup());
            records.setPurchaseOrg(dbHead.getPurchaseOrg());
            records.setPurchaseUnit(acceptItem.getPurchaseUnit());
            records.setCompany(dbHead.getCompany());
            records.setSourceId(dbHead.getId());
            records.setSourceItemId(acceptItem.getId());
            records.setSourceType(PriceSourceTypeEnum.EBIDDING.getValue());
            records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
            records.setSourceNumber(dbHead.getEbiddingNumber());
            records.setSourceItemNumber(acceptItem.getItemNumber());
            records.setCurrencyCode(acceptItem.getCurrency());
            records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
            records.setEffectiveDate(acceptItem.getEffectiveDate());
            records.setExpiryDate(acceptItem.getExpiryDate());
            records.setTransportationType(acceptItem.getSubjectType());
            records.setAddressStartNumber(lineItem.getStartNumber());
            records.setAddressArriveNumber(lineItem.getArriveNumber());
            records.setEnquiryItemNumber(lineItem.getEnquiryItemNumber());
            records.setEnquiryNumber(lineItem.getEnquiryNumber());
            records.setSubjectName(dbHead.getSubjectName());
            records.setSubjectNumber(dbHead.getSubjectNumber());
            records.setSubjectType(dbHead.getSubjectType());
            records.setSubjectFileHeadId(dbHead.getSubjectFileHeadId());
            records.setSubjectYear(dbHead.getSubjectYear());
            records.setCreateTime(new Date());
            records.setCreateBy(loginUser.getSubAccount());
            records.setCreateById(loginUser.getId());
            records.setUpdateBy(loginUser.getSubAccount());
            records.setUpdateById(loginUser.getId());
            records.setUpdateTime(new Date());
            records.setId(null);
            records.setRecordType(CharSequenceUtil.emptyToDefault((CharSequence)records.getRecordType(), (String)PriceRecordTypeEnum.STANDARD.getValue()));
            records.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            records.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            records.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            records.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            records.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
            records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
            this.checkStatus(records);
            recordsList.add(records);
        }
        this.logisticsPurchasePriceRecordsService.saveBatch(recordsList);
        acceptItem.setSendStatus(START_PRICE_FLAG);
        this.purchaseEbiddingItemService.updateById((Object)acceptItem);
    }

    @Override
    public QuoteHisReportLpVO queryQuoteHisByHeadId(PurchaseEbiddingItemLp purchaseEbiddingItem) {
        QuoteHisReportLpVO quoteHisReportVO = new QuoteHisReportLpVO();
        if (ObjectUtil.isEmpty((Object)((Object)purchaseEbiddingItem)) || StrUtil.isBlank((CharSequence)purchaseEbiddingItem.getHeadId())) {
            return quoteHisReportVO;
        }
        ArrayList<QuoteHisReportLpVO.QuoteHisReportHeadVO> reportHeadVOS = new ArrayList<QuoteHisReportLpVO.QuoteHisReportHeadVO>();
        List<PurchaseEbiddingItemHisLp> itemHisList = this.purchaseEbiddingItemHisService.selectByMainId(purchaseEbiddingItem.getHeadId());
        if (CollUtil.isEmpty(itemHisList)) {
            return quoteHisReportVO;
        }
        if (StrUtil.isNotBlank((CharSequence)purchaseEbiddingItem.getToElsAccount())) {
            itemHisList = itemHisList.stream().filter(i -> purchaseEbiddingItem.getToElsAccount().equals(i.getToElsAccount())).collect(Collectors.toList());
        }
        Map<String, List<PurchaseEbiddingItemHisLp>> itemHisMap = itemHisList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemHisLp::getToElsAccount));
        itemHisMap.forEach((toElsAccount, currentItemHisList) -> {
            List<PurchaseEbiddingItemHisLp> sortedList = currentItemHisList.stream().sorted(Comparator.comparing(PurchaseEbiddingItemHisLp::getQuoteCount)).collect(Collectors.toList());
            ArrayList<QuoteHisReportLpVO.QuoteDetail> quoteDetailList = new ArrayList<QuoteHisReportLpVO.QuoteDetail>(sortedList.size());
            sortedList.forEach(sorted -> {
                QuoteHisReportLpVO.QuoteDetail quoteDetail = QuoteHisReportLpVO.QuoteDetail.builder().ebiddingRange(sorted.getEbiddingRange()).netTotalAmount(sorted.getNetTotalAmount()).quoteTime(sorted.getQuoteTime()).quoteCount(sorted.getQuoteCount()).build();
                quoteDetailList.add(quoteDetail);
            });
            QuoteHisReportLpVO.QuoteHisReportHeadVO quoteHisReportHeadVO = QuoteHisReportLpVO.QuoteHisReportHeadVO.builder().subjectNumber(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSubjectNumber()).subjectName(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSubjectName()).supplierCode(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSupplierCode()).supplierName(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSupplierName()).totalQuoteCount(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(sortedList.size() - 1)))).getQuoteCount()).toElsAccount(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getToElsAccount()).lastNetTotalAmount(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(sortedList.size() - 1)))).getNetTotalAmount()).quoteDetailList(quoteDetailList).build();
            reportHeadVOS.add(quoteHisReportHeadVO);
        });
        Integer maxQuoteCount = itemHisList.stream().map(PurchaseEbiddingItemHisLp::getQuoteCount).max(Comparator.comparingInt(c -> c)).orElse(0);
        quoteHisReportVO.setMaxQuoteCount(maxQuoteCount);
        quoteHisReportVO.setQuoteHisReportHeadVOS(reportHeadVOS);
        return quoteHisReportVO;
    }

    @Override
    public List<PurchaseEbiddingSupplierLp> querySupplierListByHeadId(String headId) {
        ArrayList<PurchaseEbiddingSupplierLp> supplierList = new ArrayList<PurchaseEbiddingSupplierLp>();
        if (StrUtil.isBlank((CharSequence)headId)) {
            return supplierList;
        }
        return this.purchaseEbiddingSupplierService.selectByMainId(headId);
    }

    @Override
    public void exportQuoteReport(PurchaseEbiddingItemLp purchaseEbiddingItem, HttpServletResponse response) {
        int i;
        if (ObjectUtil.isEmpty((Object)((Object)purchaseEbiddingItem))) {
            return;
        }
        QuoteHisReportLpVO quoteHisReportVO = this.queryQuoteHisByHeadId(purchaseEbiddingItem);
        if (ObjectUtil.isEmpty((Object)quoteHisReportVO) || quoteHisReportVO.getMaxQuoteCount() == 0) {
            return;
        }
        ExcelWriter writer = new ExcelWriter(true, "\u7ade\u4ef7\u5386\u53f2\u62a5\u8868");
        LinkedHashMap<String, String> rowTemplateMap = this.buildRowTemplateMap(quoteHisReportVO, writer);
        ArrayList rows = new ArrayList(quoteHisReportVO.getQuoteHisReportHeadVOS().size());
        quoteHisReportVO.getQuoteHisReportHeadVOS().forEach(reportHeadVO -> rows.add(this.buildRowMap(rowTemplateMap, (QuoteHisReportLpVO.QuoteHisReportHeadVO)reportHeadVO)));
        for (i = 0; i < rows.size(); ++i) {
            ((LinkedHashMap)rows.get(i)).put("\u5e8f\u53f7", String.valueOf(i + 1));
        }
        writer.write(rows, true);
        writer.setColumnWidth(1, 20);
        writer.setColumnWidth(2, 30);
        writer.setColumnWidth(3, 20);
        writer.setColumnWidth(4, 35);
        writer.setColumnWidth(5, 10);
        writer.setColumnWidth(6, 20);
        for (i = 0; i < quoteHisReportVO.getMaxQuoteCount(); ++i) {
            writer.setColumnWidth(7 + 3 * i, 20);
            writer.setColumnWidth(8 + 3 * i, 20);
            writer.setColumnWidth(9 + 3 * i, 25);
        }
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u7ade\u4ef7\u5386\u53f2\u62a5\u8868.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
        writer.close();
    }

    private LinkedHashMap<String, String> buildRowMap(LinkedHashMap<String, String> rowTemplateMap, QuoteHisReportLpVO.QuoteHisReportHeadVO reportHeadVO) {
        LinkedHashMap<String, String> currentRow = this.cloneRowTemplateMap(rowTemplateMap);
        currentRow.put("\u6807\u7684\u7f16\u7801", reportHeadVO.getSubjectNumber());
        currentRow.put("\u6807\u7684\u540d\u79f0", reportHeadVO.getSubjectName());
        currentRow.put("\u4f9b\u5e94\u5546\u7f16\u7801", reportHeadVO.getToElsAccount());
        currentRow.put("\u4f9b\u5e94\u5546\u540d\u79f0", reportHeadVO.getSupplierName());
        currentRow.put("\u7ade\u4ef7\u6b21\u6570", reportHeadVO.getTotalQuoteCount().toString());
        currentRow.put("\u6700\u4f4e\u62a5\u4ef7", reportHeadVO.getLastNetTotalAmount().toString());
        List quoteDetailList = reportHeadVO.getQuoteDetailList().stream().sorted(Comparator.comparing(QuoteHisReportLpVO.QuoteDetail::getQuoteCount)).collect(Collectors.toList());
        Stream.iterate(0, i -> i + 1).limit(reportHeadVO.getTotalQuoteCount().intValue()).forEach(i -> {
            QuoteHisReportLpVO.QuoteDetail quoteDetail = (QuoteHisReportLpVO.QuoteDetail)quoteDetailList.get((int)i);
            currentRow.put("\u7b2c" + (i + 1) + "\u6b21\u964d\u5e45%", String.valueOf(quoteDetail.getEbiddingRange()));
            currentRow.put("\u7b2c" + (i + 1) + "\u6b21\u7efc\u5408\u4ef7\u683c", String.valueOf(quoteDetail.getNetTotalAmount()));
            currentRow.put("\u7b2c" + (i + 1) + "\u6b21\u7ade\u4ef7\u65f6\u95f4", DateUtil.format((Date)quoteDetail.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        });
        return currentRow;
    }

    private LinkedHashMap<String, String> cloneRowTemplateMap(LinkedHashMap<String, String> rowTemplateMap) {
        LinkedHashMap<String, String> copy = new LinkedHashMap<String, String>(rowTemplateMap.size());
        rowTemplateMap.forEach(copy::put);
        return copy;
    }

    private LinkedHashMap<String, String> buildRowTemplateMap(QuoteHisReportLpVO quoteHisReportVO, ExcelWriter writer) {
        LinkedHashMap<String, String> rowTemplateMap = new LinkedHashMap<String, String>(64);
        rowTemplateMap.put("\u5e8f\u53f7", "");
        rowTemplateMap.put("\u6807\u7684\u7f16\u7801", "");
        rowTemplateMap.put("\u6807\u7684\u540d\u79f0", "");
        rowTemplateMap.put("\u4f9b\u5e94\u5546\u7f16\u7801", "");
        rowTemplateMap.put("\u4f9b\u5e94\u5546\u540d\u79f0", "");
        rowTemplateMap.put("\u7ade\u4ef7\u6b21\u6570", "");
        rowTemplateMap.put("\u6700\u4f4e\u62a5\u4ef7", "");
        Stream.iterate(0, i -> i + 1).limit(quoteHisReportVO.getMaxQuoteCount().intValue()).forEach(i -> {
            rowTemplateMap.put("\u7b2c" + (i + 1) + "\u6b21\u964d\u5e45%", "");
            rowTemplateMap.put("\u7b2c" + (i + 1) + "\u6b21\u7efc\u5408\u4ef7\u683c", "");
            rowTemplateMap.put("\u7b2c" + (i + 1) + "\u6b21\u7ade\u4ef7\u65f6\u95f4", "");
        });
        return rowTemplateMap;
    }

    @Override
    public List<TemplateConfigItemDTO> queryEnquiryItemTemplateByEbiddingId(String id) {
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)this.getById((Serializable)((Object)id)));
        if (ObjectUtil.isEmpty((Object)((Object)dbHead))) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        if (StrUtil.isBlank((CharSequence)dbHead.getEnquiryNumber()) || StrUtil.isBlank((CharSequence)dbHead.getEnquiryId())) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        PurchaseEnquiryHeadLpService purchaseEnquiryHeadService = (PurchaseEnquiryHeadLpService)SpringContextUtils.getBean(PurchaseEnquiryHeadLpService.class);
        PurchaseEnquiryHeadLp dbPurchaseEnquiryHead = (PurchaseEnquiryHeadLp)((Object)purchaseEnquiryHeadService.getById((Serializable)((Object)dbHead.getEnquiryId())));
        if (ObjectUtil.isEmpty((Object)((Object)dbPurchaseEnquiryHead))) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        TemplateHeadDTO templateHead = this.invokeBaseRpcService.getTemplateConfig(dbPurchaseEnquiryHead.getElsAccount(), dbPurchaseEnquiryHead.getTemplateNumber(), String.valueOf(dbPurchaseEnquiryHead.getTemplateVersion()));
        if (ObjectUtil.isEmpty((Object)templateHead)) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        List<TemplateConfigItemDTO> itemConfigs = templateHead.getTemplateConfigItemList();
        itemConfigs = itemConfigs.stream().filter(item -> START_PRICE_FLAG.equals(item.getPurchaseShow())).filter(item -> !"subjectFileItemList".equals(item.getGroupCode())).collect(Collectors.toList());
        return itemConfigs;
    }

    @Override
    public IPage<QuoteHisReportLpVO.QuoteHisReportHeadVO> listQuoteHis(PurchaseEbiddingItemHisLp purchaseEbiddingItemHis, Integer pageNo, Integer pageSize) {
        QuoteHisReportLpVO.QuoteHisReportHeadVO.QuoteHisReportHeadPage finalHisPageResult = new QuoteHisReportLpVO.QuoteHisReportHeadVO.QuoteHisReportHeadPage(pageNo.intValue(), pageSize.intValue());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"DISTINCT ebidding_number, to_els_account, subject_number, (SUBSTRING(COALESCE(subject_number,0), 2)+0) AS subject_number_order"});
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)purchaseEbiddingItemHis.getSubjectNumber()), (Object)"subject_number", (Object)purchaseEbiddingItemHis.getSubjectNumber());
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)purchaseEbiddingItemHis.getSupplierName()), (Object)"supplier_name", (Object)purchaseEbiddingItemHis.getSupplierName());
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)purchaseEbiddingItemHis.getSupplierCode()), (Object)"to_els_account", (Object)purchaseEbiddingItemHis.getSupplierCode());
        queryWrapper.inSql((Object)"head_id", "SELECT peh.id FROM purchase_ebidding_head peh WHERE peh.id = head_id AND peh.is_test = '0'");
        queryWrapper.orderByAsc((Object)"subject_number_order");
        IPage originalHisPageResult = this.purchaseEbiddingItemHisService.page((IPage)page, (Wrapper)queryWrapper);
        finalHisPageResult.setTotal(originalHisPageResult.getTotal());
        finalHisPageResult.setSize(originalHisPageResult.getSize());
        finalHisPageResult.setCurrent(originalHisPageResult.getCurrent());
        finalHisPageResult.setPages(originalHisPageResult.getPages());
        if (CollUtil.isNotEmpty((Collection)originalHisPageResult.getRecords())) {
            ArrayList<String> keys = new ArrayList<String>();
            originalHisPageResult.getRecords().forEach(record -> keys.add(record.getEbiddingNumber() + "_" + record.getToElsAccount() + "_" + record.getSubjectNumber()));
            ArrayList reportHeadVOS = new ArrayList();
            List<PurchaseEbiddingItemHisLp> allHisList = this.purchaseEbiddingItemHisService.selectQuoteHisList(keys);
            Map<String, List<PurchaseEbiddingItemHisLp>> itemHisMap = allHisList.stream().collect(Collectors.groupingBy(i -> i.getEbiddingNumber() + "_" + i.getToElsAccount() + "_" + i.getSubjectNumber()));
            itemHisMap.forEach((key, currentItemHisList) -> {
                List<PurchaseEbiddingItemHisLp> sortedList = currentItemHisList.stream().sorted(Comparator.comparing(PurchaseEbiddingItemHisLp::getQuoteCount)).collect(Collectors.toList());
                ArrayList<QuoteHisReportLpVO.QuoteDetail> quoteDetailList = new ArrayList<QuoteHisReportLpVO.QuoteDetail>(sortedList.size());
                sortedList.forEach(sorted -> {
                    QuoteHisReportLpVO.QuoteDetail quoteDetail = QuoteHisReportLpVO.QuoteDetail.builder().ebiddingRange(sorted.getEbiddingRange()).netTotalAmount(sorted.getNetTotalAmount()).quoteTime(sorted.getQuoteTime()).quoteCount(sorted.getQuoteCount()).build();
                    quoteDetailList.add(quoteDetail);
                });
                QuoteHisReportLpVO.QuoteHisReportHeadVO quoteHisReportHeadVO = QuoteHisReportLpVO.QuoteHisReportHeadVO.builder().headId(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getHeadId()).subjectNumber(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSubjectNumber()).subjectName(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSubjectName()).supplierCode(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSupplierCode()).supplierName(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSupplierName()).totalQuoteCount(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(sortedList.size() - 1)))).getQuoteCount()).toElsAccount(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getToElsAccount()).lastNetTotalAmount(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(sortedList.size() - 1)))).getNetTotalAmount()).quoteDetailList(quoteDetailList).build();
                reportHeadVOS.add(quoteHisReportHeadVO);
            });
            Integer maxQuoteCount = allHisList.stream().map(PurchaseEbiddingItemHisLp::getQuoteCount).max(Comparator.comparingInt(c -> c)).orElse(0);
            List sortedReportHeadVOS = reportHeadVOS.stream().sorted(Comparator.comparing(QuoteHisReportLpVO.QuoteHisReportHeadVO::getSubjectNumber, (subjectNumber1, subjectNumber2) -> {
                String subjectNumber1Split = ((String)ObjectUtil.defaultIfEmpty((CharSequence)subjectNumber1, (CharSequence)"")).split("\u6807").length > 1 ? ((String)ObjectUtil.defaultIfEmpty((CharSequence)subjectNumber1, (CharSequence)"")).split("\u6807")[1] : "0";
                String subjectNumber2Split = ((String)ObjectUtil.defaultIfEmpty((CharSequence)subjectNumber2, (CharSequence)"")).split("\u6807").length > 1 ? ((String)ObjectUtil.defaultIfEmpty((CharSequence)subjectNumber2, (CharSequence)"")).split("\u6807")[1] : "0";
                Long s1 = NumberUtil.isNumber((CharSequence)subjectNumber1Split) ? Long.parseLong(subjectNumber1Split) : 0L;
                Long s2 = NumberUtil.isNumber((CharSequence)subjectNumber2Split) ? Long.parseLong(subjectNumber2Split) : 0L;
                return s1.compareTo(s2);
            }).thenComparing(QuoteHisReportLpVO.QuoteHisReportHeadVO::getLastNetTotalAmount)).collect(Collectors.toList());
            finalHisPageResult.setRecords(sortedReportHeadVOS);
            finalHisPageResult.setMaxQuoteCount(maxQuoteCount);
        }
        return finalHisPageResult;
    }

    @Override
    public void exportQuoteHisReport(PurchaseEbiddingItemHisLp purchaseEbiddingItemHis, HttpServletResponse response) {
        int i2;
        if (ObjectUtil.isEmpty((Object)((Object)purchaseEbiddingItemHis))) {
            return;
        }
        QuoteHisReportLpVO quoteHisReportVO = new QuoteHisReportLpVO();
        ArrayList<QuoteHisReportLpVO.QuoteHisReportHeadVO> reportHeadVOS = new ArrayList<QuoteHisReportLpVO.QuoteHisReportHeadVO>();
        List itemHisList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.purchaseEbiddingItemHisService.lambdaQuery().eq(StrUtil.isNotBlank((CharSequence)purchaseEbiddingItemHis.getToElsAccount()), PurchaseEbiddingItemHisLp::getToElsAccount, (Object)purchaseEbiddingItemHis.getToElsAccount())).eq(StrUtil.isNotBlank((CharSequence)purchaseEbiddingItemHis.getSubjectNumber()), PurchaseEbiddingItemHisLp::getSubjectNumber, (Object)purchaseEbiddingItemHis.getSubjectNumber())).eq(StrUtil.isNotBlank((CharSequence)purchaseEbiddingItemHis.getSubjectYear()), PurchaseEbiddingItemHisLp::getSubjectYear, (Object)purchaseEbiddingItemHis.getSubjectYear())).inSql(PurchaseEbiddingItemHisLp::getHeadId, "SELECT peh.id FROM purchase_ebidding_head peh WHERE peh.id = head_id AND peh.is_test = '0'")).list();
        if (CollUtil.isEmpty((Collection)itemHisList)) {
            StringBuilder sb = new StringBuilder("\u4e0d\u5b58\u5728");
            if (StrUtil.isNotBlank((CharSequence)purchaseEbiddingItemHis.getToElsAccount())) {
                sb.append("\u4f9b\u5e94\u5546\u7f16\u7801[").append(purchaseEbiddingItemHis.getToElsAccount()).append("]");
            }
            if (StrUtil.isNotBlank((CharSequence)purchaseEbiddingItemHis.getSubjectNumber())) {
                sb.append("\u6807\u7684\u7f16\u7801[").append(purchaseEbiddingItemHis.getSubjectNumber()).append("]");
            }
            if (StrUtil.isNotBlank((CharSequence)purchaseEbiddingItemHis.getSubjectYear())) {
                sb.append("\u6807\u7684\u5e74\u4efd[").append(purchaseEbiddingItemHis.getSubjectYear()).append("]");
            }
            sb.append("\u7684\u7ade\u4ef7\u5386\u53f2");
            throw new ELSBootException(sb.toString());
        }
        Map<String, List<PurchaseEbiddingItemHisLp>> itemHisMap = itemHisList.stream().collect(Collectors.groupingBy(i -> i.getHeadId() + "_" + i.getToElsAccount()));
        itemHisMap.forEach((key, currentItemHisList) -> {
            List<PurchaseEbiddingItemHisLp> sortedList = currentItemHisList.stream().sorted(Comparator.comparing(PurchaseEbiddingItemHisLp::getQuoteCount)).collect(Collectors.toList());
            ArrayList<QuoteHisReportLpVO.QuoteDetail> quoteDetailList = new ArrayList<QuoteHisReportLpVO.QuoteDetail>(sortedList.size());
            sortedList.forEach(sorted -> {
                QuoteHisReportLpVO.QuoteDetail quoteDetail = QuoteHisReportLpVO.QuoteDetail.builder().ebiddingRange(sorted.getEbiddingRange()).netTotalAmount(sorted.getNetTotalAmount()).quoteTime(sorted.getQuoteTime()).quoteCount(sorted.getQuoteCount()).build();
                quoteDetailList.add(quoteDetail);
            });
            QuoteHisReportLpVO.QuoteHisReportHeadVO quoteHisReportHeadVO = QuoteHisReportLpVO.QuoteHisReportHeadVO.builder().subjectNumber(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSubjectNumber()).subjectName(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSubjectName()).supplierCode(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSupplierCode()).supplierName(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getSupplierName()).totalQuoteCount(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(sortedList.size() - 1)))).getQuoteCount()).toElsAccount(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(0)))).getToElsAccount()).lastNetTotalAmount(((PurchaseEbiddingItemHisLp)((Object)((Object)sortedList.get(sortedList.size() - 1)))).getNetTotalAmount()).quoteDetailList(quoteDetailList).build();
            reportHeadVOS.add(quoteHisReportHeadVO);
        });
        Integer maxQuoteCount = itemHisList.stream().map(PurchaseEbiddingItemHisLp::getQuoteCount).max(Comparator.comparingInt(c -> c)).orElse(0);
        quoteHisReportVO.setMaxQuoteCount(maxQuoteCount);
        quoteHisReportVO.setQuoteHisReportHeadVOS(reportHeadVOS);
        if (ObjectUtil.isEmpty((Object)quoteHisReportVO) || quoteHisReportVO.getMaxQuoteCount() == 0) {
            return;
        }
        ExcelWriter writer = new ExcelWriter(true, "\u7ade\u4ef7\u5386\u53f2\u62a5\u8868");
        LinkedHashMap<String, String> rowTemplateMap = this.buildRowTemplateMap(quoteHisReportVO, writer);
        ArrayList rows = new ArrayList(quoteHisReportVO.getQuoteHisReportHeadVOS().size());
        quoteHisReportVO.getQuoteHisReportHeadVOS().forEach(reportHeadVO -> rows.add(this.buildRowMap(rowTemplateMap, (QuoteHisReportLpVO.QuoteHisReportHeadVO)reportHeadVO)));
        for (i2 = 0; i2 < rows.size(); ++i2) {
            ((LinkedHashMap)rows.get(i2)).put("\u5e8f\u53f7", String.valueOf(i2 + 1));
        }
        writer.write(rows, true);
        writer.setColumnWidth(1, 20);
        writer.setColumnWidth(2, 30);
        writer.setColumnWidth(3, 20);
        writer.setColumnWidth(4, 35);
        writer.setColumnWidth(5, 10);
        writer.setColumnWidth(6, 20);
        for (i2 = 0; i2 < maxQuoteCount; ++i2) {
            writer.setColumnWidth(7 + 3 * i2, 20);
            writer.setColumnWidth(8 + 3 * i2, 20);
            writer.setColumnWidth(9 + 3 * i2, 25);
        }
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u7ade\u4ef7\u5386\u53f2\u62a5\u8868.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
        writer.close();
    }

    @Override
    public QuoteHisDictCodeVO queryQuoteHisDictCodeList(String subjectNumber, String toElsAccount, String subjectYear) {
        QuoteHisDictCodeVO quoteHisDictCodeVO = new QuoteHisDictCodeVO();
        ArrayList<DictDTO> supplierDicts = new ArrayList<DictDTO>();
        ArrayList<DictDTO> subjectNumberDicts = new ArrayList<DictDTO>();
        ArrayList<DictDTO> subjectYearDicts = new ArrayList<DictDTO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"DISTINCT to_els_account, supplier_name, subject_number, subject_year"});
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)subjectNumber), (Object)"subject_number", (Object)subjectNumber);
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)toElsAccount), (Object)"to_els_account", (Object)toElsAccount);
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)subjectYear), (Object)"subject_year", (Object)subjectYear);
        queryWrapper.inSql((Object)"head_id", "SELECT peh.id FROM purchase_ebidding_head peh WHERE peh.id = head_id AND peh.is_test = '0'");
        List hisList = this.purchaseEbiddingItemHisService.list((Wrapper)queryWrapper);
        Map<String, String> supplierDictMap = hisList.stream().collect(Collectors.toMap(PurchaseEbiddingItemHisLp::getToElsAccount, PurchaseEbiddingItemHisLp::getSupplierName, (o, n) -> o));
        supplierDictMap.forEach((key, value) -> {
            DictDTO dto = new DictDTO();
            dto.setValue(key);
            dto.setText(value);
            supplierDicts.add(dto);
        });
        Set<String> subjectNumberSet = hisList.stream().map(PurchaseEbiddingItemHisLp::getSubjectNumber).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        subjectNumberSet.forEach(s -> {
            DictDTO dto = new DictDTO();
            dto.setValue(s);
            dto.setText(s);
            subjectNumberDicts.add(dto);
        });
        Set<String> subjectYearSet = hisList.stream().map(PurchaseEbiddingItemHisLp::getSubjectYear).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        subjectYearSet.forEach(s -> {
            DictDTO dto = new DictDTO();
            dto.setValue(s);
            dto.setText(s);
            subjectYearDicts.add(dto);
        });
        quoteHisDictCodeVO.setSupplierDicts(supplierDicts);
        quoteHisDictCodeVO.setSubjectNumberDicts(subjectNumberDicts);
        quoteHisDictCodeVO.setSubjectYearDicts(subjectYearDicts);
        return quoteHisDictCodeVO;
    }
}

