/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.excel.listener.EnquiryQuoteDataListener;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryLpOperationService;
import com.els.modules.logisticspurchase.enquiry.vo.SaleEnquiryHeadLpVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/lpEnquiry/saleOperation"})
@Tag(name="\u9500\u552e\u8be2\u4ef7\u5934")
public class LogisticsSaleEnquiryOperationController
extends BaseController<SaleEnquiryHeadLp, SaleEnquiryHeadLpService> {
    private static final Logger log = LoggerFactory.getLogger(LogisticsSaleEnquiryOperationController.class);
    @Autowired
    private SaleEnquiryLpOperationService saleEnquiryLpOperationService;
    @Autowired
    private SaleEnquiryItemLpService saleEnquiryItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleEnquiryHeadLpService saleEnquiryHeadService;

    @AutoLog(value="\u8be2\u4ef7-\u62a5\u4ef7")
    @Operation(summary="\u62a5\u4ef7", description="\u62a5\u4ef7")
    @PostMapping(value={"/quote"})
    @RequiresPermissions(value={"lpEnquiry#SaleEnquiryHeadLp:quote"})
    public Result<?> quote(HttpServletRequest request) {
        SaleEnquiryHeadLpVO headVO = this.getHeadByRequest(request);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            InputStream inputStream = null;
            try {
                EnquiryQuoteDataListener dataListener = new EnquiryQuoteDataListener();
                inputStream = file.getInputStream();
                EasyExcel.read((InputStream)inputStream, (ReadListener)dataListener).headRowNumber(Integer.valueOf(1)).doReadAll();
                headVO.setSaleEnquiryItemList(dataListener.getCachedDataList());
                this.saleEnquiryLpOperationService.publish(headVO);
            }
            catch (Exception e) {
                log.error("\u4f9b\u5e94\u5546\u62a5\u4ef7\u5f02\u5e38", (Throwable)e);
                throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.commonSuccessResult(2);
    }

    private SaleEnquiryHeadLpVO getHeadByRequest(HttpServletRequest request) {
        SaleEnquiryHeadLpVO head = new SaleEnquiryHeadLpVO();
        String id = request.getParameter("id");
        String taxCode = request.getParameter("taxCode");
        String taxRate = request.getParameter("taxRate");
        if (StrUtil.isBlank((CharSequence)id)) {
            throw new ELSBootException("\u8be2\u4ef7\u5355 id \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)taxCode)) {
            throw new ELSBootException("\u7a0e\u7801 taxCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)taxRate)) {
            throw new ELSBootException("\u7a0e\u7387 taxRate \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        head.setId(id);
        head.setTaxCode(taxCode);
        head.setTaxRate(taxRate);
        return head;
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"lpEnquiry#SaleEnquiryHeadLp:list"})
    public Result<?> queryItemPageList(SaleEnquiryItemLp saleEnquiryItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String headId = saleEnquiryItem.getHeadId();
        if (StrUtil.isBlank((CharSequence)headId)) {
            throw new ELSBootException("\u8be2\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleEnquiryItem), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleEnquiryItemService.page((IPage)page, (Wrapper)queryWrapper);
        ArrayList<SaleEnquiryItemLp> itemList = pageList.getRecords();
        if ((itemList == null || itemList.isEmpty()) && StrUtil.isBlank((CharSequence)saleEnquiryItem.getKeyWord())) {
            itemList = new ArrayList<SaleEnquiryItemLp>();
            SaleEnquiryHeadLp head = (SaleEnquiryHeadLp)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)headId)));
            List itemList2 = this.invokeBaseRpcService.getInitTableListByRelationId(head.getRelationId());
            for (ElsInitialTableDTO table : itemList2) {
                SaleEnquiryItemLp item = (SaleEnquiryItemLp)((Object)JSONObject.parseObject((String)table.getBusinessInfoJson(), SaleEnquiryItemLp.class));
                itemList.add(item);
            }
            pageList.setRecords(itemList);
        }
        return Result.ok((Object)pageList);
    }
}

